/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.plastic.asm.optimizer;

import org.apache.tapestry5.internal.plastic.asm.AnnotationVisitor;
import org.apache.tapestry5.internal.plastic.asm.Attribute;
import org.apache.tapestry5.internal.plastic.asm.ClassVisitor;
import org.apache.tapestry5.internal.plastic.asm.FieldVisitor;
import org.apache.tapestry5.internal.plastic.asm.MethodVisitor;
import org.apache.tapestry5.internal.plastic.asm.commons.Remapper;
import org.apache.tapestry5.internal.plastic.asm.commons.RemappingClassAdapter;
import org.apache.tapestry5.internal.plastic.asm.optimizer.MethodOptimizer;

public class ClassOptimizer
extends RemappingClassAdapter {
    private String pkgName;

    public ClassOptimizer(ClassVisitor cv, Remapper remapper) {
        super(cv, remapper);
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        super.visit(version, access, name, null, superName, interfaces);
        this.pkgName = name.substring(0, name.lastIndexOf(47));
    }

    public void visitSource(String source, String debug) {
    }

    public void visitOuterClass(String owner, String name, String desc) {
    }

    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        return null;
    }

    public void visitAttribute(Attribute attr) {
    }

    public void visitInnerClass(String name, String outerName, String innerName, int access) {
    }

    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        String s = this.remapper.mapFieldName(this.className, name, desc);
        if ("-".equals(s)) {
            return null;
        }
        if ((access & 5) == 0) {
            if ((access & 0x10) != 0 && (access & 8) != 0 && desc.length() == 1) {
                return null;
            }
            if ("org/objectweb/asm".equals(this.pkgName) && s.equals(name)) {
                System.out.println("INFO: " + s + " could be renamed");
            }
            super.visitField(access, name, desc, null, value);
        } else {
            if (!s.equals(name)) {
                throw new RuntimeException("The public or protected field " + this.className + '.' + name + " must not be renamed.");
            }
            super.visitField(access, name, desc, null, value);
        }
        return null;
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        String s = this.remapper.mapMethodName(this.className, name, desc);
        if ("-".equals(s)) {
            return null;
        }
        if ((access & 5) == 0) {
            if ("org/objectweb/asm".equals(this.pkgName) && !name.startsWith("<") && s.equals(name)) {
                System.out.println("INFO: " + s + " could be renamed");
            }
            return super.visitMethod(access, name, desc, null, exceptions);
        }
        if (!s.equals(name)) {
            throw new RuntimeException("The public or protected method " + this.className + '.' + name + desc + " must not be renamed.");
        }
        return super.visitMethod(access, name, desc, null, exceptions);
    }

    protected MethodVisitor createRemappingMethodAdapter(int access, String newDesc, MethodVisitor mv) {
        return new MethodOptimizer(access, newDesc, mv, this.remapper);
    }
}

