/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.plastic;

import java.lang.annotation.Annotation;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.tapestry5.internal.plastic.AnnotationBuilder;
import org.apache.tapestry5.internal.plastic.Cache;
import org.apache.tapestry5.internal.plastic.ClassLoaderDelegate;
import org.apache.tapestry5.internal.plastic.EmptyAnnotationAccess;
import org.apache.tapestry5.internal.plastic.InheritanceData;
import org.apache.tapestry5.internal.plastic.InternalPlasticClassTransformation;
import org.apache.tapestry5.internal.plastic.PlasticClassImpl;
import org.apache.tapestry5.internal.plastic.PlasticClassLoader;
import org.apache.tapestry5.internal.plastic.PlasticInternalUtils;
import org.apache.tapestry5.internal.plastic.StaticContext;
import org.apache.tapestry5.internal.plastic.TypeCategory;
import org.apache.tapestry5.internal.plastic.asm.ClassWriter;
import org.apache.tapestry5.internal.plastic.asm.Opcodes;
import org.apache.tapestry5.internal.plastic.asm.tree.AnnotationNode;
import org.apache.tapestry5.internal.plastic.asm.tree.ClassNode;
import org.apache.tapestry5.plastic.AnnotationAccess;
import org.apache.tapestry5.plastic.ClassInstantiator;
import org.apache.tapestry5.plastic.ClassType;
import org.apache.tapestry5.plastic.PlasticClassEvent;
import org.apache.tapestry5.plastic.PlasticClassListener;
import org.apache.tapestry5.plastic.PlasticClassListenerHub;
import org.apache.tapestry5.plastic.PlasticClassTransformation;
import org.apache.tapestry5.plastic.PlasticManagerDelegate;
import org.apache.tapestry5.plastic.TransformationOption;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlasticClassPool
implements ClassLoaderDelegate,
Opcodes,
PlasticClassListenerHub {
    final PlasticClassLoader loader;
    private final PlasticManagerDelegate delegate;
    private final Set<String> controlledPackages;
    private final Map<String, ClassInstantiator> instantiators = PlasticInternalUtils.newMap();
    private final InheritanceData emptyInheritanceData = new InheritanceData();
    private final StaticContext emptyStaticContext = new StaticContext();
    private final List<PlasticClassListener> listeners = new CopyOnWriteArrayList<PlasticClassListener>();
    private final Cache<String, TypeCategory> typeName2Category = new Cache<String, TypeCategory>(){

        @Override
        protected TypeCategory convert(String typeName) {
            ClassNode cn = PlasticClassPool.this.constructClassNode(typeName);
            return Modifier.isInterface(cn.access) ? TypeCategory.INTERFACE : TypeCategory.CLASS;
        }
    };
    private final Map<String, BaseClassDef> baseClassDefs = new HashMap<String, BaseClassDef>();
    private final Set<TransformationOption> options;

    public PlasticClassPool(ClassLoader parentLoader, PlasticManagerDelegate delegate, Set<String> controlledPackages, Set<TransformationOption> options) {
        this.loader = new PlasticClassLoader(parentLoader, this);
        this.delegate = delegate;
        this.controlledPackages = controlledPackages;
        this.options = options;
    }

    public ClassLoader getClassLoader() {
        return this.loader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class realizeTransformedClass(ClassNode classNode, InheritanceData inheritanceData, StaticContext staticContext) {
        PlasticClassLoader plasticClassLoader = this.loader;
        synchronized (plasticClassLoader) {
            Class result = this.realize(PlasticInternalUtils.toClassName(classNode.name), ClassType.PRIMARY, classNode);
            this.baseClassDefs.put(result.getName(), new BaseClassDef(inheritanceData, staticContext));
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class realize(String primaryClassName, ClassType classType, ClassNode classNode) {
        PlasticClassLoader plasticClassLoader = this.loader;
        synchronized (plasticClassLoader) {
            if (!this.listeners.isEmpty()) {
                this.fire(this.toEvent(primaryClassName, classType, classNode));
            }
            byte[] bytecode = this.toBytecode(classNode);
            String className = PlasticInternalUtils.toClassName(classNode.name);
            return this.loader.defineClassWithBytecode(className, bytecode);
        }
    }

    private PlasticClassEvent toEvent(final String primaryClassName, final ClassType classType, final ClassNode classNode) {
        return new PlasticClassEvent(){

            public ClassType getType() {
                return classType;
            }

            public String getPrimaryClassName() {
                return primaryClassName;
            }

            public String getDissasembledBytecode() {
                return PlasticInternalUtils.dissasembleBytecode(classNode);
            }

            public String getClassName() {
                return PlasticInternalUtils.toClassName(classNode.name);
            }
        };
    }

    private void fire(PlasticClassEvent event) {
        for (PlasticClassListener listener : this.listeners) {
            listener.classWillLoad(event);
        }
    }

    private byte[] toBytecode(ClassNode classNode) {
        ClassWriter writer = new ClassWriter(3);
        classNode.accept(writer);
        return writer.toByteArray();
    }

    public AnnotationAccess createAnnotationAccess(String className) {
        try {
            final Class<?> searchClass = this.loader.loadClass(className);
            return new AnnotationAccess(){

                @Override
                public <T extends Annotation> boolean hasAnnotation(Class<T> annotationType) {
                    return this.getAnnotation(annotationType) != null;
                }

                @Override
                public <T extends Annotation> T getAnnotation(Class<T> annotationType) {
                    return searchClass.getAnnotation(annotationType);
                }
            };
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public AnnotationAccess createAnnotationAccess(List<AnnotationNode> annotationNodes) {
        if (annotationNodes == null) {
            return EmptyAnnotationAccess.SINGLETON;
        }
        final Map cache = PlasticInternalUtils.newMap();
        final Map<String, AnnotationNode> nameToNode = PlasticInternalUtils.newMap();
        for (AnnotationNode node : annotationNodes) {
            nameToNode.put(PlasticInternalUtils.objectDescriptorToClassName(node.desc), node);
        }
        return new AnnotationAccess(){

            @Override
            public <T extends Annotation> boolean hasAnnotation(Class<T> annotationType) {
                return nameToNode.containsKey(annotationType.getName());
            }

            @Override
            public <T extends Annotation> T getAnnotation(Class<T> annotationType) {
                String className = annotationType.getName();
                Object result = cache.get(className);
                if (result == null && (result = this.buildAnnotation(className)) != null) {
                    cache.put(className, result);
                }
                return (T)((Annotation)annotationType.cast(result));
            }

            private Object buildAnnotation(String className) {
                AnnotationNode node = (AnnotationNode)nameToNode.get(className);
                if (node == null) {
                    return null;
                }
                return PlasticClassPool.this.createAnnotation(className, node);
            }
        };
    }

    Class loadClass(String className) {
        try {
            return this.loader.loadClass(className);
        }
        catch (Exception ex) {
            throw new RuntimeException(String.format("Unable to load class %s: %s", className, PlasticInternalUtils.toMessage(ex)), ex);
        }
    }

    protected Object createAnnotation(String className, AnnotationNode node) {
        AnnotationBuilder builder = new AnnotationBuilder(this.loadClass(className), this);
        node.accept(builder);
        return builder.createAnnotation();
    }

    @Override
    public boolean shouldInterceptClassLoading(String className) {
        int dotx;
        int searchFromIndex = className.length() - 1;
        while ((dotx = className.lastIndexOf(46, searchFromIndex)) >= 0) {
            String packageName = className.substring(0, dotx);
            if (this.controlledPackages.contains(packageName)) {
                return true;
            }
            searchFromIndex = dotx - 1;
        }
        return false;
    }

    @Override
    public Class<?> loadAndTransformClass(String className) throws ClassNotFoundException {
        if (className.contains("$")) {
            return this.loadInnerClass(className);
        }
        InternalPlasticClassTransformation transformation = this.getPlasticClassTransformation(className);
        this.delegate.transform(transformation.getPlasticClass());
        ClassInstantiator createInstantiator = transformation.createInstantiator();
        ClassInstantiator configuredInstantiator = this.delegate.configureInstantiator(className, createInstantiator);
        this.instantiators.put(className, configuredInstantiator);
        return transformation.getTransformedClass();
    }

    private Class loadInnerClass(String className) {
        byte[] bytecode = this.readBytecode(className);
        return this.loader.defineClassWithBytecode(className, bytecode);
    }

    public InternalPlasticClassTransformation getPlasticClassTransformation(String className) throws ClassNotFoundException {
        assert (PlasticInternalUtils.isNonBlank(className));
        ClassNode classNode = this.constructClassNode(className);
        String baseClassName = PlasticInternalUtils.toClassName(classNode.superName);
        return this.createTransformation(baseClassName, classNode);
    }

    private InternalPlasticClassTransformation createTransformation(String baseClassName, ClassNode classNode) throws ClassNotFoundException {
        if (this.shouldInterceptClassLoading(baseClassName)) {
            this.loader.loadClass(baseClassName);
            BaseClassDef def = this.baseClassDefs.get(baseClassName);
            assert (def != null);
            return new PlasticClassImpl(classNode, this, def.inheritanceData, def.staticContext);
        }
        return new PlasticClassImpl(classNode, this, this.emptyInheritanceData, this.emptyStaticContext);
    }

    public ClassNode constructClassNode(String className) {
        byte[] bytecode = this.readBytecode(className);
        if (bytecode == null) {
            return null;
        }
        return PlasticInternalUtils.convertBytecodeToClassNode(bytecode);
    }

    private byte[] readBytecode(String className) {
        ClassLoader parentClassLoader = this.loader.getParent();
        return PlasticInternalUtils.readBytecodeForClass(parentClassLoader, className, true);
    }

    public PlasticClassTransformation createTransformation(String baseClassName, String newClassName) {
        try {
            ClassNode newClassNode = new ClassNode();
            newClassNode.visit(49, 1, PlasticInternalUtils.toInternalName(newClassName), null, PlasticInternalUtils.toInternalName(baseClassName), null);
            return this.createTransformation(baseClassName, newClassNode);
        }
        catch (ClassNotFoundException ex) {
            throw new RuntimeException(String.format("Unable to create class %s as sub-class of %s: %s", newClassName, baseClassName, PlasticInternalUtils.toMessage(ex)), ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassInstantiator getClassInstantiator(String className) {
        PlasticClassLoader plasticClassLoader = this.loader;
        synchronized (plasticClassLoader) {
            ClassInstantiator result;
            if (!this.instantiators.containsKey(className)) {
                try {
                    this.loader.loadClass(className);
                }
                catch (ClassNotFoundException ex) {
                    throw new RuntimeException(ex);
                }
            }
            if ((result = this.instantiators.get(className)) == null) {
                StringBuilder b = new StringBuilder();
                b.append("Class '").append(className).append("' is not a transformed class. Transformed classes should be in one of the following packages: ");
                String sep = "";
                ArrayList<String> names = new ArrayList<String>(this.controlledPackages);
                Collections.sort(names);
                for (String name : names) {
                    b.append(sep);
                    b.append(name);
                    sep = ", ";
                }
                String message = b.append(".").toString();
                throw new IllegalArgumentException(message);
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TypeCategory getTypeCategory(String typeName) {
        PlasticClassLoader plasticClassLoader = this.loader;
        synchronized (plasticClassLoader) {
            return this.typeName2Category.get(typeName);
        }
    }

    @Override
    public void addPlasticClassListener(PlasticClassListener listener) {
        assert (listener != null);
        this.listeners.add(listener);
    }

    @Override
    public void removePlasticClassListener(PlasticClassListener listener) {
        assert (listener != null);
        this.listeners.remove(listener);
    }

    boolean isEnabled(TransformationOption option) {
        return this.options.contains((Object)option);
    }

    static class BaseClassDef {
        final InheritanceData inheritanceData;
        final StaticContext staticContext;

        public BaseClassDef(InheritanceData inheritanceData, StaticContext staticContext) {
            this.inheritanceData = inheritanceData;
            this.staticContext = staticContext;
        }
    }
}

