/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.plastic;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.apache.tapestry5.internal.plastic.AbstractMethodInvocation;
import org.apache.tapestry5.internal.plastic.ClassInstantiatorImpl;
import org.apache.tapestry5.internal.plastic.DelegatingAnnotationAccess;
import org.apache.tapestry5.internal.plastic.FailureMethodInvocationResult;
import org.apache.tapestry5.internal.plastic.FieldHandleImpl;
import org.apache.tapestry5.internal.plastic.FieldState;
import org.apache.tapestry5.internal.plastic.InstructionBuilderImpl;
import org.apache.tapestry5.internal.plastic.InternalPlasticClassTransformation;
import org.apache.tapestry5.internal.plastic.Lockable;
import org.apache.tapestry5.internal.plastic.MethodBundle;
import org.apache.tapestry5.internal.plastic.MethodHandleImpl;
import org.apache.tapestry5.internal.plastic.MethodInvocationBundle;
import org.apache.tapestry5.internal.plastic.NameCache;
import org.apache.tapestry5.internal.plastic.PlasticClassHandleShim;
import org.apache.tapestry5.internal.plastic.PlasticClassPool;
import org.apache.tapestry5.internal.plastic.PlasticInternalUtils;
import org.apache.tapestry5.internal.plastic.PrimitiveType;
import org.apache.tapestry5.internal.plastic.StaticContext;
import org.apache.tapestry5.internal.plastic.SuccessMethodInvocationResult;
import org.apache.tapestry5.internal.plastic.TypeCategory;
import org.apache.tapestry5.internal.plastic.asm.Opcodes;
import org.apache.tapestry5.internal.plastic.asm.Type;
import org.apache.tapestry5.internal.plastic.asm.tree.AbstractInsnNode;
import org.apache.tapestry5.internal.plastic.asm.tree.AnnotationNode;
import org.apache.tapestry5.internal.plastic.asm.tree.ClassNode;
import org.apache.tapestry5.internal.plastic.asm.tree.FieldInsnNode;
import org.apache.tapestry5.internal.plastic.asm.tree.FieldNode;
import org.apache.tapestry5.internal.plastic.asm.tree.InsnList;
import org.apache.tapestry5.internal.plastic.asm.tree.MemberNode;
import org.apache.tapestry5.internal.plastic.asm.tree.MethodInsnNode;
import org.apache.tapestry5.internal.plastic.asm.tree.MethodNode;
import org.apache.tapestry5.internal.plastic.asm.tree.VarInsnNode;
import org.apache.tapestry5.plastic.AnnotationAccess;
import org.apache.tapestry5.plastic.ClassInstantiator;
import org.apache.tapestry5.plastic.ClassType;
import org.apache.tapestry5.plastic.ComputedValue;
import org.apache.tapestry5.plastic.Condition;
import org.apache.tapestry5.plastic.FieldConduit;
import org.apache.tapestry5.plastic.FieldHandle;
import org.apache.tapestry5.plastic.InstanceContext;
import org.apache.tapestry5.plastic.InstructionBuilder;
import org.apache.tapestry5.plastic.InstructionBuilderCallback;
import org.apache.tapestry5.plastic.LocalVariable;
import org.apache.tapestry5.plastic.LocalVariableCallback;
import org.apache.tapestry5.plastic.MethodAdvice;
import org.apache.tapestry5.plastic.MethodDescription;
import org.apache.tapestry5.plastic.MethodHandle;
import org.apache.tapestry5.plastic.MethodInvocation;
import org.apache.tapestry5.plastic.MethodInvocationResult;
import org.apache.tapestry5.plastic.MethodParameter;
import org.apache.tapestry5.plastic.PlasticClass;
import org.apache.tapestry5.plastic.PlasticField;
import org.apache.tapestry5.plastic.PlasticMethod;
import org.apache.tapestry5.plastic.PlasticUtils;
import org.apache.tapestry5.plastic.PropertyAccessType;
import org.apache.tapestry5.plastic.SwitchBlock;
import org.apache.tapestry5.plastic.SwitchCallback;
import org.apache.tapestry5.plastic.TransformationOption;
import org.apache.tapestry5.plastic.TryCatchBlock;
import org.apache.tapestry5.plastic.TryCatchCallback;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlasticClassImpl
extends Lockable
implements PlasticClass,
InternalPlasticClassTransformation,
Opcodes {
    private static final String NOTHING_TO_VOID = "()V";
    private static final String CONSTRUCTOR_NAME = "<init>";
    private static final String OBJECT_INT_TO_OBJECT = "(Ljava/lang/Object;I)Ljava/lang/Object;";
    private static final String OBJECT_INT_OBJECT_TO_VOID = "(Ljava/lang/Object;ILjava/lang/Object;)V";
    private static final String OBJECT_INT_OBJECT_ARRAY_TO_METHOD_INVOCATION_RESULT = String.format("(Ljava/lang/Object;I[Ljava/lang/Object;)%s", PlasticClassImpl.toDesc(Type.getInternalName(MethodInvocationResult.class)));
    private static final String ABSTRACT_METHOD_INVOCATION_INTERNAL_NAME = PlasticInternalUtils.toInternalName(AbstractMethodInvocation.class.getName());
    private static final String OBJECT_INTERNAL_NAME = Type.getInternalName(Object.class);
    private static final String HANDLE_SHIM_BASE_CLASS_INTERNAL_NAME = Type.getInternalName(PlasticClassHandleShim.class);
    private static final String STATIC_CONTEXT_INTERNAL_NAME = Type.getInternalName(StaticContext.class);
    private static final String INSTANCE_CONTEXT_INTERNAL_NAME = Type.getInternalName(InstanceContext.class);
    private static final String INSTANCE_CONTEXT_DESC = PlasticClassImpl.toDesc(INSTANCE_CONTEXT_INTERNAL_NAME);
    private static final String CONSTRUCTOR_DESC = String.format("(L%s;L%s;)V", STATIC_CONTEXT_INTERNAL_NAME, INSTANCE_CONTEXT_INTERNAL_NAME);
    private static final Method STATIC_CONTEXT_GET_METHOD = PlasticClassImpl.toMethod(StaticContext.class, "get", Integer.TYPE);
    private static final Method COMPUTED_VALUE_GET_METHOD = PlasticClassImpl.toMethod(ComputedValue.class, "get", InstanceContext.class);
    private final ClassNode classNode;
    private final PlasticClassPool pool;
    private final String className;
    private final String superClassName;
    private final AnnotationAccess annotationAccess;
    private final List<PlasticMethodImpl> methods;
    private final Map<MethodDescription, PlasticMethod> description2method = new HashMap<MethodDescription, PlasticMethod>();
    private final Set<String> methodNames = new HashSet<String>();
    private final List<PlasticFieldImpl> fields;
    private final Set<PlasticMethodImpl> advisedMethods = PlasticInternalUtils.newSet();
    private final NameCache nameCache = new NameCache();
    private List<PlasticField> unclaimedFields;
    private final Set<String> fieldNames = PlasticInternalUtils.newSet();
    private final StaticContext staticContext;
    private final MethodBundle parentMethodBundle;
    private final MethodBundle methodBundle;
    private final Set<MethodNode> fieldTransformMethods = PlasticInternalUtils.newSet();
    private final Set<MethodNode> shimInvokedMethods = PlasticInternalUtils.newSet();
    private final Map<String, MethodNode> fieldToReadMethod = PlasticInternalUtils.newMap();
    private final Map<String, MethodNode> fieldToWriteMethod = PlasticInternalUtils.newMap();
    private MethodNode originalConstructor;
    private final MethodNode newConstructor;
    private final InstructionBuilder constructorBuilder;
    private String instanceContextFieldName;
    private Class<?> transformedClass;
    private int nextFieldIndex = 0;
    private int nextMethodIndex = 0;
    private final Set<PlasticFieldImpl> shimFields = PlasticInternalUtils.newSet();
    private final Set<PlasticMethodImpl> shimMethods = PlasticInternalUtils.newSet();

    private static String toDesc(String internalName) {
        return "L" + internalName + ";";
    }

    private static Method toMethod(Class declaringClass, String methodName, Class ... parameterTypes) {
        return PlasticUtils.getMethod(declaringClass, methodName, parameterTypes);
    }

    private static <T> T safeArrayDeref(T[] array, int index) {
        if (array == null) {
            return null;
        }
        return array[index];
    }

    public PlasticClassImpl(ClassNode classNode, PlasticClassPool pool, MethodBundle parentMethodBundle, StaticContext parentStaticContext) {
        this.classNode = classNode;
        this.pool = pool;
        this.staticContext = parentStaticContext.dupe();
        this.className = PlasticInternalUtils.toClassName(classNode.name);
        this.superClassName = PlasticInternalUtils.toClassName(classNode.superName);
        this.annotationAccess = new DelegatingAnnotationAccess(pool.createAnnotationAccess(classNode.visibleAnnotations), pool.createAnnotationAccess(this.superClassName));
        this.parentMethodBundle = parentMethodBundle;
        this.methodBundle = parentMethodBundle.createChild(this.className);
        this.methods = new ArrayList<PlasticMethodImpl>(classNode.methods.size());
        String invalidConstructorMessage = this.invalidConstructorMessage();
        for (MemberNode node : classNode.methods) {
            if (node.name.equals(CONSTRUCTOR_NAME)) {
                if (node.desc.equals(NOTHING_TO_VOID)) {
                    this.originalConstructor = node;
                    this.fieldTransformMethods.add((MethodNode)node);
                    continue;
                }
                node.instructions.clear();
                this.newBuilder((MethodNode)node).throwException(IllegalStateException.class, invalidConstructorMessage);
                continue;
            }
            if (Modifier.isStatic(node.access)) {
                if (!Modifier.isPrivate(node.access)) {
                    this.methodBundle.addMethod(node.name, node.desc);
                }
                this.methodNames.add(node.name);
                this.fieldTransformMethods.add((MethodNode)node);
                continue;
            }
            if (!Modifier.isAbstract(node.access)) {
                this.fieldTransformMethods.add((MethodNode)node);
            }
            PlasticMethodImpl pmi = new PlasticMethodImpl((MethodNode)node);
            this.methods.add(pmi);
            this.description2method.put(pmi.getDescription(), pmi);
            if (this.isInheritableMethod((MethodNode)node)) {
                this.methodBundle.addMethod(node.name, node.desc);
            }
            this.methodNames.add(node.name);
        }
        this.methodNames.addAll(parentMethodBundle.methodNames());
        Collections.sort(this.methods);
        this.fields = new ArrayList<PlasticFieldImpl>(classNode.fields.size());
        for (MemberNode node : classNode.fields) {
            this.fieldNames.add(((FieldNode)node).name);
            if (Modifier.isStatic(((FieldNode)node).access)) continue;
            if (!Modifier.isPrivate(((FieldNode)node).access)) {
                throw new IllegalArgumentException(String.format("Field %s of class %s is not private. Class transformation requires that all instance fields be private.", ((FieldNode)node).name, this.className));
            }
            this.fields.add(new PlasticFieldImpl((FieldNode)node));
        }
        Collections.sort(this.fields);
        this.newConstructor = new MethodNode(1, CONSTRUCTOR_NAME, CONSTRUCTOR_DESC, null, null);
        this.constructorBuilder = this.newBuilder(this.newConstructor);
        if (parentMethodBundle.isTransformed()) {
            this.constructorBuilder.loadThis().loadArgument(0).loadArgument(1);
            this.constructorBuilder.invokeConstructor(this.superClassName, StaticContext.class.getName(), InstanceContext.class.getName());
        } else {
            this.constructorBuilder.loadThis().invokeConstructor(this.superClassName, new String[0]);
        }
    }

    private String invalidConstructorMessage() {
        return String.format("Class %s has been transformed and may not be directly instantiated.", this.className);
    }

    @Override
    public <T extends Annotation> boolean hasAnnotation(Class<T> annotationType) {
        this.check();
        return this.annotationAccess.hasAnnotation(annotationType);
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> annotationType) {
        this.check();
        return this.annotationAccess.getAnnotation(annotationType);
    }

    @Override
    public PlasticClass proxyInterface(Class interfaceType, PlasticField field) {
        this.check();
        assert (field != null);
        this.introduceInterface(interfaceType);
        for (Method m : interfaceType.getMethods()) {
            this.introduceMethod(m).delegateTo(field);
        }
        return this;
    }

    public ClassInstantiator createInstantiator() {
        this.lock();
        this.createShimIfNeeded();
        this.interceptFieldAccess();
        this.rewriteAdvisedMethods();
        this.completeConstructor();
        this.transformedClass = this.pool.realizeTransformedClass(this.classNode, this.methodBundle, this.staticContext);
        return this.createInstantiatorFromClass(this.transformedClass);
    }

    private ClassInstantiator createInstantiatorFromClass(Class clazz) {
        try {
            Constructor ctor = clazz.getConstructor(StaticContext.class, InstanceContext.class);
            return new ClassInstantiatorImpl(clazz, ctor, this.staticContext);
        }
        catch (Exception ex) {
            throw new RuntimeException(String.format("Unable to create ClassInstantiator for class %s: %s", clazz.getName(), PlasticInternalUtils.toMessage(ex)), ex);
        }
    }

    private void completeConstructor() {
        if (this.originalConstructor != null) {
            String initializerName = this.makeUnique(this.methodNames, "initializeInstance");
            int originalAccess = this.originalConstructor.access;
            this.originalConstructor.access = 2;
            this.originalConstructor.name = initializerName;
            this.stripOutSuperConstructorCall(this.originalConstructor);
            this.constructorBuilder.loadThis().invokeVirtual(this.className, "void", initializerName, new String[0]);
            MethodNode replacementConstructor = new MethodNode(originalAccess, CONSTRUCTOR_NAME, NOTHING_TO_VOID, null, null);
            this.newBuilder(replacementConstructor).throwException(IllegalStateException.class, this.invalidConstructorMessage());
            this.classNode.methods.add(replacementConstructor);
        }
        this.constructorBuilder.returnResult();
        this.classNode.methods.add(this.newConstructor);
    }

    private void stripOutSuperConstructorCall(MethodNode cons) {
        AbstractInsnNode node;
        InsnList ins = cons.instructions;
        ListIterator li = ins.iterator();
        while (li.hasNext()) {
            node = (AbstractInsnNode)li.next();
            if (node.getOpcode() != 25) continue;
            VarInsnNode varNode = (VarInsnNode)node;
            assert (varNode.var == 0);
            li.remove();
            break;
        }
        while (li.hasNext()) {
            node = (AbstractInsnNode)li.next();
            if (node.getOpcode() != 183) continue;
            MethodInsnNode mnode = (MethodInsnNode)node;
            assert (mnode.owner.equals(this.classNode.superName));
            assert (mnode.name.equals(CONSTRUCTOR_NAME));
            assert (mnode.desc.equals(cons.desc));
            li.remove();
            return;
        }
        throw new AssertionError((Object)"Could not convert constructor to simple method.");
    }

    @Override
    public <T extends Annotation> List<PlasticField> getFieldsWithAnnotation(Class<T> annotationType) {
        this.check();
        List<PlasticField> result = this.getAllFields();
        Iterator<PlasticField> iterator = result.iterator();
        while (iterator.hasNext()) {
            PlasticField plasticField = iterator.next();
            if (plasticField.hasAnnotation(annotationType)) continue;
            iterator.remove();
        }
        return result;
    }

    @Override
    public List<PlasticField> getAllFields() {
        this.check();
        return new ArrayList<PlasticField>(this.fields);
    }

    @Override
    public List<PlasticField> getUnclaimedFields() {
        this.check();
        if (this.unclaimedFields == null) {
            this.unclaimedFields = new ArrayList<PlasticField>(this.fields.size());
            for (PlasticFieldImpl f : this.fields) {
                if (f.isClaimed()) continue;
                this.unclaimedFields.add(f);
            }
        }
        return this.unclaimedFields;
    }

    @Override
    public PlasticMethod introducePrivateMethod(String typeName, String suggestedName, String[] argumentTypes, String[] exceptionTypes) {
        this.check();
        assert (PlasticInternalUtils.isNonBlank(typeName));
        assert (PlasticInternalUtils.isNonBlank(suggestedName));
        String name = this.makeUnique(this.methodNames, suggestedName);
        MethodDescription description = new MethodDescription(2, typeName, name, argumentTypes, null, exceptionTypes);
        return this.introduceMethod(description);
    }

    @Override
    public PlasticField introduceField(String className, String suggestedName) {
        this.check();
        assert (PlasticInternalUtils.isNonBlank(className));
        assert (PlasticInternalUtils.isNonBlank(suggestedName));
        String name = this.makeUnique(this.fieldNames, suggestedName);
        FieldNode fieldNode = new FieldNode(2, name, PlasticInternalUtils.toDescriptor(className), null, null);
        this.classNode.fields.add(fieldNode);
        this.fieldNames.add(name);
        PlasticFieldImpl newField = new PlasticFieldImpl(fieldNode);
        return newField;
    }

    @Override
    public PlasticField introduceField(Class fieldType, String suggestedName) {
        assert (fieldType != null);
        return this.introduceField(this.nameCache.toTypeName(fieldType), suggestedName);
    }

    private String makeUnique(Set<String> values, String input) {
        return values.contains(input) ? input + "$" + PlasticUtils.nextUID() : input;
    }

    @Override
    public <T extends Annotation> List<PlasticMethod> getMethodsWithAnnotation(Class<T> annotationType) {
        this.check();
        List<PlasticMethod> result = this.getMethods();
        Iterator<PlasticMethod> iterator = result.iterator();
        while (iterator.hasNext()) {
            PlasticMethod method = iterator.next();
            if (method.hasAnnotation(annotationType)) continue;
            iterator.remove();
        }
        return result;
    }

    @Override
    public List<PlasticMethod> getMethods() {
        this.check();
        return new ArrayList<PlasticMethod>(this.methods);
    }

    @Override
    public PlasticMethod introduceMethod(MethodDescription description) {
        PlasticMethod result;
        this.check();
        if (Modifier.isAbstract(description.modifiers)) {
            description = description.withModifiers(description.modifiers & 0xFFFFFBFF);
        }
        if ((result = this.description2method.get(description)) == null) {
            result = this.createNewMethod(description);
            this.description2method.put(description, result);
        }
        this.methodNames.add(description.methodName);
        return result;
    }

    @Override
    public PlasticMethod introduceMethod(MethodDescription description, InstructionBuilderCallback callback) {
        this.check();
        return this.introduceMethod(description).changeImplementation(callback);
    }

    @Override
    public PlasticMethod introduceMethod(Method method) {
        this.check();
        return this.introduceMethod(new MethodDescription(method));
    }

    private void addMethod(MethodNode methodNode) {
        this.classNode.methods.add(methodNode);
        this.methodNames.add(methodNode.name);
        if (!Modifier.isPrivate(methodNode.access)) {
            this.methodBundle.addMethod(methodNode.name, methodNode.desc);
        }
    }

    private PlasticMethod createNewMethod(MethodDescription description) {
        if (Modifier.isStatic(description.modifiers)) {
            throw new IllegalArgumentException(String.format("Unable to introduce method '%s' into class %s: introduced methods may not be static.", description, this.className));
        }
        String desc = this.nameCache.toDesc(description);
        String[] exceptions = new String[description.checkedExceptionTypes.length];
        for (int i = 0; i < exceptions.length; ++i) {
            exceptions[i] = PlasticInternalUtils.toInternalName(description.checkedExceptionTypes[i]);
        }
        MethodNode methodNode = new MethodNode(description.modifiers, description.methodName, desc, description.genericSignature, exceptions);
        boolean isOverride = this.methodBundle.isImplemented(methodNode.name, desc);
        if (isOverride) {
            this.createOverrideOfBaseClassImpl(description, methodNode);
        } else {
            this.createNewMethodImpl(description, methodNode);
        }
        this.addMethod(methodNode);
        return new PlasticMethodImpl(methodNode);
    }

    private void createNewMethodImpl(MethodDescription methodDescription, MethodNode methodNode) {
        this.newBuilder(methodDescription, methodNode).returnDefaultValue();
    }

    private void createOverrideOfBaseClassImpl(MethodDescription methodDescription, MethodNode methodNode) {
        InstructionBuilderImpl builder = this.newBuilder(methodDescription, methodNode);
        builder.loadThis();
        builder.loadArguments();
        builder.invokeSpecial(this.superClassName, methodDescription);
        builder.returnResult();
    }

    private void interceptFieldAccess() {
        Set<MethodNode> unusedAccessMethods = PlasticInternalUtils.newSet();
        unusedAccessMethods.addAll(this.fieldToReadMethod.values());
        unusedAccessMethods.addAll(this.fieldToWriteMethod.values());
        unusedAccessMethods.removeAll(this.shimInvokedMethods);
        for (MethodNode node : this.fieldTransformMethods) {
            this.interceptFieldAccess(node, unusedAccessMethods);
        }
        this.classNode.methods.removeAll(unusedAccessMethods);
    }

    private void createShimIfNeeded() {
        if (this.shimFields.isEmpty() && this.shimMethods.isEmpty()) {
            return;
        }
        PlasticClassHandleShim shim = this.createShimInstance();
        this.installShim(shim);
    }

    public void installShim(PlasticClassHandleShim shim) {
        for (PlasticFieldImpl f : this.shimFields) {
            f.installShim(shim);
        }
        for (PlasticMethodImpl m : this.shimMethods) {
            m.installShim(shim);
        }
    }

    public PlasticClassHandleShim createShimInstance() {
        String shimClassName = String.format("%s$Shim_%s", this.classNode.name, PlasticUtils.nextUID());
        ClassNode shimClassNode = new ClassNode();
        shimClassNode.visit(49, 17, shimClassName, null, HANDLE_SHIM_BASE_CLASS_INTERNAL_NAME, null);
        this.implementConstructor(shimClassNode);
        if (!this.shimFields.isEmpty()) {
            this.implementShimGet(shimClassNode);
            this.implementShimSet(shimClassNode);
        }
        if (!this.shimMethods.isEmpty()) {
            this.implementShimInvoke(shimClassNode);
        }
        return this.instantiateShim(shimClassNode);
    }

    private void implementConstructor(ClassNode shimClassNode) {
        MethodNode mn = new MethodNode(1, CONSTRUCTOR_NAME, NOTHING_TO_VOID, null, null);
        InstructionBuilderImpl builder = this.newBuilder(mn);
        builder.loadThis().invokeConstructor(PlasticClassHandleShim.class, new Class[0]).returnResult();
        shimClassNode.methods.add(mn);
    }

    private PlasticClassHandleShim instantiateShim(ClassNode shimClassNode) {
        try {
            Class shimClass = this.pool.realize(this.className, ClassType.SUPPORT, shimClassNode);
            return (PlasticClassHandleShim)shimClass.newInstance();
        }
        catch (Exception ex) {
            throw new RuntimeException(String.format("Unable to instantiate shim class %s for plastic class %s: %s", PlasticInternalUtils.toClassName(shimClassNode.name), this.className, PlasticInternalUtils.toMessage(ex)), ex);
        }
    }

    private void implementShimGet(ClassNode shimClassNode) {
        MethodNode mn = new MethodNode(1, "get", OBJECT_INT_TO_OBJECT, null, null);
        InstructionBuilderImpl builder = this.newBuilder(mn);
        builder.loadArgument(0).checkcast(this.className);
        builder.loadArgument(1);
        builder.startSwitch(0, this.nextFieldIndex - 1, new SwitchCallback(){

            public void doSwitch(SwitchBlock block) {
                for (PlasticFieldImpl f : PlasticClassImpl.this.shimFields) {
                    f.extendShimGet(block);
                }
            }
        });
        shimClassNode.methods.add(mn);
    }

    private void implementShimSet(ClassNode shimClassNode) {
        MethodNode mn = new MethodNode(1, "set", OBJECT_INT_OBJECT_TO_VOID, null, null);
        InstructionBuilderImpl builder = this.newBuilder(mn);
        builder.loadArgument(0).checkcast(this.className);
        builder.loadArgument(2);
        builder.loadArgument(1);
        builder.startSwitch(0, this.nextFieldIndex - 1, new SwitchCallback(){

            public void doSwitch(SwitchBlock block) {
                for (PlasticFieldImpl f : PlasticClassImpl.this.shimFields) {
                    f.extendShimSet(block);
                }
            }
        });
        builder.returnResult();
        shimClassNode.methods.add(mn);
    }

    private void implementShimInvoke(ClassNode shimClassNode) {
        MethodNode mn = new MethodNode(1, "invoke", OBJECT_INT_OBJECT_ARRAY_TO_METHOD_INVOCATION_RESULT, null, null);
        InstructionBuilderImpl builder = this.newBuilder(mn);
        builder.loadArgument(0).checkcast(this.className);
        builder.loadArgument(1);
        builder.startSwitch(0, this.nextMethodIndex - 1, new SwitchCallback(){

            public void doSwitch(SwitchBlock block) {
                for (PlasticMethodImpl m : PlasticClassImpl.this.shimMethods) {
                    m.extendShimInvoke(block);
                }
            }
        });
        shimClassNode.methods.add(mn);
    }

    private void rewriteAdvisedMethods() {
        for (PlasticMethodImpl method : this.advisedMethods) {
            method.rewriteMethodForAdvice();
        }
    }

    private void interceptFieldAccess(MethodNode methodNode, Set<MethodNode> unusedAccessMethods) {
        InsnList insns = methodNode.instructions;
        ListIterator it = insns.iterator();
        while (it.hasNext()) {
            Map<String, MethodNode> fieldToMethod;
            MethodNode mn;
            AbstractInsnNode node = (AbstractInsnNode)it.next();
            int opcode = node.getOpcode();
            if (opcode != 180 && opcode != 181) continue;
            FieldInsnNode fnode = (FieldInsnNode)node;
            if (!fnode.owner.equals(this.classNode.name) || (mn = (fieldToMethod = opcode == 180 ? this.fieldToReadMethod : this.fieldToWriteMethod).get(fnode.name)) == null) continue;
            String methodDescription = opcode == 180 ? "()" + fnode.desc : "(" + fnode.desc + ")V";
            insns.insertBefore((AbstractInsnNode)fnode, new MethodInsnNode(182, fnode.owner, mn.name, methodDescription));
            it.remove();
            unusedAccessMethods.remove(mn);
        }
    }

    private String getInstanceContextFieldName() {
        if (this.instanceContextFieldName == null) {
            this.instanceContextFieldName = this.makeUnique(this.fieldNames, "instanceContext");
            FieldNode node = new FieldNode(18, this.instanceContextFieldName, INSTANCE_CONTEXT_DESC, null, null);
            this.classNode.fields.add(node);
            this.constructorBuilder.loadThis().loadArgument(1).putField(this.className, this.instanceContextFieldName, InstanceContext.class);
        }
        return this.instanceContextFieldName;
    }

    private String createAndInitializeFieldFromStaticContext(String suggestedFieldName, String fieldType, Object injectedFieldValue) {
        String name = this.makeUnique(this.fieldNames, suggestedFieldName);
        FieldNode field = new FieldNode(18, name, this.nameCache.toDesc(fieldType), null, null);
        this.classNode.fields.add(field);
        this.initializeFieldFromStaticContext(name, fieldType, injectedFieldValue);
        return name;
    }

    private void initializeFieldFromStaticContext(String fieldName, String fieldType, Object injectedFieldValue) {
        int index = this.staticContext.store(injectedFieldValue);
        this.constructorBuilder.loadThis();
        this.constructorBuilder.loadArgument(0).loadConstant(index);
        this.constructorBuilder.invoke(STATIC_CONTEXT_GET_METHOD);
        this.constructorBuilder.castOrUnbox(fieldType);
        this.constructorBuilder.putField(this.className, fieldName, fieldType);
    }

    private void pushInstanceContextFieldOntoStack(InstructionBuilder builder) {
        builder.loadThis().getField(this.className, this.getInstanceContextFieldName(), InstanceContext.class);
    }

    @Override
    public PlasticClass getPlasticClass() {
        return this;
    }

    @Override
    public Class<?> getTransformedClass() {
        if (this.transformedClass == null) {
            throw new IllegalStateException(String.format("Transformed class %s is not yet available because the transformation is not yet complete.", this.className));
        }
        return this.transformedClass;
    }

    private boolean isInheritableMethod(MethodNode node) {
        return (node.access & 0x402) == 0;
    }

    @Override
    public String getClassName() {
        return this.className;
    }

    private InstructionBuilderImpl newBuilder(MethodNode mn) {
        return this.newBuilder(PlasticInternalUtils.toMethodDescription(mn), mn);
    }

    private InstructionBuilderImpl newBuilder(MethodDescription description, MethodNode mn) {
        return new InstructionBuilderImpl(description, mn, this.nameCache);
    }

    @Override
    public Set<PlasticMethod> introduceInterface(Class interfaceType) {
        this.check();
        assert (interfaceType != null);
        if (!interfaceType.isInterface()) {
            throw new IllegalArgumentException(String.format("Class %s is not an interface; ony interfaces may be introduced.", interfaceType.getName()));
        }
        String interfaceName = this.nameCache.toInternalName(interfaceType);
        if (!this.classNode.interfaces.contains(interfaceName)) {
            this.classNode.interfaces.add(interfaceName);
        }
        HashSet<PlasticMethod> introducedMethods = new HashSet<PlasticMethod>();
        for (Method m : interfaceType.getMethods()) {
            MethodDescription description = new MethodDescription(m);
            if (this.isMethodImplemented(description)) continue;
            introducedMethods.add(this.introduceMethod(m));
        }
        return introducedMethods;
    }

    @Override
    public PlasticClass addToString(final String toStringValue) {
        this.check();
        if (!this.isMethodImplemented(PlasticUtils.TO_STRING_DESCRIPTION)) {
            this.introduceMethod(PlasticUtils.TO_STRING_DESCRIPTION, new InstructionBuilderCallback(){

                public void doBuild(InstructionBuilder builder) {
                    builder.loadConstant(toStringValue).returnResult();
                }
            });
        }
        return this;
    }

    @Override
    public boolean isMethodImplemented(MethodDescription description) {
        return this.methodBundle.isImplemented(description.methodName, this.nameCache.toDesc(description));
    }

    private static boolean hasAnnotations(MethodNode mn) {
        if (PlasticClassImpl.nonEmpty(mn.visibleAnnotations)) {
            return true;
        }
        if (mn.visibleParameterAnnotations != null) {
            for (List pa : mn.visibleParameterAnnotations) {
                if (!PlasticClassImpl.nonEmpty(pa)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean nonEmpty(List l) {
        return l != null && !l.isEmpty();
    }

    @Override
    public String getSuperClassName() {
        return this.superClassName;
    }

    class MethodAdviceManager {
        private static final String RETURN_VALUE = "returnValue";
        private final MethodDescription description;
        private final MethodNode advisedMethodNode;
        private final ClassNode invocationClassNode;
        private final List<MethodAdvice> advice = new ArrayList<MethodAdvice>();
        private final boolean isVoid;
        private final String invocationClassName;
        private final String newMethodName;
        private final String[] constructorTypes;

        protected MethodAdviceManager(MethodDescription description, MethodNode methodNode) {
            this.description = description;
            this.advisedMethodNode = methodNode;
            this.isVoid = description.returnType.equals("void");
            this.invocationClassName = String.format("%s$Invocation_%s_%s", PlasticClassImpl.this.className, description.methodName, PlasticUtils.nextUID());
            this.invocationClassNode = new ClassNode();
            this.invocationClassNode.visit(49, 17, PlasticClassImpl.this.nameCache.toInternalName(this.invocationClassName), null, ABSTRACT_METHOD_INVOCATION_INTERNAL_NAME, new String[]{PlasticClassImpl.this.nameCache.toInternalName(MethodInvocation.class)});
            this.constructorTypes = this.createFieldsAndConstructor();
            this.createReturnValueAccessors();
            this.createSetParameter();
            this.createGetParameter();
            this.newMethodName = String.format("advised$%s_%s", description.methodName, PlasticUtils.nextUID());
            this.createNewMethod();
            this.createProceedToAdvisedMethod();
        }

        private String[] createFieldsAndConstructor() {
            if (!this.isVoid) {
                this.invocationClassNode.visitField(1, RETURN_VALUE, PlasticClassImpl.this.nameCache.toDesc(this.description.returnType), null, null);
            }
            ArrayList<String> consTypes = new ArrayList<String>();
            consTypes.add(Object.class.getName());
            consTypes.add(InstanceContext.class.getName());
            consTypes.add(MethodInvocationBundle.class.getName());
            for (int i = 0; i < this.description.argumentTypes.length; ++i) {
                String type = this.description.argumentTypes[i];
                this.invocationClassNode.visitField(2, "p" + i, PlasticClassImpl.this.nameCache.toDesc(type), null, null);
                consTypes.add(type);
            }
            String[] constructorTypes = consTypes.toArray(new String[consTypes.size()]);
            MethodNode cons = new MethodNode(1, PlasticClassImpl.CONSTRUCTOR_NAME, PlasticClassImpl.this.nameCache.toMethodDescriptor("void", constructorTypes), null, null);
            InstructionBuilderImpl builder = PlasticClassImpl.this.newBuilder(cons);
            builder.loadThis();
            builder.loadArgument(0);
            builder.loadArgument(1);
            builder.loadArgument(2);
            builder.invokeConstructor(AbstractMethodInvocation.class, Object.class, InstanceContext.class, MethodInvocationBundle.class);
            for (int i = 0; i < this.description.argumentTypes.length; ++i) {
                String name = "p" + i;
                String type = this.description.argumentTypes[i];
                builder.loadThis();
                builder.loadArgument(3 + i);
                builder.putField(this.invocationClassName, name, type);
            }
            builder.returnResult();
            this.invocationClassNode.methods.add(cons);
            return constructorTypes;
        }

        public void add(MethodAdvice advice) {
            this.advice.add(advice);
        }

        private void createReturnValueAccessors() {
            this.addReturnValueSetter();
            this.createReturnValueGetter();
        }

        private InstructionBuilder newMethod(String name, Class returnType, Class ... argumentTypes) {
            MethodNode mn = new MethodNode(1, name, PlasticClassImpl.this.nameCache.toMethodDescriptor(returnType, argumentTypes), null, null);
            this.invocationClassNode.methods.add(mn);
            return PlasticClassImpl.this.newBuilder(mn);
        }

        private void createReturnValueGetter() {
            InstructionBuilder builder = this.newMethod("getReturnValue", Object.class, new Class[0]);
            if (this.isVoid) {
                builder.loadNull().returnResult();
            } else {
                builder.loadThis().getField(this.invocationClassName, RETURN_VALUE, this.description.returnType).boxPrimitive(this.description.returnType).returnResult();
            }
        }

        private void addReturnValueSetter() {
            InstructionBuilder builder = this.newMethod("setReturnValue", MethodInvocation.class, Object.class);
            if (this.isVoid) {
                builder.throwException(IllegalArgumentException.class, String.format("Method %s of class %s is void, setting a return value is not allowed.", this.description, PlasticClassImpl.this.className));
            } else {
                builder.loadThis().loadArgument(0);
                builder.castOrUnbox(this.description.returnType);
                builder.putField(this.invocationClassName, RETURN_VALUE, this.description.returnType);
                builder.loadThis().invoke(AbstractMethodInvocation.class, Void.TYPE, "clearCheckedException", new Class[0]);
                builder.loadThis().returnResult();
            }
        }

        private void createGetParameter() {
            InstructionBuilder builder = this.newMethod("getParameter", Object.class, Integer.TYPE);
            if (this.description.argumentTypes.length == 0) {
                this.indexOutOfRange(builder);
            } else {
                builder.loadArgument(0);
                builder.startSwitch(0, this.description.argumentTypes.length - 1, new SwitchCallback(){

                    public void doSwitch(SwitchBlock block) {
                        for (int i = 0; i < ((MethodAdviceManager)MethodAdviceManager.this).description.argumentTypes.length; ++i) {
                            final int index = i;
                            block.addCase(i, false, new InstructionBuilderCallback(){

                                public void doBuild(InstructionBuilder builder) {
                                    String type = ((MethodAdviceManager)MethodAdviceManager.this).description.argumentTypes[index];
                                    builder.loadThis();
                                    builder.getField(MethodAdviceManager.this.invocationClassName, "p" + index, type).boxPrimitive(type).returnResult();
                                }
                            });
                        }
                    }
                });
            }
        }

        private void indexOutOfRange(InstructionBuilder builder) {
            builder.throwException(IllegalArgumentException.class, "Parameter index out of range.");
        }

        private void createSetParameter() {
            InstructionBuilder builder = this.newMethod("setParameter", MethodInvocation.class, Integer.TYPE, Object.class);
            if (this.description.argumentTypes.length == 0) {
                this.indexOutOfRange(builder);
            } else {
                builder.loadArgument(0).startSwitch(0, this.description.argumentTypes.length - 1, new SwitchCallback(){

                    public void doSwitch(SwitchBlock block) {
                        for (int i = 0; i < ((MethodAdviceManager)MethodAdviceManager.this).description.argumentTypes.length; ++i) {
                            final int index = i;
                            block.addCase(i, true, new InstructionBuilderCallback(){

                                public void doBuild(InstructionBuilder builder) {
                                    String type = ((MethodAdviceManager)MethodAdviceManager.this).description.argumentTypes[index];
                                    builder.loadThis();
                                    builder.loadArgument(1).castOrUnbox(type);
                                    builder.putField(MethodAdviceManager.this.invocationClassName, "p" + index, type);
                                }
                            });
                        }
                    }
                });
                builder.loadThis().returnResult();
            }
        }

        private void createNewMethod() {
            String[] exceptions = this.advisedMethodNode.exceptions == null ? null : this.advisedMethodNode.exceptions.toArray(new String[0]);
            MethodNode mn = new MethodNode(this.advisedMethodNode.access & 0xFFFFFFFD, this.newMethodName, this.advisedMethodNode.desc, this.advisedMethodNode.signature, exceptions);
            this.advisedMethodNode.accept(mn);
            ((PlasticClassImpl)PlasticClassImpl.this).classNode.methods.add(mn);
        }

        private void createProceedToAdvisedMethod() {
            InstructionBuilder builder = this.newMethod("proceedToAdvisedMethod", Void.TYPE, new Class[0]);
            if (!this.isVoid) {
                builder.loadThis();
            }
            builder.loadThis().invoke(AbstractMethodInvocation.class, Object.class, "getInstance", new Class[0]).checkcast(PlasticClassImpl.this.className);
            for (int i = 0; i < this.description.argumentTypes.length; ++i) {
                String type = this.description.argumentTypes[i];
                builder.loadThis().getField(this.invocationClassName, "p" + i, type);
            }
            builder.startTryCatch(new TryCatchCallback(){

                public void doBlock(TryCatchBlock block) {
                    block.addTry(new InstructionBuilderCallback(){

                        public void doBuild(InstructionBuilder builder) {
                            builder.invokeVirtual(PlasticClassImpl.this.className, ((MethodAdviceManager)MethodAdviceManager.this).description.returnType, MethodAdviceManager.this.newMethodName, ((MethodAdviceManager)MethodAdviceManager.this).description.argumentTypes);
                            if (!MethodAdviceManager.this.isVoid) {
                                builder.putField(MethodAdviceManager.this.invocationClassName, MethodAdviceManager.RETURN_VALUE, ((MethodAdviceManager)MethodAdviceManager.this).description.returnType);
                            }
                            builder.returnResult();
                        }
                    });
                    for (String exceptionName : ((MethodAdviceManager)MethodAdviceManager.this).description.checkedExceptionTypes) {
                        block.addCatch(exceptionName, new InstructionBuilderCallback(){

                            public void doBuild(InstructionBuilder builder) {
                                builder.loadThis().swap();
                                builder.invoke(AbstractMethodInvocation.class, MethodInvocation.class, "setCheckedException", Exception.class);
                                builder.returnResult();
                            }
                        });
                    }
                }
            });
        }

        private void rewriteOriginalMethod() {
            PlasticClassImpl.this.pool.realize(PlasticClassImpl.this.className, ClassType.METHOD_INVOCATION, this.invocationClassNode);
            String fieldName = String.format("methodinvocationbundle_%s_%s", this.description.methodName, PlasticUtils.nextUID());
            MethodAdvice[] adviceArray = this.advice.toArray(new MethodAdvice[this.advice.size()]);
            MethodInvocationBundle bundle = new MethodInvocationBundle(this.description, adviceArray);
            PlasticClassImpl.this.classNode.visitField(18, fieldName, PlasticClassImpl.this.nameCache.toDesc(this.constructorTypes[2]), null, null);
            PlasticClassImpl.this.initializeFieldFromStaticContext(fieldName, this.constructorTypes[2], bundle);
            this.advisedMethodNode.instructions.clear();
            this.advisedMethodNode.tryCatchBlocks.clear();
            if (this.advisedMethodNode.localVariables != null) {
                this.advisedMethodNode.localVariables.clear();
            }
            InstructionBuilderImpl builder = PlasticClassImpl.this.newBuilder(this.description, this.advisedMethodNode);
            builder.newInstance(this.invocationClassName).dupe();
            builder.loadThis();
            builder.loadThis().getField(PlasticClassImpl.this.className, PlasticClassImpl.this.getInstanceContextFieldName(), this.constructorTypes[1]);
            builder.loadThis().getField(PlasticClassImpl.this.className, fieldName, this.constructorTypes[2]);
            builder.loadArguments();
            builder.invokeConstructor(this.invocationClassName, this.constructorTypes);
            builder.startVariable(this.invocationClassName, new LocalVariableCallback(){

                public void doBuild(final LocalVariable invocation, InstructionBuilder builder) {
                    builder.dupe().storeVariable(invocation);
                    builder.invoke(AbstractMethodInvocation.class, MethodInvocation.class, "proceed", new Class[0]);
                    if (((MethodAdviceManager)MethodAdviceManager.this).description.checkedExceptionTypes.length > 0) {
                        builder.invoke(MethodInvocation.class, Boolean.TYPE, "didThrowCheckedException", new Class[0]);
                        builder.when(Condition.NON_ZERO, new InstructionBuilderCallback(){

                            public void doBuild(InstructionBuilder builder) {
                                builder.loadVariable(invocation).loadTypeConstant(Exception.class);
                                builder.invokeVirtual(MethodAdviceManager.this.invocationClassName, Throwable.class.getName(), "getCheckedException", Class.class.getName());
                                builder.throwException();
                            }
                        });
                    }
                    if (!MethodAdviceManager.this.isVoid) {
                        builder.loadVariable(invocation).getField(MethodAdviceManager.this.invocationClassName, MethodAdviceManager.RETURN_VALUE, ((MethodAdviceManager)MethodAdviceManager.this).description.returnType);
                    }
                    builder.returnResult();
                }
            });
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PlasticFieldImpl
    extends PlasticMember
    implements PlasticField,
    Comparable<PlasticFieldImpl> {
        private final FieldNode node;
        private final String typeName;
        private Object tag;
        private FieldHandleImpl handle;
        private MethodNode getAccess;
        private MethodNode setAccess;
        private FieldState state;
        private int fieldIndex;

        public PlasticFieldImpl(FieldNode node) {
            super(node.visibleAnnotations);
            this.state = FieldState.INITIAL;
            this.fieldIndex = -1;
            this.node = node;
            this.typeName = Type.getType(node.desc).getClassName();
        }

        public String toString() {
            return String.format("PlasticField[%s %s %s (in class %s)]", Modifier.toString(this.node.access), this.typeName, this.node.name, PlasticClassImpl.this.className);
        }

        @Override
        public String getGenericSignature() {
            return this.node.signature;
        }

        @Override
        public int getModifiers() {
            return this.node.access;
        }

        @Override
        public int compareTo(PlasticFieldImpl o) {
            return this.node.name.compareTo(o.node.name);
        }

        @Override
        public PlasticClass getPlasticClass() {
            PlasticClassImpl.this.check();
            return PlasticClassImpl.this;
        }

        @Override
        public FieldHandle getHandle() {
            PlasticClassImpl.this.check();
            if (this.handle == null) {
                this.fieldIndex = PlasticClassImpl.this.nextFieldIndex++;
                this.handle = new FieldHandleImpl(PlasticClassImpl.this.className, this.node.name, this.fieldIndex);
                PlasticClassImpl.this.shimFields.add(this);
            }
            return this.handle;
        }

        @Override
        public PlasticField claim(Object tag) {
            assert (tag != null);
            PlasticClassImpl.this.check();
            if (this.tag != null) {
                throw new IllegalStateException(String.format("Field %s of class %s can not be claimed by %s as it is already claimed by %s.", this.node.name, PlasticClassImpl.this.className, tag, this.tag));
            }
            this.tag = tag;
            PlasticClassImpl.this.unclaimedFields = null;
            return this;
        }

        @Override
        public boolean isClaimed() {
            PlasticClassImpl.this.check();
            return this.tag != null;
        }

        @Override
        public String getName() {
            PlasticClassImpl.this.check();
            return this.node.name;
        }

        @Override
        public String getTypeName() {
            PlasticClassImpl.this.check();
            return this.typeName;
        }

        private void verifyInitialState(String operation) {
            if (this.state != FieldState.INITIAL) {
                throw new IllegalStateException(String.format("Unable to %s field %s of class %s, as it already %s.", operation, this.node.name, PlasticClassImpl.this.className, this.state.description));
            }
        }

        @Override
        public PlasticField inject(Object value) {
            PlasticClassImpl.this.check();
            this.verifyInitialState("inject a value into");
            assert (value != null);
            PlasticClassImpl.this.initializeFieldFromStaticContext(this.node.name, this.typeName, value);
            this.makeReadOnly();
            this.state = FieldState.INJECTED;
            return this;
        }

        @Override
        public PlasticField injectComputed(ComputedValue<?> computedValue) {
            PlasticClassImpl.this.check();
            this.verifyInitialState("inject a computed value into");
            assert (computedValue != null);
            this.initializeComputedField(computedValue);
            this.makeReadOnly();
            this.state = FieldState.INJECTED;
            return this;
        }

        private void initializeComputedField(ComputedValue<?> computedValue) {
            int index = PlasticClassImpl.this.staticContext.store(computedValue);
            PlasticClassImpl.this.constructorBuilder.loadThis();
            PlasticClassImpl.this.constructorBuilder.loadArgument(0).loadConstant(index);
            PlasticClassImpl.this.constructorBuilder.invoke(STATIC_CONTEXT_GET_METHOD).checkcast(ComputedValue.class);
            PlasticClassImpl.this.constructorBuilder.loadArgument(1);
            PlasticClassImpl.this.constructorBuilder.invoke(COMPUTED_VALUE_GET_METHOD).castOrUnbox(this.typeName);
            PlasticClassImpl.this.constructorBuilder.putField(PlasticClassImpl.this.className, this.node.name, this.typeName);
        }

        @Override
        public PlasticField injectFromInstanceContext() {
            PlasticClassImpl.this.check();
            this.verifyInitialState("inject instance context value into");
            PlasticClassImpl.this.constructorBuilder.loadThis();
            PlasticClassImpl.this.constructorBuilder.loadArgument(1);
            PlasticClassImpl.this.constructorBuilder.loadConstant(this.typeName);
            PlasticClassImpl.this.constructorBuilder.invokeStatic(PlasticInternalUtils.class, Object.class, "getFromInstanceContext", InstanceContext.class, String.class).castOrUnbox(this.typeName);
            PlasticClassImpl.this.constructorBuilder.putField(PlasticClassImpl.this.className, this.node.name, this.typeName);
            this.makeReadOnly();
            this.state = FieldState.INJECTED;
            return this;
        }

        @Override
        public PlasticField setConduit(FieldConduit<?> conduit) {
            assert (conduit != null);
            PlasticClassImpl.this.check();
            this.verifyInitialState("set the FieldConduit for");
            String conduitFieldName = PlasticClassImpl.this.createAndInitializeFieldFromStaticContext(this.node.name + "_FieldConduit", FieldConduit.class.getName(), conduit);
            this.replaceFieldReadAccess(conduitFieldName);
            this.replaceFieldWriteAccess(conduitFieldName);
            this.state = FieldState.CONDUIT;
            return this;
        }

        @Override
        public PlasticField setComputedConduit(ComputedValue<FieldConduit<?>> computedConduit) {
            assert (computedConduit != null);
            PlasticClassImpl.this.check();
            this.verifyInitialState("set the computed FieldConduit for");
            PlasticField conduitField = PlasticClassImpl.this.introduceField(FieldConduit.class, this.node.name + "_FieldConduit").injectComputed(computedConduit);
            this.replaceFieldReadAccess(conduitField.getName());
            this.replaceFieldWriteAccess(conduitField.getName());
            this.state = FieldState.CONDUIT;
            return this;
        }

        @Override
        public PlasticField createAccessors(PropertyAccessType accessType) {
            PlasticClassImpl.this.check();
            return this.createAccessors(accessType, PlasticInternalUtils.toPropertyName(this.node.name));
        }

        @Override
        public PlasticField createAccessors(PropertyAccessType accessType, String propertyName) {
            String signature;
            PlasticClassImpl.this.check();
            assert (accessType != null);
            assert (PlasticInternalUtils.isNonBlank(propertyName));
            String capitalized = PlasticInternalUtils.capitalize(propertyName);
            if (accessType != PropertyAccessType.WRITE_ONLY) {
                signature = this.node.signature == null ? null : "()" + this.node.signature;
                this.introduceAccessorMethod(this.getTypeName(), "get" + capitalized, null, signature, new InstructionBuilderCallback(){

                    public void doBuild(InstructionBuilder builder) {
                        builder.loadThis().getField(PlasticFieldImpl.this).returnResult();
                    }
                });
            }
            if (accessType != PropertyAccessType.READ_ONLY) {
                signature = this.node.signature == null ? null : "(" + this.node.signature + ")V";
                this.introduceAccessorMethod("void", "set" + capitalized, new String[]{this.getTypeName()}, this.node.signature, new InstructionBuilderCallback(){

                    public void doBuild(InstructionBuilder builder) {
                        builder.loadThis().loadArgument(0);
                        builder.putField(PlasticClassImpl.this.className, ((PlasticFieldImpl)PlasticFieldImpl.this).node.name, PlasticFieldImpl.this.getTypeName());
                        builder.returnResult();
                    }
                });
            }
            return this;
        }

        private void introduceAccessorMethod(String returnType, String name, String[] parameterTypes, String signature, InstructionBuilderCallback callback) {
            MethodDescription description = new MethodDescription(1, returnType, name, parameterTypes, signature, null);
            String desc = PlasticClassImpl.this.nameCache.toDesc(description);
            if (PlasticClassImpl.this.methodBundle.isImplemented(name, desc)) {
                throw new IllegalArgumentException(String.format("Unable to create new accessor method %s on class %s as the method is already implemented.", description.toString(), PlasticClassImpl.this.className));
            }
            PlasticClassImpl.this.introduceMethod(description, callback);
        }

        private void replaceFieldWriteAccess(String conduitFieldName) {
            String setAccessName = PlasticClassImpl.this.makeUnique(PlasticClassImpl.this.methodNames, "set_" + this.node.name);
            this.setAccess = new MethodNode(4112, setAccessName, "(" + this.node.desc + ")V", null, null);
            InstructionBuilderImpl builder = PlasticClassImpl.this.newBuilder(this.setAccess);
            this.pushFieldConduitOntoStack(conduitFieldName, builder);
            builder.loadThis();
            PlasticClassImpl.this.pushInstanceContextFieldOntoStack(builder);
            builder.loadArgument(0);
            builder.boxPrimitive(this.typeName);
            builder.invoke(FieldConduit.class, Void.TYPE, "set", Object.class, InstanceContext.class, Object.class);
            if (this.isWriteBehindEnabled()) {
                builder.loadThis().loadArgument(0).putField(PlasticClassImpl.this.className, this.node.name, this.typeName);
            }
            builder.returnResult();
            PlasticClassImpl.this.addMethod(this.setAccess);
            PlasticClassImpl.this.fieldToWriteMethod.put(this.node.name, this.setAccess);
        }

        private void replaceFieldReadAccess(String conduitFieldName) {
            boolean writeBehindEnabled = this.isWriteBehindEnabled();
            String getAccessName = PlasticClassImpl.this.makeUnique(PlasticClassImpl.this.methodNames, "getfieldvalue_" + this.node.name);
            this.getAccess = new MethodNode(4112, getAccessName, "()" + this.node.desc, null, null);
            InstructionBuilderImpl builder = PlasticClassImpl.this.newBuilder(this.getAccess);
            this.pushFieldConduitOntoStack(conduitFieldName, builder);
            builder.loadThis();
            PlasticClassImpl.this.pushInstanceContextFieldOntoStack(builder);
            builder.invoke(FieldConduit.class, Object.class, "get", Object.class, InstanceContext.class).castOrUnbox(this.typeName);
            if (writeBehindEnabled) {
                if (this.isWide()) {
                    builder.dupeWide().loadThis().dupe(2).pop();
                } else {
                    builder.dupe().loadThis().swap();
                }
                builder.putField(PlasticClassImpl.this.className, this.node.name, this.typeName);
            }
            builder.returnResult();
            PlasticClassImpl.this.addMethod(this.getAccess);
            PlasticClassImpl.this.fieldToReadMethod.put(this.node.name, this.getAccess);
        }

        private boolean isWriteBehindEnabled() {
            return PlasticClassImpl.this.pool.isEnabled(TransformationOption.FIELD_WRITEBEHIND);
        }

        private boolean isWide() {
            PrimitiveType pt = PrimitiveType.getByName(this.typeName);
            return pt != null && pt.isWide();
        }

        private void pushFieldConduitOntoStack(String conduitFileName, InstructionBuilder builder) {
            builder.loadThis();
            builder.getField(PlasticClassImpl.this.className, conduitFileName, FieldConduit.class);
        }

        private void makeReadOnly() {
            String setAccessName = PlasticClassImpl.this.makeUnique(PlasticClassImpl.this.methodNames, "setfieldvalue_" + this.node.name);
            this.setAccess = new MethodNode(4112, setAccessName, "(" + this.node.desc + ")V", null, null);
            String message = String.format("Field %s of class %s is read-only.", this.node.name, PlasticClassImpl.this.className);
            PlasticClassImpl.this.newBuilder(this.setAccess).throwException(IllegalStateException.class, message);
            PlasticClassImpl.this.addMethod(this.setAccess);
            PlasticClassImpl.this.fieldToWriteMethod.put(this.node.name, this.setAccess);
            this.node.access |= 0x10;
        }

        private MethodNode addShimSetAccessMethod() {
            String name = PlasticClassImpl.this.makeUnique(PlasticClassImpl.this.methodNames, "shimset_" + this.node.name);
            MethodNode mn = new MethodNode(4112, name, "(" + this.node.desc + ")V", null, null);
            InstructionBuilderImpl builder = PlasticClassImpl.this.newBuilder(mn);
            builder.loadThis().loadArgument(0).putField(PlasticClassImpl.this.className, this.node.name, this.typeName);
            builder.returnResult();
            PlasticClassImpl.this.addMethod(mn);
            PlasticClassImpl.this.fieldTransformMethods.add(mn);
            return mn;
        }

        private MethodNode addShimGetAccessMethod() {
            String name = PlasticClassImpl.this.makeUnique(PlasticClassImpl.this.methodNames, "shimget_" + this.node.name);
            MethodNode mn = new MethodNode(4112, name, "()" + this.node.desc, null, null);
            InstructionBuilderImpl builder = PlasticClassImpl.this.newBuilder(mn);
            builder.loadThis().getField(PlasticClassImpl.this.className, this.node.name, this.typeName).returnResult();
            PlasticClassImpl.this.addMethod(mn);
            PlasticClassImpl.this.fieldTransformMethods.add(mn);
            return mn;
        }

        void installShim(PlasticClassHandleShim shim) {
            if (this.handle != null) {
                this.handle.shim = shim;
            }
        }

        void extendShimGet(SwitchBlock switchBlock) {
            if (this.getAccess == null) {
                this.getAccess = this.addShimGetAccessMethod();
            }
            final String methodToInvoke = this.getAccess.name;
            PlasticClassImpl.this.shimInvokedMethods.add(this.getAccess);
            switchBlock.addCase(this.fieldIndex, false, new InstructionBuilderCallback(){

                public void doBuild(InstructionBuilder builder) {
                    builder.invokeVirtual(PlasticClassImpl.this.className, PlasticFieldImpl.this.typeName, methodToInvoke, new String[0]).boxPrimitive(PlasticFieldImpl.this.typeName).returnResult();
                }
            });
        }

        void extendShimSet(SwitchBlock switchBlock) {
            if (this.setAccess == null) {
                this.setAccess = this.addShimSetAccessMethod();
            }
            PlasticClassImpl.this.shimInvokedMethods.add(this.setAccess);
            final String methodToInvoke = this.setAccess.name;
            switchBlock.addCase(this.fieldIndex, true, new InstructionBuilderCallback(){

                public void doBuild(InstructionBuilder builder) {
                    builder.castOrUnbox(PlasticFieldImpl.this.typeName);
                    builder.invokeVirtual(PlasticClassImpl.this.className, "void", methodToInvoke, PlasticFieldImpl.this.typeName);
                }
            });
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PlasticMethodImpl
    extends PlasticMember
    implements PlasticMethod,
    Comparable<PlasticMethodImpl> {
        private final MethodNode node;
        private MethodDescription description;
        private MethodHandleImpl handle;
        private MethodAdviceManager adviceManager;
        private List<MethodParameter> parameters;
        private int methodIndex;

        public PlasticMethodImpl(MethodNode node) {
            super(node.visibleAnnotations);
            this.methodIndex = -1;
            this.node = node;
            this.description = PlasticInternalUtils.toMethodDescription(node);
        }

        public String toString() {
            return String.format("PlasticMethod[%s in class %s]", this.description, PlasticClassImpl.this.className);
        }

        @Override
        public PlasticClass getPlasticClass() {
            PlasticClassImpl.this.check();
            return PlasticClassImpl.this;
        }

        @Override
        public MethodDescription getDescription() {
            PlasticClassImpl.this.check();
            return this.description;
        }

        @Override
        public int compareTo(PlasticMethodImpl o) {
            return this.description.compareTo(o.description);
        }

        @Override
        public boolean isOverride() {
            return PlasticClassImpl.this.parentMethodBundle.isImplemented(this.node.name, this.node.desc);
        }

        @Override
        public MethodHandle getHandle() {
            PlasticClassImpl.this.check();
            if (this.handle == null) {
                this.methodIndex = PlasticClassImpl.this.nextMethodIndex++;
                this.handle = new MethodHandleImpl(PlasticClassImpl.this.className, this.description.toString(), this.methodIndex);
                PlasticClassImpl.this.shimMethods.add(this);
            }
            return this.handle;
        }

        @Override
        public PlasticMethod changeImplementation(InstructionBuilderCallback callback) {
            PlasticClassImpl.this.check();
            if (Modifier.isAbstract(this.node.access)) {
                this.node.access &= 0xFFFFFBFF;
                this.description = this.description.withModifiers(this.node.access);
            }
            this.node.instructions.clear();
            PlasticClassImpl.this.newBuilder(this.description, this.node).doCallback(callback);
            PlasticClassImpl.this.fieldTransformMethods.add(this.node);
            return this;
        }

        @Override
        public PlasticMethod addAdvice(MethodAdvice advice) {
            PlasticClassImpl.this.check();
            assert (advice != null);
            if (this.adviceManager == null) {
                this.adviceManager = new MethodAdviceManager(this.description, this.node);
                PlasticClassImpl.this.advisedMethods.add(this);
            }
            this.adviceManager.add(advice);
            return this;
        }

        @Override
        public PlasticMethod delegateTo(final PlasticField field) {
            PlasticClassImpl.this.check();
            assert (field != null);
            this.changeImplementation(new InstructionBuilderCallback(){

                public void doBuild(InstructionBuilder builder) {
                    builder.loadThis().getField(field);
                    builder.loadArguments();
                    PlasticMethodImpl.this.invokeDelegateAndReturnResult(builder, field.getTypeName());
                }
            });
            return this;
        }

        @Override
        public PlasticMethod delegateTo(PlasticMethod delegateProvidingMethod) {
            PlasticClassImpl.this.check();
            assert (delegateProvidingMethod != null);
            final MethodDescription providerDescriptor = delegateProvidingMethod.getDescription();
            final String delegateType = providerDescriptor.returnType;
            if (delegateType.equals("void") || providerDescriptor.argumentTypes.length > 0) {
                throw new IllegalArgumentException(String.format("Method %s is not usable as a delegate provider; it must be a void method that takes no arguments.", delegateProvidingMethod));
            }
            this.changeImplementation(new InstructionBuilderCallback(){

                public void doBuild(InstructionBuilder builder) {
                    builder.loadThis();
                    if (Modifier.isPrivate(providerDescriptor.modifiers)) {
                        builder.invokeSpecial(PlasticClassImpl.this.className, providerDescriptor);
                    } else {
                        builder.invokeVirtual(PlasticClassImpl.this.className, delegateType, providerDescriptor.methodName, new String[0]);
                    }
                    builder.loadArguments();
                    PlasticMethodImpl.this.invokeDelegateAndReturnResult(builder, delegateType);
                }
            });
            return this;
        }

        @Override
        public List<MethodParameter> getParameters() {
            if (this.parameters == null) {
                this.parameters = PlasticInternalUtils.newList();
                for (int i = 0; i < this.description.argumentTypes.length; ++i) {
                    this.parameters.add(new MethodParameterImpl((List)PlasticClassImpl.safeArrayDeref(this.node.visibleParameterAnnotations, i), (String)PlasticClassImpl.safeArrayDeref(this.description.argumentTypes, i), i));
                }
            }
            return this.parameters;
        }

        private void rewriteMethodForAdvice() {
            this.adviceManager.rewriteOriginalMethod();
        }

        private boolean isPrivate() {
            return Modifier.isPrivate(this.node.access);
        }

        private String setupMethodHandleAccess() {
            if (this.isPrivate()) {
                return this.createAccessMethod();
            }
            return this.node.name;
        }

        private String createAccessMethod() {
            String name = String.format("%s$access%s", this.node.name, PlasticUtils.nextUID());
            MethodNode mn = new MethodNode(4112, name, this.node.desc, this.node.signature, null);
            mn.exceptions = this.node.exceptions;
            InstructionBuilderImpl builder = PlasticClassImpl.this.newBuilder(mn);
            builder.loadThis();
            builder.loadArguments();
            builder.invokeSpecial(PlasticClassImpl.this.className, this.description);
            builder.returnResult();
            PlasticClassImpl.this.addMethod(mn);
            return name;
        }

        void installShim(PlasticClassHandleShim shim) {
            this.handle.shim = shim;
        }

        void extendShimInvoke(SwitchBlock block) {
            final String accessMethodName = this.setupMethodHandleAccess();
            block.addCase(this.methodIndex, false, new InstructionBuilderCallback(){

                public void doBuild(InstructionBuilder builder) {
                    builder.startTryCatch(new TryCatchCallback(){

                        public void doBlock(TryCatchBlock block) {
                            block.addTry(new InstructionBuilderCallback(){

                                public void doBuild(InstructionBuilder builder) {
                                    for (int i = 0; i < ((PlasticMethodImpl)PlasticMethodImpl.this).description.argumentTypes.length; ++i) {
                                        String argumentType = ((PlasticMethodImpl)PlasticMethodImpl.this).description.argumentTypes[i];
                                        builder.loadArgument(2);
                                        builder.loadArrayElement(i, Object.class.getName());
                                        builder.castOrUnbox(argumentType);
                                    }
                                    builder.invokeVirtual(PlasticClassImpl.this.className, ((PlasticMethodImpl)PlasticMethodImpl.this).description.returnType, accessMethodName, ((PlasticMethodImpl)PlasticMethodImpl.this).description.argumentTypes);
                                    if (((PlasticMethodImpl)PlasticMethodImpl.this).description.returnType.equals("void")) {
                                        builder.loadNull();
                                    } else {
                                        builder.boxPrimitive(((PlasticMethodImpl)PlasticMethodImpl.this).description.returnType);
                                    }
                                    builder.newInstance(SuccessMethodInvocationResult.class).dupe(1).swap();
                                    builder.invokeConstructor(SuccessMethodInvocationResult.class, Object.class);
                                    builder.returnResult();
                                }
                            });
                            for (String exceptionType : ((PlasticMethodImpl)PlasticMethodImpl.this).description.checkedExceptionTypes) {
                                block.addCatch(exceptionType, new InstructionBuilderCallback(){

                                    public void doBuild(InstructionBuilder builder) {
                                        builder.newInstance(FailureMethodInvocationResult.class).dupe(1).swap();
                                        builder.invokeConstructor(FailureMethodInvocationResult.class, Throwable.class);
                                        builder.returnResult();
                                    }
                                });
                            }
                        }
                    });
                }
            });
        }

        private void invokeDelegateAndReturnResult(InstructionBuilder builder, String delegateType) {
            TypeCategory typeCategory = PlasticClassImpl.this.pool.getTypeCategory(delegateType);
            if (typeCategory == TypeCategory.INTERFACE) {
                builder.invokeInterface(delegateType, this.description.returnType, this.description.methodName, this.description.argumentTypes);
            } else {
                builder.invokeVirtual(delegateType, this.description.returnType, this.description.methodName, this.description.argumentTypes);
            }
            builder.returnResult();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MethodParameterImpl
    extends PlasticMember
    implements MethodParameter {
        private final String type;
        private final int index;

        MethodParameterImpl(List<AnnotationNode> visibleAnnotations, String type, int index) {
            super(visibleAnnotations);
            this.type = type;
            this.index = index;
        }

        @Override
        public String getType() {
            PlasticClassImpl.this.check();
            return this.type;
        }

        @Override
        public int getIndex() {
            PlasticClassImpl.this.check();
            return this.index;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PlasticMember
    implements AnnotationAccess {
        private final AnnotationAccess annotationAccess;

        PlasticMember(List<AnnotationNode> visibleAnnotations) {
            this.annotationAccess = PlasticClassImpl.this.pool.createAnnotationAccess(visibleAnnotations);
        }

        @Override
        public <T extends Annotation> boolean hasAnnotation(Class<T> annotationType) {
            PlasticClassImpl.this.check();
            return this.annotationAccess.hasAnnotation(annotationType);
        }

        @Override
        public <T extends Annotation> T getAnnotation(Class<T> annotationType) {
            PlasticClassImpl.this.check();
            return this.annotationAccess.getAnnotation(annotationType);
        }
    }
}

