/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.plastic;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.apache.tapestry5.internal.plastic.MethodInvocationBundle;
import org.apache.tapestry5.plastic.InstanceContext;
import org.apache.tapestry5.plastic.MethodInvocation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMethodInvocation
implements MethodInvocation {
    private final Object instance;
    private final InstanceContext instanceContext;
    private final MethodInvocationBundle bundle;
    private int adviceIndex;
    private Exception checkedException;

    protected AbstractMethodInvocation(Object instance, InstanceContext instanceContext, MethodInvocationBundle bundle) {
        this.instance = instance;
        this.instanceContext = instanceContext;
        this.bundle = bundle;
    }

    protected void clearCheckedException() {
        this.checkedException = null;
    }

    @Override
    public void rethrow() {
        if (this.checkedException != null) {
            throw new RuntimeException(this.checkedException);
        }
    }

    @Override
    public boolean didThrowCheckedException() {
        return this.checkedException != null;
    }

    @Override
    public <T extends Throwable> T getCheckedException(Class<T> exceptionType) {
        assert (exceptionType != null);
        if (exceptionType.isInstance(this.checkedException)) {
            return (T)((Throwable)exceptionType.cast(this.checkedException));
        }
        return null;
    }

    @Override
    public Object getInstance() {
        return this.instance;
    }

    @Override
    public InstanceContext getInstanceContext() {
        return this.instanceContext;
    }

    @Override
    public MethodInvocation proceed() {
        if (this.adviceIndex == this.bundle.advice.length) {
            this.proceedToAdvisedMethod();
        } else {
            this.bundle.advice[this.adviceIndex++].advise(this);
        }
        return this;
    }

    @Override
    public MethodInvocation setCheckedException(Exception exception) {
        this.checkedException = exception;
        return this;
    }

    @Override
    public String getMethodName() {
        return this.bundle.methodDescription.methodName;
    }

    @Override
    public int getParameterCount() {
        return this.bundle.methodDescription.argumentTypes.length;
    }

    @Override
    public <T extends Annotation> boolean hasAnnotation(Class<T> annotationType) {
        return this.getAnnotation(annotationType) != null;
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> annotationType) {
        return this.method().getAnnotation(annotationType);
    }

    public Method method() {
        return this.bundle.getMethod(this.getInstance());
    }

    @Override
    public Class getReturnType() {
        return this.method().getReturnType();
    }

    @Override
    public Class getParameterType(int index) {
        return this.method().getParameterTypes()[index];
    }

    protected abstract void proceedToAdvisedMethod();
}

