/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.plastic;

import java.lang.reflect.Array;
import java.util.ArrayList;
import org.apache.tapestry5.internal.plastic.AnnotationBuilder;
import org.apache.tapestry5.internal.plastic.PlasticClassPool;
import org.apache.tapestry5.internal.plastic.PlasticInternalUtils;
import org.apache.tapestry5.internal.plastic.asm.AnnotationVisitor;
import org.apache.tapestry5.internal.plastic.asm.Type;

public abstract class AbstractAnnotationBuilder
implements AnnotationVisitor {
    protected final PlasticClassPool pool;

    public AbstractAnnotationBuilder(PlasticClassPool pool) {
        this.pool = pool;
    }

    protected abstract void store(String var1, Object var2);

    protected Class elementTypeForArrayAttribute(String name) {
        throw new IllegalStateException("elementTypeForArrayAttribute() may not be invoked here.");
    }

    public void visit(String name, Object value) {
        if (value instanceof Type) {
            Type type = (Type)value;
            Class valueType = this.pool.loadClass(type.getClassName());
            this.store(name, valueType);
            return;
        }
        this.store(name, value);
    }

    public void visitEnum(String name, String desc, String value) {
        try {
            String enumClassName = PlasticInternalUtils.objectDescriptorToClassName(desc);
            Class<?> enumClass = this.pool.loader.loadClass(enumClassName);
            Object enumValue = Enum.valueOf(enumClass, value);
            this.store(name, enumValue);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(String.format("Unable to convert enum annotation attribute %s %s: %s", value, desc, PlasticInternalUtils.toMessage(ex)), ex);
        }
    }

    public AnnotationVisitor visitAnnotation(final String name, String desc) {
        final AbstractAnnotationBuilder outerBuilder = this;
        Class nestedAnnotationType = this.pool.loadClass(PlasticInternalUtils.objectDescriptorToClassName(desc));
        return new AnnotationBuilder(nestedAnnotationType, this.pool){

            public void visitEnd() {
                outerBuilder.store(name, this.createAnnotation());
            }
        };
    }

    public AnnotationVisitor visitArray(final String name) {
        final ArrayList values = new ArrayList();
        final Class componentType = this.elementTypeForArrayAttribute(name);
        final AbstractAnnotationBuilder outerBuilder = this;
        return new AbstractAnnotationBuilder(this.pool){

            protected void store(String name2, Object value) {
                values.add(value);
            }

            public void visitEnd() {
                Object[] array = Array.newInstance(componentType, values.size());
                if (values.size() != 0) {
                    array = values.toArray((Object[])array);
                }
                outerBuilder.store(name, array);
            }
        };
    }

    public void visitEnd() {
    }
}

