/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.views.tiles;

import com.opensymphony.xwork2.ActionInvocation;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.result.ServletDispatcherResult;
import org.apache.struts2.tiles.StrutsTilesAnnotationProcessor;
import org.apache.struts2.tiles.annotation.TilesDefinition;
import org.apache.tiles.Definition;
import org.apache.tiles.TilesContainer;
import org.apache.tiles.TilesException;
import org.apache.tiles.access.TilesAccess;
import org.apache.tiles.mgmt.MutableTilesContainer;
import org.apache.tiles.request.ApplicationContext;
import org.apache.tiles.request.Request;
import org.apache.tiles.request.servlet.ServletRequest;
import org.apache.tiles.request.servlet.ServletUtil;

public class TilesResult
extends ServletDispatcherResult {
    private static final long serialVersionUID = -3806939435493086244L;
    private static final Logger LOG = LogManager.getLogger(TilesResult.class);

    public TilesResult() {
    }

    public TilesResult(String location) {
        super(location);
    }

    public void doExecute(String location, ActionInvocation invocation) throws Exception {
        StrutsTilesAnnotationProcessor annotationProcessor = new StrutsTilesAnnotationProcessor();
        TilesDefinition tilesDefinition = null;
        Object action = invocation.getAction();
        String actionName = invocation.getInvocationContext().getName();
        if (StringUtils.isEmpty((CharSequence)location)) {
            String tileName;
            LOG.trace("location not set -> action must have one @TilesDefinition");
            tilesDefinition = annotationProcessor.findAnnotation(action, null);
            location = tileName = StringUtils.isNotEmpty((CharSequence)tilesDefinition.name()) ? tilesDefinition.name() : actionName;
            LOG.debug("using new location name '{}' and @TilesDefinition '{}'", (Object)location, (Object)tilesDefinition);
        }
        this.setLocation(location);
        ServletContext servletContext = ServletActionContext.getServletContext();
        ApplicationContext applicationContext = ServletUtil.getApplicationContext((ServletContext)servletContext);
        TilesContainer container = TilesAccess.getContainer((ApplicationContext)applicationContext);
        HttpServletRequest httpRequest = ServletActionContext.getRequest();
        HttpServletResponse httpResponse = ServletActionContext.getResponse();
        ServletRequest request = new ServletRequest(applicationContext, httpRequest, httpResponse);
        boolean definitionValid = false;
        try {
            LOG.debug("checking if tiles definition exists '{}'", (Object)location);
            definitionValid = container.isValidDefinition(location, (Request)request);
        }
        catch (TilesException e) {
            LOG.warn("got TilesException while checking if definiton exists, ignoring it", (Throwable)e);
        }
        if (!definitionValid) {
            if (tilesDefinition == null) {
                LOG.trace("tilesDefinition not found yet, searching in action");
                tilesDefinition = annotationProcessor.findAnnotation(action, location);
            }
            if (tilesDefinition != null) {
                Definition definition = annotationProcessor.buildTilesDefinition(location, tilesDefinition);
                if (container instanceof MutableTilesContainer) {
                    LOG.debug("registering tiles definition with name '{}'", (Object)definition.getName());
                    ((MutableTilesContainer)container).register(definition, (Request)request);
                } else {
                    LOG.error("cannot register tiles definition as tiles container is not mutable!");
                }
            } else {
                LOG.warn("could not find @TilesDefinition for action: {}", (Object)actionName);
            }
        }
        container.render(location, (Request)request);
    }
}

