/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sqlfederation.optimizer.statement;

import java.util.Objects;
import lombok.Generated;
import org.apache.calcite.adapter.enumerable.EnumerableConvention;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.metadata.JaninoRelMetadataProvider;
import org.apache.calcite.rel.metadata.RelMetadataQueryBase;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql2rel.SqlToRelConverter;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;
import org.apache.shardingsphere.sqlfederation.optimizer.SQLFederationExecutionPlan;
import org.apache.shardingsphere.sqlfederation.optimizer.converter.SQLNodeConverterEngine;
import org.apache.shardingsphere.sqlfederation.optimizer.operator.util.LogicalScanRelShuttle;
import org.apache.shardingsphere.sqlfederation.optimizer.planner.util.SQLFederationPlannerUtils;

public final class SQLStatementCompiler {
    private final SqlToRelConverter converter;

    public SQLFederationExecutionPlan compile(SQLStatement sqlStatement, String databaseType) {
        RelMetadataQueryBase.THREAD_PROVIDERS.set(JaninoRelMetadataProvider.DEFAULT);
        SqlNode sqlNode = SQLNodeConverterEngine.convert(sqlStatement);
        RelNode logicalPlan = this.converter.convertQuery((SqlNode)sqlNode, (boolean)true, (boolean)true).rel;
        RelDataType resultColumnType = Objects.requireNonNull(this.converter.validator).getValidatedNodeType(sqlNode);
        RelNode replacePlan = LogicalScanRelShuttle.replace(logicalPlan, databaseType);
        RelNode rewritePlan = this.rewrite(replacePlan, SQLFederationPlannerUtils.createHepPlanner());
        RelNode physicalPlan = this.optimize(rewritePlan, this.converter);
        RelMetadataQueryBase.THREAD_PROVIDERS.remove();
        return new SQLFederationExecutionPlan(physicalPlan, resultColumnType);
    }

    private RelNode rewrite(RelNode logicalPlan, RelOptPlanner hepPlanner) {
        hepPlanner.setRoot(logicalPlan);
        return hepPlanner.findBestExp();
    }

    private RelNode optimize(RelNode rewritePlan, SqlToRelConverter converter) {
        RelOptPlanner planner = converter.getCluster().getPlanner();
        if (rewritePlan.getTraitSet().equals((Object)converter.getCluster().traitSet().replace((RelTrait)EnumerableConvention.INSTANCE))) {
            planner.setRoot(rewritePlan);
        } else {
            planner.setRoot(planner.changeTraits(rewritePlan, converter.getCluster().traitSet().replace((RelTrait)EnumerableConvention.INSTANCE)));
        }
        return planner.findBestExp();
    }

    @Generated
    public SQLStatementCompiler(SqlToRelConverter converter) {
        this.converter = converter;
    }
}

