/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.parser;

import org.antlr.v4.runtime.misc.ParseCancellationException;
import org.apache.shardingsphere.distsql.parser.engine.api.DistSQLStatementParserEngine;
import org.apache.shardingsphere.infra.database.core.type.DatabaseType;
import org.apache.shardingsphere.infra.exception.dialect.exception.syntax.sql.DialectSQLParsingException;
import org.apache.shardingsphere.infra.parser.SQLParserEngine;
import org.apache.shardingsphere.infra.parser.sql.SQLStatementParserEngine;
import org.apache.shardingsphere.infra.parser.sql.SQLStatementParserEngineFactory;
import org.apache.shardingsphere.sql.parser.api.CacheOption;
import org.apache.shardingsphere.sql.parser.exception.SQLParsingException;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.sql.common.util.SQLUtils;

public final class ShardingSphereSQLParserEngine
implements SQLParserEngine {
    private final SQLStatementParserEngine sqlStatementParserEngine;
    private final DistSQLStatementParserEngine distSQLStatementParserEngine;

    public ShardingSphereSQLParserEngine(DatabaseType databaseType, CacheOption sqlStatementCacheOption, CacheOption parseTreeCacheOption) {
        this.sqlStatementParserEngine = SQLStatementParserEngineFactory.getSQLStatementParserEngine(databaseType, sqlStatementCacheOption, parseTreeCacheOption);
        this.distSQLStatementParserEngine = new DistSQLStatementParserEngine();
    }

    @Override
    public SQLStatement parse(String sql, boolean useCache) {
        try {
            return this.sqlStatementParserEngine.parse(sql, useCache);
        }
        catch (ParseCancellationException | SQLParsingException originalEx) {
            try {
                String trimSQL = SQLUtils.trimComment((String)sql);
                return this.distSQLStatementParserEngine.parse(trimSQL);
            }
            catch (SQLParsingException ignored) {
                throw originalEx instanceof SQLParsingException ? new DialectSQLParsingException(originalEx.getMessage(), ((SQLParsingException)originalEx).getSymbol(), ((SQLParsingException)originalEx).getLine()) : originalEx;
            }
        }
    }
}

