/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat.mp;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.xml.transform.TransformerConfigurationException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.apache.rat.Defaults;
import org.apache.rat.Report;
import org.apache.rat.ReportConfiguration;
import org.apache.rat.analysis.IHeaderMatcher;
import org.apache.rat.analysis.util.HeaderMatcherMultiplexer;
import org.apache.rat.api.RatException;
import org.apache.rat.license.ILicenseFamily;
import org.apache.rat.mp.FilesReportable;
import org.apache.rat.mp.HeaderMatcherSpecification;
import org.apache.rat.mp.LicenseFamilySpecification;
import org.apache.rat.report.IReportable;
import org.apache.rat.report.claim.ClaimStatistic;
import org.codehaus.plexus.util.DirectoryScanner;

public abstract class AbstractRatMojo
extends AbstractMojo {
    public static final String[] MAVEN_DEFAULT_EXCLUDES = new String[]{"target/**/*", "cobertura.ser", "release.properties", "pom.xml.releaseBackup"};
    public static final String[] ECLIPSE_DEFAULT_EXCLUDES = new String[]{".classpath", ".project", ".settings/**/*"};
    public static final String[] IDEA_DEFAULT_EXCLUDES = new String[]{"*.iml", "*.ipr", "*.iws"};
    protected File basedir;
    private HeaderMatcherSpecification[] licenseMatchers;
    private IHeaderMatcher[] licenses;
    private LicenseFamilySpecification[] licenseFamilyNames;
    private ILicenseFamily[] licenseFamilies;
    private boolean addDefaultLicenseMatchers;
    private String[] includes;
    private String[] excludes;
    private boolean useDefaultExcludes;
    private boolean useMavenDefaultExcludes;
    private boolean useEclipseDefaultExcludes;
    private boolean useIdeaDefaultExcludes;
    private boolean excludeSubProjects;
    private MavenProject project;
    static /* synthetic */ Class class$org$apache$rat$analysis$IHeaderMatcher;
    static /* synthetic */ Class class$org$apache$rat$license$ILicenseFamily;

    protected MavenProject getProject() {
        return this.project;
    }

    protected IHeaderMatcher[] getLicenseMatchers() throws MojoFailureException, MojoExecutionException {
        ArrayList<IHeaderMatcher> list = new ArrayList<IHeaderMatcher>();
        if (this.licenses != null) {
            list.addAll(Arrays.asList(this.licenses));
        }
        if (this.licenseMatchers != null) {
            for (int i = 0; i < this.licenseMatchers.length; ++i) {
                HeaderMatcherSpecification spec = this.licenseMatchers[i];
                String className = spec.getClassName();
                IHeaderMatcher headerMatcher = (IHeaderMatcher)this.newInstance(class$org$apache$rat$analysis$IHeaderMatcher == null ? AbstractRatMojo.class$("org.apache.rat.analysis.IHeaderMatcher") : class$org$apache$rat$analysis$IHeaderMatcher, className);
                list.add(headerMatcher);
            }
        }
        if (this.addDefaultLicenseMatchers) {
            list.addAll(Arrays.asList(Defaults.DEFAULT_MATCHERS));
        }
        return list.toArray(new IHeaderMatcher[list.size()]);
    }

    private Object newInstance(Class clazz, String className) throws MojoExecutionException, MojoFailureException {
        Object o;
        try {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            o = cl.loadClass(className).newInstance();
        }
        catch (InstantiationException e) {
            throw new MojoExecutionException("Failed to instantiate class " + className + ": " + e.getMessage(), (Exception)e);
        }
        catch (ClassCastException e) {
            throw new MojoExecutionException("The class " + className + " is not implementing " + clazz.getName() + ": " + e.getMessage(), (Exception)e);
        }
        catch (IllegalAccessException e) {
            throw new MojoExecutionException("Illegal access to class " + className + ": " + e.getMessage(), (Exception)e);
        }
        catch (ClassNotFoundException e) {
            throw new MojoExecutionException("Class " + className + " not found: " + e.getMessage(), (Exception)e);
        }
        if (!clazz.isAssignableFrom(o.getClass())) {
            throw new MojoFailureException("The class " + o.getClass().getName() + " does not implement " + clazz.getName());
        }
        return o;
    }

    private void add(List pList, String[] pArray) {
        if (pArray != null) {
            for (int i = 0; i < pArray.length; ++i) {
                pList.add(pArray[i]);
            }
        }
    }

    protected IReportable getResources() {
        DirectoryScanner ds = new DirectoryScanner();
        ds.setBasedir(this.basedir);
        this.setExcludes(ds);
        this.setIncludes(ds);
        ds.scan();
        String[] files = ds.getIncludedFiles();
        try {
            return new FilesReportable(this.basedir, files);
        }
        catch (IOException e) {
            throw new UndeclaredThrowableException(e);
        }
    }

    private void setIncludes(DirectoryScanner ds) {
        if (this.includes != null) {
            ds.setIncludes(this.includes);
        }
    }

    private void setExcludes(DirectoryScanner ds) {
        ArrayList<String> excludeList1 = new ArrayList<String>();
        if (this.useDefaultExcludes) {
            this.add(excludeList1, DirectoryScanner.DEFAULTEXCLUDES);
        }
        if (this.useMavenDefaultExcludes) {
            this.add(excludeList1, MAVEN_DEFAULT_EXCLUDES);
        }
        if (this.useEclipseDefaultExcludes) {
            this.add(excludeList1, ECLIPSE_DEFAULT_EXCLUDES);
        }
        if (this.useIdeaDefaultExcludes) {
            this.add(excludeList1, IDEA_DEFAULT_EXCLUDES);
        }
        if (this.excludeSubProjects && this.project != null && this.project.getModules() != null) {
            Iterator it = this.project.getModules().iterator();
            while (it.hasNext()) {
                String moduleSubPath = (String)it.next();
                excludeList1.add(moduleSubPath + "/**/*");
            }
        }
        ArrayList<String> excludeList = excludeList1;
        if (this.excludes == null || this.excludes.length == 0) {
            this.getLog().info((CharSequence)"No excludes");
        } else {
            for (int i = 0; i < this.excludes.length; ++i) {
                this.getLog().info((CharSequence)("Exclude: " + this.excludes[i]));
            }
        }
        this.add(excludeList, this.excludes);
        if (!excludeList.isEmpty()) {
            String[] allExcludes = excludeList.toArray(new String[excludeList.size()]);
            ds.setExcludes(allExcludes);
        }
    }

    protected ClaimStatistic createReport(Writer out, InputStream style) throws MojoExecutionException, MojoFailureException {
        ReportConfiguration configuration = this.getConfiguration();
        try {
            if (style != null) {
                return Report.report((Writer)out, (IReportable)this.getResources(), (InputStream)style, (ReportConfiguration)configuration);
            }
            return Report.report((IReportable)this.getResources(), (Writer)out, (ReportConfiguration)configuration);
        }
        catch (TransformerConfigurationException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
        catch (InterruptedException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
        catch (RatException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
    }

    protected ReportConfiguration getConfiguration() throws MojoFailureException, MojoExecutionException {
        ReportConfiguration configuration = new ReportConfiguration();
        configuration.setHeaderMatcher((IHeaderMatcher)new HeaderMatcherMultiplexer(this.getLicenseMatchers()));
        configuration.setApprovedLicenseNames(this.getApprovedLicenseNames());
        return configuration;
    }

    private ILicenseFamily[] getApprovedLicenseNames() throws MojoExecutionException, MojoFailureException {
        ArrayList<Object> list = new ArrayList<Object>();
        if (this.licenseFamilies != null) {
            list.addAll(Arrays.asList(this.licenseFamilies));
        }
        if (this.licenseFamilyNames != null) {
            for (int i = 0; i < this.licenseFamilyNames.length; ++i) {
                LicenseFamilySpecification spec = this.licenseFamilyNames[i];
                list.add(this.newInstance(class$org$apache$rat$license$ILicenseFamily == null ? AbstractRatMojo.class$("org.apache.rat.license.ILicenseFamily") : class$org$apache$rat$license$ILicenseFamily, spec.getClassName()));
            }
        }
        if (list.isEmpty()) {
            return null;
        }
        return list.toArray(new ILicenseFamily[list.size()]);
    }
}

