/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat.mp;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URL;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.rat.Defaults;
import org.apache.rat.mp.AbstractRatMojo;
import org.apache.rat.mp.RatCheckException;
import org.apache.rat.mp.RatStatistics;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class RatCheckMojo
extends AbstractRatMojo {
    private File reportFile;
    private int numUnapprovedLicenses;

    private URL getStylesheetURL() {
        URL url = Thread.currentThread().getContextClassLoader().getResource("org/apache/rat/mp/identity.xsl");
        if (url == null) {
            throw new IllegalStateException("Failed to locate stylesheet");
        }
        return url;
    }

    private Document getRawReport() throws MojoExecutionException, MojoFailureException {
        URL url = this.getStylesheetURL();
        InputStream style = null;
        try {
            style = url.openStream();
            StringWriter sw = new StringWriter();
            this.createReport(new PrintWriter(sw), style);
            style.close();
            style = null;
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            dbf.setValidating(false);
            Document document = dbf.newDocumentBuilder().parse(new InputSource(new StringReader(sw.toString())));
            return document;
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
        catch (SAXException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
        catch (ParserConfigurationException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
        finally {
            if (style != null) {
                try {
                    style.close();
                }
                catch (Throwable t) {}
            }
        }
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        File parent = this.reportFile.getParentFile();
        parent.mkdirs();
        Document report = this.getRawReport();
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(this.reportFile);
            Transformer t = TransformerFactory.newInstance().newTransformer(new StreamSource(Defaults.getDefaultStyleSheet()));
            t.transform(new DOMSource(report), new StreamResult(fos));
            fos.close();
            fos = null;
        }
        catch (TransformerException e) {
            throw new MojoExecutionException("Failed to create file " + this.reportFile + ": " + e.getMessage(), (Exception)e);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to create file " + this.reportFile + ": " + e.getMessage(), (Exception)e);
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (Throwable t) {}
            }
        }
        this.check(report);
    }

    private void count(RatStatistics pStatistics, Node node) {
        block4: for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            switch (child.getNodeType()) {
                case 1: {
                    String localName;
                    Element e = (Element)child;
                    String uri = e.getNamespaceURI();
                    if ((uri == null || uri.length() == 0) && "license-approval".equals(localName = e.getLocalName())) {
                        if (Boolean.valueOf(e.getAttribute("name")).booleanValue()) {
                            pStatistics.setNumApprovedLicenses(pStatistics.getNumApprovedLicenses() + 1);
                        } else {
                            pStatistics.setNumUnapprovedLicenses(pStatistics.getNumUnapprovedLicenses() + 1);
                        }
                    }
                    this.count(pStatistics, child);
                    continue block4;
                }
                case 11: {
                    this.count(pStatistics, child);
                    continue block4;
                }
            }
        }
    }

    protected void check(Document document) throws MojoFailureException {
        RatStatistics statistics = new RatStatistics();
        this.count(statistics, document);
        this.check(statistics);
    }

    protected void check(RatStatistics statistics) throws MojoFailureException {
        if (this.numUnapprovedLicenses < statistics.getNumUnapprovedLicenses()) {
            throw new RatCheckException("Too many unapproved licenses: " + statistics.getNumUnapprovedLicenses());
        }
    }
}

