/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hpbf.model;

import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.poi.poifs.filesystem.DirectoryNode;
import org.apache.poi.poifs.filesystem.DocumentEntry;

public abstract class HPBFPart {
    protected byte[] data;

    public HPBFPart(DirectoryNode baseDir, String[] path) throws IOException {
        DocumentEntry docProps;
        DirectoryNode dir = this.getDir(path, baseDir);
        String name = path[path.length - 1];
        try {
            docProps = (DocumentEntry)dir.getEntry(name);
        }
        catch (FileNotFoundException e) {
            throw new IllegalArgumentException("File invalid - failed to find document entry '" + name + "'");
        }
        this.data = new byte[docProps.getSize()];
        dir.createDocumentInputStream(name).read(this.data);
    }

    private DirectoryNode getDir(String[] path, DirectoryNode baseDir) {
        DirectoryNode dir = baseDir;
        for (int i = 0; i < path.length - 1; ++i) {
            try {
                dir = (DirectoryNode)dir.getEntry(path[i]);
                continue;
            }
            catch (FileNotFoundException e) {
                throw new IllegalArgumentException("File invalid - failed to find directory entry '" + path[i] + "'");
            }
        }
        return dir;
    }

    public void writeOut(DirectoryNode baseDir) throws IOException {
        String[] path = this.getPath();
        DirectoryNode dir = baseDir;
        for (int i = 0; i < path.length - 1; ++i) {
            try {
                dir = (DirectoryNode)dir.getEntry(path[i]);
                continue;
            }
            catch (FileNotFoundException e) {
                dir.createDirectory(path[i]);
            }
        }
        this.generateData();
        ByteArrayInputStream bais = new ByteArrayInputStream(this.data);
        dir.createDocument(path[path.length - 1], (InputStream)bais);
    }

    protected abstract void generateData();

    public byte[] getData() {
        return this.data;
    }

    public final String[] getPath() {
        return null;
    }
}

