/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.driver;

import java.io.IOException;
import javax.portlet.PortletException;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pluto.PortletContainer;
import org.apache.pluto.PortletContainerException;
import org.apache.pluto.PortletWindow;
import org.apache.pluto.driver.config.DriverConfiguration;
import org.apache.pluto.driver.core.PortalRequestContext;
import org.apache.pluto.driver.core.PortletWindowImpl;
import org.apache.pluto.driver.services.portal.PageConfig;
import org.apache.pluto.driver.services.portal.PortletWindowConfig;
import org.apache.pluto.driver.url.PortalURL;

public class PortalDriverServlet
extends HttpServlet {
    private static final Log LOG = LogFactory.getLog((Class)(class$org$apache$pluto$driver$PortalDriverServlet == null ? (class$org$apache$pluto$driver$PortalDriverServlet = PortalDriverServlet.class$("org.apache.pluto.driver.PortalDriverServlet")) : class$org$apache$pluto$driver$PortalDriverServlet));
    private ServletContext servletContext;
    public static final String DEFAULT_PAGE_URI = "/WEB-INF/themes/pluto-default-theme.jsp";
    protected PortletContainer container;
    static /* synthetic */ Class class$org$apache$pluto$driver$PortalDriverServlet;

    public String getServletInfo() {
        return "Pluto Portal Driver Servlet";
    }

    public void init() {
        this.servletContext = this.getServletContext();
        this.container = (PortletContainer)this.servletContext.getAttribute("portletContainer");
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        PortletWindowConfig actionWindowConfig;
        PortalRequestContext portalRequestContext = new PortalRequestContext(this.getServletContext(), request, response);
        PortalURL portalURL = portalRequestContext.getRequestedPortalURL();
        String actionWindowId = portalURL.getActionWindow();
        PortletWindowConfig portletWindowConfig = actionWindowConfig = actionWindowId == null ? null : PortletWindowConfig.fromId(actionWindowId);
        if (actionWindowConfig != null) {
            PortletWindowImpl portletWindow = new PortletWindowImpl(actionWindowConfig, portalURL);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Processing action request for window: " + portletWindow.getId().getStringId()));
            }
            try {
                this.container.doAction((PortletWindow)portletWindow, request, response);
            }
            catch (PortletContainerException ex) {
                throw new ServletException((Throwable)ex);
            }
            catch (PortletException ex) {
                throw new ServletException((Throwable)ex);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Action request processed.\n\n");
            }
        } else {
            String uri;
            PageConfig pageConfig;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Processing render request.");
            }
            if ((pageConfig = this.getPageConfig(portalURL)) == null) {
                LOG.error((Object)("PageConfig for render path [" + portalURL.getRenderPath() + "] could not be found."));
            }
            request.setAttribute("currentPage", (Object)pageConfig);
            String string = uri = pageConfig.getUri() != null ? pageConfig.getUri() : DEFAULT_PAGE_URI;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Dispatching to: " + uri));
            }
            RequestDispatcher dispatcher = request.getRequestDispatcher(uri);
            dispatcher.forward((ServletRequest)request, (ServletResponse)response);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Render request processed.\n\n");
            }
        }
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    private PageConfig getPageConfig(PortalURL currentURL) {
        String requestedPageId = currentURL.getRenderPath();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Rendering Portal: Requested Page: " + requestedPageId));
        }
        return this.getDriverConfiguration().getPageConfig(requestedPageId);
    }

    private DriverConfiguration getDriverConfiguration() {
        return (DriverConfiguration)this.getServletContext().getAttribute("driverConfig");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

