/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.internal.impl;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.portlet.PortalContext;
import javax.portlet.PortletMode;
import javax.portlet.PortletModeException;
import javax.portlet.PortletSecurityException;
import javax.portlet.PortletURL;
import javax.portlet.WindowState;
import javax.portlet.WindowStateException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.pluto.PortletContainer;
import org.apache.pluto.descriptors.portlet.PortletDD;
import org.apache.pluto.descriptors.portlet.SupportsDD;
import org.apache.pluto.internal.InternalPortletWindow;
import org.apache.pluto.spi.PortletURLProvider;
import org.apache.pluto.util.StringManager;
import org.apache.pluto.util.StringUtils;

public class PortletURLImpl
implements PortletURL {
    private static final StringManager EXCEPTIONS = StringManager.getManager((class$org$apache$pluto$internal$impl$PortletURLImpl == null ? (class$org$apache$pluto$internal$impl$PortletURLImpl = PortletURLImpl.class$("org.apache.pluto.internal.impl.PortletURLImpl")) : class$org$apache$pluto$internal$impl$PortletURLImpl).getPackage().getName());
    private PortletContainer container;
    protected PortletMode mode = null;
    protected Map parameters = new HashMap();
    protected InternalPortletWindow internalPortletWindow;
    protected boolean secure;
    protected HttpServletRequest servletRequest;
    protected HttpServletResponse servletResponse;
    protected WindowState state;
    protected boolean isAction;
    private PortalContext context;
    static /* synthetic */ Class class$org$apache$pluto$internal$impl$PortletURLImpl;

    public PortletURLImpl(PortletContainer container, InternalPortletWindow internalPortletWindow, HttpServletRequest servletRequest, HttpServletResponse servletResponse, boolean isAction) {
        this.container = container;
        this.internalPortletWindow = internalPortletWindow;
        this.servletRequest = servletRequest;
        this.servletResponse = servletResponse;
        this.secure = servletRequest.isSecure();
        this.isAction = isAction;
        this.context = container.getRequiredContainerServices().getPortalContext();
    }

    public void setWindowState(WindowState windowState) throws WindowStateException {
        if (windowState != null && this.isWindowStateAllowed(windowState)) {
            this.state = windowState;
            return;
        }
        throw new WindowStateException("unsupported Window State used: " + windowState, windowState);
    }

    public void setPortletMode(PortletMode portletMode) throws PortletModeException {
        this.isPortletModeAllowed(portletMode);
        this.mode = portletMode;
    }

    public void setParameter(String name, String value) {
        if (name == null || value == null) {
            throw new IllegalArgumentException("name and value must not be null");
        }
        this.parameters.put(name, new String[]{value});
    }

    public void setParameter(String name, String[] values) {
        if (name == null || values == null || values.length == 0) {
            throw new IllegalArgumentException("name and values must not be null or values be an empty array");
        }
        this.parameters.put(name, StringUtils.copy(values));
    }

    public void setParameters(Map parameters) {
        if (parameters == null) {
            throw new IllegalArgumentException("Parameters must not be null.");
        }
        Iterator it = parameters.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            if (!(entry.getKey() instanceof String)) {
                throw new IllegalArgumentException("Key must not be null and of type java.lang.String.");
            }
            if (entry.getValue() instanceof String[]) continue;
            throw new IllegalArgumentException("Value must not be null and of type java.lang.String[].");
        }
        this.parameters = StringUtils.copyParameters(parameters);
    }

    public void setSecure(boolean secure) throws PortletSecurityException {
        PortletURLProvider urlProvider = this.container.getRequiredContainerServices().getPortalCallbackService().getPortletURLProvider(this.servletRequest, this.internalPortletWindow);
        if (urlProvider.isSecureSupported()) {
            throw new PortletSecurityException("Secure URLs not supported.");
        }
    }

    public String toString() {
        StringBuffer url = new StringBuffer(200);
        PortletURLProvider urlProvider = this.container.getRequiredContainerServices().getPortalCallbackService().getPortletURLProvider(this.servletRequest, this.internalPortletWindow);
        if (this.mode != null) {
            urlProvider.setPortletMode(this.mode);
        }
        if (this.state != null) {
            urlProvider.setWindowState(this.state);
        }
        if (this.isAction) {
            urlProvider.setAction(true);
        }
        if (this.secure && urlProvider.isSecureSupported()) {
            try {
                urlProvider.setSecure();
            }
            catch (PortletSecurityException e) {
                throw new IllegalStateException("URL Provider is misconfigured.  It claims to support secure urls, yet it threw a PortletSecurityException");
            }
        }
        urlProvider.clearParameters();
        urlProvider.setParameters(this.parameters);
        url.append(((Object)urlProvider).toString());
        return url.toString();
    }

    public String getParameter(String name) {
        return (String)this.parameters.get(name);
    }

    public String[] getParameters(String name) {
        return (String[])this.parameters.get(name);
    }

    public PortletMode getPortletMode() {
        return this.mode;
    }

    public WindowState getWindowState() {
        return this.state;
    }

    private boolean isPortletModeAllowed(PortletMode mode) throws PortletModeException {
        if (mode == null) {
            throw new PortletModeException(EXCEPTIONS.getString("javax.portlet.PortletModeException.null"), null);
        }
        return this.isPortletModeAllowedByPortlet(mode) && this.isPortletModeAllowedByPortal(mode);
    }

    private boolean isPortletModeAllowedByPortlet(PortletMode mode) throws PortletModeException {
        if (mode.equals((Object)PortletMode.VIEW)) {
            return true;
        }
        PortletDD dd = this.internalPortletWindow.getPortletEntity().getPortletDefinition();
        Iterator supports = dd.getSupports().iterator();
        while (supports.hasNext()) {
            SupportsDD support = (SupportsDD)supports.next();
            Iterator modes = support.getPortletModes().iterator();
            while (modes.hasNext()) {
                String md = (String)modes.next();
                if (!md.toUpperCase().equals(mode.toString().toUpperCase())) continue;
                return true;
            }
        }
        String message = EXCEPTIONS.getString("javax.portlet.PortletModeException.portlet", mode.toString());
        throw new PortletModeException(message, mode);
    }

    private boolean isPortletModeAllowedByPortal(PortletMode mode) throws PortletModeException {
        Enumeration supportedModes = this.context.getSupportedPortletModes();
        while (supportedModes.hasMoreElements()) {
            if (!supportedModes.nextElement().toString().toUpperCase().equals(mode.toString().toUpperCase())) continue;
            return true;
        }
        String message = EXCEPTIONS.getString("javax.portlet.PortletModeException.portal", mode.toString());
        throw new PortletModeException(message, mode);
    }

    private boolean isWindowStateAllowed(WindowState state) {
        Enumeration supportedStates = this.context.getSupportedWindowStates();
        while (supportedStates.hasMoreElements()) {
            if (!supportedStates.nextElement().toString().toUpperCase().equals(state.toString().toUpperCase())) continue;
            return true;
        }
        return false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

