/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fontbox.ttf;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.apache.fontbox.ttf.MemoryTTFDataStream;
import org.apache.fontbox.ttf.OTFParser;
import org.apache.fontbox.ttf.OpenTypeFont;
import org.apache.fontbox.ttf.RAFDataStream;
import org.apache.fontbox.ttf.TTCDataStream;
import org.apache.fontbox.ttf.TTFDataStream;
import org.apache.fontbox.ttf.TTFParser;
import org.apache.fontbox.ttf.TrueTypeFont;

public class TrueTypeCollection
implements Closeable {
    private final TTFDataStream stream;
    private final int numFonts;
    private final long[] fontOffsets;
    private final float version;

    public TrueTypeCollection(File file) throws IOException {
        this(new RAFDataStream(file, "r"));
    }

    public TrueTypeCollection(InputStream stream) throws IOException {
        this(new MemoryTTFDataStream(stream));
    }

    TrueTypeCollection(TTFDataStream stream) throws IOException {
        this.stream = stream;
        String tag = stream.readTag();
        if (!tag.equals("ttcf")) {
            throw new IOException("Missing TTC header");
        }
        this.version = stream.read32Fixed();
        this.numFonts = (int)stream.readUnsignedInt();
        this.fontOffsets = new long[this.numFonts];
        for (int i = 0; i < this.numFonts; ++i) {
            this.fontOffsets[i] = stream.readUnsignedInt();
        }
        if (this.version >= 2.0f) {
            int ulDsigTag = stream.readUnsignedShort();
            int ulDsigLength = stream.readUnsignedShort();
            int ulDsigOffset = stream.readUnsignedShort();
        }
    }

    public void processAllFonts(TrueTypeFontProcessor trueTypeFontProcessor) throws IOException {
        for (int i = 0; i < this.numFonts; ++i) {
            TrueTypeFont font = this.getFontAtIndex(i);
            trueTypeFontProcessor.process(font);
        }
    }

    private TrueTypeFont getFontAtIndex(int idx) throws IOException {
        this.stream.seek(this.fontOffsets[idx]);
        if (this.stream.readTag().equals("OTTO")) {
            this.stream.seek(this.fontOffsets[idx]);
            OTFParser parser = new OTFParser(false, true);
            OpenTypeFont otf = parser.parse(new TTCDataStream(this.stream));
            return otf;
        }
        this.stream.seek(this.fontOffsets[idx]);
        TTFParser parser = new TTFParser(false, true);
        TrueTypeFont ttf = parser.parse(new TTCDataStream(this.stream));
        return ttf;
    }

    public TrueTypeFont getFontByName(String name) throws IOException {
        for (int i = 0; i < this.numFonts; ++i) {
            TrueTypeFont font = this.getFontAtIndex(i);
            if (!font.getName().equals(name)) continue;
            return font;
        }
        return null;
    }

    @Override
    public void close() throws IOException {
        this.stream.close();
    }

    public static interface TrueTypeFontProcessor {
        public void process(TrueTypeFont var1) throws IOException;
    }
}

