/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.kernel.exps;

import java.util.Collection;
import java.util.Map;
import org.apache.openjpa.kernel.StoreContext;
import org.apache.openjpa.kernel.exps.Exp;
import org.apache.openjpa.kernel.exps.ExpressionVisitor;
import org.apache.openjpa.kernel.exps.Val;

class IsEmptyExpression
extends Exp {
    private final Val _val;

    public IsEmptyExpression(Val val) {
        this._val = val;
    }

    @Override
    protected boolean eval(Object candidate, Object orig, StoreContext ctx, Object[] params) {
        Object obj = this._val.eval(candidate, orig, ctx, params);
        if (obj == null) {
            return true;
        }
        if (obj instanceof Collection) {
            return ((Collection)obj).isEmpty();
        }
        if (obj instanceof Map) {
            return ((Map)obj).isEmpty();
        }
        return false;
    }

    @Override
    protected boolean eval(Collection candidates, StoreContext ctx, Object[] params) {
        Collection c = this._val.eval(candidates, null, ctx, params);
        if (c == null || c.isEmpty()) {
            return false;
        }
        Object obj = c.iterator().next();
        if (obj == null) {
            return true;
        }
        if (obj instanceof Collection) {
            return ((Collection)obj).isEmpty();
        }
        if (obj instanceof Map) {
            return ((Map)obj).isEmpty();
        }
        return false;
    }

    @Override
    public void acceptVisit(ExpressionVisitor visitor) {
        visitor.enter(this);
        this._val.acceptVisit(visitor);
        visitor.exit(this);
    }
}

