/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.resource.jdbc;

import java.io.File;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Properties;
import java.util.logging.Logger;
import javax.sql.DataSource;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.resource.jdbc.BasicDataSourceUtil;
import org.apache.openejb.resource.jdbc.DataSourcePlugin;
import org.apache.openejb.resource.jdbc.IsolationLevels;
import org.apache.openejb.resource.jdbc.PasswordCipher;

public class BasicDataSource
extends org.apache.commons.dbcp.BasicDataSource {
    private String passwordCipher = null;

    public synchronized String getPasswordCipher() {
        return this.passwordCipher;
    }

    public synchronized void setPasswordCipher(String passwordCipher) {
        this.passwordCipher = passwordCipher;
    }

    public synchronized String getUserName() {
        return super.getUsername();
    }

    public synchronized void setUserName(String string) {
        super.setUsername(string);
    }

    public synchronized String getJdbcDriver() {
        return super.getDriverClassName();
    }

    public synchronized void setJdbcDriver(String string) {
        super.setDriverClassName(string);
    }

    public synchronized String getJdbcUrl() {
        return super.getUrl();
    }

    public synchronized void setJdbcUrl(String string) {
        super.setUrl(string);
    }

    public synchronized void setDefaultTransactionIsolation(String s) {
        if (s == null || s.equals("")) {
            return;
        }
        int level = IsolationLevels.getIsolationLevel(s);
        super.setDefaultTransactionIsolation(level);
    }

    public synchronized void setMaxWait(int maxWait) {
        super.setMaxWait(maxWait);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected synchronized DataSource createDataSource() throws SQLException {
        Properties systemProperties;
        DataSourcePlugin helper;
        if (this.dataSource != null) {
            return this.dataSource;
        }
        if (null != this.passwordCipher) {
            PasswordCipher cipher = BasicDataSourceUtil.getPasswordCipher(this.passwordCipher);
            String plainPwd = cipher.decrypt(this.password.toCharArray());
            super.setPassword(plainPwd);
        }
        if ((helper = BasicDataSourceUtil.getDataSourcePlugin(this.getUrl())) != null) {
            helper.configure(this);
        }
        if (helper == null || !helper.enableUserDirHack()) {
            return super.createDataSource();
        }
        Properties properties = systemProperties = System.getProperties();
        synchronized (properties) {
            DataSource dataSource;
            String userDir = systemProperties.getProperty("user.dir");
            try {
                File base = SystemInstance.get().getBase().getDirectory();
                systemProperties.setProperty("user.dir", base.getAbsolutePath());
                dataSource = super.createDataSource();
                systemProperties.setProperty("user.dir", userDir);
            }
            catch (Throwable throwable) {
                systemProperties.setProperty("user.dir", userDir);
                throw throwable;
            }
            return dataSource;
        }
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        try {
            return (Logger)DataSource.class.getDeclaredMethod("getParentLogger", new Class[0]).invoke((Object)this.dataSource, new Object[0]);
        }
        catch (Throwable e) {
            throw new SQLFeatureNotSupportedException();
        }
    }
}

