/**
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.openejb.jee.jba;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;


@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "authMethod",
    "realm",
    "required"
})
@XmlRootElement(name = "as-context")
public class AsContext {

    @XmlElement(name = "auth-method", required = true)
    protected String authMethod;
    @XmlElement(required = true)
    protected String realm;
    @XmlElement(required = true)
    protected String required;

    /**
     * Gets the value of the authMethod property.
     *
     * @return possible object is
     * {@link String }
     */
    public String getAuthMethod() {
        return authMethod;
    }

    /**
     * Sets the value of the authMethod property.
     *
     * @param value allowed object is
     *              {@link String }
     */
    public void setAuthMethod(final String value) {
        this.authMethod = value;
    }

    /**
     * Gets the value of the realm property.
     *
     * @return possible object is
     * {@link String }
     */
    public String getRealm() {
        return realm;
    }

    /**
     * Sets the value of the realm property.
     *
     * @param value allowed object is
     *              {@link String }
     */
    public void setRealm(final String value) {
        this.realm = value;
    }

    /**
     * Gets the value of the required property.
     *
     * @return possible object is
     * {@link String }
     */
    public String getRequired() {
        return required;
    }

    /**
     * Sets the value of the required property.
     *
     * @param value allowed object is
     *              {@link String }
     */
    public void setRequired(final String value) {
        this.required = value;
    }

}
