/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.wagon.providers.http.httpclient.impl.pool;

import java.util.concurrent.atomic.AtomicLong;
import org.apache.maven.wagon.providers.http.httpclient.HttpClientConnection;
import org.apache.maven.wagon.providers.http.httpclient.HttpHost;
import org.apache.maven.wagon.providers.http.httpclient.annotation.ThreadSafe;
import org.apache.maven.wagon.providers.http.httpclient.impl.pool.BasicConnFactory;
import org.apache.maven.wagon.providers.http.httpclient.impl.pool.BasicPoolEntry;
import org.apache.maven.wagon.providers.http.httpclient.params.HttpParams;
import org.apache.maven.wagon.providers.http.httpclient.pool.AbstractConnPool;
import org.apache.maven.wagon.providers.http.httpclient.pool.ConnFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public class BasicConnPool
extends AbstractConnPool<HttpHost, HttpClientConnection, BasicPoolEntry> {
    private static AtomicLong COUNTER = new AtomicLong();

    public BasicConnPool(ConnFactory<HttpHost, HttpClientConnection> connFactory) {
        super(connFactory, 2, 20);
    }

    public BasicConnPool(HttpParams params) {
        super(new BasicConnFactory(params), 2, 20);
    }

    @Override
    protected BasicPoolEntry createEntry(HttpHost host, HttpClientConnection conn) {
        return new BasicPoolEntry(Long.toString(COUNTER.getAndIncrement()), host, conn);
    }
}

