/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.junitcore;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.maven.surefire.booter.Command;
import org.apache.maven.surefire.booter.CommandListener;
import org.apache.maven.surefire.booter.CommandReader;
import org.apache.maven.surefire.common.junit4.JUnit4ProviderUtil;
import org.apache.maven.surefire.common.junit4.JUnit4RunListener;
import org.apache.maven.surefire.common.junit4.JUnit4RunListenerFactory;
import org.apache.maven.surefire.common.junit4.JUnitTestFailureListener;
import org.apache.maven.surefire.common.junit4.Notifier;
import org.apache.maven.surefire.common.junit48.FilterFactory;
import org.apache.maven.surefire.common.junit48.JUnit48Reflector;
import org.apache.maven.surefire.common.junit48.JUnit48TestChecker;
import org.apache.maven.surefire.junitcore.ConcurrentRunListener;
import org.apache.maven.surefire.junitcore.JUnitCoreParameters;
import org.apache.maven.surefire.junitcore.JUnitCoreRunListener;
import org.apache.maven.surefire.junitcore.JUnitCoreWrapper;
import org.apache.maven.surefire.junitcore.NonConcurrentRunListener;
import org.apache.maven.surefire.junitcore.TestSet;
import org.apache.maven.surefire.providerapi.AbstractProvider;
import org.apache.maven.surefire.providerapi.ProviderParameters;
import org.apache.maven.surefire.report.ConsoleOutputCapture;
import org.apache.maven.surefire.report.ConsoleOutputReceiver;
import org.apache.maven.surefire.report.ConsoleStream;
import org.apache.maven.surefire.report.ReporterFactory;
import org.apache.maven.surefire.suite.RunResult;
import org.apache.maven.surefire.testset.TestListResolver;
import org.apache.maven.surefire.testset.TestSetFailedException;
import org.apache.maven.surefire.util.RunOrderCalculator;
import org.apache.maven.surefire.util.ScanResult;
import org.apache.maven.surefire.util.ScannerFilter;
import org.apache.maven.surefire.util.TestsToRun;
import org.junit.runner.manipulation.Filter;
import org.junit.runner.notification.RunListener;

public class JUnitCoreProvider
extends AbstractProvider {
    private final ClassLoader testClassLoader;
    private final JUnitCoreParameters jUnitCoreParameters;
    private final ScannerFilter scannerFilter;
    private final String customRunListeners;
    private final ProviderParameters providerParameters;
    private final ScanResult scanResult;
    private final int rerunFailingTestsCount;
    private final JUnit48Reflector jUnit48Reflector;
    private final RunOrderCalculator runOrderCalculator;
    private final TestListResolver testResolver;
    private final CommandReader commandsReader;
    private TestsToRun testsToRun;

    public JUnitCoreProvider(ProviderParameters bootParams) {
        this.commandsReader = bootParams.isInsideFork() ? CommandReader.getReader().setShutdown(bootParams.getShutdown()) : null;
        this.providerParameters = bootParams;
        this.testClassLoader = bootParams.getTestClassLoader();
        this.scanResult = bootParams.getScanResult();
        this.runOrderCalculator = bootParams.getRunOrderCalculator();
        this.jUnitCoreParameters = new JUnitCoreParameters(bootParams.getProviderProperties());
        this.scannerFilter = new JUnit48TestChecker(this.testClassLoader);
        this.testResolver = bootParams.getTestRequest().getTestListResolver();
        this.rerunFailingTestsCount = bootParams.getTestRequest().getRerunFailingTestsCount();
        this.customRunListeners = (String)bootParams.getProviderProperties().get("listener");
        this.jUnit48Reflector = new JUnit48Reflector(this.testClassLoader);
    }

    public Iterable<Class<?>> getSuites() {
        this.testsToRun = this.scanClassPath();
        return this.testsToRun;
    }

    private boolean isSingleThreaded() {
        return this.jUnitCoreParameters.isNoThreading();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RunResult invoke(Object forkTestSet) throws TestSetFailedException {
        RunResult runResult;
        Filter filter;
        ReporterFactory reporterFactory = this.providerParameters.getReporterFactory();
        ConsoleStream consoleStream = this.providerParameters.getConsoleLogger();
        Notifier notifier = new Notifier(this.createRunListener(reporterFactory, consoleStream), this.getSkipAfterFailureCount());
        Filter filter2 = filter = this.jUnit48Reflector.isJUnit48Available() ? this.createJUnit48Filter() : null;
        if (this.testsToRun == null) {
            this.setTestsToRun(forkTestSet);
        }
        JUnitTestFailureListener testFailureListener = new JUnitTestFailureListener();
        notifier.addListener((RunListener)testFailureListener);
        if (this.isFailFast() && this.commandsReader != null) {
            this.registerPleaseStopJUnitListener(notifier);
        }
        try {
            JUnitCoreWrapper core = new JUnitCoreWrapper(notifier, this.jUnitCoreParameters, consoleStream);
            if (this.commandsReader != null) {
                this.registerShutdownListener(this.testsToRun);
                this.commandsReader.awaitStarted();
            }
            notifier.asFailFast(this.isFailFast());
            core.execute(this.testsToRun, JUnit4RunListenerFactory.createCustomListeners((String)this.customRunListeners), filter);
            notifier.asFailFast(false);
            if (this.isRerunFailingTests()) {
                Notifier rerunNotifier = Notifier.pureNotifier();
                notifier.copyListenersTo(rerunNotifier);
                JUnitCoreWrapper rerunCore = new JUnitCoreWrapper(rerunNotifier, this.jUnitCoreParameters, consoleStream);
                for (int i = 0; i < this.rerunFailingTestsCount && !testFailureListener.getAllFailures().isEmpty(); ++i) {
                    Set failures = JUnit4ProviderUtil.generateFailingTestDescriptions((List)testFailureListener.getAllFailures());
                    testFailureListener.reset();
                    FilterFactory filterFactory = new FilterFactory(this.testClassLoader);
                    Filter failureDescriptionFilter = filterFactory.createMatchAnyDescriptionFilter((Iterable)failures);
                    rerunCore.execute(this.testsToRun, failureDescriptionFilter);
                }
            }
        }
        finally {
            runResult = reporterFactory.close();
            notifier.removeListeners();
        }
        return runResult;
    }

    private void setTestsToRun(Object forkTestSet) throws TestSetFailedException {
        if (forkTestSet instanceof TestsToRun) {
            this.testsToRun = (TestsToRun)forkTestSet;
        } else if (forkTestSet instanceof Class) {
            Class theClass = (Class)forkTestSet;
            this.testsToRun = TestsToRun.fromClass((Class)theClass);
        } else {
            this.testsToRun = this.scanClassPath();
        }
    }

    private boolean isRerunFailingTests() {
        return this.rerunFailingTestsCount > 0;
    }

    private boolean isFailFast() {
        return this.providerParameters.getSkipAfterFailureCount() > 0;
    }

    private int getSkipAfterFailureCount() {
        return this.isFailFast() ? this.providerParameters.getSkipAfterFailureCount() : 0;
    }

    private void registerShutdownListener(final TestsToRun testsToRun) {
        this.commandsReader.addShutdownListener(new CommandListener(){

            public void update(Command command) {
                testsToRun.markTestSetFinished();
            }
        });
    }

    private void registerPleaseStopJUnitListener(final Notifier stoppable) {
        this.commandsReader.addSkipNextTestsListener(new CommandListener(){

            public void update(Command command) {
                stoppable.pleaseStop();
            }
        });
    }

    private JUnit4RunListener createRunListener(ReporterFactory reporterFactory, ConsoleStream consoleStream) throws TestSetFailedException {
        if (this.isSingleThreaded()) {
            NonConcurrentRunListener rm = new NonConcurrentRunListener(reporterFactory.createReporter());
            ConsoleOutputCapture.startCapture((ConsoleOutputReceiver)rm);
            return rm;
        }
        ConcurrentHashMap<String, TestSet> testSetMap = new ConcurrentHashMap<String, TestSet>();
        ConcurrentRunListener listener = ConcurrentRunListener.createInstance(testSetMap, reporterFactory, this.isParallelTypes(), this.isParallelMethodsAndTypes(), consoleStream);
        ConsoleOutputCapture.startCapture((ConsoleOutputReceiver)listener);
        return new JUnitCoreRunListener(listener, testSetMap);
    }

    private boolean isParallelMethodsAndTypes() {
        return this.jUnitCoreParameters.isParallelMethods() && this.isParallelTypes();
    }

    private boolean isParallelTypes() {
        return this.jUnitCoreParameters.isParallelClasses() || this.jUnitCoreParameters.isParallelSuites();
    }

    private Filter createJUnit48Filter() {
        boolean onlyGroups;
        FilterFactory factory = new FilterFactory(this.testClassLoader);
        Map props = this.providerParameters.getProviderProperties();
        Filter groupFilter = factory.canCreateGroupFilter(props) ? factory.createGroupFilter(props) : null;
        TestListResolver methodFilter = TestListResolver.optionallyWildcardFilter((TestListResolver)this.testResolver);
        boolean bl = onlyGroups = methodFilter.isEmpty() || methodFilter.isWildcard();
        if (onlyGroups) {
            return groupFilter;
        }
        Filter jUnitMethodFilter = factory.createMethodFilter(methodFilter);
        return groupFilter == null ? jUnitMethodFilter : factory.and(groupFilter, jUnitMethodFilter);
    }

    private TestsToRun scanClassPath() {
        TestsToRun scanned = this.scanResult.applyFilter(this.scannerFilter, this.testClassLoader);
        return this.runOrderCalculator.orderTestClasses(scanned);
    }
}

