/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.booter;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class ManifestJarWriter {
    public static final int MAX_LINE_LENGTH = 72;
    public static final int MAX_SECTION_LENGTH = 70;
    public static final String EOL = "\r\n";
    private PrintWriter writer;

    public ManifestJarWriter(File jarFile) throws IOException {
        FileOutputStream fos = new FileOutputStream(jarFile);
        ZipOutputStream zos = new ZipOutputStream(fos);
        zos.setLevel(0);
        ZipEntry ze = new ZipEntry("META-INF/MANIFEST.MF");
        zos.putNextEntry(ze);
        this.writer = new PrintWriter(zos);
    }

    public void writeValue(String name, String value) throws IOException {
        String nameValue = name + ": " + value;
        StringTokenizer tokenizer = new StringTokenizer(nameValue, "\n\r");
        String prefix = "";
        while (tokenizer.hasMoreTokens()) {
            this.writeLine(prefix + tokenizer.nextToken());
            prefix = " ";
        }
    }

    private void writeLine(String line) throws IOException {
        while (line.getBytes().length > 72) {
            int breakIndex = 70;
            String section = line.substring(0, breakIndex);
            while (section.getBytes().length > 70 && breakIndex > 0) {
                section = line.substring(0, --breakIndex);
            }
            if (breakIndex == 0) {
                throw new IOException("Unable to write manifest line " + line);
            }
            this.writer.print(section + EOL);
            line = " " + line.substring(breakIndex);
        }
        this.writer.print(line + EOL);
    }

    public void close() {
        this.writer.flush();
        this.writer.close();
    }
}

