/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.booter;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.surefire.booter.Commandline;
import org.apache.maven.surefire.booter.SurefireBooterForkException;
import org.apache.maven.surefire.util.UrlUtils;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.jar.JarArchiver;
import org.codehaus.plexus.archiver.jar.Manifest;
import org.codehaus.plexus.archiver.jar.ManifestException;
import org.codehaus.plexus.util.StringUtils;

public class ForkConfiguration {
    public static final String FORK_ONCE = "once";
    public static final String FORK_ALWAYS = "always";
    public static final String FORK_NEVER = "never";
    private String forkMode;
    private boolean useSystemClassLoader;
    private Properties systemProperties;
    private String jvmExecutable;
    private String argLine;
    private Map environmentVariables;
    private File workingDirectory;
    private boolean debug;
    static /* synthetic */ Class class$org$apache$maven$surefire$booter$SurefireBooter;

    public void setForkMode(String forkMode) {
        if ("pertest".equalsIgnoreCase(forkMode)) {
            this.forkMode = FORK_ALWAYS;
        } else if ("none".equalsIgnoreCase(forkMode)) {
            this.forkMode = FORK_NEVER;
        } else if (forkMode.equals(FORK_NEVER) || forkMode.equals(FORK_ONCE) || forkMode.equals(FORK_ALWAYS)) {
            this.forkMode = forkMode;
        } else {
            throw new IllegalArgumentException("Fork mode " + forkMode + " is not a legal value");
        }
    }

    public boolean isForking() {
        return !FORK_NEVER.equals(this.forkMode);
    }

    public void setUseSystemClassLoader(boolean useSystemClassLoader) {
        this.useSystemClassLoader = useSystemClassLoader;
    }

    public boolean isUseSystemClassLoader() {
        return this.useSystemClassLoader;
    }

    public void setSystemProperties(Properties systemProperties) {
        this.systemProperties = (Properties)systemProperties.clone();
    }

    public void setJvmExecutable(String jvmExecutable) {
        this.jvmExecutable = jvmExecutable;
    }

    public void setArgLine(String argLine) {
        this.argLine = argLine;
    }

    public void setEnvironmentVariables(Map environmentVariables) {
        this.environmentVariables = new HashMap(environmentVariables);
    }

    public void setWorkingDirectory(File workingDirectory) {
        this.workingDirectory = workingDirectory;
    }

    public String getForkMode() {
        return this.forkMode;
    }

    public Properties getSystemProperties() {
        return this.systemProperties;
    }

    public Commandline createCommandLine(List classPath) throws SurefireBooterForkException {
        return this.createCommandLine(classPath, false);
    }

    public Commandline createCommandLine(List classPath, boolean useJar) throws SurefireBooterForkException {
        Commandline cli = new Commandline();
        cli.setExecutable(this.jvmExecutable);
        if (this.argLine != null) {
            cli.addArguments(StringUtils.split((String)this.argLine, (String)" "));
        }
        if (this.environmentVariables != null) {
            Iterator iter = this.environmentVariables.keySet().iterator();
            while (iter.hasNext()) {
                String key = (String)iter.next();
                String value = (String)this.environmentVariables.get(key);
                cli.addEnvironment(key, value);
            }
        }
        if (System.getProperty("maven.surefire.debug") != null) {
            cli.createArgument().setLine("-Xdebug -Xnoagent -Djava.compiler=NONE -Xrunjdwp:transport=dt_socket,server=y,suspend=y,address=5005");
        }
        if (useJar) {
            File jarFile;
            try {
                jarFile = ForkConfiguration.createJar(classPath);
            }
            catch (IOException e) {
                throw new SurefireBooterForkException("Error creating archive file", e);
            }
            catch (ManifestException e) {
                throw new SurefireBooterForkException("Error creating manifest", e);
            }
            catch (ArchiverException e) {
                throw new SurefireBooterForkException("Error creating archive", e);
            }
            cli.createArgument().setValue("-jar");
            cli.createArgument().setValue(jarFile.getAbsolutePath());
        } else {
            cli.createArgument().setValue("-classpath");
            cli.createArgument().setValue(StringUtils.join(classPath.iterator(), (String)File.pathSeparator));
            cli.createArgument().setValue((class$org$apache$maven$surefire$booter$SurefireBooter == null ? (class$org$apache$maven$surefire$booter$SurefireBooter = ForkConfiguration.class$("org.apache.maven.surefire.booter.SurefireBooter")) : class$org$apache$maven$surefire$booter$SurefireBooter).getName());
        }
        cli.setWorkingDirectory(this.workingDirectory.getAbsolutePath());
        return cli;
    }

    private static File createJar(List classPath) throws IOException, ManifestException, ArchiverException {
        JarArchiver jar = new JarArchiver();
        jar.setCompress(false);
        File file = File.createTempFile("surefirebooter", ".jar");
        file.deleteOnExit();
        jar.setDestFile(file);
        Manifest manifest = new Manifest();
        String cp = "";
        Iterator it = classPath.iterator();
        while (it.hasNext()) {
            String el = (String)it.next();
            cp = cp + UrlUtils.getURL((File)new File(el)).toExternalForm() + " ";
        }
        Manifest.Attribute attr = new Manifest.Attribute("Class-Path", cp.trim());
        manifest.addConfiguredAttribute(attr);
        attr = new Manifest.Attribute("Main-Class", (class$org$apache$maven$surefire$booter$SurefireBooter == null ? (class$org$apache$maven$surefire$booter$SurefireBooter = ForkConfiguration.class$("org.apache.maven.surefire.booter.SurefireBooter")) : class$org$apache$maven$surefire$booter$SurefireBooter).getName());
        manifest.addConfiguredAttribute(attr);
        jar.addConfiguredManifest(manifest);
        jar.createArchive();
        return file;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public boolean isDebug() {
        return this.debug;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

