/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.surefire;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.zip.ZipFile;
import javax.annotation.Nonnull;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ResolutionErrorHandler;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ScopeArtifactFilter;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugin.surefire.InPluginVMSurefireStarter;
import org.apache.maven.plugin.surefire.JdkAttributes;
import org.apache.maven.plugin.surefire.ResolvePathResultWrapper;
import org.apache.maven.plugin.surefire.StartupReportConfiguration;
import org.apache.maven.plugin.surefire.SurefireDependencyResolver;
import org.apache.maven.plugin.surefire.SurefireExecutionParameters;
import org.apache.maven.plugin.surefire.SurefireHelper;
import org.apache.maven.plugin.surefire.SurefireProperties;
import org.apache.maven.plugin.surefire.TestClassPath;
import org.apache.maven.plugin.surefire.booterclient.ChecksumCalculator;
import org.apache.maven.plugin.surefire.booterclient.ClasspathForkConfiguration;
import org.apache.maven.plugin.surefire.booterclient.ForkConfiguration;
import org.apache.maven.plugin.surefire.booterclient.ForkStarter;
import org.apache.maven.plugin.surefire.booterclient.JarManifestForkConfiguration;
import org.apache.maven.plugin.surefire.booterclient.ModularClasspathForkConfiguration;
import org.apache.maven.plugin.surefire.booterclient.Platform;
import org.apache.maven.plugin.surefire.extensions.LegacyForkNodeFactory;
import org.apache.maven.plugin.surefire.extensions.SurefireConsoleOutputReporter;
import org.apache.maven.plugin.surefire.extensions.SurefireStatelessReporter;
import org.apache.maven.plugin.surefire.extensions.SurefireStatelessTestsetInfoReporter;
import org.apache.maven.plugin.surefire.log.PluginConsoleLogger;
import org.apache.maven.plugin.surefire.log.api.ConsoleLogger;
import org.apache.maven.plugin.surefire.util.DependencyScanner;
import org.apache.maven.plugin.surefire.util.DirectoryScanner;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.repository.RepositorySystem;
import org.apache.maven.shared.artifact.filter.PatternIncludesArtifactFilter;
import org.apache.maven.surefire.api.booter.Shutdown;
import org.apache.maven.surefire.api.cli.CommandLineOption;
import org.apache.maven.surefire.api.report.ReporterConfiguration;
import org.apache.maven.surefire.api.suite.RunResult;
import org.apache.maven.surefire.api.testset.DirectoryScannerParameters;
import org.apache.maven.surefire.api.testset.RunOrderParameters;
import org.apache.maven.surefire.api.testset.TestArtifactInfo;
import org.apache.maven.surefire.api.testset.TestListResolver;
import org.apache.maven.surefire.api.testset.TestRequest;
import org.apache.maven.surefire.api.testset.TestSetFailedException;
import org.apache.maven.surefire.api.util.DefaultScanResult;
import org.apache.maven.surefire.api.util.ReflectionUtils;
import org.apache.maven.surefire.api.util.RunOrder;
import org.apache.maven.surefire.booter.AbstractPathConfiguration;
import org.apache.maven.surefire.booter.ClassLoaderConfiguration;
import org.apache.maven.surefire.booter.Classpath;
import org.apache.maven.surefire.booter.ClasspathConfiguration;
import org.apache.maven.surefire.booter.ModularClasspath;
import org.apache.maven.surefire.booter.ModularClasspathConfiguration;
import org.apache.maven.surefire.booter.ProcessCheckerType;
import org.apache.maven.surefire.booter.ProviderConfiguration;
import org.apache.maven.surefire.booter.StartupConfiguration;
import org.apache.maven.surefire.booter.SurefireBooterForkException;
import org.apache.maven.surefire.booter.SurefireExecutionException;
import org.apache.maven.surefire.booter.SystemUtils;
import org.apache.maven.surefire.extensions.ForkNodeFactory;
import org.apache.maven.surefire.providerapi.ConfigurableProviderInfo;
import org.apache.maven.surefire.providerapi.ProviderDetector;
import org.apache.maven.surefire.providerapi.ProviderInfo;
import org.apache.maven.surefire.providerapi.ProviderRequirements;
import org.apache.maven.surefire.shared.lang3.JavaVersion;
import org.apache.maven.surefire.shared.utils.StringUtils;
import org.apache.maven.surefire.shared.utils.cli.ShutdownHookUtils;
import org.apache.maven.surefire.shared.utils.io.FileUtils;
import org.apache.maven.toolchain.DefaultToolchain;
import org.apache.maven.toolchain.Toolchain;
import org.apache.maven.toolchain.ToolchainManager;
import org.apache.maven.toolchain.java.DefaultJavaToolChain;
import org.codehaus.plexus.languages.java.jpms.JavaModuleDescriptor;
import org.codehaus.plexus.languages.java.jpms.LocationManager;
import org.codehaus.plexus.languages.java.jpms.ResolvePathRequest;
import org.codehaus.plexus.languages.java.jpms.ResolvePathResult;
import org.codehaus.plexus.languages.java.jpms.ResolvePathsRequest;
import org.codehaus.plexus.languages.java.jpms.ResolvePathsResult;
import org.codehaus.plexus.logging.Logger;

public abstract class AbstractSurefireMojo
extends AbstractMojo
implements SurefireExecutionParameters {
    private static final Map<String, String> JAVA_9_MATCHER_OLD_NOTATION = Collections.singletonMap("version", "[1.9,)");
    private static final Map<String, String> JAVA_9_MATCHER = Collections.singletonMap("version", "[9,)");
    private static final Platform PLATFORM = new Platform();
    private final ClasspathCache classpathCache = new ClasspathCache();
    @Parameter
    private SurefireStatelessReporter statelessTestsetReporter;
    @Parameter
    private SurefireConsoleOutputReporter consoleOutputReporter;
    @Parameter
    private SurefireStatelessTestsetInfoReporter statelessTestsetInfoReporter;
    @Parameter(defaultValue="${plugin}", readonly=true, required=true)
    private PluginDescriptor pluginDescriptor;
    @Parameter(property="skipTests", defaultValue="false")
    protected boolean skipTests;
    @Deprecated
    @Parameter(property="maven.test.skip.exec")
    protected boolean skipExec;
    @Parameter(property="maven.test.skip", defaultValue="false")
    protected boolean skip;
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    private MavenProject project;
    @Parameter(defaultValue="${basedir}", readonly=true, required=true)
    protected File basedir;
    @Parameter(defaultValue="${project.build.testOutputDirectory}")
    protected File testClassesDirectory;
    @Parameter(property="maven.test.dependency.excludes")
    private String[] classpathDependencyExcludes;
    @Parameter(defaultValue="")
    private String classpathDependencyScopeExclude;
    @Parameter(property="maven.test.additionalClasspath")
    private String[] additionalClasspathElements;
    @Parameter(defaultValue="${project.build.testSourceDirectory}")
    private File testSourceDirectory;
    @Parameter(defaultValue="${localRepository}", required=true, readonly=true)
    private ArtifactRepository localRepository;
    @Deprecated
    @Parameter
    private Properties systemProperties;
    @Parameter
    private Map<String, String> systemPropertyVariables;
    @Parameter
    private Properties properties;
    @Parameter(property="plugin.artifactMap", required=true, readonly=true)
    private Map<String, Artifact> pluginArtifactMap;
    @Parameter(property="project.artifactMap", readonly=true, required=true)
    private Map<String, Artifact> projectArtifactMap;
    @Parameter(property="surefire.reportNameSuffix", defaultValue="")
    private String reportNameSuffix;
    @Parameter(property="maven.test.redirectTestOutputToFile", defaultValue="false")
    private boolean redirectTestOutputToFile;
    @Parameter(property="failIfNoTests", defaultValue="false")
    private boolean failIfNoTests;
    @Parameter(property="tempDir", defaultValue="surefire")
    private String tempDir;
    @Parameter(property="jvm")
    private String jvm;
    @Parameter(property="argLine")
    private String argLine;
    @Parameter
    private Map<String, String> environmentVariables = new HashMap<String, String>();
    @Parameter(property="basedir")
    private File workingDirectory;
    @Parameter(property="childDelegation", defaultValue="false")
    private boolean childDelegation;
    @Parameter(property="groups")
    private String groups;
    @Parameter(property="excludedGroups")
    private String excludedGroups;
    @Parameter(property="junitArtifactName", defaultValue="junit:junit")
    private String junitArtifactName;
    @Parameter(property="testNGArtifactName", defaultValue="org.testng:testng")
    private String testNGArtifactName;
    @Parameter(property="threadCount")
    private int threadCount;
    @Parameter(property="forkCount", defaultValue="1")
    private String forkCount;
    @Parameter(property="reuseForks", defaultValue="true")
    private boolean reuseForks;
    @Parameter(property="perCoreThreadCount", defaultValue="true")
    private boolean perCoreThreadCount;
    @Parameter(property="useUnlimitedThreads", defaultValue="false")
    private boolean useUnlimitedThreads;
    @Parameter(property="parallel")
    private String parallel;
    @Parameter(property="parallelOptimized", defaultValue="true")
    private boolean parallelOptimized;
    @Parameter(property="threadCountSuites", defaultValue="0")
    private int threadCountSuites;
    @Parameter(property="threadCountClasses", defaultValue="0")
    private int threadCountClasses;
    @Parameter(property="threadCountMethods", defaultValue="0")
    private int threadCountMethods;
    @Parameter(property="trimStackTrace", defaultValue="false")
    private boolean trimStackTrace;
    @Parameter(defaultValue="${project.pluginArtifactRepositories}", readonly=true, required=true)
    private List<ArtifactRepository> remoteRepositories;
    @Parameter(defaultValue="${project.remoteArtifactRepositories}", required=true, readonly=true)
    private List<ArtifactRepository> projectRemoteRepositories;
    @Deprecated
    @Parameter(property="disableXmlReport", defaultValue="false")
    private boolean disableXmlReport;
    @Parameter(property="enableAssertions", defaultValue="true")
    private boolean enableAssertions;
    @Parameter(defaultValue="${session}", required=true, readonly=true)
    private MavenSession session;
    @Component
    private Logger logger;
    @Parameter(property="objectFactory")
    private String objectFactory;
    @Parameter(defaultValue="${session.parallel}", readonly=true)
    private Boolean parallelMavenExecution;
    @Parameter(defaultValue="${project.build.directory}", readonly=true, required=true)
    private File projectBuildDirectory;
    @Parameter(property="dependenciesToScan")
    private String[] dependenciesToScan;
    @Parameter
    private Map<String, String> jdkToolchain;
    @Component
    private ToolchainManager toolchainManager;
    @Component
    private LocationManager locationManager;
    @Component
    private RepositorySystem repositorySystem;
    @Component
    private ProviderDetector providerDetector;
    @Component
    private ResolutionErrorHandler resolutionErrorHandler;
    private Toolchain toolchain;
    private int effectiveForkCount = -1;
    private SurefireDependencyResolver surefireDependencyResolver;
    private TestListResolver specificTests;
    private TestListResolver includedExcludedTests;
    private List<CommandLineOption> cli;
    private volatile PluginConsoleLogger consoleLogger;

    protected abstract String getPluginName();

    protected abstract int getRerunFailingTestsCount();

    @Override
    public abstract List<String> getIncludes();

    public abstract File getIncludesFile();

    @Override
    public abstract void setIncludes(List<String> var1);

    public abstract File getExcludesFile();

    protected abstract List<File> suiteXmlFiles();

    protected abstract boolean hasSuiteXmlFiles();

    protected abstract String[] getExcludedEnvironmentVariables();

    public abstract File[] getSuiteXmlFiles();

    public abstract void setSuiteXmlFiles(File[] var1);

    public abstract String getRunOrder();

    public abstract void setRunOrder(String var1);

    public abstract Long getRunOrderRandomSeed();

    public abstract void setRunOrderRandomSeed(Long var1);

    protected abstract void handleSummary(RunResult var1, Exception var2) throws MojoExecutionException, MojoFailureException;

    protected abstract boolean isSkipExecution();

    protected abstract String[] getDefaultIncludes();

    protected abstract String getReportSchemaLocation();

    protected abstract boolean useModulePath();

    protected abstract void setUseModulePath(boolean var1);

    protected abstract String getEnableProcessChecker();

    protected abstract ForkNodeFactory getForkNode();

    protected Artifact getMojoArtifact() {
        return this.getPluginDescriptor().getPluginArtifact();
    }

    private String getDefaultExcludes() {
        return "**/*$*";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException, MojoFailureException {
        this.cli = this.commandLineOptions();
        this.setupStuff();
        Platform platform = PLATFORM.withJdkExecAttributesForTests(this.getEffectiveJvm());
        Thread shutdownThread = new Thread(platform::setShutdownState);
        ShutdownHookUtils.addShutDownHook((Thread)shutdownThread);
        try {
            if (this.verifyParameters() && !this.hasExecutedBefore()) {
                DefaultScanResult scan = this.scanForTestClasses();
                if (!this.hasSuiteXmlFiles() && scan.isEmpty()) {
                    switch (this.getEffectiveFailIfNoTests()) {
                        case COULD_NOT_RUN_DEFAULT_TESTS: {
                            throw new MojoFailureException("No tests were executed!  (Set -DfailIfNoTests=false to ignore this error.)");
                        }
                        case COULD_NOT_RUN_SPECIFIED_TESTS: {
                            throw new MojoFailureException("No tests matching pattern \"" + this.getSpecificTests().toString() + "\" were executed! (Set -D" + this.getPluginName() + ".failIfNoSpecifiedTests=false to ignore this error.)");
                        }
                    }
                    this.handleSummary(RunResult.noTestsRun(), null);
                    return;
                }
                this.logReportsDirectory();
                this.executeAfterPreconditionsChecked(scan, platform);
            }
        }
        finally {
            platform.clearShutdownState();
            ShutdownHookUtils.removeShutdownHook((Thread)shutdownThread);
        }
    }

    void setLogger(Logger logger) {
        this.logger = logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    protected final PluginConsoleLogger getConsoleLogger() {
        if (this.consoleLogger == null) {
            AbstractSurefireMojo abstractSurefireMojo = this;
            synchronized (abstractSurefireMojo) {
                if (this.consoleLogger == null) {
                    this.consoleLogger = new PluginConsoleLogger(this.logger);
                }
            }
        }
        return this.consoleLogger;
    }

    private static <T extends ToolchainManager> Toolchain getToolchainMaven33x(Class<T> toolchainManagerType, T toolchainManager, MavenSession session, Map<String, String> toolchainArgs) throws MojoFailureException {
        Method getToolchainsMethod = ReflectionUtils.tryGetMethod(toolchainManagerType, (String)"getToolchains", (Class[])new Class[]{MavenSession.class, String.class, Map.class});
        if (getToolchainsMethod != null) {
            List tcs = (List)ReflectionUtils.invokeMethodWithArray(toolchainManager, (Method)getToolchainsMethod, (Object[])new Object[]{session, "jdk", toolchainArgs});
            if (tcs.isEmpty()) {
                throw new MojoFailureException("Requested toolchain specification did not match any configured toolchain: " + toolchainArgs);
            }
            return (Toolchain)tcs.get(0);
        }
        return null;
    }

    private Toolchain getToolchain() throws MojoFailureException {
        Toolchain tc = null;
        if (this.getJdkToolchain() != null) {
            tc = AbstractSurefireMojo.getToolchainMaven33x(ToolchainManager.class, this.getToolchainManager(), this.getSession(), this.getJdkToolchain());
        }
        if (tc == null) {
            tc = this.getToolchainManager().getToolchainFromBuildContext("jdk", this.getSession());
        }
        return tc;
    }

    private void setupStuff() throws MojoFailureException {
        this.surefireDependencyResolver = new SurefireDependencyResolver(this.getRepositorySystem(), this.getConsoleLogger(), this.getLocalRepository(), this.getRemoteRepositories(), this.getProjectRemoteRepositories(), this.resolutionErrorHandler, this.getPluginName(), this.getSession().isOffline());
        if (this.getBooterArtifact() == null) {
            throw new RuntimeException("Unable to locate surefire-booter in the list of plugin artifacts");
        }
        if (this.getToolchainManager() != null) {
            this.toolchain = this.getToolchain();
        }
    }

    @Nonnull
    private DefaultScanResult scanForTestClasses() throws MojoFailureException {
        DefaultScanResult scan = this.scanDirectories();
        DefaultScanResult scanDeps = this.scanDependencies();
        return scan.append(scanDeps);
    }

    private DefaultScanResult scanDirectories() throws MojoFailureException {
        DirectoryScanner scanner = new DirectoryScanner(this.getTestClassesDirectory(), this.getIncludedAndExcludedTests());
        return scanner.scan();
    }

    List<Artifact> getProjectTestArtifacts() {
        return this.project.getTestArtifacts();
    }

    DefaultScanResult scanDependencies() throws MojoFailureException {
        if (this.getDependenciesToScan() == null) {
            return null;
        }
        try {
            DefaultScanResult result = null;
            List<Artifact> dependenciesToScan = DependencyScanner.filter(this.getProjectTestArtifacts(), Arrays.asList(this.getDependenciesToScan()));
            for (Artifact artifact : dependenciesToScan) {
                Object scanner;
                String type = artifact.getType();
                File out = artifact.getFile();
                if (out == null || !out.exists() || !"jar".equals(type) && !out.isDirectory() && !out.getName().endsWith(".jar")) continue;
                if (out.isFile()) {
                    scanner = new DependencyScanner(Collections.singletonList(out), this.getIncludedAndExcludedTests());
                    result = result == null ? ((DependencyScanner)scanner).scan() : result.append(((DependencyScanner)scanner).scan());
                    continue;
                }
                if (!out.isDirectory()) continue;
                scanner = new DirectoryScanner(out, this.getIncludedAndExcludedTests());
                result = result == null ? ((DirectoryScanner)scanner).scan() : result.append(((DirectoryScanner)scanner).scan());
            }
            return result;
        }
        catch (Exception e) {
            throw new MojoFailureException(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    boolean verifyParameters() throws MojoFailureException, MojoExecutionException {
        this.setProperties(new SurefireProperties(this.getProperties()));
        if (this.isSkipExecution()) {
            this.getConsoleLogger().info("Tests are skipped.");
            return false;
        }
        String jvmToUse = this.getJvm();
        if (this.toolchain != null) {
            this.getConsoleLogger().info("Toolchain in maven-" + this.getPluginName() + "-plugin: " + this.toolchain);
            if (jvmToUse != null) {
                this.getConsoleLogger().warning("Toolchains are ignored, 'jvm' parameter is set to " + jvmToUse);
            }
        }
        if (!(this.getTestClassesDirectory().exists() || this.getDependenciesToScan() != null && this.getDependenciesToScan().length != 0)) {
            if (this.getFailIfNoTests()) {
                throw new MojoFailureException("No tests to run!");
            }
            this.getConsoleLogger().info("No tests to run.");
        } else {
            this.ensureEnableProcessChecker();
            this.ensureWorkingDirectoryExists();
            this.ensureParallelRunningCompatibility();
            this.warnIfUselessUseSystemClassLoaderParameter();
            this.warnIfDefunctGroupsCombinations();
            this.warnIfRerunClashes();
            this.warnIfWrongShutdownValue();
            this.warnIfNotApplicableSkipAfterFailureCount();
            this.warnIfIllegalTempDir();
            this.warnIfForkCountIsZero();
            this.warnIfIllegalFailOnFlakeCount();
            this.printDefaultSeedIfNecessary();
        }
        return true;
    }

    private void warnIfForkCountIsZero() {
        if ("0".equals(this.getForkCount())) {
            this.getConsoleLogger().warning("The parameter forkCount should likely not be 0. Forking a JVM for tests improves test accuracy. Ensure to have a <forkCount> >= 1.");
        }
    }

    private void executeAfterPreconditionsChecked(@Nonnull DefaultScanResult scanResult, @Nonnull Platform platform) throws MojoExecutionException, MojoFailureException {
        TestClassPath testClasspath = this.generateTestClasspath();
        List<ProviderInfo> providers = this.createProviders(testClasspath);
        ResolvePathResultWrapper wrapper = this.findModuleDescriptor(platform.getJdkExecAttributesForTests().getJdkHome());
        RunResult current = RunResult.noTestsRun();
        Throwable firstForkException = null;
        for (ProviderInfo provider : providers) {
            try {
                current = current.aggregate(this.executeProvider(provider, scanResult, testClasspath, platform, wrapper));
            }
            catch (TestSetFailedException | SurefireBooterForkException | SurefireExecutionException e) {
                if (firstForkException != null) continue;
                firstForkException = e;
            }
        }
        if (firstForkException != null) {
            current = RunResult.failure((RunResult)current, firstForkException);
        }
        this.handleSummary(current, (Exception)firstForkException);
    }

    protected List<ProviderInfo> createProviders(TestClassPath testClasspath) throws MojoExecutionException {
        Artifact junitDepArtifact = this.getJunitDepArtifact();
        return this.providerDetector.resolve(new DynamicProviderInfo(null), new JUnitPlatformProviderInfo(this.getJUnitPlatformRunnerArtifact(), this.getJUnit5Artifact(), testClasspath), new TestNgProviderInfo(this.getTestNgArtifact()), new JUnitCoreProviderInfo(this.getJunitArtifact(), junitDepArtifact), new JUnit4ProviderInfo(this.getJunitArtifact(), junitDepArtifact), new JUnit3ProviderInfo());
    }

    private SurefireProperties setupProperties() {
        SurefireProperties sysProps = null;
        try {
            sysProps = SurefireProperties.loadProperties(this.getSystemPropertiesFile());
        }
        catch (IOException e) {
            String msg = "The file '" + this.getSystemPropertiesFile().getAbsolutePath() + "' can't be read.";
            if (this.getConsoleLogger().isDebugEnabled()) {
                this.getConsoleLogger().debug(msg, e);
            }
            this.getConsoleLogger().warning(msg);
        }
        SurefireProperties result = SurefireProperties.calculateEffectiveProperties(this.getSystemProperties(), this.getSystemPropertyVariables(), this.getUserProperties(), sysProps);
        result.setProperty("basedir", this.getBasedir().getAbsolutePath());
        result.setProperty("localRepository", this.getLocalRepository().getBasedir());
        if (this.isForking()) {
            for (Object o : result.propertiesThatCannotBeSetASystemProperties()) {
                if (this.getArgLine() != null && this.getArgLine().contains("-D" + o + "=")) continue;
                this.getConsoleLogger().warning(o + " cannot be set as system property, use <argLine>-D" + o + "=...</argLine> instead");
            }
            for (Object systemPropertyMatchingArgLine : this.systemPropertiesMatchingArgLine(result)) {
                this.getConsoleLogger().warning("The system property " + systemPropertyMatchingArgLine + " is configured twice! The property appears in <argLine/> and any of <systemPropertyVariables/>, <systemProperties/> or user property.");
            }
        } else {
            result.setProperty("user.dir", this.getWorkingDirectory().getAbsolutePath());
        }
        if (this.getConsoleLogger().isDebugEnabled()) {
            this.showToLog(result, this.getConsoleLogger());
        }
        return result;
    }

    private Set<Object> systemPropertiesMatchingArgLine(SurefireProperties result) {
        HashSet<Object> intersection = new HashSet<Object>();
        if (StringUtils.isNotBlank((String)this.getArgLine())) {
            for (Object systemProperty : result.getStringKeySet()) {
                if (!this.getArgLine().contains("-D" + systemProperty + "=")) continue;
                intersection.add(systemProperty);
            }
            Set<Object> ignored = result.propertiesThatCannotBeSetASystemProperties();
            intersection.removeAll(ignored);
        }
        return intersection;
    }

    private void showToLog(SurefireProperties props, ConsoleLogger log) {
        for (Object key : props.getStringKeySet()) {
            String value = props.getProperty((String)key);
            log.debug("Setting system property [" + key + "]=[" + value + "]");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    private RunResult executeProvider(@Nonnull ProviderInfo provider, @Nonnull DefaultScanResult scanResult, @Nonnull TestClassPath testClasspathWrapper, @Nonnull Platform platform, @Nonnull ResolvePathResultWrapper resolvedJavaModularityResult) throws MojoExecutionException, MojoFailureException, SurefireExecutionException, SurefireBooterForkException, TestSetFailedException {
        this.getConsoleLogger().debug("Using the provider " + provider.getProviderName());
        SurefireProperties effectiveProperties = this.setupProperties();
        ClassLoaderConfiguration classLoaderConfiguration = this.getClassLoaderConfiguration();
        provider.addProviderProperties();
        RunOrderParameters runOrderParameters = new RunOrderParameters(this.getRunOrder(), this.getStatisticsFile(this.getConfigChecksum()), this.getRunOrderRandomSeed());
        if (this.isNotForking()) {
            Properties originalSystemProperties = (Properties)System.getProperties().clone();
            try {
                AbstractSurefireMojo.createCopyAndReplaceForkNumPlaceholder(effectiveProperties, 1).copyToSystemProperties();
                InPluginVMSurefireStarter surefireStarter = this.createInprocessStarter(provider, classLoaderConfiguration, runOrderParameters, scanResult, platform, testClasspathWrapper);
                RunResult runResult = surefireStarter.runSuitesInProcess(scanResult);
                return runResult;
            }
            finally {
                System.setProperties(originalSystemProperties);
            }
        }
        ForkConfiguration forkConfiguration = this.createForkConfiguration(platform, resolvedJavaModularityResult);
        if (this.getConsoleLogger().isDebugEnabled()) {
            this.showMap(this.getEnvironmentVariables(), "environment variable");
            this.showArray(this.getExcludedEnvironmentVariables(), "excluded environment variable");
        }
        Properties originalSystemProperties = (Properties)System.getProperties().clone();
        ForkStarter forkStarter = null;
        try {
            forkStarter = this.createForkStarter(provider, forkConfiguration, classLoaderConfiguration, runOrderParameters, this.getConsoleLogger(), scanResult, testClasspathWrapper, platform, resolvedJavaModularityResult);
            RunResult runResult = forkStarter.run(effectiveProperties, scanResult);
            return runResult;
        }
        catch (SurefireBooterForkException e) {
            forkStarter.killOrphanForks();
            throw e;
        }
        finally {
            System.setProperties(originalSystemProperties);
            this.cleanupForkConfiguration(forkConfiguration);
        }
    }

    public static SurefireProperties createCopyAndReplaceForkNumPlaceholder(SurefireProperties effectiveSystemProperties, int threadNumber) {
        SurefireProperties filteredProperties = new SurefireProperties(effectiveSystemProperties);
        for (Map.Entry<Object, Object> entry : effectiveSystemProperties.entrySet()) {
            if (!(entry.getValue() instanceof String)) continue;
            String value = (String)entry.getValue();
            filteredProperties.put(entry.getKey(), SurefireHelper.replaceThreadNumberPlaceholders(value, threadNumber));
        }
        return filteredProperties;
    }

    protected void cleanupForkConfiguration(ForkConfiguration forkConfiguration) {
        if (!this.getConsoleLogger().isDebugEnabled() && forkConfiguration != null) {
            File tempDirectory = forkConfiguration.getTempDirectory();
            try {
                FileUtils.deleteDirectory((File)tempDirectory);
            }
            catch (IOException e) {
                this.getConsoleLogger().warning("Could not delete temp directory " + tempDirectory + " because " + e.getMessage());
            }
        }
    }

    protected void logReportsDirectory() {
        this.logDebugOrCliShowErrors(StringUtils.capitalizeFirstLetter((String)this.getPluginName()) + " report directory: " + this.getReportsDirectory());
    }

    public RepositorySystem getRepositorySystem() {
        return this.repositorySystem;
    }

    public void setRepositorySystem(RepositorySystem repositorySystem) {
        this.repositorySystem = repositorySystem;
    }

    private boolean existsModuleDescriptor(ResolvePathResultWrapper resolvedJavaModularityResult) {
        return resolvedJavaModularityResult.getResolvePathResult() != null;
    }

    private ResolvePathResultWrapper findModuleDescriptor(File jdkHome) {
        ResolvePathResultWrapper test = this.findModuleDescriptor(jdkHome, this.getTestClassesDirectory(), false);
        return test.getResolvePathResult() == null ? this.findModuleDescriptor(jdkHome, this.getMainBuildPath(), true) : test;
    }

    private ResolvePathResultWrapper findModuleDescriptor(File jdkHome, File buildPath, boolean isMainDescriptor) {
        boolean isJpmsModule;
        boolean bl = isJpmsModule = buildPath.isDirectory() ? new File(buildPath, "module-info.class").exists() : AbstractSurefireMojo.isModule(buildPath);
        if (!isJpmsModule) {
            return new ResolvePathResultWrapper(null, isMainDescriptor);
        }
        try {
            ResolvePathRequest request = ResolvePathRequest.ofFile((File)buildPath).setJdkHome((Object)jdkHome);
            ResolvePathResult result = this.getLocationManager().resolvePath(request);
            boolean isEmpty = result.getModuleNameSource() == null;
            return new ResolvePathResultWrapper(isEmpty ? null : result, isMainDescriptor);
        }
        catch (Exception e) {
            return new ResolvePathResultWrapper(null, isMainDescriptor);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean isModule(File jar) {
        try (ZipFile zip = new ZipFile(jar);){
            boolean bl = zip.getEntry("module-info.class") != null;
            return bl;
        }
        catch (IOException e) {
            return false;
        }
    }

    private boolean canExecuteProviderWithModularPath(@Nonnull Platform platform, @Nonnull ResolvePathResultWrapper resolvedJavaModularityResult) {
        return this.useModulePath() && platform.getJdkExecAttributesForTests().isJava9AtLeast() && this.existsModuleDescriptor(resolvedJavaModularityResult);
    }

    private void convertTestNGParameters() throws MojoExecutionException {
        Artifact testNgArtifact;
        if (this.getParallel() != null) {
            this.getProperties().setProperty("parallel", this.getParallel());
        }
        this.convertGroupParameters();
        if (this.getThreadCount() > 0) {
            this.getProperties().setProperty("threadcount", Integer.toString(this.getThreadCount()));
        }
        if (this.getObjectFactory() != null) {
            this.getProperties().setProperty("objectfactory", this.getObjectFactory());
        }
        if (this.getTestClassesDirectory() != null) {
            this.getProperties().setProperty("testng.test.classpath", this.getTestClassesDirectory().getAbsolutePath());
        }
        if ((testNgArtifact = this.getTestNgArtifact()) != null) {
            DefaultArtifactVersion defaultArtifactVersion = new DefaultArtifactVersion(testNgArtifact.getVersion());
            this.getProperties().setProperty("testng.configurator", AbstractSurefireMojo.getConfiguratorName((ArtifactVersion)defaultArtifactVersion, this.getConsoleLogger()));
        }
    }

    private static String getConfiguratorName(ArtifactVersion version, PluginConsoleLogger log) throws MojoExecutionException {
        try {
            VersionRange range = VersionRange.createFromVersionSpec((String)"[4.7,5.2)");
            if (range.containsVersion(version)) {
                return "org.apache.maven.surefire.testng.conf.TestNG4751Configurator";
            }
            range = VersionRange.createFromVersionSpec((String)"[5.2,5.3)");
            if (range.containsVersion(version)) {
                return "org.apache.maven.surefire.testng.conf.TestNG52Configurator";
            }
            range = VersionRange.createFromVersionSpec((String)"[5.3,5.10)");
            if (range.containsVersion(version)) {
                return "org.apache.maven.surefire.testng.conf.TestNGMapConfigurator";
            }
            range = VersionRange.createFromVersionSpec((String)"[5.10,5.13)");
            if (range.containsVersion(version)) {
                return "org.apache.maven.surefire.testng.conf.TestNG510Configurator";
            }
            range = VersionRange.createFromVersionSpec((String)"[5.13,5.14.1)");
            if (range.containsVersion(version)) {
                return "org.apache.maven.surefire.testng.conf.TestNG513Configurator";
            }
            range = VersionRange.createFromVersionSpec((String)"[5.14.1,5.14.3)");
            if (range.containsVersion(version)) {
                log.warning("The 'reporter' or 'listener' may not work properly in TestNG 5.14.1 and 5.14.2.");
                return "org.apache.maven.surefire.testng.conf.TestNG5141Configurator";
            }
            range = VersionRange.createFromVersionSpec((String)"[5.14.3,6.0)");
            if (range.containsVersion(version)) {
                if (version.equals(new DefaultArtifactVersion("[5.14.3,5.14.5]"))) {
                    throw new MojoExecutionException("TestNG 5.14.3-5.14.5 is not supported. System dependency org.testng:guice missed path.");
                }
                return "org.apache.maven.surefire.testng.conf.TestNG5143Configurator";
            }
            range = VersionRange.createFromVersionSpec((String)"[6.0,7.4.0)");
            if (range.containsVersion(version)) {
                return "org.apache.maven.surefire.testng.conf.TestNG60Configurator";
            }
            range = VersionRange.createFromVersionSpec((String)"[7.4.0,)");
            if (range.containsVersion(version)) {
                return "org.apache.maven.surefire.testng.conf.TestNG740Configurator";
            }
            throw new MojoExecutionException("Unknown TestNG version " + version);
        }
        catch (InvalidVersionSpecificationException invsex) {
            throw new MojoExecutionException("Bug in plugin. Please report it with the attached stacktrace", (Exception)((Object)invsex));
        }
    }

    private void convertGroupParameters() {
        if (this.getExcludedGroups() != null) {
            this.getProperties().setProperty("excludegroups", this.getExcludedGroups());
        }
        if (this.getGroups() != null) {
            this.getProperties().setProperty("groups", this.getGroups());
        }
    }

    private void convertJunitEngineParameters() {
        if (this.getIncludeJUnit5Engines() != null && this.getIncludeJUnit5Engines().length != 0) {
            this.getProperties().setProperty("includejunit5engines", AbstractSurefireMojo.join(this.getIncludeJUnit5Engines()));
        }
        if (this.getExcludeJUnit5Engines() != null && this.getExcludeJUnit5Engines().length != 0) {
            this.getProperties().setProperty("excludejunit5engines", AbstractSurefireMojo.join(this.getExcludeJUnit5Engines()));
        }
    }

    private static String join(String[] array) {
        StringBuilder stringBuilder = new StringBuilder();
        int length = array.length;
        for (int i = 0; i < length; ++i) {
            stringBuilder.append(array[i]);
            if (i >= length - 1) continue;
            stringBuilder.append(',');
        }
        return stringBuilder.toString();
    }

    protected boolean isAnyConcurrencySelected() {
        return this.getParallel() != null && !this.getParallel().trim().isEmpty();
    }

    protected boolean isAnyGroupsSelected() {
        return this.getGroups() != null || this.getExcludedGroups() != null;
    }

    private void convertJunitCoreParameters() throws MojoExecutionException {
        String usedParallel;
        AbstractSurefireMojo.checkThreadCountEntity(this.getThreadCountSuites(), "suites");
        AbstractSurefireMojo.checkThreadCountEntity(this.getThreadCountClasses(), "classes");
        AbstractSurefireMojo.checkThreadCountEntity(this.getThreadCountMethods(), "methods");
        String string = usedParallel = this.getParallel() != null ? this.getParallel() : "none";
        if (!"none".equals(usedParallel)) {
            this.checkNonForkedThreads(this.parallel);
        }
        this.getProperties().setProperty("parallel", usedParallel);
        if (this.getThreadCount() > 0) {
            this.getProperties().setProperty("threadcount", Integer.toString(this.getThreadCount()));
        }
        this.getProperties().setProperty("perCoreThreadCount", Boolean.toString(this.getPerCoreThreadCount()));
        this.getProperties().setProperty("useUnlimitedThreads", Boolean.toString(this.getUseUnlimitedThreads()));
        this.getProperties().setProperty("threadcountsuites", Integer.toString(this.getThreadCountSuites()));
        this.getProperties().setProperty("threadcountclasses", Integer.toString(this.getThreadCountClasses()));
        this.getProperties().setProperty("threadcountmethods", Integer.toString(this.getThreadCountMethods()));
        this.getProperties().setProperty("paralleltimeout", Double.toString(this.getParallelTestsTimeoutInSeconds()));
        this.getProperties().setProperty("paralleltimeoutforced", Double.toString(this.getParallelTestsTimeoutForcedInSeconds()));
        this.getProperties().setProperty("paralleloptimization", Boolean.toString(this.isParallelOptimized()));
        String message = "parallel='" + usedParallel + '\'' + ", perCoreThreadCount=" + this.getPerCoreThreadCount() + ", threadCount=" + this.getThreadCount() + ", useUnlimitedThreads=" + this.getUseUnlimitedThreads() + ", threadCountSuites=" + this.getThreadCountSuites() + ", threadCountClasses=" + this.getThreadCountClasses() + ", threadCountMethods=" + this.getThreadCountMethods() + ", parallelOptimized=" + this.isParallelOptimized();
        this.logDebugOrCliShowErrors(message);
    }

    private void checkNonForkedThreads(String parallel) throws MojoExecutionException {
        if ("suites".equals(parallel)) {
            if (!this.getUseUnlimitedThreads() && !(this.getThreadCount() > 0 ^ this.getThreadCountSuites() > 0)) {
                throw new MojoExecutionException("Use threadCount or threadCountSuites > 0 or useUnlimitedThreads=true for parallel='suites'");
            }
            this.setThreadCountClasses(0);
            this.setThreadCountMethods(0);
        } else if ("classes".equals(parallel)) {
            if (!this.getUseUnlimitedThreads() && !(this.getThreadCount() > 0 ^ this.getThreadCountClasses() > 0)) {
                throw new MojoExecutionException("Use threadCount or threadCountClasses > 0 or useUnlimitedThreads=true for parallel='classes'");
            }
            this.setThreadCountSuites(0);
            this.setThreadCountMethods(0);
        } else if ("methods".equals(parallel)) {
            if (!this.getUseUnlimitedThreads() && !(this.getThreadCount() > 0 ^ this.getThreadCountMethods() > 0)) {
                throw new MojoExecutionException("Use threadCount or threadCountMethods > 0 or useUnlimitedThreads=true for parallel='methods'");
            }
            this.setThreadCountSuites(0);
            this.setThreadCountClasses(0);
        } else if ("suitesAndClasses".equals(parallel)) {
            if (!(this.getUseUnlimitedThreads() || this.onlyThreadCount() || this.getThreadCountSuites() > 0 && this.getThreadCountClasses() > 0 && this.getThreadCount() == 0 && this.getThreadCountMethods() == 0 || this.getThreadCount() > 0 && this.getThreadCountSuites() > 0 && this.getThreadCountClasses() > 0 && this.getThreadCountMethods() == 0 || this.getThreadCount() > 0 && this.getThreadCountSuites() > 0 && this.getThreadCount() > this.getThreadCountSuites() && this.getThreadCountClasses() == 0 && this.getThreadCountMethods() == 0)) {
                throw new MojoExecutionException("Use useUnlimitedThreads=true, or only threadCount > 0, or (threadCountSuites > 0 and threadCountClasses > 0), or (threadCount > 0 and threadCountSuites > 0 and threadCountClasses > 0) or (threadCount > 0 and threadCountSuites > 0 and threadCount > threadCountSuites) for parallel='suitesAndClasses' or 'both'");
            }
            this.setThreadCountMethods(0);
        } else if ("suitesAndMethods".equals(parallel)) {
            if (!(this.getUseUnlimitedThreads() || this.onlyThreadCount() || this.getThreadCountSuites() > 0 && this.getThreadCountMethods() > 0 && this.getThreadCount() == 0 && this.getThreadCountClasses() == 0 || this.getThreadCount() > 0 && this.getThreadCountSuites() > 0 && this.getThreadCountMethods() > 0 && this.getThreadCountClasses() == 0 || this.getThreadCount() > 0 && this.getThreadCountSuites() > 0 && this.getThreadCount() > this.getThreadCountSuites() && this.getThreadCountClasses() == 0 && this.getThreadCountMethods() == 0)) {
                throw new MojoExecutionException("Use useUnlimitedThreads=true, or only threadCount > 0, or (threadCountSuites > 0 and threadCountMethods > 0), or (threadCount > 0 and threadCountSuites > 0 and threadCountMethods > 0), or (threadCount > 0 and threadCountSuites > 0 and threadCount > threadCountSuites) for parallel='suitesAndMethods'");
            }
            this.setThreadCountClasses(0);
        } else if ("both".equals(parallel) || "classesAndMethods".equals(parallel)) {
            if (!(this.getUseUnlimitedThreads() || this.onlyThreadCount() || this.getThreadCountClasses() > 0 && this.getThreadCountMethods() > 0 && this.getThreadCount() == 0 && this.getThreadCountSuites() == 0 || this.getThreadCount() > 0 && this.getThreadCountClasses() > 0 && this.getThreadCountMethods() > 0 && this.getThreadCountSuites() == 0 || this.getThreadCount() > 0 && this.getThreadCountClasses() > 0 && this.getThreadCount() > this.getThreadCountClasses() && this.getThreadCountSuites() == 0 && this.getThreadCountMethods() == 0)) {
                throw new MojoExecutionException("Use useUnlimitedThreads=true, or only threadCount > 0, or (threadCountClasses > 0 and threadCountMethods > 0), or (threadCount > 0 and threadCountClasses > 0 and threadCountMethods > 0), or (threadCount > 0 and threadCountClasses > 0 and threadCount > threadCountClasses) for parallel='both' or parallel='classesAndMethods'");
            }
            this.setThreadCountSuites(0);
        } else if ("all".equals(parallel)) {
            if (!(this.getUseUnlimitedThreads() || this.onlyThreadCount() || this.getThreadCountSuites() > 0 && this.getThreadCountClasses() > 0 && this.getThreadCountMethods() > 0 || this.getThreadCount() > 0 && this.getThreadCountSuites() > 0 && this.getThreadCountClasses() > 0 && this.getThreadCountMethods() == 0 && this.getThreadCount() > this.getThreadCountSuites() + this.getThreadCountClasses())) {
                throw new MojoExecutionException("Use useUnlimitedThreads=true, or only threadCount > 0, or (threadCountSuites > 0 and threadCountClasses > 0 and threadCountMethods > 0), or every thread-count is specified, or (threadCount > 0 and threadCountSuites > 0 and threadCountClasses > 0 and threadCount > threadCountSuites + threadCountClasses) for parallel='all'");
            }
        } else {
            throw new MojoExecutionException("Illegal parallel='" + parallel + "'");
        }
    }

    private boolean onlyThreadCount() {
        return this.getThreadCount() > 0 && this.getThreadCountSuites() == 0 && this.getThreadCountClasses() == 0 && this.getThreadCountMethods() == 0;
    }

    private static void checkThreadCountEntity(int count, String entity) throws MojoExecutionException {
        if (count < 0) {
            throw new MojoExecutionException("parallel maven execution does not allow negative thread-count" + entity);
        }
    }

    private boolean isJunit47Compatible(Artifact artifact) {
        return SurefireDependencyResolver.isWithinVersionSpec(artifact, "[4.7,)");
    }

    private boolean isAnyJunit4(Artifact artifact) {
        return SurefireDependencyResolver.isWithinVersionSpec(artifact, "[4.0,)");
    }

    protected boolean isForking() {
        return 0 < this.getEffectiveForkCount();
    }

    private List<RunOrder> getRunOrders() {
        String runOrderString = this.getRunOrder();
        RunOrder[] runOrder = runOrderString == null ? RunOrder.DEFAULT : RunOrder.valueOfMulti((String)runOrderString);
        return Arrays.asList(runOrder);
    }

    private boolean requiresRunHistory() {
        List<RunOrder> runOrders = this.getRunOrders();
        return runOrders.contains(RunOrder.BALANCED) || runOrders.contains(RunOrder.FAILEDFIRST);
    }

    private PluginFailureReason getEffectiveFailIfNoTests() {
        if (this.isSpecificTestSpecified()) {
            return this.getFailIfNoSpecifiedTests() ? PluginFailureReason.COULD_NOT_RUN_SPECIFIED_TESTS : PluginFailureReason.NONE;
        }
        return this.getFailIfNoTests() ? PluginFailureReason.COULD_NOT_RUN_DEFAULT_TESTS : PluginFailureReason.NONE;
    }

    private ProviderConfiguration createProviderConfiguration(RunOrderParameters runOrderParameters) throws MojoExecutionException, MojoFailureException {
        ReporterConfiguration reporterConfiguration = new ReporterConfiguration(this.getReportsDirectory(), this.isTrimStackTrace());
        Artifact testNgArtifact = this.getTestNgArtifact();
        boolean isTestNg = testNgArtifact != null;
        TestArtifactInfo testNg = isTestNg ? new TestArtifactInfo(testNgArtifact.getVersion(), testNgArtifact.getClassifier()) : null;
        TestRequest testSuiteDefinition = new TestRequest(this.suiteXmlFiles(), this.getTestSourceDirectory(), this.getSpecificTests(), this.getRerunFailingTestsCount());
        DirectoryScannerParameters directoryScannerParameters = null;
        if (this.hasSuiteXmlFiles() && !this.isSpecificTestSpecified()) {
            boolean actualFailIfNoTests = this.getFailIfNoTests();
            if (!isTestNg) {
                throw new MojoExecutionException("suiteXmlFiles is configured, but there is no TestNG dependency");
            }
        } else {
            List<String> actualIncludes = this.getIncludeList();
            List<String> actualExcludes = this.getExcludeList();
            List specificTests = Collections.emptyList();
            directoryScannerParameters = new DirectoryScannerParameters(this.getTestClassesDirectory(), actualIncludes, actualExcludes, specificTests, this.getRunOrder());
        }
        Map<String, String> providerProperties = AbstractSurefireMojo.toStringProperties(this.getProperties());
        return new ProviderConfiguration(directoryScannerParameters, runOrderParameters, reporterConfiguration, testNg, testSuiteDefinition, providerProperties, null, false, this.cli, this.getSkipAfterFailureCount(), Shutdown.parameterOf((String)this.getShutdown()), Integer.valueOf(this.getForkedProcessExitTimeoutInSeconds()));
    }

    private static Map<String, String> toStringProperties(Properties properties) {
        ConcurrentHashMap<String, String> h = new ConcurrentHashMap<String, String>(properties.size());
        Enumeration<Object> e = properties.keys();
        while (e.hasMoreElements()) {
            Object k = e.nextElement();
            Object v = properties.get(k);
            if (k.getClass() != String.class || v.getClass() != String.class) continue;
            h.put((String)k, (String)v);
        }
        return h;
    }

    private File getStatisticsFile(String configurationHash) {
        return new File(this.getBasedir(), ".surefire-" + configurationHash);
    }

    private StartupConfiguration createStartupConfiguration(@Nonnull ProviderInfo provider, boolean isForking, @Nonnull ClassLoaderConfiguration classLoaderConfiguration, @Nonnull DefaultScanResult scanResult, @Nonnull TestClassPath testClasspathWrapper, @Nonnull Platform platform, @Nonnull ResolvePathResultWrapper resolvedJavaModularity) throws MojoExecutionException {
        try {
            if (isForking && this.canExecuteProviderWithModularPath(platform, resolvedJavaModularity)) {
                File jdkHome = platform.getJdkExecAttributesForTests().getJdkHome();
                return this.newStartupConfigWithModularPath(classLoaderConfiguration, provider, resolvedJavaModularity, scanResult, jdkHome.getAbsolutePath(), testClasspathWrapper);
            }
            return this.newStartupConfigWithClasspath(classLoaderConfiguration, provider, testClasspathWrapper);
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
    }

    private StartupConfiguration newStartupConfigWithClasspath(@Nonnull ClassLoaderConfiguration classLoaderConfiguration, @Nonnull ProviderInfo providerInfo, @Nonnull TestClassPath testClasspathWrapper) throws MojoExecutionException {
        Classpath testClasspath = testClasspathWrapper.toClasspath();
        Set<Artifact> providerArtifacts = providerInfo.getProviderClasspath();
        String providerName = providerInfo.getProviderName();
        Classpath providerClasspath = this.classpathCache.getCachedClassPath(providerName);
        if (providerClasspath == null) {
            providerClasspath = this.classpathCache.setCachedClasspath(providerName, providerArtifacts);
        }
        this.getConsoleLogger().debug(testClasspath.getLogMessage("test classpath:"));
        this.getConsoleLogger().debug(providerClasspath.getLogMessage("provider classpath:"));
        this.getConsoleLogger().debug(testClasspath.getCompactLogMessage("test(compact) classpath:"));
        this.getConsoleLogger().debug(providerClasspath.getCompactLogMessage("provider(compact) classpath:"));
        Artifact[] additionalInProcArtifacts = new Artifact[]{this.getCommonArtifact(), this.getBooterArtifact(), this.getExtensionsArtifact(), this.getApiArtifact(), this.getSpiArtifact(), this.getLoggerApiArtifact(), this.getSurefireSharedUtilsArtifact()};
        Set<Artifact> inProcArtifacts = AbstractSurefireMojo.retainInProcArtifactsUnique(providerArtifacts, additionalInProcArtifacts);
        Classpath inProcClasspath = AbstractSurefireMojo.createInProcClasspath(providerClasspath, inProcArtifacts);
        this.getConsoleLogger().debug(inProcClasspath.getLogMessage("in-process classpath:"));
        this.getConsoleLogger().debug(inProcClasspath.getCompactLogMessage("in-process(compact) classpath:"));
        ClasspathConfiguration classpathConfiguration = new ClasspathConfiguration(testClasspath, providerClasspath, inProcClasspath, this.effectiveIsEnableAssertions(), this.isChildDelegation());
        ProviderRequirements forkRequirements = new ProviderRequirements(false, false, false);
        return new StartupConfiguration(providerName, (AbstractPathConfiguration)classpathConfiguration, classLoaderConfiguration, ProcessCheckerType.toEnum((String)this.getEnableProcessChecker()), providerInfo.getJpmsArguments(forkRequirements));
    }

    private static Set<Artifact> retainInProcArtifactsUnique(Set<Artifact> providerArtifacts, Artifact ... inPluginArtifacts) {
        LinkedHashSet<Artifact> result = new LinkedHashSet<Artifact>();
        for (Artifact inPluginArtifact : inPluginArtifacts) {
            boolean contains = false;
            for (Artifact providerArtifact : providerArtifacts) {
                if (!AbstractSurefireMojo.hasGroupArtifactId(providerArtifact.getGroupId(), providerArtifact.getArtifactId(), inPluginArtifact)) continue;
                contains = true;
                break;
            }
            if (contains) continue;
            result.add(inPluginArtifact);
        }
        return result;
    }

    private static boolean hasGroupArtifactId(String groupId, String artifactId, Artifact artifact) {
        return groupId.equals(artifact.getGroupId()) && artifactId.equals(artifact.getArtifactId());
    }

    private static Classpath createInProcClasspath(Classpath providerClasspath, Set<Artifact> newArtifacts) {
        Classpath inprocClasspath = providerClasspath.clone();
        for (Artifact newArtifact : newArtifacts) {
            inprocClasspath = inprocClasspath.addClassPathElementUrl(newArtifact.getFile().getAbsolutePath());
        }
        return inprocClasspath;
    }

    private LocationManager getLocationManager() {
        return this.locationManager;
    }

    private StartupConfiguration newStartupConfigWithModularPath(@Nonnull ClassLoaderConfiguration classLoaderConfiguration, @Nonnull ProviderInfo providerInfo, @Nonnull ResolvePathResultWrapper moduleDescriptor, @Nonnull DefaultScanResult scanResult, @Nonnull String javaHome, @Nonnull TestClassPath testClasspathWrapper) throws MojoExecutionException, IOException {
        Classpath testModulepath;
        ProviderRequirements providerRequirements;
        boolean isMainDescriptor = moduleDescriptor.isMainModuleDescriptor();
        JavaModuleDescriptor javaModuleDescriptor = moduleDescriptor.getResolvePathResult().getModuleDescriptor();
        TreeSet<String> packages = new TreeSet<String>();
        Classpath testClasspath = testClasspathWrapper.toClasspath();
        Set<Artifact> providerArtifacts = providerInfo.getProviderClasspath();
        String providerName = providerInfo.getProviderName();
        Classpath providerClasspath = this.classpathCache.getCachedClassPath(providerName);
        if (providerClasspath == null) {
            providerClasspath = this.classpathCache.setCachedClasspath(providerName, providerArtifacts);
        }
        if (isMainDescriptor) {
            providerRequirements = new ProviderRequirements(true, true, false);
            ResolvePathsRequest req = ResolvePathsRequest.ofStrings((Collection)testClasspath.getClassPath()).setIncludeAllProviders(true).setJdkHome((Object)javaHome).setIncludeStatic(true).setModuleDescriptor(javaModuleDescriptor);
            ResolvePathsResult result = this.getLocationManager().resolvePaths(req);
            for (Map.Entry entry : result.getPathExceptions().entrySet()) {
                this.getConsoleLogger().warning("Exception for '" + (String)entry.getKey() + "'.", (Throwable)entry.getValue());
            }
            testClasspath = new Classpath(result.getClasspathElements());
            testModulepath = new Classpath(result.getModulepathElements().keySet());
            for (String className : scanResult.getClasses()) {
                packages.add(org.apache.maven.surefire.shared.lang3.StringUtils.substringBeforeLast((String)className, (String)"."));
            }
        } else {
            providerRequirements = new ProviderRequirements(true, false, true);
            testModulepath = testClasspath;
            testClasspath = Classpath.emptyClasspath();
        }
        this.getConsoleLogger().debug("main module descriptor name: " + javaModuleDescriptor.name());
        ModularClasspath modularClasspath = new ModularClasspath(javaModuleDescriptor.name(), testModulepath.getClassPath(), packages, isMainDescriptor ? this.getTestClassesDirectory() : null, isMainDescriptor);
        Artifact[] additionalInProcArtifacts = new Artifact[]{this.getCommonArtifact(), this.getBooterArtifact(), this.getExtensionsArtifact(), this.getApiArtifact(), this.getSpiArtifact(), this.getLoggerApiArtifact(), this.getSurefireSharedUtilsArtifact()};
        Set<Artifact> inProcArtifacts = AbstractSurefireMojo.retainInProcArtifactsUnique(providerArtifacts, additionalInProcArtifacts);
        Classpath inProcClasspath = AbstractSurefireMojo.createInProcClasspath(providerClasspath, inProcArtifacts);
        ModularClasspathConfiguration classpathConfiguration = new ModularClasspathConfiguration(modularClasspath, testClasspath, providerClasspath, inProcClasspath, this.effectiveIsEnableAssertions(), this.isChildDelegation());
        this.getConsoleLogger().debug(testClasspath.getLogMessage("test classpath:"));
        this.getConsoleLogger().debug(testModulepath.getLogMessage("test modulepath:"));
        this.getConsoleLogger().debug(providerClasspath.getLogMessage("provider classpath:"));
        this.getConsoleLogger().debug(testClasspath.getCompactLogMessage("test(compact) classpath:"));
        this.getConsoleLogger().debug(testModulepath.getCompactLogMessage("test(compact) modulepath:"));
        this.getConsoleLogger().debug(providerClasspath.getCompactLogMessage("provider(compact) classpath:"));
        this.getConsoleLogger().debug(inProcClasspath.getLogMessage("in-process classpath:"));
        this.getConsoleLogger().debug(inProcClasspath.getCompactLogMessage("in-process(compact) classpath:"));
        ProcessCheckerType processCheckerType = ProcessCheckerType.toEnum((String)this.getEnableProcessChecker());
        List<String[]> jpmsArgs = providerInfo.getJpmsArguments(providerRequirements);
        return new StartupConfiguration(providerName, (AbstractPathConfiguration)classpathConfiguration, classLoaderConfiguration, processCheckerType, jpmsArgs);
    }

    private Artifact getCommonArtifact() {
        return this.getPluginArtifactMap().get("org.apache.maven.surefire:maven-surefire-common");
    }

    private Artifact getExtensionsArtifact() {
        return this.getPluginArtifactMap().get("org.apache.maven.surefire:surefire-extensions-api");
    }

    private Artifact getSpiArtifact() {
        return this.getPluginArtifactMap().get("org.apache.maven.surefire:surefire-extensions-spi");
    }

    private Artifact getApiArtifact() {
        return this.getPluginArtifactMap().get("org.apache.maven.surefire:surefire-api");
    }

    private Artifact getSurefireSharedUtilsArtifact() {
        return this.getPluginArtifactMap().get("org.apache.maven.surefire:surefire-shared-utils");
    }

    private Artifact getLoggerApiArtifact() {
        return this.getPluginArtifactMap().get("org.apache.maven.surefire:surefire-logger-api");
    }

    private Artifact getBooterArtifact() {
        return this.getPluginArtifactMap().get("org.apache.maven.surefire:surefire-booter");
    }

    private Artifact getShadefireArtifact() {
        return this.getPluginArtifactMap().get("org.apache.maven.surefire:surefire-shadefire");
    }

    private StartupReportConfiguration getStartupReportConfiguration(String configChecksum, boolean isForking) {
        SurefireStatelessReporter xmlReporter = this.statelessTestsetReporter == null ? new SurefireStatelessReporter(this.isDisableXmlReport(), "3.0") : this.statelessTestsetReporter;
        xmlReporter.setDisable(this.isDisableXmlReport());
        SurefireConsoleOutputReporter outReporter = this.consoleOutputReporter == null ? new SurefireConsoleOutputReporter() : this.consoleOutputReporter;
        SurefireStatelessTestsetInfoReporter testsetReporter = this.statelessTestsetInfoReporter == null ? new SurefireStatelessTestsetInfoReporter() : this.statelessTestsetInfoReporter;
        return new StartupReportConfiguration(this.isUseFile(), this.isPrintSummary(), this.getReportFormat(), this.isRedirectTestOutputToFile(), this.getReportsDirectory(), this.isTrimStackTrace(), this.getReportNameSuffix(), this.getStatisticsFile(configChecksum), this.requiresRunHistory(), this.getRerunFailingTestsCount(), this.getReportSchemaLocation(), this.getEncoding(), isForking, xmlReporter, outReporter, testsetReporter);
    }

    private boolean isSpecificTestSpecified() {
        return StringUtils.isNotBlank((String)this.getTest());
    }

    @Nonnull
    private List<String> readListFromFile(@Nonnull File file) {
        this.getConsoleLogger().debug("Reading list from: " + file);
        if (!file.exists()) {
            throw new RuntimeException("Failed to load list from file: " + file);
        }
        try {
            List list = FileUtils.loadFile((File)file);
            if (this.getConsoleLogger().isDebugEnabled()) {
                this.getConsoleLogger().debug("List contents:");
                for (String entry : list) {
                    this.getConsoleLogger().debug("  " + entry);
                }
            }
            return list;
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to load list from file: " + file, e);
        }
    }

    @Nonnull
    private List<String> getExcludedScanList() throws MojoFailureException {
        return this.getExcludeList(true);
    }

    @Nonnull
    private List<String> getExcludeList() throws MojoFailureException {
        return this.getExcludeList(false);
    }

    @Nonnull
    private List<String> getExcludeList(boolean asScanList) throws MojoFailureException {
        List<String> excludes;
        if (this.isSpecificTestSpecified()) {
            excludes = Collections.emptyList();
        } else {
            excludes = new ArrayList();
            if (asScanList) {
                if (this.getExcludes() != null) {
                    excludes.addAll(this.getExcludes());
                }
                this.checkMethodFilterInIncludesExcludes(excludes);
            }
            if (this.getExcludesFile() != null) {
                excludes.addAll(this.readListFromFile(this.getExcludesFile()));
            }
            if (asScanList && excludes.isEmpty()) {
                excludes = Collections.singletonList(this.getDefaultExcludes());
            }
        }
        return this.filterNulls(excludes);
    }

    @Nonnull
    private List<String> getIncludedScanList() throws MojoFailureException {
        return this.getIncludeList(true);
    }

    @Nonnull
    private List<String> getIncludeList() throws MojoFailureException {
        return this.getIncludeList(false);
    }

    @Nonnull
    private List<String> getIncludeList(boolean asScanList) throws MojoFailureException {
        ArrayList<String> includes = new ArrayList<String>();
        if (this.isSpecificTestSpecified()) {
            Collections.addAll(includes, StringUtils.split((String)this.getTest(), (String)","));
        } else {
            if (asScanList) {
                if (this.getIncludes() != null) {
                    includes.addAll(this.getIncludes());
                }
                this.checkMethodFilterInIncludesExcludes(includes);
            }
            if (this.getIncludesFile() != null) {
                includes.addAll(this.readListFromFile(this.getIncludesFile()));
            }
            if (asScanList && includes.isEmpty()) {
                Collections.addAll(includes, this.getDefaultIncludes());
            }
        }
        return this.filterNulls(includes);
    }

    private void checkMethodFilterInIncludesExcludes(Iterable<String> patterns) throws MojoFailureException {
        for (String pattern : patterns) {
            if (pattern == null || !pattern.contains("#")) continue;
            throw new MojoFailureException("Method filter prohibited in includes|excludes parameter: " + pattern);
        }
    }

    private TestListResolver getIncludedAndExcludedTests() throws MojoFailureException {
        if (this.includedExcludedTests == null) {
            this.includedExcludedTests = new TestListResolver(this.getIncludedScanList(), this.getExcludedScanList());
            this.getConsoleLogger().debug("Resolved included and excluded patterns: " + this.includedExcludedTests);
        }
        return this.includedExcludedTests;
    }

    public TestListResolver getSpecificTests() throws MojoFailureException {
        if (this.specificTests == null) {
            this.specificTests = new TestListResolver(this.getIncludeList(), this.getExcludeList());
        }
        return this.specificTests;
    }

    @Nonnull
    private List<String> filterNulls(@Nonnull List<String> toFilter) {
        ArrayList<String> result = new ArrayList<String>(toFilter.size());
        for (String item : toFilter) {
            if (item == null || (item = item.trim()).isEmpty()) continue;
            result.add(item);
        }
        return result;
    }

    private Artifact getTestNgArtifact() throws MojoExecutionException {
        Artifact artifact = this.getProjectArtifactMap().get(this.getTestNGArtifactName());
        Artifact projectArtifact = this.project.getArtifact();
        String projectArtifactName = projectArtifact.getGroupId() + ":" + projectArtifact.getArtifactId();
        if (artifact != null) {
            VersionRange range = this.createVersionRange();
            if (!range.containsVersion((ArtifactVersion)new DefaultArtifactVersion(artifact.getVersion()))) {
                throw new MojoExecutionException("TestNG support requires version 4.7 or above. You have declared version " + artifact.getVersion());
            }
        } else if (projectArtifactName.equals(this.getTestNGArtifactName())) {
            artifact = projectArtifact;
        }
        return artifact;
    }

    private VersionRange createVersionRange() {
        try {
            return VersionRange.createFromVersionSpec((String)"[4.7,)");
        }
        catch (InvalidVersionSpecificationException e) {
            throw new RuntimeException(e);
        }
    }

    private Artifact getJunitArtifact() {
        Artifact artifact = this.getProjectArtifactMap().get(this.getJunitArtifactName());
        Artifact projectArtifact = this.project.getArtifact();
        String projectArtifactName = projectArtifact.getGroupId() + ":" + projectArtifact.getArtifactId();
        if (artifact == null && projectArtifactName.equals(this.getJunitArtifactName())) {
            artifact = projectArtifact;
        }
        return artifact;
    }

    private Artifact getJunitDepArtifact() {
        return this.getProjectArtifactMap().get("junit:junit-dep");
    }

    private Artifact getJUnitPlatformRunnerArtifact() {
        return this.getProjectArtifactMap().get("org.junit.platform:junit-platform-runner");
    }

    private Artifact getJUnit5Artifact() {
        Artifact artifact = this.getPluginArtifactMap().get("org.junit.platform:junit-platform-engine");
        if (artifact == null) {
            return this.getProjectArtifactMap().get("org.junit.platform:junit-platform-commons");
        }
        return artifact;
    }

    private ForkStarter createForkStarter(@Nonnull ProviderInfo provider, @Nonnull ForkConfiguration forkConfiguration, @Nonnull ClassLoaderConfiguration classLoaderConfiguration, @Nonnull RunOrderParameters runOrderParameters, @Nonnull ConsoleLogger log, @Nonnull DefaultScanResult scanResult, @Nonnull TestClassPath testClasspathWrapper, @Nonnull Platform platform, @Nonnull ResolvePathResultWrapper resolvedJavaModularityResult) throws MojoExecutionException, MojoFailureException {
        StartupConfiguration startupConfiguration = this.createStartupConfiguration(provider, true, classLoaderConfiguration, scanResult, testClasspathWrapper, platform, resolvedJavaModularityResult);
        String configChecksum = this.getConfigChecksum();
        StartupReportConfiguration startupReportConfiguration = this.getStartupReportConfiguration(configChecksum, true);
        ProviderConfiguration providerConfiguration = this.createProviderConfiguration(runOrderParameters);
        return new ForkStarter(providerConfiguration, startupConfiguration, forkConfiguration, this.getForkedProcessTimeoutInSeconds(), startupReportConfiguration, log);
    }

    private InPluginVMSurefireStarter createInprocessStarter(@Nonnull ProviderInfo provider, @Nonnull ClassLoaderConfiguration classLoaderConfig, @Nonnull RunOrderParameters runOrderParameters, @Nonnull DefaultScanResult scanResult, @Nonnull Platform platform, @Nonnull TestClassPath testClasspathWrapper) throws MojoExecutionException, MojoFailureException {
        StartupConfiguration startupConfiguration = this.createStartupConfiguration(provider, false, classLoaderConfig, scanResult, testClasspathWrapper, platform, new ResolvePathResultWrapper(null, true));
        String configChecksum = this.getConfigChecksum();
        StartupReportConfiguration startupReportConfiguration = this.getStartupReportConfiguration(configChecksum, false);
        ProviderConfiguration providerConfiguration = this.createProviderConfiguration(runOrderParameters);
        return new InPluginVMSurefireStarter(startupConfiguration, providerConfiguration, startupReportConfiguration, this.getConsoleLogger(), platform);
    }

    @Nonnull
    private ForkNodeFactory getForkNodeFactory() {
        ForkNodeFactory forkNode = this.getForkNode();
        return forkNode == null ? new LegacyForkNodeFactory() : forkNode;
    }

    @Nonnull
    private ForkConfiguration createForkConfiguration(@Nonnull Platform platform, @Nonnull ResolvePathResultWrapper resolvedJavaModularityResult) throws MojoExecutionException {
        File tmpDir = this.getSurefireTempDir();
        Artifact shadeFire = this.getShadefireArtifact();
        Classpath bootClasspath = this.getArtifactClasspath(shadeFire != null ? shadeFire : this.getBooterArtifact());
        ForkNodeFactory forkNode = this.getForkNodeFactory();
        this.getConsoleLogger().debug("Found implementation of fork node factory: " + forkNode.getClass().getName());
        if (this.canExecuteProviderWithModularPath(platform, resolvedJavaModularityResult)) {
            return new ModularClasspathForkConfiguration(bootClasspath, tmpDir, this.getEffectiveDebugForkedProcess(), this.getWorkingDirectory() != null ? this.getWorkingDirectory() : this.getBasedir(), this.getProject().getModel().getProperties(), this.getArgLine(), this.getEnvironmentVariables(), this.getExcludedEnvironmentVariables(), this.getConsoleLogger().isDebugEnabled(), this.getEffectiveForkCount(), this.reuseForks, platform, this.getConsoleLogger(), forkNode);
        }
        if (this.getClassLoaderConfiguration().isManifestOnlyJarRequestedAndUsable()) {
            return new JarManifestForkConfiguration(bootClasspath, tmpDir, this.getEffectiveDebugForkedProcess(), this.getWorkingDirectory() != null ? this.getWorkingDirectory() : this.getBasedir(), this.getProject().getModel().getProperties(), this.getArgLine(), this.getEnvironmentVariables(), this.getExcludedEnvironmentVariables(), this.getConsoleLogger().isDebugEnabled(), this.getEffectiveForkCount(), this.reuseForks, platform, this.getConsoleLogger(), forkNode);
        }
        return new ClasspathForkConfiguration(bootClasspath, tmpDir, this.getEffectiveDebugForkedProcess(), this.getWorkingDirectory() != null ? this.getWorkingDirectory() : this.getBasedir(), this.getProject().getModel().getProperties(), this.getArgLine(), this.getEnvironmentVariables(), this.getExcludedEnvironmentVariables(), this.getConsoleLogger().isDebugEnabled(), this.getEffectiveForkCount(), this.reuseForks, platform, this.getConsoleLogger(), forkNode);
    }

    private void ensureEnableProcessChecker() throws MojoFailureException {
        if (!ProcessCheckerType.isValid((String)this.getEnableProcessChecker())) {
            throw new MojoFailureException("Unexpected value '" + this.getEnableProcessChecker() + "' in the configuration parameter 'enableProcessChecker'.");
        }
    }

    protected int getEffectiveForkCount() {
        if (this.effectiveForkCount < 0) {
            try {
                this.effectiveForkCount = this.convertWithCoreCount(this.forkCount);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (this.effectiveForkCount < 0) {
                throw new IllegalArgumentException("Fork count " + this.forkCount.trim() + " is not a legal value.");
            }
        }
        return this.effectiveForkCount;
    }

    protected int convertWithCoreCount(String count) {
        String trimmed = count.trim();
        if (trimmed.endsWith("C")) {
            double multiplier = Double.parseDouble(trimmed.substring(0, trimmed.length() - 1));
            double calculated = multiplier * (double)Runtime.getRuntime().availableProcessors();
            return calculated > 0.0 ? Math.max((int)calculated, 1) : 0;
        }
        return Integer.parseInt(trimmed);
    }

    private String getEffectiveDebugForkedProcess() {
        String debugForkedProcess = this.getDebugForkedProcess();
        if ("true".equals(debugForkedProcess)) {
            return "-agentlib:jdwp=transport=dt_socket,server=y,suspend=y,address=localhost:5005";
        }
        return debugForkedProcess;
    }

    private JdkAttributes getEffectiveJvm() throws MojoFailureException {
        String jvmToUse;
        if (StringUtils.isNotEmpty((String)this.getJvm())) {
            File pathToJava = new File(this.getJvm()).getAbsoluteFile();
            if (!SystemUtils.endsWithJavaPath((String)pathToJava.getPath())) {
                throw new MojoFailureException("Given path does not end with java executor \"" + pathToJava.getPath() + "\".");
            }
            if (!(pathToJava.isFile() || "java".equals(pathToJava.getName()) && pathToJava.getParentFile().isDirectory())) {
                throw new MojoFailureException("Given path to java executor does not exist \"" + pathToJava.getPath() + "\".");
            }
            File jdkHome = SystemUtils.toJdkHomeFromJvmExec((String)pathToJava.getPath());
            if (jdkHome == null) {
                this.getConsoleLogger().warning("Cannot determine JAVA_HOME of jvm exec path " + pathToJava);
            } else if (!this.getEnvironmentVariables().containsKey("JAVA_HOME")) {
                this.getEnvironmentVariables().put("JAVA_HOME", jdkHome.getAbsolutePath());
            }
            BigDecimal version = jdkHome == null ? null : SystemUtils.toJdkVersionFromReleaseFile((File)jdkHome);
            boolean javaVersion9 = version == null ? SystemUtils.isJava9AtLeast((String)pathToJava.getPath()) : SystemUtils.isJava9AtLeast((BigDecimal)version);
            return new JdkAttributes(pathToJava, jdkHome, javaVersion9);
        }
        if (this.toolchain != null && StringUtils.isNotEmpty((String)(jvmToUse = this.toolchain.findTool("java")))) {
            boolean javaVersion9 = false;
            String jdkHome = null;
            if (this.toolchain instanceof DefaultToolchain) {
                DefaultToolchain defaultToolchain = (DefaultToolchain)this.toolchain;
                boolean bl = javaVersion9 = defaultToolchain.matchesRequirements(JAVA_9_MATCHER) || defaultToolchain.matchesRequirements(JAVA_9_MATCHER_OLD_NOTATION);
            }
            if (this.toolchain instanceof DefaultJavaToolChain) {
                DefaultJavaToolChain defaultJavaToolChain = (DefaultJavaToolChain)this.toolchain;
                if (!this.getEnvironmentVariables().containsKey("JAVA_HOME")) {
                    jdkHome = defaultJavaToolChain.getJavaHome();
                    this.getEnvironmentVariables().put("JAVA_HOME", jdkHome);
                }
            }
            if (!javaVersion9) {
                javaVersion9 = SystemUtils.isJava9AtLeast((String)jvmToUse);
            }
            return new JdkAttributes(new File(jvmToUse), jdkHome == null ? SystemUtils.toJdkHomeFromJvmExec((String)jvmToUse) : new File(jdkHome), javaVersion9);
        }
        jvmToUse = System.getProperty("java.home") + File.separator + "bin" + File.separator + "java";
        this.getConsoleLogger().debug("Using JVM: " + jvmToUse + " with Java version " + JavaVersion.JAVA_RECENT);
        return new JdkAttributes(jvmToUse, SystemUtils.isBuiltInJava9AtLeast());
    }

    File getSurefireTempDir() {
        File result = org.apache.maven.surefire.shared.lang3.SystemUtils.IS_OS_WINDOWS ? this.createSurefireBootDirectoryInTemp() : this.createSurefireBootDirectoryInBuild();
        try {
            File canonical = result.getCanonicalFile();
            if (!result.equals(canonical)) {
                this.getConsoleLogger().debug("Canonicalized tempDir path '" + result + "' to '" + canonical + "'");
            }
            return canonical;
        }
        catch (IOException e) {
            this.getConsoleLogger().error("Could not canonicalize tempDir path '" + result + "'", e);
            return result;
        }
    }

    private String getConfigChecksum() {
        ChecksumCalculator checksum = new ChecksumCalculator();
        checksum.add(this.getPluginName());
        checksum.add(this.isSkipTests());
        checksum.add(this.isSkipExec());
        checksum.add(this.isSkip());
        checksum.add(this.getTestClassesDirectory());
        checksum.add(this.getMainBuildPath());
        checksum.add(this.getClasspathDependencyExcludes());
        checksum.add(this.getClasspathDependencyScopeExclude());
        checksum.add(this.getAdditionalClasspathElements());
        checksum.add(this.getReportsDirectory());
        checksum.add(this.getProjectBuildDirectory());
        checksum.add(this.getTestSourceDirectory());
        checksum.add(this.getTest());
        checksum.add(this.getIncludes());
        checksum.add(this.getSkipAfterFailureCount());
        checksum.add(this.getShutdown());
        checksum.add(this.getExcludes());
        checksum.add(this.getLocalRepository());
        checksum.add(this.getSystemProperties());
        checksum.add(this.getSystemPropertyVariables());
        checksum.add(this.getSystemPropertiesFile());
        checksum.add(this.getProperties());
        checksum.add(this.isPrintSummary());
        checksum.add(this.getReportFormat());
        checksum.add(this.getReportNameSuffix());
        checksum.add(this.isUseFile());
        checksum.add(this.isRedirectTestOutputToFile());
        checksum.add(this.getForkCount());
        checksum.add(this.isReuseForks());
        checksum.add(this.getJvm());
        checksum.add(this.getArgLine());
        checksum.add(this.getDebugForkedProcess());
        checksum.add(this.getForkedProcessTimeoutInSeconds());
        checksum.add(this.getParallelTestsTimeoutInSeconds());
        checksum.add(this.getParallelTestsTimeoutForcedInSeconds());
        checksum.add(this.getEnvironmentVariables());
        checksum.add(this.getExcludedEnvironmentVariables());
        checksum.add(this.getWorkingDirectory());
        checksum.add(this.isChildDelegation());
        checksum.add(this.getGroups());
        checksum.add(this.getExcludedGroups());
        checksum.add(this.getIncludeJUnit5Engines());
        checksum.add(this.getExcludeJUnit5Engines());
        checksum.add(this.getSuiteXmlFiles());
        checksum.add(this.getJunitArtifact());
        checksum.add(this.getTestNGArtifactName());
        checksum.add(this.getThreadCount());
        checksum.add(this.getThreadCountSuites());
        checksum.add(this.getThreadCountClasses());
        checksum.add(this.getThreadCountMethods());
        checksum.add(this.getPerCoreThreadCount());
        checksum.add(this.getUseUnlimitedThreads());
        checksum.add(this.getParallel());
        checksum.add(this.isParallelOptimized());
        checksum.add(this.isTrimStackTrace());
        checksum.add(this.getRemoteRepositories());
        checksum.add(this.getProjectRemoteRepositories());
        checksum.add(this.isDisableXmlReport());
        checksum.add(this.isUseSystemClassLoader());
        checksum.add(this.isUseManifestOnlyJar());
        checksum.add(this.getEncoding());
        checksum.add(this.isEnableAssertions());
        checksum.add(this.getObjectFactory());
        checksum.add(this.getFailIfNoTests());
        checksum.add(this.getRunOrder());
        checksum.add(this.getDependenciesToScan());
        checksum.add(this.getForkedProcessExitTimeoutInSeconds());
        checksum.add(this.getRerunFailingTestsCount());
        checksum.add(this.getTempDir());
        checksum.add(this.useModulePath());
        checksum.add(this.getEnableProcessChecker());
        this.addPluginSpecificChecksumItems(checksum);
        return checksum.getSha1();
    }

    protected void addPluginSpecificChecksumItems(ChecksumCalculator checksum) {
    }

    protected boolean hasExecutedBefore() {
        String configChecksum = this.getConfigChecksum();
        Map pluginContext = this.getPluginContext();
        if (pluginContext.containsKey(configChecksum)) {
            this.getConsoleLogger().info("Skipping execution of surefire because it has already been run for this configuration");
            return true;
        }
        pluginContext.put(configChecksum, configChecksum);
        return false;
    }

    @Nonnull
    protected ClassLoaderConfiguration getClassLoaderConfiguration() {
        return this.isForking() ? new ClassLoaderConfiguration(this.isUseSystemClassLoader(), this.isUseManifestOnlyJar()) : new ClassLoaderConfiguration(false, false);
    }

    private TestClassPath generateTestClasspath() {
        Set<Artifact> classpathArtifacts = this.getProject().getArtifacts();
        if (this.getClasspathDependencyScopeExclude() != null && !this.getClasspathDependencyScopeExclude().isEmpty()) {
            ScopeArtifactFilter dependencyFilter = new ScopeArtifactFilter(this.getClasspathDependencyScopeExclude());
            classpathArtifacts = AbstractSurefireMojo.filterArtifacts(classpathArtifacts, (ArtifactFilter)dependencyFilter);
        }
        if (this.getClasspathDependencyExcludes() != null) {
            List<String> excludedDependencies = Arrays.asList(this.getClasspathDependencyExcludes());
            PatternIncludesArtifactFilter dependencyFilter = new PatternIncludesArtifactFilter(excludedDependencies);
            classpathArtifacts = AbstractSurefireMojo.filterArtifacts(classpathArtifacts, (ArtifactFilter)dependencyFilter);
        }
        return new TestClassPath((Iterable<Artifact>)classpathArtifacts, this.getMainBuildPath(), this.getTestClassesDirectory(), this.getAdditionalClasspathElements());
    }

    private static Set<Artifact> filterArtifacts(Set<Artifact> artifacts, ArtifactFilter filter) {
        LinkedHashSet<Artifact> filteredArtifacts = new LinkedHashSet<Artifact>();
        for (Artifact artifact : artifacts) {
            if (filter.include(artifact)) continue;
            filteredArtifacts.add(artifact);
        }
        return filteredArtifacts;
    }

    private void showMap(Map<?, ?> map, String setting) {
        for (Object o : map.keySet()) {
            String key = (String)o;
            String value = (String)map.get(key);
            this.getConsoleLogger().debug("Setting " + setting + " [" + key + "]=[" + value + "]");
        }
    }

    private <T> void showArray(T[] array, String setting) {
        for (T e : array) {
            this.getConsoleLogger().debug("Setting " + setting + " [" + e + "]");
        }
    }

    private Classpath getArtifactClasspath(Artifact surefireArtifact) throws MojoExecutionException {
        Classpath existing = this.classpathCache.getCachedClassPath(surefireArtifact.getArtifactId());
        if (existing == null) {
            ArrayList<String> items = new ArrayList<String>();
            Set booterArtifacts = this.surefireDependencyResolver.resolvePluginArtifact(surefireArtifact).getArtifacts();
            for (Artifact artifact : booterArtifacts) {
                this.getConsoleLogger().debug("Adding to " + this.getPluginName() + " booter test classpath: " + artifact.getFile().getAbsolutePath() + " Scope: " + artifact.getScope());
                items.add(artifact.getFile().getAbsolutePath());
            }
            existing = new Classpath(items);
            this.classpathCache.setCachedClasspath(surefireArtifact.getArtifactId(), existing);
        }
        return existing;
    }

    private Properties getUserProperties() {
        return this.getSession().getUserProperties();
    }

    private void ensureWorkingDirectoryExists() throws MojoFailureException {
        if (this.getWorkingDirectory() == null) {
            throw new MojoFailureException("workingDirectory cannot be null");
        }
        if (this.isForking()) {
            return;
        }
        if (!this.getWorkingDirectory().exists() && !this.getWorkingDirectory().mkdirs()) {
            throw new MojoFailureException("Cannot create workingDirectory " + this.getWorkingDirectory());
        }
        if (!this.getWorkingDirectory().isDirectory()) {
            throw new MojoFailureException("workingDirectory " + this.getWorkingDirectory() + " exists and is not a directory");
        }
    }

    private void ensureParallelRunningCompatibility() throws MojoFailureException {
        if (this.isMavenParallel() && this.isNotForking()) {
            throw new MojoFailureException("parallel maven execution is not compatible with surefire forkCount 0");
        }
    }

    private void warnIfUselessUseSystemClassLoaderParameter() {
        if (this.isUseSystemClassLoader() && this.isNotForking()) {
            this.getConsoleLogger().warning("useSystemClassLoader setting has no effect when not forking");
        }
    }

    private boolean isNotForking() {
        return !this.isForking();
    }

    private List<CommandLineOption> commandLineOptions() {
        return SurefireHelper.commandLineOptions(this.getSession(), this.getConsoleLogger());
    }

    private void warnIfDefunctGroupsCombinations() throws MojoFailureException, MojoExecutionException {
        if (this.isAnyGroupsSelected() && this.getTestNgArtifact() == null) {
            boolean junit5PlatformCompatible;
            Artifact junitArtifact = this.getJunitArtifact();
            boolean junit47Compatible = this.isJunit47Compatible(junitArtifact);
            boolean bl = junit5PlatformCompatible = this.getJUnit5Artifact() != null;
            if (!junit47Compatible && !junit5PlatformCompatible) {
                if (junitArtifact != null) {
                    throw new MojoFailureException("groups/excludedGroups are specified but JUnit version on classpath is too old to support groups. Check your dependency:tree to see if your project is picking up an old junit version");
                }
                throw new MojoFailureException("groups/excludedGroups require TestNG, JUnit48+ or JUnit 5 (a specific engine required on classpath) on project test classpath");
            }
        }
    }

    private void warnIfRerunClashes() throws MojoFailureException {
        if (this.getRerunFailingTestsCount() < 0) {
            throw new MojoFailureException("Parameter \"rerunFailingTestsCount\" should not be negative.");
        }
        if (this.getSkipAfterFailureCount() < 0) {
            throw new MojoFailureException("Parameter \"skipAfterFailureCount\" should not be negative.");
        }
    }

    private void warnIfWrongShutdownValue() throws MojoFailureException {
        if (!Shutdown.isKnown((String)this.getShutdown())) {
            throw new MojoFailureException("Parameter \"shutdown\" should have values " + Shutdown.listParameters());
        }
    }

    private void warnIfNotApplicableSkipAfterFailureCount() throws MojoFailureException {
        int skipAfterFailureCount = this.getSkipAfterFailureCount();
        if (skipAfterFailureCount < 0) {
            throw new MojoFailureException("Parameter \"skipAfterFailureCount\" should not be negative.");
        }
        if (skipAfterFailureCount > 0) {
            try {
                Artifact testng = this.getTestNgArtifact();
                if (testng != null) {
                    VersionRange range = VersionRange.createFromVersionSpec((String)"[5.10,)");
                    if (!range.containsVersion((ArtifactVersion)new DefaultArtifactVersion(testng.getVersion()))) {
                        throw new MojoFailureException("Parameter \"skipAfterFailureCount\" expects TestNG Version 5.10 or higher. java.lang.NoClassDefFoundError: org/testng/IInvokedMethodListener");
                    }
                } else {
                    VersionRange range;
                    Artifact junit = this.getJunitArtifact();
                    if (junit != null && !(range = VersionRange.createFromVersionSpec((String)"[4.0,)")).containsVersion((ArtifactVersion)new DefaultArtifactVersion(junit.getVersion()))) {
                        throw new MojoFailureException("Parameter \"skipAfterFailureCount\" expects JUnit Version 4.0 or higher. java.lang.NoSuchMethodError: org.junit.runner.notification.RunNotifier.pleaseStop()V");
                    }
                }
            }
            catch (MojoExecutionException e) {
                throw new MojoFailureException(e.getLocalizedMessage());
            }
            catch (InvalidVersionSpecificationException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void warnIfIllegalTempDir() throws MojoFailureException {
        if (StringUtils.isEmpty((String)this.getTempDir())) {
            throw new MojoFailureException("Parameter 'tempDir' should not be blank string.");
        }
    }

    protected void warnIfIllegalFailOnFlakeCount() throws MojoFailureException {
    }

    private void printDefaultSeedIfNecessary() {
        if (this.getRunOrder().equals(RunOrder.RANDOM.name())) {
            if (this.getRunOrderRandomSeed() == null) {
                this.setRunOrderRandomSeed(System.nanoTime());
            }
            this.getConsoleLogger().info("Tests will run in random order. To reproduce ordering use flag -D" + this.getPluginName() + ".runOrder.random.seed=" + this.getRunOrderRandomSeed());
        }
    }

    File createSurefireBootDirectoryInBuild() {
        File tmp = new File(this.getProjectBuildDirectory(), this.getTempDir());
        tmp.mkdirs();
        return tmp;
    }

    File createSurefireBootDirectoryInTemp() {
        try {
            return Files.createTempDirectory(this.getTempDir(), new FileAttribute[0]).toFile();
        }
        catch (IOException e) {
            return this.createSurefireBootDirectoryInBuild();
        }
    }

    @Override
    public ArtifactRepository getLocalRepository() {
        return this.localRepository;
    }

    @Override
    public void setLocalRepository(ArtifactRepository localRepository) {
        this.localRepository = localRepository;
    }

    public Properties getSystemProperties() {
        return this.systemProperties;
    }

    public void setSystemProperties(Properties systemProperties) {
        this.systemProperties = systemProperties;
    }

    public Map<String, String> getSystemPropertyVariables() {
        return this.systemPropertyVariables;
    }

    public void setSystemPropertyVariables(Map<String, String> systemPropertyVariables) {
        this.systemPropertyVariables = systemPropertyVariables;
    }

    public abstract File getSystemPropertiesFile();

    public abstract void setSystemPropertiesFile(File var1);

    private Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public Map<String, Artifact> getPluginArtifactMap() {
        return this.pluginArtifactMap;
    }

    public void setPluginArtifactMap(Map<String, Artifact> pluginArtifactMap) {
        this.pluginArtifactMap = pluginArtifactMap;
    }

    public Map<String, Artifact> getProjectArtifactMap() {
        return this.projectArtifactMap;
    }

    public void setProjectArtifactMap(Map<String, Artifact> projectArtifactMap) {
        this.projectArtifactMap = projectArtifactMap;
    }

    public String getReportNameSuffix() {
        return this.reportNameSuffix;
    }

    public void setReportNameSuffix(String reportNameSuffix) {
        this.reportNameSuffix = reportNameSuffix;
    }

    public boolean isRedirectTestOutputToFile() {
        return this.redirectTestOutputToFile;
    }

    public void setRedirectTestOutputToFile(boolean redirectTestOutputToFile) {
        this.redirectTestOutputToFile = redirectTestOutputToFile;
    }

    public boolean getFailIfNoTests() {
        return this.failIfNoTests;
    }

    public void setFailIfNoTests(boolean failIfNoTests) {
        this.failIfNoTests = failIfNoTests;
    }

    public String getJvm() {
        return this.jvm;
    }

    public String getArgLine() {
        return this.argLine;
    }

    public void setArgLine(String argLine) {
        this.argLine = argLine;
    }

    public Map<String, String> getEnvironmentVariables() {
        return this.environmentVariables;
    }

    public void setEnvironmentVariables(Map<String, String> environmentVariables) {
        this.environmentVariables = environmentVariables;
    }

    public File getWorkingDirectory() {
        return this.workingDirectory;
    }

    public void setWorkingDirectory(File workingDirectory) {
        this.workingDirectory = workingDirectory;
    }

    public boolean isChildDelegation() {
        return this.childDelegation;
    }

    public void setChildDelegation(boolean childDelegation) {
        this.childDelegation = childDelegation;
    }

    public String getGroups() {
        return this.groups;
    }

    public void setGroups(String groups) {
        this.groups = groups;
    }

    public String getExcludedGroups() {
        return this.excludedGroups;
    }

    public void setExcludedGroups(String excludedGroups) {
        this.excludedGroups = excludedGroups;
    }

    public String getJunitArtifactName() {
        return this.junitArtifactName;
    }

    public void setJunitArtifactName(String junitArtifactName) {
        this.junitArtifactName = junitArtifactName;
    }

    public String getTestNGArtifactName() {
        return this.testNGArtifactName;
    }

    public void setTestNGArtifactName(String testNGArtifactName) {
        this.testNGArtifactName = testNGArtifactName;
    }

    public int getThreadCount() {
        return this.threadCount;
    }

    public void setThreadCount(int threadCount) {
        this.threadCount = threadCount;
    }

    public boolean getPerCoreThreadCount() {
        return this.perCoreThreadCount;
    }

    public void setPerCoreThreadCount(boolean perCoreThreadCount) {
        this.perCoreThreadCount = perCoreThreadCount;
    }

    public boolean getUseUnlimitedThreads() {
        return this.useUnlimitedThreads;
    }

    public void setUseUnlimitedThreads(boolean useUnlimitedThreads) {
        this.useUnlimitedThreads = useUnlimitedThreads;
    }

    public String getParallel() {
        return this.parallel;
    }

    public void setParallel(String parallel) {
        this.parallel = parallel;
    }

    public boolean isParallelOptimized() {
        return this.parallelOptimized;
    }

    public void setParallelOptimized(boolean parallelOptimized) {
        this.parallelOptimized = parallelOptimized;
    }

    public int getThreadCountSuites() {
        return this.threadCountSuites;
    }

    public void setThreadCountSuites(int threadCountSuites) {
        this.threadCountSuites = threadCountSuites;
    }

    public int getThreadCountClasses() {
        return this.threadCountClasses;
    }

    public void setThreadCountClasses(int threadCountClasses) {
        this.threadCountClasses = threadCountClasses;
    }

    public int getThreadCountMethods() {
        return this.threadCountMethods;
    }

    public void setThreadCountMethods(int threadCountMethods) {
        this.threadCountMethods = threadCountMethods;
    }

    public boolean isTrimStackTrace() {
        return this.trimStackTrace;
    }

    public void setTrimStackTrace(boolean trimStackTrace) {
        this.trimStackTrace = trimStackTrace;
    }

    public List<ArtifactRepository> getProjectRemoteRepositories() {
        return this.projectRemoteRepositories;
    }

    public void setProjectRemoteRepositories(List<ArtifactRepository> projectRemoteRepositories) {
        this.projectRemoteRepositories = projectRemoteRepositories;
    }

    public List<ArtifactRepository> getRemoteRepositories() {
        return this.remoteRepositories;
    }

    public void setRemoteRepositories(List<ArtifactRepository> remoteRepositories) {
        this.remoteRepositories = remoteRepositories;
    }

    public boolean isDisableXmlReport() {
        return this.disableXmlReport;
    }

    public void setDisableXmlReport(boolean disableXmlReport) {
        this.disableXmlReport = disableXmlReport;
    }

    public boolean isEnableAssertions() {
        return this.enableAssertions;
    }

    public boolean effectiveIsEnableAssertions() {
        List<String> args;
        if (this.getArgLine() != null && ((args = Arrays.asList(this.getArgLine().split(" "))).contains("-da") || args.contains("-disableassertions"))) {
            return false;
        }
        return this.isEnableAssertions();
    }

    public void setEnableAssertions(boolean enableAssertions) {
        this.enableAssertions = enableAssertions;
    }

    public MavenSession getSession() {
        return this.session;
    }

    public void setSession(MavenSession session) {
        this.session = session;
    }

    public String getObjectFactory() {
        return this.objectFactory;
    }

    public void setObjectFactory(String objectFactory) {
        this.objectFactory = objectFactory;
    }

    public ToolchainManager getToolchainManager() {
        return this.toolchainManager;
    }

    public void setToolchainManager(ToolchainManager toolchainManager) {
        this.toolchainManager = toolchainManager;
    }

    public boolean isMavenParallel() {
        return this.parallelMavenExecution != null && this.parallelMavenExecution != false;
    }

    public String[] getDependenciesToScan() {
        return this.dependenciesToScan;
    }

    public void setDependenciesToScan(String[] dependenciesToScan) {
        this.dependenciesToScan = dependenciesToScan;
    }

    void setPluginDescriptor(PluginDescriptor pluginDescriptor) {
        this.pluginDescriptor = pluginDescriptor;
    }

    public PluginDescriptor getPluginDescriptor() {
        return this.pluginDescriptor;
    }

    public MavenProject getProject() {
        return this.project;
    }

    public void setProject(MavenProject project) {
        this.project = project;
    }

    @Override
    public File getTestSourceDirectory() {
        return this.testSourceDirectory;
    }

    @Override
    public void setTestSourceDirectory(File testSourceDirectory) {
        this.testSourceDirectory = testSourceDirectory;
    }

    public String getForkCount() {
        return this.forkCount;
    }

    public boolean isReuseForks() {
        return this.reuseForks;
    }

    public String[] getAdditionalClasspathElements() {
        return this.additionalClasspathElements;
    }

    public void setAdditionalClasspathElements(String[] additionalClasspathElements) {
        this.additionalClasspathElements = additionalClasspathElements;
    }

    public String[] getClasspathDependencyExcludes() {
        return this.classpathDependencyExcludes;
    }

    public void setClasspathDependencyExcludes(String[] classpathDependencyExcludes) {
        this.classpathDependencyExcludes = classpathDependencyExcludes;
    }

    public String getClasspathDependencyScopeExclude() {
        return this.classpathDependencyScopeExclude;
    }

    public void setClasspathDependencyScopeExclude(String classpathDependencyScopeExclude) {
        this.classpathDependencyScopeExclude = classpathDependencyScopeExclude;
    }

    public File getProjectBuildDirectory() {
        return this.projectBuildDirectory;
    }

    public void setProjectBuildDirectory(File projectBuildDirectory) {
        this.projectBuildDirectory = projectBuildDirectory;
    }

    protected void logDebugOrCliShowErrors(String s) {
        SurefireHelper.logDebugOrCliShowErrors(s, this.getConsoleLogger(), this.cli);
    }

    public Map<String, String> getJdkToolchain() {
        return this.jdkToolchain;
    }

    public void setJdkToolchain(Map<String, String> jdkToolchain) {
        this.jdkToolchain = jdkToolchain;
    }

    public String getTempDir() {
        return this.tempDir;
    }

    public void setTempDir(String tempDir) {
        this.tempDir = tempDir;
    }

    public void setResolutionErrorHandler(ResolutionErrorHandler resolutionErrorHandler) {
        this.resolutionErrorHandler = resolutionErrorHandler;
    }

    static enum PluginFailureReason {
        NONE,
        COULD_NOT_RUN_SPECIFIED_TESTS,
        COULD_NOT_RUN_DEFAULT_TESTS;

    }

    private static final class ClasspathCache {
        private final Map<String, Classpath> classpaths = new HashMap<String, Classpath>(4);

        private ClasspathCache() {
        }

        private Classpath getCachedClassPath(@Nonnull String artifactId) {
            return this.classpaths.get(artifactId);
        }

        private void setCachedClasspath(@Nonnull String key, @Nonnull Classpath classpath) {
            this.classpaths.put(key, classpath);
        }

        private Classpath setCachedClasspath(@Nonnull String key, @Nonnull Set<Artifact> artifacts) {
            ArrayList<String> files = new ArrayList<String>();
            for (Artifact artifact : artifacts) {
                files.add(artifact.getFile().getAbsolutePath());
            }
            Classpath classpath = new Classpath(files);
            this.setCachedClasspath(key, classpath);
            return classpath;
        }
    }

    final class DynamicProviderInfo
    implements ConfigurableProviderInfo {
        final String providerName;

        DynamicProviderInfo(String providerName) {
            this.providerName = providerName;
        }

        @Override
        public ProviderInfo instantiate(String providerName) {
            return new DynamicProviderInfo(providerName);
        }

        @Override
        @Nonnull
        public String getProviderName() {
            return this.providerName;
        }

        @Override
        public boolean isApplicable() {
            return true;
        }

        @Override
        public void addProviderProperties() throws MojoExecutionException {
            AbstractSurefireMojo.this.convertJunitCoreParameters();
            AbstractSurefireMojo.this.convertTestNGParameters();
        }

        @Override
        @Nonnull
        public List<String[]> getJpmsArguments(@Nonnull ProviderRequirements forkRequirements) {
            return Collections.emptyList();
        }

        @Override
        @Nonnull
        public Set<Artifact> getProviderClasspath() throws MojoExecutionException {
            Plugin plugin = AbstractSurefireMojo.this.getPluginDescriptor().getPlugin();
            Map<String, Artifact> providerArtifacts = AbstractSurefireMojo.this.surefireDependencyResolver.resolvePluginDependencies(plugin, AbstractSurefireMojo.this.getPluginArtifactMap());
            return new LinkedHashSet<Artifact>(providerArtifacts.values());
        }
    }

    final class JUnitCoreProviderInfo
    implements ProviderInfo {
        private final Artifact junitArtifact;
        private final Artifact junitDepArtifact;

        JUnitCoreProviderInfo(Artifact junitArtifact, Artifact junitDepArtifact) {
            this.junitArtifact = junitArtifact;
            this.junitDepArtifact = junitDepArtifact;
        }

        @Override
        @Nonnull
        public String getProviderName() {
            return "org.apache.maven.surefire.junitcore.JUnitCoreProvider";
        }

        private boolean is47CompatibleJunitDep() {
            return AbstractSurefireMojo.this.isJunit47Compatible(this.junitDepArtifact);
        }

        @Override
        public boolean isApplicable() {
            boolean isJunitArtifact47 = AbstractSurefireMojo.this.isAnyJunit4(this.junitArtifact) && AbstractSurefireMojo.this.isJunit47Compatible(this.junitArtifact);
            boolean isAny47ProvidersForces = AbstractSurefireMojo.this.isAnyConcurrencySelected() || AbstractSurefireMojo.this.isAnyGroupsSelected();
            return isAny47ProvidersForces && (isJunitArtifact47 || this.is47CompatibleJunitDep());
        }

        @Override
        public void addProviderProperties() throws MojoExecutionException {
            AbstractSurefireMojo.this.convertJunitCoreParameters();
            AbstractSurefireMojo.this.convertGroupParameters();
            AbstractSurefireMojo.this.convertJunitEngineParameters();
        }

        @Override
        @Nonnull
        public List<String[]> getJpmsArguments(@Nonnull ProviderRequirements forkRequirements) {
            return Collections.emptyList();
        }

        @Override
        @Nonnull
        public Set<Artifact> getProviderClasspath() throws MojoExecutionException {
            String version = AbstractSurefireMojo.this.getBooterArtifact().getBaseVersion();
            return AbstractSurefireMojo.this.surefireDependencyResolver.getProviderClasspath("surefire-junit47", version);
        }
    }

    final class JUnitPlatformProviderInfo
    implements ProviderInfo {
        private static final String PROVIDER_DEP_GID = "org.junit.platform";
        private static final String PROVIDER_DEP_AID = "junit-platform-launcher";
        private final Artifact junitPlatformRunnerArtifact;
        private final Artifact junitPlatformArtifact;
        private final TestClassPath testClasspath;

        JUnitPlatformProviderInfo(Artifact junitPlatformRunnerArtifact, @Nonnull Artifact junitPlatformArtifact, TestClassPath testClasspath) {
            this.junitPlatformRunnerArtifact = junitPlatformRunnerArtifact;
            this.junitPlatformArtifact = junitPlatformArtifact;
            this.testClasspath = testClasspath;
        }

        @Override
        @Nonnull
        public String getProviderName() {
            return "org.apache.maven.surefire.junitplatform.JUnitPlatformProvider";
        }

        @Override
        public boolean isApplicable() {
            return this.junitPlatformRunnerArtifact == null && this.junitPlatformArtifact != null;
        }

        @Override
        public void addProviderProperties() {
            AbstractSurefireMojo.this.convertGroupParameters();
            AbstractSurefireMojo.this.convertJunitEngineParameters();
        }

        @Override
        @Nonnull
        public List<String[]> getJpmsArguments(@Nonnull ProviderRequirements forkRequirements) {
            boolean hasTestDescriptor = forkRequirements.isModularPath() && forkRequirements.hasTestModuleDescriptor();
            return hasTestDescriptor ? this.getJpmsArgs() : Collections.emptyList();
        }

        @Override
        @Nonnull
        public Set<Artifact> getProviderClasspath() throws MojoExecutionException {
            String surefireVersion = AbstractSurefireMojo.this.getBooterArtifact().getBaseVersion();
            Map<String, Artifact> providerArtifacts = AbstractSurefireMojo.this.surefireDependencyResolver.getProviderClasspathAsMap("surefire-junit-platform", surefireVersion);
            Map<String, Artifact> testDeps = this.testClasspath.getTestDependencies();
            Plugin plugin = AbstractSurefireMojo.this.getPluginDescriptor().getPlugin();
            Map<String, Artifact> pluginDeps = AbstractSurefireMojo.this.surefireDependencyResolver.resolvePluginDependencies(plugin, AbstractSurefireMojo.this.getPluginArtifactMap());
            if (this.hasDependencyPlatformEngine(pluginDeps)) {
                providerArtifacts.putAll(pluginDeps);
            } else {
                String engineCoordinates;
                String engineArtifactId;
                String engineGroupId;
                String engineVersion = null;
                if (this.hasDependencyJupiterAPI(testDeps) && !testDeps.containsKey("org.junit.jupiter:junit-jupiter-engine")) {
                    engineGroupId = "org.junit.jupiter";
                    engineArtifactId = "junit-jupiter-engine";
                    engineCoordinates = engineGroupId + ":" + engineArtifactId;
                    String api = "org.junit.jupiter:junit-jupiter-api";
                    engineVersion = testDeps.get(api).getBaseVersion();
                    AbstractSurefireMojo.this.getConsoleLogger().debug("Test dependencies contain " + api + ". Resolving " + engineCoordinates + ":" + engineVersion);
                    this.addEngineByApi(engineGroupId, engineArtifactId, engineVersion, providerArtifacts);
                }
                if ((testDeps.containsKey("junit:junit") || testDeps.containsKey("junit:junit-dep")) && !testDeps.containsKey("org.junit.vintage:junit-vintage-engine")) {
                    engineGroupId = "org.junit.vintage";
                    engineArtifactId = "junit-vintage-engine";
                    engineCoordinates = engineGroupId + ":" + engineArtifactId;
                    if (engineVersion != null) {
                        AbstractSurefireMojo.this.getConsoleLogger().debug("Test dependencies contain JUnit4. Resolving " + engineCoordinates + ":" + engineVersion);
                        this.addEngineByApi(engineGroupId, engineArtifactId, engineVersion, providerArtifacts);
                    }
                }
            }
            this.narrowDependencies(providerArtifacts, testDeps);
            this.alignProviderVersions(providerArtifacts);
            return new LinkedHashSet<Artifact>(providerArtifacts.values());
        }

        private List<String[]> getJpmsArgs() {
            ArrayList<String[]> args = new ArrayList<String[]>();
            args.add(new String[]{"--add-opens", "org.junit.platform.commons/org.junit.platform.commons.util=ALL-UNNAMED"});
            args.add(new String[]{"--add-opens", "org.junit.platform.commons/org.junit.platform.commons.logging=ALL-UNNAMED"});
            return args;
        }

        private void addEngineByApi(String engineGroupId, String engineArtifactId, String engineVersion, Map<String, Artifact> providerArtifacts) throws MojoExecutionException {
            for (Artifact dep : this.resolve(engineGroupId, engineArtifactId, engineVersion, null, "jar")) {
                String key = dep.getGroupId() + ":" + dep.getArtifactId();
                providerArtifacts.put(key, dep);
            }
        }

        private void narrowDependencies(Map<String, Artifact> providerArtifacts, Map<String, Artifact> testDependencies) {
            providerArtifacts.keySet().removeAll(testDependencies.keySet());
        }

        private void alignProviderVersions(Map<String, Artifact> providerArtifacts) throws MojoExecutionException {
            String version = this.junitPlatformArtifact.getBaseVersion();
            for (Artifact launcherArtifact : this.resolve(PROVIDER_DEP_GID, PROVIDER_DEP_AID, version, null, "jar")) {
                String key = launcherArtifact.getGroupId() + ":" + launcherArtifact.getArtifactId();
                if (!providerArtifacts.containsKey(key)) continue;
                providerArtifacts.put(key, launcherArtifact);
            }
        }

        private Set<Artifact> resolve(String g, String a, String v, String c, String t) throws MojoExecutionException {
            ArtifactHandler handler = this.junitPlatformArtifact.getArtifactHandler();
            DefaultArtifact artifact = new DefaultArtifact(g, a, v, null, t, c, handler);
            AbstractSurefireMojo.this.getConsoleLogger().debug("Resolving artifact " + g + ":" + a + ":" + v);
            Set r = AbstractSurefireMojo.this.surefireDependencyResolver.resolveProjectArtifact((Artifact)artifact).getArtifacts();
            AbstractSurefireMojo.this.getConsoleLogger().debug("Resolved artifact " + g + ":" + a + ":" + v + " to " + r);
            return r;
        }

        private boolean hasDependencyJupiterAPI(Map<String, Artifact> dependencies) {
            return dependencies.containsKey("org.junit.jupiter:junit-jupiter-api");
        }

        private boolean hasDependencyPlatformEngine(Map<String, Artifact> dependencies) {
            for (Map.Entry<String, Artifact> dependency : dependencies.entrySet()) {
                if (!dependency.getKey().equals("org.junit.platform:junit-platform-engine")) continue;
                return true;
            }
            return false;
        }
    }

    final class JUnit4ProviderInfo
    implements ProviderInfo {
        private final Artifact junitArtifact;
        private final Artifact junitDepArtifact;

        JUnit4ProviderInfo(Artifact junitArtifact, Artifact junitDepArtifact) {
            this.junitArtifact = junitArtifact;
            this.junitDepArtifact = junitDepArtifact;
        }

        @Override
        @Nonnull
        public String getProviderName() {
            return "org.apache.maven.surefire.junit4.JUnit4Provider";
        }

        @Override
        public boolean isApplicable() {
            return this.junitDepArtifact != null || AbstractSurefireMojo.this.isAnyJunit4(this.junitArtifact);
        }

        @Override
        public void addProviderProperties() {
        }

        @Override
        @Nonnull
        public List<String[]> getJpmsArguments(@Nonnull ProviderRequirements forkRequirements) {
            return Collections.emptyList();
        }

        @Override
        @Nonnull
        public Set<Artifact> getProviderClasspath() throws MojoExecutionException {
            String version = AbstractSurefireMojo.this.getBooterArtifact().getBaseVersion();
            return AbstractSurefireMojo.this.surefireDependencyResolver.getProviderClasspath("surefire-junit4", version);
        }
    }

    final class JUnit3ProviderInfo
    implements ProviderInfo {
        JUnit3ProviderInfo() {
        }

        @Override
        @Nonnull
        public String getProviderName() {
            return "org.apache.maven.surefire.junit.JUnit3Provider";
        }

        @Override
        public boolean isApplicable() {
            return true;
        }

        @Override
        public void addProviderProperties() {
        }

        @Override
        @Nonnull
        public List<String[]> getJpmsArguments(@Nonnull ProviderRequirements forkRequirements) {
            return Collections.emptyList();
        }

        @Override
        @Nonnull
        public Set<Artifact> getProviderClasspath() throws MojoExecutionException {
            String version = AbstractSurefireMojo.this.getBooterArtifact().getBaseVersion();
            return AbstractSurefireMojo.this.surefireDependencyResolver.getProviderClasspath("surefire-junit3", version);
        }
    }

    final class TestNgProviderInfo
    implements ProviderInfo {
        private final Artifact testNgArtifact;

        TestNgProviderInfo(Artifact testNgArtifact) {
            this.testNgArtifact = testNgArtifact;
        }

        @Override
        @Nonnull
        public String getProviderName() {
            return "org.apache.maven.surefire.testng.TestNGProvider";
        }

        @Override
        public boolean isApplicable() {
            return this.testNgArtifact != null;
        }

        @Override
        public void addProviderProperties() throws MojoExecutionException {
            AbstractSurefireMojo.this.convertTestNGParameters();
        }

        @Override
        @Nonnull
        public List<String[]> getJpmsArguments(@Nonnull ProviderRequirements forkRequirements) {
            return Collections.emptyList();
        }

        @Override
        @Nonnull
        public Set<Artifact> getProviderClasspath() throws MojoExecutionException {
            Artifact surefireArtifact = AbstractSurefireMojo.this.getBooterArtifact();
            String version = surefireArtifact.getBaseVersion();
            return AbstractSurefireMojo.this.surefireDependencyResolver.getProviderClasspath("surefire-testng", version);
        }
    }
}

