/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.surefire.util;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.maven.surefire.shade.org.apache.maven.shared.utils.io.SelectorUtils;

public class SpecificFileFilter {
    private static final char FS = System.getProperty("file.separator").charAt(0);
    private Set<String> names;

    public SpecificFileFilter(@Nullable String[] classNames) {
        if (classNames != null && classNames.length > 0) {
            this.names = new HashSet<String>();
            boolean isBackslashFs = '\\' == FS;
            for (String name : classNames) {
                this.names.add(isBackslashFs ? name.replace('/', FS) : name);
            }
            Collections.addAll(this.names, classNames);
        }
    }

    public boolean accept(@Nullable String className) {
        if (this.names != null && !this.names.isEmpty()) {
            for (String pattern : this.names) {
                if (!SelectorUtils.matchPath(pattern, className, true)) continue;
                return true;
            }
            return false;
        }
        return true;
    }
}

