/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.scriptinterpreter;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.shared.scriptinterpreter.BeanShellScriptInterpreter;
import org.apache.maven.shared.scriptinterpreter.ExecutionLogger;
import org.apache.maven.shared.scriptinterpreter.GroovyScriptInterpreter;
import org.apache.maven.shared.scriptinterpreter.RunErrorException;
import org.apache.maven.shared.scriptinterpreter.RunFailureException;
import org.apache.maven.shared.scriptinterpreter.ScriptEvaluationException;
import org.apache.maven.shared.scriptinterpreter.ScriptInterpreter;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScriptRunner {
    private Log log;
    private Map<String, ScriptInterpreter> scriptInterpreters;
    private Map<String, Object> globalVariables;
    private List<String> classPath;
    private String encoding;

    public ScriptRunner(Log log) {
        if (log == null) {
            throw new IllegalArgumentException("missing logger");
        }
        this.log = log;
        this.scriptInterpreters = new LinkedHashMap<String, ScriptInterpreter>();
        this.scriptInterpreters.put("bsh", new BeanShellScriptInterpreter());
        this.scriptInterpreters.put("groovy", new GroovyScriptInterpreter());
        this.globalVariables = new HashMap<String, Object>();
        this.classPath = new ArrayList<String>();
    }

    public void addScriptInterpreter(String id, ScriptInterpreter scriptInterpreter) {
        this.scriptInterpreters.put(id, scriptInterpreter);
    }

    private Log getLog() {
        return this.log;
    }

    public void setGlobalVariable(String name, Object value) {
        this.globalVariables.put(name, value);
    }

    public void setClassPath(List<String> classPath) {
        this.classPath = classPath != null ? new ArrayList<String>(classPath) : new ArrayList();
    }

    public void setScriptEncoding(String encoding) {
        this.encoding = StringUtils.isNotEmpty((String)encoding) ? encoding : null;
    }

    public void run(String scriptDescription, File basedir, String relativeScriptPath, Map<String, ? extends Object> context, ExecutionLogger logger, String stage, boolean failOnException) throws IOException, RunFailureException {
        if (relativeScriptPath == null) {
            this.getLog().debug((CharSequence)"relativeScriptPath is null: not executing script");
            return;
        }
        File scriptFile = this.resolveScript(new File(basedir, relativeScriptPath));
        if (!scriptFile.exists()) {
            this.getLog().debug((CharSequence)("no script found in directory:" + basedir.getAbsolutePath()));
            return;
        }
        this.run(scriptDescription, scriptFile, context, logger, stage, failOnException);
    }

    public void run(String scriptDescription, File scriptFile, Map<String, ? extends Object> context, ExecutionLogger logger, String stage, boolean failOnException) throws IOException, RunFailureException {
        Object result;
        String script;
        if (!scriptFile.exists()) {
            this.getLog().debug((CharSequence)("scriptFile not found in directory:" + scriptFile.getAbsolutePath()));
            return;
        }
        this.getLog().info((CharSequence)("run script " + scriptFile.getAbsolutePath()));
        HashMap<String, Object> globalVariables = new HashMap<String, Object>(this.globalVariables);
        globalVariables.put("basedir", scriptFile.getParentFile());
        globalVariables.put("context", context);
        PrintStream out = logger != null ? logger.getPrintStream() : null;
        ScriptInterpreter interpreter = this.getInterpreter(scriptFile);
        if (this.getLog().isDebugEnabled()) {
            String name = interpreter.getClass().getName();
            name = name.substring(name.lastIndexOf(46) + 1);
            this.getLog().debug((CharSequence)("Running script with " + name + ": " + scriptFile));
        }
        try {
            script = FileUtils.fileRead((File)scriptFile, (String)this.encoding);
        }
        catch (IOException e) {
            String errorMessage = "error reading " + scriptDescription + " " + scriptFile.getPath() + ", " + e.getMessage();
            IOException ioException = new IOException(errorMessage);
            ioException.initCause(e);
            throw ioException;
        }
        try {
            if (logger != null) {
                logger.consumeLine("Running " + scriptDescription + ": " + scriptFile);
            }
            result = interpreter.evaluateScript(script, this.classPath, globalVariables, out);
            if (logger != null) {
                logger.consumeLine("Finished " + scriptDescription + ": " + scriptFile);
            }
        }
        catch (ScriptEvaluationException e) {
            String msg;
            Throwable t = e.getCause() != null ? e.getCause() : e;
            String string = msg = t.getMessage() != null ? t.getMessage() : t.toString();
            if (this.getLog().isDebugEnabled()) {
                String errorMessage = "Error evaluating " + scriptDescription + " " + scriptFile.getPath() + ", " + t;
                this.getLog().debug((CharSequence)errorMessage, t);
            }
            if (logger != null) {
                t.printStackTrace(logger.getPrintStream());
            }
            if (failOnException) {
                throw new RunFailureException("The " + scriptDescription + " did not succeed. " + msg, stage);
            }
            throw new RunErrorException("The " + scriptDescription + " did not succeed. " + msg, stage, t);
        }
        if (result != null && !Boolean.TRUE.equals(result) && !"true".equals(result)) {
            throw new RunFailureException("The " + scriptDescription + " returned " + result + ".", stage);
        }
    }

    private File resolveScript(File scriptFile) {
        if (scriptFile != null && !scriptFile.exists()) {
            for (String ext : this.scriptInterpreters.keySet()) {
                File candidateFile = new File(scriptFile.getPath() + '.' + ext);
                if (!candidateFile.exists()) continue;
                scriptFile = candidateFile;
                break;
            }
        }
        return scriptFile;
    }

    private ScriptInterpreter getInterpreter(File scriptFile) {
        String ext = FileUtils.extension((String)scriptFile.getName()).toLowerCase(Locale.ENGLISH);
        ScriptInterpreter interpreter = this.scriptInterpreters.get(ext);
        if (interpreter == null) {
            interpreter = this.scriptInterpreters.get("bsh");
        }
        return interpreter;
    }
}

