/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.release.transform.jdom2;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.apache.maven.model.Build;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;
import org.apache.maven.model.Profile;
import org.apache.maven.model.Reporting;
import org.apache.maven.model.Scm;
import org.apache.maven.shared.release.transform.jdom2.JDomModelBase;
import org.apache.maven.shared.release.transform.jdom2.JDomParent;
import org.apache.maven.shared.release.transform.jdom2.JDomProfile;
import org.apache.maven.shared.release.transform.jdom2.JDomProperties;
import org.apache.maven.shared.release.transform.jdom2.JDomReporting;
import org.apache.maven.shared.release.transform.jdom2.JDomScm;
import org.apache.maven.shared.release.transform.jdom2.JDomUtils;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Text;

public class JDomModel
extends Model {
    private final Element project;
    private final JDomModelBase modelBase;

    public JDomModel(Document document) {
        this(document.getRootElement());
    }

    public JDomModel(Element project) {
        this.project = project;
        this.modelBase = new JDomModelBase(project);
    }

    public Build getBuild() {
        return this.modelBase.getBuild();
    }

    public List<Dependency> getDependencies() {
        return this.modelBase.getDependencies();
    }

    public DependencyManagement getDependencyManagement() {
        return this.modelBase.getDependencyManagement();
    }

    public Parent getParent() {
        Element elm = this.getParentElement();
        if (elm == null) {
            return null;
        }
        return new JDomParent(elm);
    }

    private Element getParentElement() {
        return this.project.getChild("parent", this.project.getNamespace());
    }

    public List<Profile> getProfiles() {
        Element profilesElm = this.project.getChild("profiles", this.project.getNamespace());
        if (profilesElm == null) {
            return Collections.emptyList();
        }
        List profileElms = profilesElm.getChildren("profile", this.project.getNamespace());
        ArrayList<Profile> profiles = new ArrayList<Profile>(profileElms.size());
        for (Element profileElm : profileElms) {
            profiles.add(new JDomProfile(profileElm));
        }
        return profiles;
    }

    public Properties getProperties() {
        Element properties = this.project.getChild("properties", this.project.getNamespace());
        if (properties == null) {
            return null;
        }
        return new JDomProperties(properties);
    }

    public Reporting getReporting() {
        Element reporting = this.project.getChild("reporting", this.project.getNamespace());
        if (reporting == null) {
            return null;
        }
        return new JDomReporting(reporting);
    }

    public void setScm(Scm scm) {
        if (scm == null) {
            JDomUtils.rewriteElement("scm", null, this.project, this.project.getNamespace());
        } else {
            Element scmRoot = new Element("scm");
            scmRoot.addContent("\n  ");
            JDomScm jdomScm = new JDomScm(scmRoot);
            jdomScm.setConnection(scm.getConnection());
            jdomScm.setDeveloperConnection(scm.getDeveloperConnection());
            jdomScm.setTag(scm.getTag());
            jdomScm.setUrl(scm.getUrl());
            this.project.addContent("\n  ").addContent((Content)scmRoot).addContent("\n");
        }
    }

    public Scm getScm() {
        Element elm = this.project.getChild("scm", this.project.getNamespace());
        if (elm == null) {
            return null;
        }
        return new JDomScm(elm);
    }

    public void setVersion(String version) {
        Element versionElement = this.project.getChild("version", this.project.getNamespace());
        Element parent = this.getParentElement();
        String parentVersion = parent != null ? parent.getChildTextTrim("version", this.project.getNamespace()) : null;
        if (versionElement == null) {
            if (!version.equals(parentVersion)) {
                Element artifactIdElement = this.project.getChild("artifactId", this.project.getNamespace());
                int index = this.project.indexOf((Content)artifactIdElement);
                versionElement = new Element("version", this.project.getNamespace());
                versionElement.setText(version);
                this.project.addContent(index + 1, (Content)new Text("\n  "));
                this.project.addContent(index + 2, (Content)versionElement);
            }
        } else {
            JDomUtils.rewriteValue(versionElement, version);
        }
    }
}

