/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.war;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

public class HelpMojo
extends AbstractMojo {
    private boolean detail;
    private String goal;
    private int lineLength;
    private int indentSize;

    public void execute() throws MojoExecutionException {
        StringBuffer sb = new StringBuffer();
        this.append(sb, "org.apache.maven.plugins:maven-war-plugin:2.1-alpha-2", 0);
        this.append(sb, "", 0);
        this.append(sb, "Maven War Plugin 2.1-alpha-2", 0);
        this.append(sb, "Maven Plugins", 1);
        this.append(sb, "", 0);
        if (this.goal == null || this.goal.length() <= 0) {
            this.append(sb, "This plugin has 5 goals:", 0);
            this.append(sb, "", 0);
        }
        if (this.goal == null || this.goal.length() <= 0 || "exploded".equals(this.goal)) {
            this.append(sb, "war:exploded", 0);
            this.append(sb, "Generate the exploded webapp", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "archive", 2);
                this.append(sb, "The archive configuration to use. See Maven Archiver Reference.", 3);
                this.append(sb, "", 0);
                this.append(sb, "archiveClasses (Default: false)", 2);
                this.append(sb, "Whether a JAR file will be created for the classes in the webapp. Using this optional configuration parameter will make the generated classes to be archived into a jar file and the classes directory will then be excluded from the webapp.", 3);
                this.append(sb, "", 0);
                this.append(sb, "cacheFile", 2);
                this.append(sb, "The file containing the webapp structure cache.", 3);
                this.append(sb, "", 0);
                this.append(sb, "containerConfigXML", 2);
                this.append(sb, "The path to the context.xml file to use.", 3);
                this.append(sb, "", 0);
                this.append(sb, "dependentWarExcludes", 2);
                this.append(sb, "The comma separated list of tokens to exclude when doing a war overlay.", 3);
                this.append(sb, "", 0);
                this.append(sb, "dependentWarIncludes", 2);
                this.append(sb, "The comma separated list of tokens to include when doing a war overlay. Default is '**'", 3);
                this.append(sb, "", 0);
                this.append(sb, "escapedBackslashesInFilePath (Default: false)", 2);
                this.append(sb, "To escape interpolated value with windows path c:\\foo\\bar will be replace with c\\:\\\\foo\\\\bar", 3);
                this.append(sb, "", 0);
                this.append(sb, "filteringDeploymentDescriptors (Default: false)", 2);
                this.append(sb, "To filtering deployment descriptors disabled by default", 3);
                this.append(sb, "", 0);
                this.append(sb, "filters", 2);
                this.append(sb, "Filters (property files) to include during the interpolation of the pom.xml.", 3);
                this.append(sb, "", 0);
                this.append(sb, "nonFilteredFileExtensions", 2);
                this.append(sb, "A list of file extensions to not filtering. will be used for webResources and overlay filtering", 3);
                this.append(sb, "", 0);
                this.append(sb, "outputFileNameMapping", 2);
                this.append(sb, "The file name mapping to use to copy libraries and tlds. If no file mapping is set (default) the file is copied with its standard name.", 3);
                this.append(sb, "", 0);
                this.append(sb, "overlays", 2);
                this.append(sb, "The overlays to apply.", 3);
                this.append(sb, "", 0);
                this.append(sb, "useCache (Default: true)", 2);
                this.append(sb, "Whether the cache should be used to save the status of the webapp accross multiple runs.", 3);
                this.append(sb, "", 0);
                this.append(sb, "warSourceDirectory", 2);
                this.append(sb, "Single directory for extra files to include in the WAR.", 3);
                this.append(sb, "", 0);
                this.append(sb, "warSourceExcludes", 2);
                this.append(sb, "The comma separated list of tokens to exclude when copying content of the warSourceDirectory.", 3);
                this.append(sb, "", 0);
                this.append(sb, "warSourceIncludes", 2);
                this.append(sb, "The comma separated list of tokens to include when copying content of the warSourceDirectory. Default is '**'.", 3);
                this.append(sb, "", 0);
                this.append(sb, "webResources", 2);
                this.append(sb, "The list of webResources we want to transfer.", 3);
                this.append(sb, "", 0);
                this.append(sb, "webXml", 2);
                this.append(sb, "The path to the web.xml file to use.", 3);
                this.append(sb, "", 0);
                this.append(sb, "webappDirectory", 2);
                this.append(sb, "The directory where the webapp is built.", 3);
                this.append(sb, "", 0);
                this.append(sb, "workDirectory", 2);
                this.append(sb, "Directory to unpack dependent WARs into if needed", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "help".equals(this.goal)) {
            this.append(sb, "war:help", 0);
            this.append(sb, "Display help information on maven-war-plugin. Call\n\u00a0\u00a0mvn\u00a0war:help\u00a0-Ddetail=true\u00a0-Dgoal=<goal-name>\nto display parameter details.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "detail (Default: false)", 2);
                this.append(sb, "If true, display all settable properties for each goal.", 3);
                this.append(sb, "", 0);
                this.append(sb, "goal", 2);
                this.append(sb, "The name of the goal for which to show help. If unspecified, all goals will be displayed.", 3);
                this.append(sb, "", 0);
                this.append(sb, "lineLength (Default: 80)", 2);
                this.append(sb, "The maximum length of a display line.", 3);
                this.append(sb, "", 0);
                this.append(sb, "indentSize (Default: 2)", 2);
                this.append(sb, "The number of spaces per indentation level.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "inplace".equals(this.goal)) {
            this.append(sb, "war:inplace", 0);
            this.append(sb, "Generates webapp in the source directory", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "archive", 2);
                this.append(sb, "The archive configuration to use. See Maven Archiver Reference.", 3);
                this.append(sb, "", 0);
                this.append(sb, "archiveClasses (Default: false)", 2);
                this.append(sb, "Whether a JAR file will be created for the classes in the webapp. Using this optional configuration parameter will make the generated classes to be archived into a jar file and the classes directory will then be excluded from the webapp.", 3);
                this.append(sb, "", 0);
                this.append(sb, "cacheFile", 2);
                this.append(sb, "The file containing the webapp structure cache.", 3);
                this.append(sb, "", 0);
                this.append(sb, "containerConfigXML", 2);
                this.append(sb, "The path to the context.xml file to use.", 3);
                this.append(sb, "", 0);
                this.append(sb, "dependentWarExcludes", 2);
                this.append(sb, "The comma separated list of tokens to exclude when doing a war overlay.", 3);
                this.append(sb, "", 0);
                this.append(sb, "dependentWarIncludes", 2);
                this.append(sb, "The comma separated list of tokens to include when doing a war overlay. Default is '**'", 3);
                this.append(sb, "", 0);
                this.append(sb, "escapedBackslashesInFilePath (Default: false)", 2);
                this.append(sb, "To escape interpolated value with windows path c:\\foo\\bar will be replace with c\\:\\\\foo\\\\bar", 3);
                this.append(sb, "", 0);
                this.append(sb, "filteringDeploymentDescriptors (Default: false)", 2);
                this.append(sb, "To filtering deployment descriptors disabled by default", 3);
                this.append(sb, "", 0);
                this.append(sb, "filters", 2);
                this.append(sb, "Filters (property files) to include during the interpolation of the pom.xml.", 3);
                this.append(sb, "", 0);
                this.append(sb, "nonFilteredFileExtensions", 2);
                this.append(sb, "A list of file extensions to not filtering. will be used for webResources and overlay filtering", 3);
                this.append(sb, "", 0);
                this.append(sb, "outputFileNameMapping", 2);
                this.append(sb, "The file name mapping to use to copy libraries and tlds. If no file mapping is set (default) the file is copied with its standard name.", 3);
                this.append(sb, "", 0);
                this.append(sb, "overlays", 2);
                this.append(sb, "The overlays to apply.", 3);
                this.append(sb, "", 0);
                this.append(sb, "useCache (Default: true)", 2);
                this.append(sb, "Whether the cache should be used to save the status of the webapp accross multiple runs.", 3);
                this.append(sb, "", 0);
                this.append(sb, "warSourceDirectory", 2);
                this.append(sb, "Single directory for extra files to include in the WAR.", 3);
                this.append(sb, "", 0);
                this.append(sb, "warSourceExcludes", 2);
                this.append(sb, "The comma separated list of tokens to exclude when copying content of the warSourceDirectory.", 3);
                this.append(sb, "", 0);
                this.append(sb, "warSourceIncludes", 2);
                this.append(sb, "The comma separated list of tokens to include when copying content of the warSourceDirectory. Default is '**'.", 3);
                this.append(sb, "", 0);
                this.append(sb, "webResources", 2);
                this.append(sb, "The list of webResources we want to transfer.", 3);
                this.append(sb, "", 0);
                this.append(sb, "webXml", 2);
                this.append(sb, "The path to the web.xml file to use.", 3);
                this.append(sb, "", 0);
                this.append(sb, "webappDirectory", 2);
                this.append(sb, "The directory where the webapp is built.", 3);
                this.append(sb, "", 0);
                this.append(sb, "workDirectory", 2);
                this.append(sb, "Directory to unpack dependent WARs into if needed", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "manifest".equals(this.goal)) {
            this.append(sb, "war:manifest", 0);
            this.append(sb, "Generate a manifest for this WAR.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "archive", 2);
                this.append(sb, "The archive configuration to use. See Maven Archiver Reference.", 3);
                this.append(sb, "", 0);
                this.append(sb, "archiveClasses (Default: false)", 2);
                this.append(sb, "Whether a JAR file will be created for the classes in the webapp. Using this optional configuration parameter will make the generated classes to be archived into a jar file and the classes directory will then be excluded from the webapp.", 3);
                this.append(sb, "", 0);
                this.append(sb, "cacheFile", 2);
                this.append(sb, "The file containing the webapp structure cache.", 3);
                this.append(sb, "", 0);
                this.append(sb, "containerConfigXML", 2);
                this.append(sb, "The path to the context.xml file to use.", 3);
                this.append(sb, "", 0);
                this.append(sb, "dependentWarExcludes", 2);
                this.append(sb, "The comma separated list of tokens to exclude when doing a war overlay.", 3);
                this.append(sb, "", 0);
                this.append(sb, "dependentWarIncludes", 2);
                this.append(sb, "The comma separated list of tokens to include when doing a war overlay. Default is '**'", 3);
                this.append(sb, "", 0);
                this.append(sb, "escapedBackslashesInFilePath (Default: false)", 2);
                this.append(sb, "To escape interpolated value with windows path c:\\foo\\bar will be replace with c\\:\\\\foo\\\\bar", 3);
                this.append(sb, "", 0);
                this.append(sb, "filteringDeploymentDescriptors (Default: false)", 2);
                this.append(sb, "To filtering deployment descriptors disabled by default", 3);
                this.append(sb, "", 0);
                this.append(sb, "filters", 2);
                this.append(sb, "Filters (property files) to include during the interpolation of the pom.xml.", 3);
                this.append(sb, "", 0);
                this.append(sb, "nonFilteredFileExtensions", 2);
                this.append(sb, "A list of file extensions to not filtering. will be used for webResources and overlay filtering", 3);
                this.append(sb, "", 0);
                this.append(sb, "outputFileNameMapping", 2);
                this.append(sb, "The file name mapping to use to copy libraries and tlds. If no file mapping is set (default) the file is copied with its standard name.", 3);
                this.append(sb, "", 0);
                this.append(sb, "overlays", 2);
                this.append(sb, "The overlays to apply.", 3);
                this.append(sb, "", 0);
                this.append(sb, "useCache (Default: true)", 2);
                this.append(sb, "Whether the cache should be used to save the status of the webapp accross multiple runs.", 3);
                this.append(sb, "", 0);
                this.append(sb, "warSourceDirectory", 2);
                this.append(sb, "Single directory for extra files to include in the WAR.", 3);
                this.append(sb, "", 0);
                this.append(sb, "warSourceExcludes", 2);
                this.append(sb, "The comma separated list of tokens to exclude when copying content of the warSourceDirectory.", 3);
                this.append(sb, "", 0);
                this.append(sb, "warSourceIncludes", 2);
                this.append(sb, "The comma separated list of tokens to include when copying content of the warSourceDirectory. Default is '**'.", 3);
                this.append(sb, "", 0);
                this.append(sb, "webResources", 2);
                this.append(sb, "The list of webResources we want to transfer.", 3);
                this.append(sb, "", 0);
                this.append(sb, "webXml", 2);
                this.append(sb, "The path to the web.xml file to use.", 3);
                this.append(sb, "", 0);
                this.append(sb, "webappDirectory", 2);
                this.append(sb, "The directory where the webapp is built.", 3);
                this.append(sb, "", 0);
                this.append(sb, "workDirectory", 2);
                this.append(sb, "Directory to unpack dependent WARs into if needed", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "war".equals(this.goal)) {
            this.append(sb, "war:war", 0);
            this.append(sb, "Build a war/webapp.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "archive", 2);
                this.append(sb, "The archive configuration to use. See Maven Archiver Reference.", 3);
                this.append(sb, "", 0);
                this.append(sb, "archiveClasses (Default: false)", 2);
                this.append(sb, "Whether a JAR file will be created for the classes in the webapp. Using this optional configuration parameter will make the generated classes to be archived into a jar file and the classes directory will then be excluded from the webapp.", 3);
                this.append(sb, "", 0);
                this.append(sb, "attachClasses (Default: false)", 2);
                this.append(sb, "Whether classes (that is the content of the WEB-INF/classes directory) should be attached to the project.", 3);
                this.append(sb, "", 0);
                this.append(sb, "cacheFile", 2);
                this.append(sb, "The file containing the webapp structure cache.", 3);
                this.append(sb, "", 0);
                this.append(sb, "classesClassifier (Default: classes)", 2);
                this.append(sb, "The classifier to use for the attached classes artifact.", 3);
                this.append(sb, "", 0);
                this.append(sb, "classifier", 2);
                this.append(sb, "Classifier to add to the artifact generated. If given, the artifact will be an attachment instead.", 3);
                this.append(sb, "", 0);
                this.append(sb, "containerConfigXML", 2);
                this.append(sb, "The path to the context.xml file to use.", 3);
                this.append(sb, "", 0);
                this.append(sb, "dependentWarExcludes", 2);
                this.append(sb, "The comma separated list of tokens to exclude when doing a war overlay.", 3);
                this.append(sb, "", 0);
                this.append(sb, "dependentWarIncludes", 2);
                this.append(sb, "The comma separated list of tokens to include when doing a war overlay. Default is '**'", 3);
                this.append(sb, "", 0);
                this.append(sb, "escapedBackslashesInFilePath (Default: false)", 2);
                this.append(sb, "To escape interpolated value with windows path c:\\foo\\bar will be replace with c\\:\\\\foo\\\\bar", 3);
                this.append(sb, "", 0);
                this.append(sb, "failOnMissingWebXml (Default: true)", 2);
                this.append(sb, "Whether or not to fail the build is the web.xml file is missing. Set to false if you want you war built without a web.xml file.", 3);
                this.append(sb, "", 0);
                this.append(sb, "filteringDeploymentDescriptors (Default: false)", 2);
                this.append(sb, "To filtering deployment descriptors disabled by default", 3);
                this.append(sb, "", 0);
                this.append(sb, "filters", 2);
                this.append(sb, "Filters (property files) to include during the interpolation of the pom.xml.", 3);
                this.append(sb, "", 0);
                this.append(sb, "nonFilteredFileExtensions", 2);
                this.append(sb, "A list of file extensions to not filtering. will be used for webResources and overlay filtering", 3);
                this.append(sb, "", 0);
                this.append(sb, "outputDirectory", 2);
                this.append(sb, "The directory for the generated WAR.", 3);
                this.append(sb, "", 0);
                this.append(sb, "outputFileNameMapping", 2);
                this.append(sb, "The file name mapping to use to copy libraries and tlds. If no file mapping is set (default) the file is copied with its standard name.", 3);
                this.append(sb, "", 0);
                this.append(sb, "overlays", 2);
                this.append(sb, "The overlays to apply.", 3);
                this.append(sb, "", 0);
                this.append(sb, "packagingExcludes", 2);
                this.append(sb, "The comma separated list of tokens to exclude from the WAR before packaging. This option may be used to implement the skinny war use case.", 3);
                this.append(sb, "", 0);
                this.append(sb, "primaryArtifact (Default: true)", 2);
                this.append(sb, "Whether this is the main artifact being built. Set to false if you don't want to install or deploy it to the local repository instead of the default one in an execution.", 3);
                this.append(sb, "", 0);
                this.append(sb, "useCache (Default: true)", 2);
                this.append(sb, "Whether the cache should be used to save the status of the webapp accross multiple runs.", 3);
                this.append(sb, "", 0);
                this.append(sb, "warName", 2);
                this.append(sb, "The name of the generated WAR.", 3);
                this.append(sb, "", 0);
                this.append(sb, "warSourceDirectory", 2);
                this.append(sb, "Single directory for extra files to include in the WAR.", 3);
                this.append(sb, "", 0);
                this.append(sb, "warSourceExcludes", 2);
                this.append(sb, "The comma separated list of tokens to exclude when copying content of the warSourceDirectory.", 3);
                this.append(sb, "", 0);
                this.append(sb, "warSourceIncludes", 2);
                this.append(sb, "The comma separated list of tokens to include when copying content of the warSourceDirectory. Default is '**'.", 3);
                this.append(sb, "", 0);
                this.append(sb, "webResources", 2);
                this.append(sb, "The list of webResources we want to transfer.", 3);
                this.append(sb, "", 0);
                this.append(sb, "webXml", 2);
                this.append(sb, "The path to the web.xml file to use.", 3);
                this.append(sb, "", 0);
                this.append(sb, "webappDirectory", 2);
                this.append(sb, "The directory where the webapp is built.", 3);
                this.append(sb, "", 0);
                this.append(sb, "workDirectory", 2);
                this.append(sb, "Directory to unpack dependent WARs into if needed", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((CharSequence)sb.toString());
        }
    }

    private static String repeat(String str, int repeat) {
        StringBuffer buffer = new StringBuffer(repeat * str.length());
        for (int i = 0; i < repeat; ++i) {
            buffer.append(str);
        }
        return buffer.toString();
    }

    private void append(StringBuffer sb, String description, int indent) {
        Iterator it = this.toLines(description, indent).iterator();
        while (it.hasNext()) {
            sb.append(it.next().toString()).append('\n');
        }
    }

    private List toLines(String text, int indent) {
        ArrayList lines = new ArrayList();
        String ind = HelpMojo.repeat("\t", indent);
        String[] plainLines = text.split("(\r\n)|(\r)|(\n)");
        for (int i = 0; i < plainLines.length; ++i) {
            this.toLines(lines, ind + plainLines[i]);
        }
        return lines;
    }

    private void toLines(List lines, String line) {
        int lineIndent = HelpMojo.getIndentLevel(line);
        StringBuffer buf = new StringBuffer(256);
        String[] tokens = line.split(" +");
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i];
            if (i > 0) {
                if (buf.length() + token.length() >= this.lineLength) {
                    lines.add(buf.toString());
                    buf.setLength(0);
                    buf.append(HelpMojo.repeat(" ", lineIndent * this.indentSize));
                } else {
                    buf.append(' ');
                }
            }
            for (int j = 0; j < token.length(); ++j) {
                char c = token.charAt(j);
                if (c == '\t') {
                    buf.append(HelpMojo.repeat(" ", this.indentSize - buf.length() % this.indentSize));
                    continue;
                }
                if (c == '\u00a0') {
                    buf.append(' ');
                    continue;
                }
                buf.append(c);
            }
        }
        lines.add(buf.toString());
    }

    private static int getIndentLevel(String line) {
        int i;
        int level = 0;
        for (i = 0; i < line.length() && line.charAt(i) == '\t'; ++i) {
            ++level;
        }
        for (i = level + 1; i <= level + 4 && i < line.length(); ++i) {
            if (line.charAt(i) != '\t') continue;
            ++level;
            break;
        }
        return level;
    }
}

