/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.site.render;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import org.apache.maven.doxia.siterenderer.DocumentRenderer;
import org.apache.maven.doxia.siterenderer.DoxiaDocumentRenderer;
import org.apache.maven.doxia.siterenderer.RendererException;
import org.apache.maven.doxia.siterenderer.SiteRenderingContext;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.plugins.site.render.AbstractSiteRenderingMojo;
import org.apache.maven.plugins.site.render.SiteMap;
import org.apache.maven.project.MavenProject;
import org.apache.maven.reporting.MavenReport;
import org.apache.maven.reporting.MavenReportException;
import org.apache.maven.reporting.exec.MavenReportExecution;

@Mojo(name="site", requiresDependencyResolution=ResolutionScope.TEST, requiresReports=true)
public class SiteMojo
extends AbstractSiteRenderingMojo {
    @Parameter(property="siteOutputDirectory", defaultValue="${project.reporting.outputDirectory}")
    protected File outputDirectory;
    @Parameter(property="generateReports", defaultValue="true")
    private boolean generateReports;
    @Parameter(property="generateSitemap", defaultValue="false")
    private boolean generateSitemap;
    @Parameter(property="validate", defaultValue="false")
    private boolean validate;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.getLog().info((CharSequence)"maven.site.skip = true: Skipping site generation");
            return;
        }
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)"executing Site Mojo");
        }
        this.checkInputEncoding();
        List<Object> reports = this.generateReports ? this.getReports() : Collections.emptyList();
        try {
            List<Locale> localesList = this.getLocales();
            Locale defaultLocale = localesList.get(0);
            Locale.setDefault(defaultLocale);
            for (Locale locale : localesList) {
                this.renderLocale(locale, reports);
            }
        }
        catch (RendererException e) {
            if (e.getCause() instanceof MavenReportException) {
                throw new MojoExecutionException(e.getMessage(), e.getCause());
            }
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error during site generation", (Exception)e);
        }
    }

    private void renderLocale(Locale locale, List<MavenReportExecution> reports) throws IOException, RendererException, MojoFailureException, MojoExecutionException {
        SiteRenderingContext context = this.createSiteRenderingContext(locale);
        context.addSiteDirectory(this.generatedSiteDirectory);
        context.setInputEncoding(this.getInputEncoding());
        context.setOutputEncoding(this.getOutputEncoding());
        context.setValidate(this.validate);
        if (this.validate) {
            this.getLog().info((CharSequence)"Validation is switched on, xml input documents will be validated!");
        }
        File outputDir = this.getOutputDirectory(locale);
        Map<String, DocumentRenderer> documents = this.locateDocuments(context, reports, locale);
        this.siteRenderer.copyResources(context, outputDir);
        List<DocumentRenderer> reportDocuments = this.renderDoxiaDocuments(documents, context, outputDir, false);
        for (MavenReportExecution mavenReportExecution : reports) {
            MavenReport report = mavenReportExecution.getMavenReport();
            report.setReportOutputDirectory(outputDir);
        }
        this.siteRenderer.render(reportDocuments, context, outputDir);
        if (this.generateSitemap) {
            this.getLog().info((CharSequence)"Generating Sitemap.");
            new SiteMap(this.getOutputEncoding(), this.i18n).generate(context.getDecoration(), this.generatedSiteDirectory, locale);
        }
        context.getSiteDirectories().clear();
        context.addSiteDirectory(this.generatedSiteDirectory);
        Map generatedDocuments = this.siteRenderer.locateDocumentFiles(context, false);
        this.renderDoxiaDocuments(generatedDocuments, context, outputDir, true);
        this.siteRenderer.copyResources(context, outputDir);
    }

    private List<DocumentRenderer> renderDoxiaDocuments(Map<String, DocumentRenderer> documents, SiteRenderingContext context, File outputDir, boolean generated) throws RendererException, IOException {
        TreeMap<String, DocumentRenderer> doxiaDocuments = new TreeMap<String, DocumentRenderer>();
        ArrayList<DocumentRenderer> nonDoxiaDocuments = new ArrayList<DocumentRenderer>();
        TreeMap<String, Integer> counts = new TreeMap<String, Integer>();
        for (Map.Entry<String, DocumentRenderer> entry : documents.entrySet()) {
            DocumentRenderer doc = entry.getValue();
            if (doc instanceof DoxiaDocumentRenderer) {
                doxiaDocuments.put(entry.getKey(), doc);
                DoxiaDocumentRenderer doxia = (DoxiaDocumentRenderer)doc;
                String parserId = doxia.getRenderingContext().getParserId();
                Integer count = (Integer)counts.get(parserId);
                if (count == null) {
                    count = 1;
                } else {
                    Integer n = count;
                    Integer n2 = count = Integer.valueOf(count + 1);
                }
                counts.put(parserId, count);
                continue;
            }
            nonDoxiaDocuments.add(doc);
        }
        if (doxiaDocuments.size() > 0) {
            StringBuilder sb = new StringBuilder(15 * counts.size());
            for (Map.Entry entry : counts.entrySet()) {
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                sb.append(entry.getValue());
                sb.append(' ');
                sb.append((String)entry.getKey());
            }
            this.getLog().info((CharSequence)("Rendering " + doxiaDocuments.size() + (generated ? " generated" : "") + " Doxia document" + (doxiaDocuments.size() > 1 ? "s" : "") + ": " + sb.toString()));
            this.siteRenderer.render(doxiaDocuments.values(), context, outputDir);
        }
        return nonDoxiaDocuments;
    }

    private File getOutputDirectory(Locale locale) {
        File file = locale.getLanguage().equals(Locale.getDefault().getLanguage()) ? this.outputDirectory : new File(this.outputDirectory, locale.getLanguage());
        if (!file.exists()) {
            file.mkdirs();
        }
        return file;
    }

    public MavenProject getProject() {
        return this.project;
    }

    public MavenSession getSession() {
        return this.mavenSession;
    }
}

