/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.shade;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.shade.ShadeRequest;
import org.apache.maven.plugins.shade.Shader;
import org.apache.maven.plugins.shade.filter.Filter;
import org.apache.maven.plugins.shade.relocation.Relocator;
import org.apache.maven.plugins.shade.resource.ManifestResourceTransformer;
import org.apache.maven.plugins.shade.resource.ResourceTransformer;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.util.IOUtil;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.commons.Remapper;
import org.objectweb.asm.commons.RemappingClassAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(role=Shader.class, hint="default")
public class DefaultShader
extends AbstractLogEnabled
implements Shader {
    @Override
    public void shade(ShadeRequest shadeRequest) throws IOException, MojoExecutionException {
        HashSet<String> resources = new HashSet<String>();
        ResourceTransformer manifestTransformer = null;
        ArrayList<ResourceTransformer> transformers = new ArrayList<ResourceTransformer>(shadeRequest.getResourceTransformers());
        Iterator it = transformers.iterator();
        while (it.hasNext()) {
            ResourceTransformer transformer = (ResourceTransformer)it.next();
            if (!(transformer instanceof ManifestResourceTransformer)) continue;
            manifestTransformer = transformer;
            it.remove();
        }
        RelocatorRemapper remapper = new RelocatorRemapper(shadeRequest.getRelocators());
        shadeRequest.getUberJar().getParentFile().mkdirs();
        JarOutputStream jos = new JarOutputStream(new FileOutputStream(shadeRequest.getUberJar()));
        if (manifestTransformer != null) {
            block1: for (File jar : shadeRequest.getJars()) {
                JarFile jarFile = this.newJarFile(jar);
                Enumeration<JarEntry> en = jarFile.entries();
                while (en.hasMoreElements()) {
                    JarEntry entry = en.nextElement();
                    String resource = entry.getName();
                    if (!manifestTransformer.canTransformResource(resource)) continue;
                    resources.add(resource);
                    manifestTransformer.processResource(resource, jarFile.getInputStream(entry), shadeRequest.getRelocators());
                    continue block1;
                }
            }
            if (manifestTransformer.hasTransformedResource()) {
                manifestTransformer.modifyOutputStream(jos);
            }
        }
        for (File jar : shadeRequest.getJars()) {
            this.getLogger().debug("Processing JAR " + jar);
            List<Filter> jarFilters = this.getFilters(jar, shadeRequest.getFilters());
            JarFile jarFile = this.newJarFile(jar);
            Enumeration<JarEntry> j = jarFile.entries();
            while (j.hasMoreElements()) {
                String dir;
                JarEntry entry = j.nextElement();
                String name = entry.getName();
                if ("META-INF/INDEX.LIST".equals(name) || entry.isDirectory() || this.isFiltered(jarFilters, name)) continue;
                InputStream is = jarFile.getInputStream(entry);
                String mappedName = remapper.map(name);
                int idx = mappedName.lastIndexOf(47);
                if (idx != -1 && !resources.contains(dir = mappedName.substring(0, idx))) {
                    this.addDirectory(resources, jos, dir);
                }
                if (name.endsWith(".class")) {
                    this.addRemappedClass(remapper, jos, jar, name, is);
                } else if (shadeRequest.isShadeSourcesContent() && name.endsWith(".java")) {
                    if (resources.contains(mappedName)) continue;
                    this.addJavaSource(resources, jos, mappedName, is, shadeRequest.getRelocators());
                } else if (!this.resourceTransformed(transformers, mappedName, is, shadeRequest.getRelocators())) {
                    if (resources.contains(mappedName)) continue;
                    this.addResource(resources, jos, mappedName, is);
                }
                IOUtil.close((InputStream)is);
            }
            jarFile.close();
        }
        for (ResourceTransformer transformer : transformers) {
            if (!transformer.hasTransformedResource()) continue;
            transformer.modifyOutputStream(jos);
        }
        IOUtil.close((OutputStream)jos);
        for (Filter filter : shadeRequest.getFilters()) {
            filter.finished();
        }
    }

    private JarFile newJarFile(File jar) throws IOException {
        try {
            return new JarFile(jar);
        }
        catch (ZipException zex) {
            throw new ZipException("error in opening zip file " + jar);
        }
    }

    private List<Filter> getFilters(File jar, List<Filter> filters) {
        ArrayList<Filter> list = new ArrayList<Filter>();
        for (Filter filter : filters) {
            if (!filter.canFilter(jar)) continue;
            list.add(filter);
        }
        return list;
    }

    private void addDirectory(Set<String> resources, JarOutputStream jos, String name) throws IOException {
        String parent;
        if (name.lastIndexOf(47) > 0 && !resources.contains(parent = name.substring(0, name.lastIndexOf(47)))) {
            this.addDirectory(resources, jos, parent);
        }
        JarEntry entry = new JarEntry(name + "/");
        jos.putNextEntry(entry);
        resources.add(name);
    }

    private void addRemappedClass(RelocatorRemapper remapper, JarOutputStream jos, File jar, String name, InputStream is) throws IOException, MojoExecutionException {
        if (!remapper.hasRelocators()) {
            try {
                jos.putNextEntry(new JarEntry(name));
                IOUtil.copy((InputStream)is, (OutputStream)jos);
            }
            catch (ZipException e) {
                this.getLogger().warn("We have a duplicate " + name + " in " + jar);
            }
            return;
        }
        ClassReader cr = new ClassReader(is);
        ClassWriter cw = new ClassWriter(0);
        RemappingClassAdapter cv = new RemappingClassAdapter((ClassVisitor)cw, (Remapper)remapper);
        try {
            cr.accept((ClassVisitor)cv, 8);
        }
        catch (Throwable ise) {
            throw new MojoExecutionException("Error in ASM processing class " + name, ise);
        }
        byte[] renamedClass = cw.toByteArray();
        String mappedName = remapper.map(name.substring(0, name.indexOf(46)));
        try {
            jos.putNextEntry(new JarEntry(mappedName + ".class"));
            IOUtil.copy((byte[])renamedClass, (OutputStream)jos);
        }
        catch (ZipException e) {
            this.getLogger().warn("We have a duplicate " + mappedName + " in " + jar);
        }
    }

    private boolean isFiltered(List<Filter> filters, String name) {
        for (Filter filter : filters) {
            if (!filter.isFiltered(name)) continue;
            return true;
        }
        return false;
    }

    private boolean resourceTransformed(List<ResourceTransformer> resourceTransformers, String name, InputStream is, List<Relocator> relocators) throws IOException {
        boolean resourceTransformed = false;
        for (ResourceTransformer transformer : resourceTransformers) {
            if (!transformer.canTransformResource(name)) continue;
            this.getLogger().debug("Transforming " + name + " using " + transformer.getClass().getName());
            transformer.processResource(name, is, relocators);
            resourceTransformed = true;
            break;
        }
        return resourceTransformed;
    }

    private void addJavaSource(Set<String> resources, JarOutputStream jos, String name, InputStream is, List<Relocator> relocators) throws IOException {
        jos.putNextEntry(new JarEntry(name));
        String sourceContent = IOUtil.toString((Reader)new InputStreamReader(is, "UTF-8"));
        for (Relocator relocator : relocators) {
            sourceContent = relocator.applyToSourceContent(sourceContent);
        }
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)jos, "UTF-8");
        IOUtil.copy((String)sourceContent, (Writer)writer);
        writer.flush();
        resources.add(name);
    }

    private void addResource(Set<String> resources, JarOutputStream jos, String name, InputStream is) throws IOException {
        jos.putNextEntry(new JarEntry(name));
        IOUtil.copy((InputStream)is, (OutputStream)jos);
        resources.add(name);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class RelocatorRemapper
    extends Remapper {
        private final Pattern classPattern = Pattern.compile("(\\[*)?L(.+);");
        List<Relocator> relocators;

        public RelocatorRemapper(List<Relocator> relocators) {
            this.relocators = relocators;
        }

        public boolean hasRelocators() {
            return !this.relocators.isEmpty();
        }

        public Object mapValue(Object object) {
            if (object instanceof String) {
                String name;
                String value = name = (String)object;
                String prefix = "";
                String suffix = "";
                Matcher m = this.classPattern.matcher(name);
                if (m.matches()) {
                    prefix = m.group(1) + "L";
                    suffix = ";";
                    name = m.group(2);
                }
                for (Relocator r : this.relocators) {
                    if (r.canRelocateClass(name)) {
                        value = prefix + r.relocateClass(name) + suffix;
                        break;
                    }
                    if (!r.canRelocatePath(name)) continue;
                    value = prefix + r.relocatePath(name) + suffix;
                    break;
                }
                return value;
            }
            return super.mapValue(object);
        }

        public String map(String name) {
            String value = name;
            String prefix = "";
            String suffix = "";
            Matcher m = this.classPattern.matcher(name);
            if (m.matches()) {
                prefix = m.group(1) + "L";
                suffix = ";";
                name = m.group(2);
            }
            for (Relocator r : this.relocators) {
                if (!r.canRelocatePath(name)) continue;
                value = prefix + r.relocatePath(name) + suffix;
                break;
            }
            return value;
        }
    }
}

