/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.shade.filter;

import java.io.File;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.maven.plugins.shade.filter.Filter;
import org.codehaus.plexus.util.SelectorUtils;

public class SimpleFilter
implements Filter {
    private Set jars;
    private Set includes;
    private Set excludes;

    public SimpleFilter(Set jars, Set includes, Set excludes) {
        this.jars = jars != null ? new HashSet(jars) : new HashSet();
        this.includes = this.normalizePatterns(includes);
        this.excludes = this.normalizePatterns(excludes);
    }

    public boolean canFilter(File jar) {
        return this.jars.contains(jar);
    }

    public boolean isFiltered(String classFile) {
        String path = this.normalizePath(classFile);
        return !this.isIncluded(path) || this.isExcluded(path);
    }

    private boolean isIncluded(String classFile) {
        if (this.includes == null || this.includes.isEmpty()) {
            return true;
        }
        return this.matchPaths(this.includes, classFile);
    }

    private boolean isExcluded(String classFile) {
        if (this.excludes == null || this.excludes.isEmpty()) {
            return false;
        }
        return this.matchPaths(this.excludes, classFile);
    }

    private boolean matchPaths(Set patterns, String classFile) {
        Iterator iterator = patterns.iterator();
        while (iterator.hasNext()) {
            String pattern = (String)iterator.next();
            if (!SelectorUtils.matchPath((String)pattern, (String)classFile)) continue;
            return true;
        }
        return false;
    }

    private String normalizePath(String path) {
        return path != null ? path.replace(File.separatorChar == '/' ? (char)'\\' : '/', File.separatorChar) : null;
    }

    private Set normalizePatterns(Set patterns) {
        HashSet<String> result = new HashSet<String>();
        if (patterns != null) {
            Iterator it = patterns.iterator();
            while (it.hasNext()) {
                String pattern = (String)it.next();
                if ((pattern = this.normalizePath(pattern)).endsWith(File.separator)) {
                    pattern = pattern + "**";
                }
                result.add(pattern);
            }
        }
        return result;
    }
}

