/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.pmd;

import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.plugins.pmd.AbstractPmdReport;
import org.apache.maven.plugins.pmd.PmdFileInfo;
import org.apache.maven.plugins.pmd.model.CpdFile;
import org.apache.maven.plugins.pmd.model.Duplication;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.StringUtils;

public class CpdReportGenerator {
    private Sink sink;
    private Map<File, PmdFileInfo> fileMap;
    private ResourceBundle bundle;
    private boolean aggregate;

    public CpdReportGenerator(Sink sink, Map<File, PmdFileInfo> fileMap, ResourceBundle bundle, boolean aggregate) {
        this.sink = sink;
        this.fileMap = fileMap;
        this.bundle = bundle;
        this.aggregate = aggregate;
    }

    private String getTitle() {
        return this.bundle.getString("report.cpd.title");
    }

    public void beginDocument() {
        this.sink.head();
        this.sink.title();
        this.sink.text(this.getTitle());
        this.sink.title_();
        this.sink.head_();
        this.sink.body();
        this.sink.section1();
        this.sink.sectionTitle1();
        this.sink.text(this.getTitle());
        this.sink.sectionTitle1_();
        this.sink.paragraph();
        this.sink.text(this.bundle.getString("report.cpd.cpdlink") + " ");
        this.sink.link("https://pmd.github.io/latest/pmd_userdocs_cpd.html");
        this.sink.text("CPD");
        this.sink.link_();
        this.sink.text(" " + AbstractPmdReport.getPmdVersion() + ".");
        this.sink.paragraph_();
        this.sink.section1_();
        this.sink.section1();
        this.sink.sectionTitle1();
        this.sink.text(this.bundle.getString("report.cpd.dupes"));
        this.sink.sectionTitle1_();
    }

    private void generateFileLine(CpdFile duplicationMark) {
        String filename = duplicationMark.getPath();
        File file = new File(filename);
        PmdFileInfo fileInfo = this.fileMap.get(file);
        File sourceDirectory = fileInfo.getSourceDirectory();
        filename = StringUtils.substring((String)filename, (int)(sourceDirectory.getAbsolutePath().length() + 1));
        String xrefLocation = fileInfo.getXrefLocation();
        MavenProject projectFile = fileInfo.getProject();
        int line = duplicationMark.getLine();
        this.sink.tableRow();
        this.sink.tableCell();
        this.sink.text(filename);
        this.sink.tableCell_();
        if (this.aggregate) {
            this.sink.tableCell();
            this.sink.text(projectFile.getName());
            this.sink.tableCell_();
        }
        this.sink.tableCell();
        if (xrefLocation != null) {
            this.sink.link(xrefLocation + "/" + filename.replaceAll("\\.java$", ".html").replace('\\', '/') + "#L" + line);
        }
        this.sink.text(String.valueOf(line));
        if (xrefLocation != null) {
            this.sink.link_();
        }
        this.sink.tableCell_();
        this.sink.tableRow_();
    }

    public void generate(List<Duplication> duplications) {
        this.beginDocument();
        if (duplications.isEmpty()) {
            this.sink.paragraph();
            this.sink.text(this.bundle.getString("report.cpd.noProblems"));
            this.sink.paragraph_();
        }
        for (Duplication duplication : duplications) {
            String code = duplication.getCodefragment();
            this.sink.table();
            this.sink.tableRow();
            this.sink.tableHeaderCell();
            this.sink.text(this.bundle.getString("report.cpd.column.file"));
            this.sink.tableHeaderCell_();
            if (this.aggregate) {
                this.sink.tableHeaderCell();
                this.sink.text(this.bundle.getString("report.cpd.column.project"));
                this.sink.tableHeaderCell_();
            }
            this.sink.tableHeaderCell();
            this.sink.text(this.bundle.getString("report.cpd.column.line"));
            this.sink.tableHeaderCell_();
            this.sink.tableRow_();
            for (CpdFile mark : duplication.getFiles()) {
                this.generateFileLine(mark);
            }
            this.sink.tableRow();
            int colspan = 2;
            if (this.aggregate) {
                ++colspan;
            }
            this.sink.rawText("<td colspan='" + colspan + "'>");
            this.sink.verbatim(null);
            this.sink.text(code);
            this.sink.verbatim_();
            this.sink.rawText("</td>");
            this.sink.tableRow_();
            this.sink.table_();
        }
        this.sink.section1_();
        this.sink.body_();
        this.sink.flush();
        this.sink.close();
    }
}

