/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.pmd;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import net.sourceforge.pmd.cpd.CPD;
import net.sourceforge.pmd.cpd.CSVRenderer;
import net.sourceforge.pmd.cpd.JavaLanguage;
import net.sourceforge.pmd.cpd.Language;
import net.sourceforge.pmd.cpd.Renderer;
import net.sourceforge.pmd.cpd.XMLRenderer;
import org.apache.maven.plugin.pmd.AbstractPmdReport;
import org.apache.maven.plugin.pmd.CpdReportGenerator;
import org.apache.maven.reporting.MavenReportException;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.WriterFactory;

public class CpdReport
extends AbstractPmdReport {
    private int minimumTokens;
    private boolean skip;
    private String sourceEncoding;

    public String getName(Locale locale) {
        return CpdReport.getBundle(locale).getString("report.cpd.name");
    }

    public String getDescription(Locale locale) {
        return CpdReport.getBundle(locale).getString("report.cpd.description");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeReport(Locale locale) throws MavenReportException {
        if (!this.skip && this.canGenerateReport()) {
            ClassLoader origLoader = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
                CPD cpd = new CPD(this.minimumTokens, (Language)new JavaLanguage());
                Map files = null;
                try {
                    files = this.getFilesToProcess();
                    if (StringUtils.isNotEmpty((String)this.sourceEncoding)) {
                        cpd.setEncoding(this.sourceEncoding);
                        WriterFactory.newWriter((OutputStream)new ByteArrayOutputStream(), (String)this.sourceEncoding);
                    } else if (!files.isEmpty()) {
                        this.getLog().warn((CharSequence)("File encoding has not been set, using platform encoding " + WriterFactory.FILE_ENCODING + ", i.e. build is platform dependent!"));
                    }
                    Iterator it = files.keySet().iterator();
                    while (it.hasNext()) {
                        cpd.add((File)it.next());
                    }
                }
                catch (UnsupportedEncodingException e) {
                    throw new MavenReportException("Encoding '" + this.sourceEncoding + "' is not supported.", (Exception)e);
                }
                catch (IOException e) {
                    throw new MavenReportException(e.getMessage(), (Exception)e);
                }
                cpd.go();
                CpdReportGenerator gen = new CpdReportGenerator(this.getSink(), files, CpdReport.getBundle(locale), this.aggregate);
                gen.generate(cpd.getMatches());
                if (!this.isHtml()) {
                    this.writeNonHtml(cpd);
                }
            }
            finally {
                Thread.currentThread().setContextClassLoader(origLoader);
            }
        }
    }

    void writeNonHtml(CPD cpd) throws MavenReportException {
        Renderer r = this.createRenderer();
        String buffer = r.render(cpd.getMatches());
        try {
            this.targetDirectory.mkdirs();
            FileOutputStream tStream = new FileOutputStream(new File(this.targetDirectory, "cpd." + this.format));
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)tStream, "UTF-8");
            ((Writer)writer).write(buffer, 0, buffer.length());
            ((Writer)writer).close();
            File siteDir = new File(this.targetDirectory, "site");
            siteDir.mkdirs();
            writer = new FileWriter(new File(siteDir, "cpd." + this.format));
            ((Writer)writer).write(buffer, 0, buffer.length());
            ((Writer)writer).close();
        }
        catch (IOException ioe) {
            throw new MavenReportException(ioe.getMessage(), (Exception)ioe);
        }
    }

    public String getOutputName() {
        return "cpd";
    }

    private static ResourceBundle getBundle(Locale locale) {
        return ResourceBundle.getBundle("cpd-report", locale, CpdReport.class.getClassLoader());
    }

    public Renderer createRenderer() throws MavenReportException {
        XMLRenderer renderer = null;
        if ("xml".equals(this.format)) {
            renderer = new XMLRenderer("UTF-8");
        } else if ("csv".equals(this.format)) {
            renderer = new CSVRenderer();
        } else if (!"".equals(this.format) && !"none".equals(this.format)) {
            try {
                renderer = (Renderer)Class.forName(this.format).newInstance();
            }
            catch (Exception e) {
                throw new MavenReportException("Can't find the custom format " + this.format + ": " + e.getClass().getName());
            }
        }
        if (renderer == null) {
            throw new MavenReportException("Can't create report with format of " + this.format);
        }
        return renderer;
    }
}

