/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.mavenone;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.installer.ArtifactInstallationException;
import org.apache.maven.artifact.installer.ArtifactInstaller;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.ArtifactRepositoryFactory;
import org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.plexus.util.IOUtil;

public class MavenOneRepositoryInstallMojo
extends AbstractMojo {
    protected String packaging;
    private File pomFile;
    private Artifact artifact;
    protected ArtifactInstaller installer;
    protected ArtifactRepositoryFactory factory;
    protected String mavenOneRepository;
    private ArtifactRepositoryLayout legacyLayout;
    private List attachedArtifacts;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException {
        try {
            File f;
            if (this.mavenOneRepository == null) {
                f = new File(System.getProperty("user.home"), "build.properties");
                if (f.exists()) {
                    Properties p = new Properties();
                    FileInputStream inStream = new FileInputStream(f);
                    try {
                        p.load(inStream);
                    }
                    finally {
                        IOUtil.close((InputStream)inStream);
                    }
                    this.mavenOneRepository = p.getProperty("maven.repo.local");
                }
                if (this.mavenOneRepository == null) {
                    this.mavenOneRepository = System.getProperty("user.home") + "/.maven/repository";
                }
            }
            if (!(f = new File(this.mavenOneRepository)).exists()) {
                f.mkdirs();
            }
            ArtifactRepository localRepository = this.factory.createDeploymentArtifactRepository("mavenOneRepository", f.toURL().toString(), this.legacyLayout, false);
            boolean isPomArtifact = "pom".equals(this.packaging);
            if (isPomArtifact) {
                this.installer.install(this.pomFile, this.artifact, localRepository);
            } else {
                File file = this.artifact.getFile();
                if (file == null) {
                    throw new MojoExecutionException("The packaging for this project did not assign a file to the build artifact");
                }
                this.installer.install(file, this.artifact, localRepository);
            }
            if (this.attachedArtifacts != null && !this.attachedArtifacts.isEmpty()) {
                Iterator i = this.attachedArtifacts.iterator();
                while (i.hasNext()) {
                    Artifact attached = (Artifact)i.next();
                    this.installer.install(attached.getFile(), attached, localRepository);
                }
            }
        }
        catch (ArtifactInstallationException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
        catch (FileNotFoundException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
    }
}

