/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.invoker;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Model;
import org.apache.maven.model.Profile;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.invoker.CompositeMap;
import org.apache.maven.plugin.invoker.FileLogger;
import org.apache.maven.plugin.invoker.InvokerProperties;
import org.apache.maven.plugin.invoker.InvokerSession;
import org.apache.maven.plugin.invoker.PomUtils;
import org.apache.maven.plugin.invoker.SelectorUtils;
import org.apache.maven.plugin.invoker.model.BuildJob;
import org.apache.maven.plugin.invoker.model.io.xpp3.BuildJobXpp3Writer;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Settings;
import org.apache.maven.settings.SettingsUtils;
import org.apache.maven.settings.io.xpp3.SettingsXpp3Reader;
import org.apache.maven.settings.io.xpp3.SettingsXpp3Writer;
import org.apache.maven.shared.invoker.CommandLineConfigurationException;
import org.apache.maven.shared.invoker.DefaultInvocationRequest;
import org.apache.maven.shared.invoker.InvocationOutputHandler;
import org.apache.maven.shared.invoker.InvocationRequest;
import org.apache.maven.shared.invoker.InvocationResult;
import org.apache.maven.shared.invoker.Invoker;
import org.apache.maven.shared.invoker.MavenCommandLineBuilder;
import org.apache.maven.shared.invoker.MavenInvocationException;
import org.apache.maven.shared.scriptinterpreter.ExecutionLogger;
import org.apache.maven.shared.scriptinterpreter.RunErrorException;
import org.apache.maven.shared.scriptinterpreter.RunFailureException;
import org.apache.maven.shared.scriptinterpreter.ScriptRunner;
import org.codehaus.plexus.interpolation.InterpolationException;
import org.codehaus.plexus.interpolation.MapBasedValueSource;
import org.codehaus.plexus.interpolation.RegexBasedInterpolator;
import org.codehaus.plexus.interpolation.ValueSource;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.InterpolationFilterReader;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.WriterFactory;
import org.codehaus.plexus.util.xml.XmlStreamReader;
import org.codehaus.plexus.util.xml.XmlStreamWriter;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractInvokerMojo
extends AbstractMojo {
    @Parameter(property="invoker.skip", defaultValue="false")
    private boolean skipInvocation;
    @Parameter(defaultValue="false")
    protected boolean suppressSummaries;
    @Parameter(property="invoker.streamLogs", defaultValue="false")
    private boolean streamLogs;
    @Parameter(property="invoker.localRepositoryPath", defaultValue="${settings.localRepository}")
    private File localRepositoryPath;
    @Parameter(property="invoker.projectsDirectory", defaultValue="${basedir}/src/it/")
    private File projectsDirectory;
    @Parameter(property="invoker.reportsDirectory", defaultValue="${project.build.directory}/invoker-reports")
    private File reportsDirectory;
    @Parameter(property="invoker.disableReports", defaultValue="false")
    private boolean disableReports;
    @Parameter
    private File cloneProjectsTo;
    @Parameter(defaultValue="false")
    private boolean cloneAllFiles;
    @Parameter(defaultValue="false")
    private boolean cloneClean;
    @Parameter(property="invoker.pom")
    private File pom;
    @Parameter
    private List<String> pomIncludes = Collections.singletonList("*/pom.xml");
    @Parameter
    private List<String> pomExcludes = Collections.emptyList();
    @Parameter
    private List<String> setupIncludes = Collections.singletonList("setup*/pom.xml");
    @Parameter
    private List<String> goals = Collections.singletonList("package");
    @Parameter(property="invoker.goalsFile", defaultValue="goals.txt")
    private String goalsFile;
    @Component
    private Invoker invoker;
    @Parameter(property="invoker.selectorScript", defaultValue="selector")
    private String selectorScript;
    @Parameter(property="invoker.preBuildHookScript", defaultValue="prebuild")
    private String preBuildHookScript;
    @Parameter(property="invoker.postBuildHookScript", defaultValue="postbuild")
    private String postBuildHookScript;
    @Parameter(property="invoker.testPropertiesFile", defaultValue="test.properties")
    private String testPropertiesFile;
    @Parameter
    private Properties testProperties;
    @Parameter
    private Map<String, String> properties;
    @Parameter(property="invoker.showErrors", defaultValue="false")
    private boolean showErrors;
    @Parameter(property="invoker.debug", defaultValue="false")
    private boolean debug;
    @Parameter(property="invoker.noLog", defaultValue="false")
    private boolean noLog;
    @Parameter
    private List<String> profiles;
    @Parameter
    private Properties interpolationsProperties;
    @Parameter
    private Map<String, String> filterProperties;
    @Component
    private MavenProject project;
    @Parameter(property="invoker.test")
    private String invokerTest;
    @Parameter(property="invoker.profilesFile", defaultValue="profiles.txt")
    private String profilesFile;
    @Parameter(property="invoker.settingsFile")
    private File settingsFile;
    @Parameter(property="invoker.mavenOpts")
    private String mavenOpts;
    @Parameter(property="invoker.mavenHome")
    private File mavenHome;
    @Parameter(property="invoker.javaHome")
    private File javaHome;
    @Parameter(property="encoding", defaultValue="${project.build.sourceEncoding}")
    private String encoding;
    @Component
    private Settings settings;
    @Parameter(property="invoker.addTestClassPath", defaultValue="false")
    private boolean addTestClassPath;
    @Parameter(defaultValue="${project.testClasspathElements}", readonly=true)
    private List<String> testClassPath;
    @Parameter(property="invoker.invokerPropertiesFile", defaultValue="invoker.properties")
    private String invokerPropertiesFile;
    @Parameter(property="invoker.showVersion", defaultValue="false")
    private boolean showVersion;
    @Parameter(property="invoker.parallelThreads", defaultValue="1")
    private int parallelThreads;
    @Parameter(property="plugin.artifacts", required=true, readonly=true)
    private List<Artifact> pluginArtifacts;
    @Parameter(property="invoker.mergeUserSettings", defaultValue="false")
    private boolean mergeUserSettings;
    private ScriptRunner scriptRunner;
    private String filteredPomPrefix = "interpolated-";
    private final DecimalFormat secFormat = new DecimalFormat("(0.0 s)", new DecimalFormatSymbols(Locale.ENGLISH));

    public void execute() throws MojoExecutionException, MojoFailureException {
        ArrayList<String> scriptClassPath;
        BuildJob[] buildJobs;
        if (this.skipInvocation) {
            this.getLog().info((CharSequence)"Skipping invocation per configuration. If this is incorrect, ensure the skipInvocation parameter is not set to true.");
            return;
        }
        if (!this.disableReports && !this.reportsDirectory.exists()) {
            this.reportsDirectory.mkdirs();
        }
        if (this.pom != null) {
            try {
                this.projectsDirectory = this.pom.getCanonicalFile().getParentFile();
            }
            catch (IOException e) {
                throw new MojoExecutionException("Failed to discover projectsDirectory from pom File parameter. Reason: " + e.getMessage(), (Exception)e);
            }
            buildJobs = new BuildJob[]{new BuildJob(this.pom.getName(), "normal")};
        } else {
            try {
                buildJobs = this.getBuildJobs();
            }
            catch (IOException e) {
                throw new MojoExecutionException("Error retrieving POM list from includes, excludes, and projects directory. Reason: " + e.getMessage(), (Exception)e);
            }
        }
        if (buildJobs == null || buildJobs.length < 1) {
            this.getLog().info((CharSequence)"No projects were selected for execution.");
            return;
        }
        if (StringUtils.isEmpty((String)this.encoding)) {
            this.getLog().warn((CharSequence)("File encoding has not been set, using platform encoding " + ReaderFactory.FILE_ENCODING + ", i.e. build is platform dependent!"));
        }
        if (this.addTestClassPath) {
            scriptClassPath = new ArrayList<String>(this.testClassPath);
            for (Artifact pluginArtifact : this.pluginArtifacts) {
                scriptClassPath.remove(pluginArtifact.getFile().getAbsolutePath());
            }
        } else {
            scriptClassPath = null;
        }
        this.scriptRunner = new ScriptRunner(this.getLog());
        this.scriptRunner.setScriptEncoding(this.encoding);
        this.scriptRunner.setGlobalVariable("localRepositoryPath", (Object)this.localRepositoryPath);
        this.scriptRunner.setClassPath(scriptClassPath);
        LinkedHashSet<String> collectedProjects = new LinkedHashSet<String>();
        for (int i = 0; i < buildJobs.length; ++i) {
            this.collectProjects(this.projectsDirectory, buildJobs[i].getProject(), collectedProjects, true);
        }
        File projectsDir = this.projectsDirectory;
        if (this.cloneProjectsTo != null) {
            this.cloneProjects(collectedProjects);
            projectsDir = this.cloneProjectsTo;
        } else {
            this.getLog().warn((CharSequence)"Filtering of parent/child POMs is not supported without cloning the projects");
        }
        this.runBuilds(projectsDir, buildJobs);
        this.processResults(new InvokerSession(buildJobs));
    }

    abstract void processResults(InvokerSession var1) throws MojoFailureException;

    private Reader newReader(File file) throws IOException {
        if (StringUtils.isNotEmpty((String)this.encoding)) {
            return ReaderFactory.newReader((File)file, (String)this.encoding);
        }
        return ReaderFactory.newPlatformReader((File)file);
    }

    private void collectProjects(File projectsDir, String projectPath, Collection<String> projectPaths, boolean included) throws MojoExecutionException {
        File pomFile = new File(projectsDir, projectPath = projectPath.replace('\\', '/'));
        if (pomFile.isDirectory()) {
            if (!(pomFile = new File(pomFile, "pom.xml")).exists()) {
                if (included) {
                    projectPaths.add(projectPath);
                }
                return;
            }
            if (!projectPath.endsWith("/")) {
                projectPath = projectPath + '/';
            }
            projectPath = projectPath + "pom.xml";
        } else if (!pomFile.isFile()) {
            return;
        }
        if (!projectPaths.add(projectPath)) {
            return;
        }
        this.getLog().debug((CharSequence)("Collecting parent/child projects of " + projectPath));
        Model model = PomUtils.loadPom(pomFile);
        try {
            String parent;
            String projectsRoot = projectsDir.getCanonicalPath();
            String projectDir = pomFile.getParent();
            String parentPath = "../pom.xml";
            if (model.getParent() != null && StringUtils.isNotEmpty((String)model.getParent().getRelativePath())) {
                parentPath = model.getParent().getRelativePath();
            }
            if ((parent = this.relativizePath(new File(projectDir, parentPath), projectsRoot)) != null) {
                this.collectProjects(projectsDir, parent, projectPaths, false);
            }
            LinkedHashSet modulePaths = new LinkedHashSet();
            modulePaths.addAll(model.getModules());
            for (Profile profile : model.getProfiles()) {
                modulePaths.addAll(profile.getModules());
            }
            for (String modulePath : modulePaths) {
                String module = this.relativizePath(new File(projectDir, modulePath), projectsRoot);
                if (module == null) continue;
                this.collectProjects(projectsDir, module, projectPaths, false);
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to analyze POM: " + pomFile, (Exception)e);
        }
    }

    private void cloneProjects(Collection<String> projectPaths) throws MojoExecutionException {
        if (!this.cloneProjectsTo.mkdirs() && this.cloneClean) {
            try {
                FileUtils.cleanDirectory((File)this.cloneProjectsTo);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Could not clean the cloneProjectsTo directory. Reason: " + e.getMessage(), (Exception)e);
            }
        }
        LinkedHashSet<String> dirs = new LinkedHashSet<String>();
        for (String projectPath : projectPaths) {
            if (!new File(this.projectsDirectory, projectPath).isDirectory()) {
                projectPath = this.getParentPath(projectPath);
            }
            dirs.add(projectPath);
        }
        boolean filter = false;
        try {
            filter = !this.cloneProjectsTo.getCanonicalFile().equals(this.projectsDirectory.getCanonicalFile());
            ArrayList<String> clonedSubpaths = new ArrayList<String>();
            for (String subpath : dirs) {
                if (!".".equals(subpath) && dirs.contains(this.getParentPath(subpath)) || AbstractInvokerMojo.alreadyCloned(subpath, clonedSubpaths)) continue;
                if (".".equals(subpath)) {
                    String cloneSubdir = this.relativizePath(this.cloneProjectsTo, this.projectsDirectory.getCanonicalPath());
                    if (cloneSubdir != null) {
                        File temp = File.createTempFile("pre-invocation-clone.", "");
                        temp.delete();
                        temp.mkdirs();
                        this.copyDirectoryStructure(this.projectsDirectory, temp);
                        FileUtils.deleteDirectory((File)new File(temp, cloneSubdir));
                        this.copyDirectoryStructure(temp, this.cloneProjectsTo);
                    } else {
                        this.copyDirectoryStructure(this.projectsDirectory, this.cloneProjectsTo);
                    }
                } else {
                    File srcDir = new File(this.projectsDirectory, subpath);
                    File dstDir = new File(this.cloneProjectsTo, subpath);
                    this.copyDirectoryStructure(srcDir, dstDir);
                }
                clonedSubpaths.add(subpath);
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to clone projects from: " + this.projectsDirectory + " to: " + this.cloneProjectsTo + ". Reason: " + e.getMessage(), (Exception)e);
        }
        if (filter) {
            for (String projectPath : projectPaths) {
                File pomFile = new File(this.cloneProjectsTo, projectPath);
                if (!pomFile.isFile()) continue;
                this.buildInterpolatedFile(pomFile, pomFile);
            }
            this.filteredPomPrefix = null;
        }
    }

    private String getParentPath(String path) {
        int lastSep = Math.max(path.lastIndexOf(47), path.lastIndexOf(92));
        return lastSep < 0 ? "." : path.substring(0, lastSep);
    }

    private void copyDirectoryStructure(File sourceDir, File destDir) throws IOException {
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(sourceDir);
        if (!this.cloneAllFiles) {
            scanner.addDefaultExcludes();
        }
        scanner.scan();
        destDir.mkdirs();
        String[] includedDirs = scanner.getIncludedDirectories();
        for (int i = 0; i < includedDirs.length; ++i) {
            File clonedDir = new File(destDir, includedDirs[i]);
            clonedDir.mkdirs();
        }
        String[] includedFiles = scanner.getIncludedFiles();
        for (int i = 0; i < includedFiles.length; ++i) {
            File sourceFile = new File(sourceDir, includedFiles[i]);
            File destFile = new File(destDir, includedFiles[i]);
            FileUtils.copyFile((File)sourceFile, (File)destFile);
        }
    }

    static boolean alreadyCloned(String subpath, List<String> clonedSubpaths) {
        for (String path : clonedSubpaths) {
            if (!".".equals(path) && !subpath.equals(path) && !subpath.startsWith(path + File.separator)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void runBuilds(final File projectsDir, BuildJob[] buildJobs) throws MojoExecutionException {
        File mergedSettingsFile;
        if (!this.localRepositoryPath.exists()) {
            this.localRepositoryPath.mkdirs();
        }
        File interpolatedSettingsFile = null;
        if (this.settingsFile != null) {
            interpolatedSettingsFile = this.cloneProjectsTo != null ? new File(this.cloneProjectsTo, "interpolated-" + this.settingsFile.getName()) : new File(this.settingsFile.getParentFile(), "interpolated-" + this.settingsFile.getName());
            this.buildInterpolatedFile(this.settingsFile, interpolatedSettingsFile);
        }
        SettingsXpp3Writer settingsWriter = new SettingsXpp3Writer();
        Settings mergedSettings = this.settings;
        if (this.mergeUserSettings && interpolatedSettingsFile != null) {
            XmlStreamReader reader = null;
            try {
                reader = new XmlStreamReader(interpolatedSettingsFile);
                SettingsXpp3Reader settingsReader = new SettingsXpp3Reader();
                Settings dominantSettings = settingsReader.read((Reader)reader);
                Settings recessiveSettings = this.settings;
                SettingsUtils.merge((Settings)dominantSettings, (Settings)recessiveSettings, (String)"user-level");
                mergedSettings = dominantSettings;
                this.getLog().debug((CharSequence)"Merged specified settings file with settings of invoking process");
            }
            catch (XmlPullParserException e) {
                try {
                    throw new MojoExecutionException("Could not read specified settings file", (Exception)((Object)e));
                    catch (IOException e2) {
                        throw new MojoExecutionException("Could not read specified settings file", (Exception)e2);
                    }
                }
                catch (Throwable throwable) {
                    IOUtil.close(reader);
                    throw throwable;
                }
            }
            IOUtil.close((Reader)reader);
        }
        if (this.settingsFile != null && !this.mergeUserSettings) {
            mergedSettingsFile = interpolatedSettingsFile;
        } else {
            try {
                mergedSettingsFile = File.createTempFile("invoker-settings", ".xml");
                FileWriter fileWriter = null;
                try {
                    fileWriter = new FileWriter(mergedSettingsFile);
                    settingsWriter.write((Writer)fileWriter, mergedSettings);
                }
                catch (Throwable throwable) {
                    IOUtil.close(fileWriter);
                    throw throwable;
                }
                IOUtil.close((Writer)fileWriter);
                if (this.getLog().isDebugEnabled()) {
                    this.getLog().debug((CharSequence)("Created temporary file for invoker settings.xml: " + mergedSettingsFile.getAbsolutePath()));
                }
            }
            catch (IOException e) {
                throw new MojoExecutionException("Could not create temporary file for invoker settings.xml", (Exception)e);
            }
        }
        final File finalSettingsFile = mergedSettingsFile;
        try {
            if (this.isParallelRun()) {
                this.getLog().info((CharSequence)("use parallelThreads " + this.parallelThreads));
                ExecutorService executorService = Executors.newFixedThreadPool(this.parallelThreads);
                for (int i = 0; i < buildJobs.length; ++i) {
                    final BuildJob project = buildJobs[i];
                    executorService.execute(new Runnable(){

                        public void run() {
                            try {
                                AbstractInvokerMojo.this.runBuild(projectsDir, project, finalSettingsFile);
                            }
                            catch (MojoExecutionException e) {
                                throw new RuntimeException(e.getMessage(), e);
                            }
                        }
                    });
                }
                try {
                    executorService.shutdown();
                    executorService.awaitTermination(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
                    return;
                }
                catch (InterruptedException e) {
                    throw new MojoExecutionException(e.getMessage(), (Exception)e);
                }
            }
            int i = 0;
            while (i < buildJobs.length) {
                BuildJob project = buildJobs[i];
                this.runBuild(projectsDir, project, finalSettingsFile);
                ++i;
            }
            return;
        }
        finally {
            if (interpolatedSettingsFile != null && this.cloneProjectsTo == null) {
                interpolatedSettingsFile.delete();
            }
            if (mergedSettingsFile != null && mergedSettingsFile.exists()) {
                mergedSettingsFile.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runBuild(File projectsDir, BuildJob buildJob, File settingsFile) throws MojoExecutionException {
        block27: {
            File basedir;
            File pomFile = new File(projectsDir, buildJob.getProject());
            if (pomFile.isDirectory()) {
                basedir = pomFile;
                if (!(pomFile = new File(basedir, "pom.xml")).exists()) {
                    pomFile = null;
                } else {
                    buildJob.setProject(buildJob.getProject() + File.separator + "pom.xml");
                }
            } else {
                basedir = pomFile.getParentFile();
            }
            this.getLog().info((CharSequence)("Building: " + buildJob.getProject()));
            File interpolatedPomFile = null;
            if (pomFile != null) {
                if (this.filteredPomPrefix != null) {
                    interpolatedPomFile = new File(basedir, this.filteredPomPrefix + pomFile.getName());
                    this.buildInterpolatedFile(pomFile, interpolatedPomFile);
                } else {
                    interpolatedPomFile = pomFile;
                }
            }
            InvokerProperties invokerProperties = this.getInvokerProperties(basedir);
            buildJob.setName(invokerProperties.getJobName());
            buildJob.setDescription(invokerProperties.getJobDescription());
            try {
                if (this.isSelected(invokerProperties)) {
                    boolean executed;
                    long milliseconds = System.currentTimeMillis();
                    try {
                        executed = this.runBuild(basedir, interpolatedPomFile, settingsFile, invokerProperties);
                    }
                    finally {
                        milliseconds = System.currentTimeMillis() - milliseconds;
                        buildJob.setTime((double)milliseconds / 1000.0);
                    }
                    if (executed) {
                        buildJob.setResult("success");
                        if (!this.suppressSummaries) {
                            this.getLog().info((CharSequence)("..SUCCESS " + this.formatTime(buildJob.getTime())));
                        }
                    } else {
                        buildJob.setResult("skipped");
                        if (!this.suppressSummaries) {
                            this.getLog().info((CharSequence)("..SKIPPED " + this.formatTime(buildJob.getTime())));
                        }
                    }
                    break block27;
                }
                buildJob.setResult("skipped");
                if (!this.suppressSummaries) {
                    this.getLog().info((CharSequence)"..SKIPPED ");
                }
            }
            catch (RunErrorException e) {
                buildJob.setResult("error");
                buildJob.setFailureMessage(e.getMessage());
                if (!this.suppressSummaries) {
                    this.getLog().info((CharSequence)("..ERROR " + this.formatTime(buildJob.getTime())));
                    this.getLog().info((CharSequence)("  " + e.getMessage()));
                }
            }
            catch (RunFailureException e) {
                buildJob.setResult(e.getType());
                buildJob.setFailureMessage(e.getMessage());
                if (!this.suppressSummaries) {
                    this.getLog().info((CharSequence)("..FAILED " + this.formatTime(buildJob.getTime())));
                    this.getLog().info((CharSequence)("  " + e.getMessage()));
                }
            }
            finally {
                if (interpolatedPomFile != null && StringUtils.isNotEmpty((String)this.filteredPomPrefix)) {
                    interpolatedPomFile.delete();
                }
                this.writeBuildReport(buildJob);
            }
        }
    }

    private boolean isSelected(InvokerProperties invokerProperties) {
        if (!SelectorUtils.isMavenVersion(invokerProperties.getMavenVersion())) {
            return false;
        }
        if (!SelectorUtils.isJreVersion(invokerProperties.getJreVersion())) {
            return false;
        }
        return SelectorUtils.isOsFamily(invokerProperties.getOsFamily());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeBuildReport(BuildJob buildJob) throws MojoExecutionException {
        if (this.disableReports) {
            return;
        }
        String safeFileName = buildJob.getProject().replace('/', '_').replace('\\', '_').replace(' ', '_');
        if (safeFileName.endsWith("_pom.xml")) {
            safeFileName = safeFileName.substring(0, safeFileName.length() - "_pom.xml".length());
        }
        File reportFile = new File(this.reportsDirectory, "BUILD-" + safeFileName + ".xml");
        try {
            FileOutputStream fos = new FileOutputStream(reportFile);
            try {
                OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, buildJob.getModelEncoding());
                BuildJobXpp3Writer writer = new BuildJobXpp3Writer();
                writer.write(osw, buildJob);
                ((Writer)osw).close();
            }
            finally {
                fos.close();
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to write build report " + reportFile, (Exception)e);
        }
    }

    private String formatTime(double seconds) {
        return this.secFormat.format(seconds);
    }

    private boolean runBuild(File basedir, File pomFile, File settingsFile, InvokerProperties invokerProperties) throws MojoExecutionException, RunFailureException {
        if (this.getLog().isDebugEnabled() && !invokerProperties.getProperties().isEmpty()) {
            Properties props = invokerProperties.getProperties();
            this.getLog().debug((CharSequence)"Using invoker properties:");
            for (String string : new TreeSet<Object>(props.keySet())) {
                String value = props.getProperty(string);
                this.getLog().debug((CharSequence)("  " + string + " = " + value));
            }
        }
        List<String> goals = this.getGoals(basedir);
        List<String> profiles = this.getProfiles(basedir);
        LinkedHashMap linkedHashMap = new LinkedHashMap();
        FileLogger logger = this.setupLogger(basedir);
        try {
            try {
                this.scriptRunner.run("selector script", basedir, this.selectorScript, linkedHashMap, (ExecutionLogger)logger, "skipped", false);
            }
            catch (RunErrorException e) {
                throw e;
            }
            catch (RunFailureException e) {
                boolean bl = false;
                if (logger != null) {
                    logger.close();
                }
                return bl;
            }
            this.scriptRunner.run("pre-build script", basedir, this.preBuildHookScript, linkedHashMap, (ExecutionLogger)logger, "failure-pre-hook", false);
            DefaultInvocationRequest request = new DefaultInvocationRequest();
            request.setLocalRepositoryDirectory(this.localRepositoryPath);
            request.setInteractive(false);
            request.setShowErrors(this.showErrors);
            request.setDebug(this.debug);
            request.setShowVersion(this.showVersion);
            if (logger != null) {
                request.setErrorHandler((InvocationOutputHandler)logger);
                request.setOutputHandler((InvocationOutputHandler)logger);
            }
            if (this.mavenHome != null) {
                this.invoker.setMavenHome(this.mavenHome);
                request.addShellEnvironment("M2_HOME", this.mavenHome.getAbsolutePath());
            }
            if (this.javaHome != null) {
                request.setJavaHome(this.javaHome);
            }
            for (int invocationIndex = 1; invocationIndex <= 1 || invokerProperties.isInvocationDefined(invocationIndex); ++invocationIndex) {
                InvocationResult result;
                request.setBaseDirectory(basedir);
                request.setPomFile(pomFile);
                request.setGoals(goals);
                request.setProfiles(profiles);
                request.setMavenOpts(this.mavenOpts);
                request.setOffline(false);
                request.setUserSettingsFile(settingsFile);
                Properties systemProperties = this.getSystemProperties(basedir, invokerProperties.getSystemPropertiesFile(invocationIndex));
                request.setProperties(systemProperties);
                invokerProperties.configureInvocation((InvocationRequest)request, invocationIndex);
                if (this.getLog().isDebugEnabled()) {
                    try {
                        this.getLog().debug((CharSequence)("Using MAVEN_OPTS: " + request.getMavenOpts()));
                        this.getLog().debug((CharSequence)("Executing: " + new MavenCommandLineBuilder().build((InvocationRequest)request)));
                    }
                    catch (CommandLineConfigurationException e) {
                        this.getLog().debug((CharSequence)("Failed to display command line: " + e.getMessage()));
                    }
                }
                try {
                    result = this.invoker.execute((InvocationRequest)request);
                }
                catch (MavenInvocationException e) {
                    this.getLog().debug((CharSequence)("Error invoking Maven: " + e.getMessage()), (Throwable)e);
                    throw new RunFailureException("Maven invocation failed. " + e.getMessage(), "failure-build");
                }
                this.verify(result, invocationIndex, invokerProperties, logger);
            }
            this.scriptRunner.run("post-build script", basedir, this.postBuildHookScript, linkedHashMap, (ExecutionLogger)logger, "failure-post-hook", true);
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
        finally {
            if (logger != null) {
                logger.close();
            }
        }
        return true;
    }

    private FileLogger setupLogger(File basedir) throws MojoExecutionException {
        FileLogger logger = null;
        if (!this.noLog) {
            File outputLog = new File(basedir, "build.log");
            try {
                logger = this.streamLogs ? new FileLogger(outputLog, this.getLog()) : new FileLogger(outputLog);
                this.getLog().debug((CharSequence)("build log initialized in: " + outputLog));
            }
            catch (IOException e) {
                throw new MojoExecutionException("Error initializing build logfile in: " + outputLog, (Exception)e);
            }
        }
        return logger;
    }

    private Properties getSystemProperties(File basedir, String filename) throws MojoExecutionException {
        Properties collectedTestProperties = new Properties();
        if (this.testProperties != null) {
            collectedTestProperties.putAll((Map<?, ?>)this.testProperties);
        }
        if (this.properties != null) {
            collectedTestProperties.putAll(this.properties);
        }
        File propertiesFile = null;
        if (filename != null) {
            propertiesFile = new File(basedir, filename);
        } else if (this.testPropertiesFile != null) {
            propertiesFile = new File(basedir, this.testPropertiesFile);
        }
        if (propertiesFile != null && propertiesFile.isFile()) {
            FileInputStream fin = null;
            try {
                fin = new FileInputStream(propertiesFile);
                Properties loadedProperties = new Properties();
                loadedProperties.load(fin);
                collectedTestProperties.putAll((Map<?, ?>)loadedProperties);
            }
            catch (IOException e) {
                try {
                    throw new MojoExecutionException("Error reading system properties from " + propertiesFile);
                }
                catch (Throwable throwable) {
                    IOUtil.close(fin);
                    throw throwable;
                }
            }
            IOUtil.close((InputStream)fin);
        }
        return collectedTestProperties;
    }

    private void verify(InvocationResult result, int invocationIndex, InvokerProperties invokerProperties, FileLogger logger) throws RunFailureException {
        if (result.getExecutionException() != null) {
            throw new RunFailureException("The Maven invocation failed. " + result.getExecutionException().getMessage(), "error");
        }
        if (!invokerProperties.isExpectedResult(result.getExitCode(), invocationIndex)) {
            StringBuffer buffer = new StringBuffer(256);
            buffer.append("The build exited with code ").append(result.getExitCode()).append(". ");
            if (logger != null) {
                buffer.append("See ");
                buffer.append(logger.getOutputFile().getAbsolutePath());
                buffer.append(" for details.");
            } else {
                buffer.append("See console output for details.");
            }
            throw new RunFailureException(buffer.toString(), "failure-build");
        }
    }

    List<String> getGoals(File basedir) throws MojoExecutionException {
        try {
            return this.getTokens(basedir, this.goalsFile, this.goals);
        }
        catch (IOException e) {
            throw new MojoExecutionException("error reading goals", (Exception)e);
        }
    }

    List<String> getProfiles(File basedir) throws MojoExecutionException {
        try {
            return this.getTokens(basedir, this.profilesFile, this.profiles);
        }
        catch (IOException e) {
            throw new MojoExecutionException("error reading profiles", (Exception)e);
        }
    }

    BuildJob[] getBuildJobs() throws IOException {
        BuildJob[] buildJobs;
        if (this.pom != null && this.pom.exists()) {
            buildJobs = new BuildJob[]{new BuildJob(this.pom.getAbsolutePath(), "normal")};
        } else if (this.invokerTest != null) {
            String[] testRegexes = StringUtils.split((String)this.invokerTest, (String)",");
            ArrayList<String> includes = new ArrayList<String>(testRegexes.length);
            int size = testRegexes.length;
            for (int i = 0; i < size; ++i) {
                includes.add(testRegexes[i]);
            }
            buildJobs = this.scanProjectsDirectory(includes, null, "direct");
        } else {
            int i;
            String exclude;
            ArrayList<String> excludes;
            ArrayList<String> arrayList = excludes = this.pomExcludes != null ? new ArrayList<String>(this.pomExcludes) : new ArrayList();
            if (this.settingsFile != null && (exclude = this.relativizePath(this.settingsFile, this.projectsDirectory.getCanonicalPath())) != null) {
                excludes.add(exclude.replace('\\', '/'));
                this.getLog().debug((CharSequence)("Automatically excluded " + exclude + " from project scanning"));
            }
            BuildJob[] setupPoms = this.scanProjectsDirectory(this.setupIncludes, excludes, "setup");
            this.getLog().debug((CharSequence)("Setup projects: " + Arrays.asList(setupPoms)));
            BuildJob[] normalPoms = this.scanProjectsDirectory(this.pomIncludes, excludes, "normal");
            LinkedHashMap<String, BuildJob> uniquePoms = new LinkedHashMap<String, BuildJob>();
            for (i = 0; i < setupPoms.length; ++i) {
                uniquePoms.put(setupPoms[i].getProject(), setupPoms[i]);
            }
            for (i = 0; i < normalPoms.length; ++i) {
                if (uniquePoms.containsKey(normalPoms[i].getProject())) continue;
                uniquePoms.put(normalPoms[i].getProject(), normalPoms[i]);
            }
            buildJobs = uniquePoms.values().toArray(new BuildJob[uniquePoms.size()]);
        }
        this.relativizeProjectPaths(buildJobs);
        return buildJobs;
    }

    private BuildJob[] scanProjectsDirectory(List<String> includes, List<String> excludes, String type) throws IOException {
        if (!this.projectsDirectory.isDirectory()) {
            return new BuildJob[0];
        }
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(this.projectsDirectory.getCanonicalFile());
        scanner.setFollowSymlinks(false);
        if (includes != null) {
            scanner.setIncludes(includes.toArray(new String[includes.size()]));
        }
        if (excludes != null) {
            scanner.setExcludes(excludes.toArray(new String[excludes.size()]));
        }
        scanner.addDefaultExcludes();
        scanner.scan();
        LinkedHashMap<String, BuildJob> matches = new LinkedHashMap<String, BuildJob>();
        String[] includedFiles = scanner.getIncludedFiles();
        for (int i = 0; i < includedFiles.length; ++i) {
            matches.put(includedFiles[i], new BuildJob(includedFiles[i], type));
        }
        String[] includedDirs = scanner.getIncludedDirectories();
        for (int i = 0; i < includedDirs.length; ++i) {
            String includedFile = includedDirs[i] + File.separatorChar + "pom.xml";
            if (new File(scanner.getBasedir(), includedFile).isFile()) {
                matches.put(includedFile, new BuildJob(includedFile, type));
                continue;
            }
            matches.put(includedDirs[i], new BuildJob(includedDirs[i], type));
        }
        return matches.values().toArray(new BuildJob[matches.size()]);
    }

    private void relativizeProjectPaths(BuildJob[] buildJobs) throws IOException {
        String projectsDirPath = this.projectsDirectory.getCanonicalPath();
        for (int i = 0; i < buildJobs.length; ++i) {
            String relativizedPath;
            String projectPath = buildJobs[i].getProject();
            File file = new File(projectPath);
            if (!file.isAbsolute()) {
                file = new File(this.projectsDirectory, projectPath);
            }
            if ((relativizedPath = this.relativizePath(file, projectsDirPath)) == null) {
                relativizedPath = projectPath;
            }
            buildJobs[i].setProject(relativizedPath);
        }
    }

    private String relativizePath(File path, String basedir) throws IOException {
        String relativizedPath = path.getCanonicalPath();
        if (relativizedPath.startsWith(basedir)) {
            if ((relativizedPath = relativizedPath.substring(basedir.length())).startsWith(File.separator)) {
                relativizedPath = relativizedPath.substring(File.separator.length());
            }
            return relativizedPath;
        }
        return null;
    }

    private Map<String, Object> getInterpolationValueSource() {
        HashMap<String, Object> props = new HashMap<String, Object>();
        if (this.interpolationsProperties != null) {
            props.putAll(this.interpolationsProperties);
        }
        if (this.filterProperties != null) {
            props.putAll(this.filterProperties);
        }
        props.put("basedir", this.project.getBasedir().getAbsolutePath());
        props.put("baseurl", AbstractInvokerMojo.toUrl(this.project.getBasedir().getAbsolutePath()));
        if (this.settings.getLocalRepository() != null) {
            props.put("localRepository", this.settings.getLocalRepository());
            props.put("localRepositoryUrl", AbstractInvokerMojo.toUrl(this.settings.getLocalRepository()));
        }
        return new CompositeMap(this.project, props);
    }

    private static String toUrl(String filename) {
        String url = "file://" + new File(filename).toURI().getPath();
        if (url.endsWith("/")) {
            url = url.substring(0, url.length() - 1);
        }
        return url;
    }

    private List<String> getTokens(File basedir, String filename, List<String> defaultTokens) throws IOException {
        File tokenFile;
        List<String> tokens;
        ArrayList<String> arrayList = tokens = defaultTokens != null ? defaultTokens : new ArrayList<String>();
        if (StringUtils.isNotEmpty((String)filename) && (tokenFile = new File(basedir, filename)).exists()) {
            tokens = this.readTokens(tokenFile);
        }
        return tokens;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> readTokens(File tokenFile) throws IOException {
        ArrayList<String> result = new ArrayList<String>();
        BufferedReader reader = null;
        try {
            Map<String, Object> composite = this.getInterpolationValueSource();
            reader = new BufferedReader((Reader)new InterpolationFilterReader(this.newReader(tokenFile), composite));
            String line = null;
            while ((line = reader.readLine()) != null) {
                result.addAll(this.collectListFromCSV(line));
            }
        }
        catch (Throwable throwable) {
            IOUtil.close(reader);
            throw throwable;
        }
        IOUtil.close((Reader)reader);
        return result;
    }

    private List<String> collectListFromCSV(String csv) {
        ArrayList<String> result = new ArrayList<String>();
        if (csv != null && csv.trim().length() > 0) {
            StringTokenizer st = new StringTokenizer(csv, ",");
            while (st.hasMoreTokens()) {
                result.add(st.nextToken().trim());
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void buildInterpolatedFile(File originalFile, File interpolatedFile) throws MojoExecutionException {
        this.getLog().debug((CharSequence)("Interpolate " + originalFile.getPath() + " to " + interpolatedFile.getPath()));
        try {
            String xml;
            XmlStreamReader reader = null;
            try {
                Map<String, Object> composite = this.getInterpolationValueSource();
                reader = ReaderFactory.newXmlReader((File)originalFile);
                reader = new InterpolationFilterReader((Reader)reader, composite, "@", "@");
                xml = IOUtil.toString((Reader)reader);
            }
            catch (Throwable throwable) {
                IOUtil.close(reader);
                throw throwable;
            }
            IOUtil.close((Reader)reader);
            XmlStreamWriter writer = null;
            try {
                interpolatedFile.getParentFile().mkdirs();
                writer = WriterFactory.newXmlWriter((File)interpolatedFile);
                writer.write(xml);
                writer.flush();
            }
            catch (Throwable throwable) {
                IOUtil.close(writer);
                throw throwable;
            }
            IOUtil.close((Writer)writer);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to interpolate file " + originalFile.getPath(), (Exception)e);
        }
    }

    private InvokerProperties getInvokerProperties(File projectDirectory) throws MojoExecutionException {
        Properties props = new Properties();
        if (this.invokerPropertiesFile != null) {
            File propertiesFile = new File(projectDirectory, this.invokerPropertiesFile);
            if (propertiesFile.isFile()) {
                FileInputStream in = null;
                try {
                    in = new FileInputStream(propertiesFile);
                    props.load(in);
                }
                catch (IOException e) {
                    try {
                        throw new MojoExecutionException("Failed to read invoker properties: " + propertiesFile, (Exception)e);
                    }
                    catch (Throwable throwable) {
                        IOUtil.close(in);
                        throw throwable;
                    }
                }
                IOUtil.close((InputStream)in);
            }
            RegexBasedInterpolator interpolator = new RegexBasedInterpolator();
            interpolator.addValueSource((ValueSource)new MapBasedValueSource(this.getInterpolationValueSource()));
            for (String key : props.keySet()) {
                String value = props.getProperty(key);
                try {
                    value = interpolator.interpolate(value, "");
                }
                catch (InterpolationException e) {
                    throw new MojoExecutionException("Failed to interpolate invoker properties: " + propertiesFile, (Exception)((Object)e));
                }
                props.setProperty(key, value);
            }
        }
        return new InvokerProperties(props);
    }

    protected boolean isParallelRun() {
        return this.parallelThreads > 1;
    }
}

