/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.invoker;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Properties;
import org.apache.maven.shared.invoker.InvocationRequest;
import org.codehaus.plexus.util.StringUtils;

class InvokerProperties {
    private final Properties properties;

    public InvokerProperties(Properties properties) {
        this.properties = properties != null ? properties : new Properties();
    }

    public Properties getProperties() {
        return this.properties;
    }

    public boolean isInvocationDefined(int index) {
        return this.properties.getProperty("invoker.goals." + index) != null;
    }

    public void configureInvocation(InvocationRequest request, int index) {
        String nonRecursive;
        String failureBehavior;
        String mvnOpts;
        String profiles;
        String goals = this.get("invoker.goals", index);
        if (goals != null) {
            request.setGoals(new ArrayList<String>(Arrays.asList(StringUtils.split((String)goals, (String)", \t\n\r\f"))));
        }
        if ((profiles = this.get("invoker.profiles", index)) != null) {
            request.setProfiles(new ArrayList<String>(Arrays.asList(StringUtils.split((String)profiles, (String)", \t\n\r\f"))));
        }
        if ((mvnOpts = this.get("invoker.mavenOpts", index)) != null) {
            request.setMavenOpts(mvnOpts);
        }
        if ((failureBehavior = this.get("invoker.failureBehavior", index)) != null) {
            request.setFailureBehavior(failureBehavior);
        }
        if ((nonRecursive = this.get("invoker.nonRecursive", index)) != null) {
            request.setRecursive(Boolean.valueOf(nonRecursive) == false);
        }
    }

    public boolean isExpectedResult(int exitCode, int index) {
        boolean nonZeroExit = "failure".equalsIgnoreCase(this.get("invoker.buildResult", index));
        return exitCode != 0 == nonZeroExit;
    }

    String get(String key, int index) {
        if (index < 0) {
            throw new IllegalArgumentException("invalid invocation index: " + index);
        }
        String value = this.properties.getProperty(key + '.' + index);
        if (value == null) {
            value = this.properties.getProperty(key);
        }
        return value;
    }
}

