/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.invoker;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.installer.ArtifactInstaller;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.ArtifactRepositoryFactory;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;

public class InstallMojo
extends AbstractMojo {
    private ArtifactInstaller installer;
    private ArtifactFactory artifactFactory;
    private ArtifactRepositoryFactory repositoryFactory;
    private ArtifactRepository localRepository;
    private File localRepositoryPath;
    private MavenProject project;
    private Collection reactorProjects;

    public void execute() throws MojoExecutionException {
        ArtifactRepository testRepository = this.createTestRepository();
        this.installProjectArtifacts(this.project, testRepository);
        this.installProjectParents(this.project, testRepository);
        this.installProjectDependencies(this.project, this.reactorProjects, testRepository);
    }

    private ArtifactRepository createTestRepository() throws MojoExecutionException {
        ArtifactRepository testRepository = this.localRepository;
        if (this.localRepositoryPath != null) {
            try {
                if (!this.localRepositoryPath.exists() && !this.localRepositoryPath.mkdirs()) {
                    throw new IOException("Failed to create directory: " + this.localRepositoryPath);
                }
                testRepository = this.repositoryFactory.createArtifactRepository(this.localRepository.getId(), this.localRepositoryPath.toURL().toExternalForm(), this.localRepository.getLayout(), this.localRepository.getSnapshots(), this.localRepository.getReleases());
            }
            catch (Exception e) {
                throw new MojoExecutionException("Failed to create local repository: " + this.localRepositoryPath, e);
            }
        }
        return testRepository;
    }

    private void installArtifact(File file, Artifact artifact, ArtifactRepository testRepository) throws MojoExecutionException {
        try {
            if (file == null) {
                throw new IllegalStateException("Artifact has no associated file: " + file);
            }
            if (!file.isFile()) {
                throw new IllegalStateException("Artifact is not fully assembled: " + file);
            }
            this.installer.install(file, artifact, testRepository);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to install artifact: " + artifact, e);
        }
    }

    private void installProjectArtifacts(MavenProject mvnProject, ArtifactRepository testRepository) throws MojoExecutionException {
        try {
            this.installProjectPom(mvnProject, testRepository);
            Artifact mainArtifact = mvnProject.getArtifact();
            if (mainArtifact.getFile() != null) {
                this.installArtifact(mainArtifact.getFile(), mainArtifact, testRepository);
            }
            List attachedArtifacts = mvnProject.getAttachedArtifacts();
            Iterator artifactIter = attachedArtifacts.iterator();
            while (artifactIter.hasNext()) {
                Artifact attachedArtifact = (Artifact)artifactIter.next();
                this.installArtifact(attachedArtifact.getFile(), attachedArtifact, testRepository);
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to install project artifacts: " + mvnProject, e);
        }
    }

    private void installProjectParents(MavenProject mvnProject, ArtifactRepository testRepository) throws MojoExecutionException {
        try {
            for (MavenProject parent = mvnProject.getParent(); parent != null && parent.getFile() != null; parent = parent.getParent()) {
                this.installProjectPom(parent, testRepository);
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to install project parents: " + mvnProject, e);
        }
    }

    private void installProjectPom(MavenProject mvnProject, ArtifactRepository testRepository) throws MojoExecutionException {
        try {
            Artifact pomArtifact = null;
            if ("pom".equals(mvnProject.getPackaging())) {
                pomArtifact = mvnProject.getArtifact();
            }
            if (pomArtifact == null) {
                pomArtifact = this.artifactFactory.createProjectArtifact(mvnProject.getGroupId(), mvnProject.getArtifactId(), mvnProject.getVersion());
            }
            this.installArtifact(mvnProject.getFile(), pomArtifact, testRepository);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to install POM: " + mvnProject, e);
        }
    }

    private void installProjectDependencies(MavenProject mvnProject, Collection reactorProjects, ArtifactRepository testRepository) throws MojoExecutionException {
        String id;
        Artifact artifact;
        String id2;
        HashMap<String, MavenProject> projects = new HashMap<String, MavenProject>();
        Iterator it = reactorProjects.iterator();
        while (it.hasNext()) {
            MavenProject reactorProject = (MavenProject)it.next();
            id2 = reactorProject.getGroupId() + ':' + reactorProject.getArtifactId();
            projects.put(id2, reactorProject);
        }
        HashSet<String> dependencies = new HashSet<String>();
        Iterator it2 = mvnProject.getRuntimeArtifacts().iterator();
        while (it2.hasNext()) {
            artifact = (Artifact)it2.next();
            id = ArtifactUtils.versionlessKey((Artifact)artifact);
            dependencies.add(id);
        }
        try {
            it2 = dependencies.iterator();
            while (it2.hasNext()) {
                id2 = (String)it2.next();
                MavenProject requiredProject = (MavenProject)projects.remove(id2);
                if (requiredProject == null) continue;
                it2.remove();
                this.installProjectArtifacts(requiredProject, testRepository);
                this.installProjectParents(requiredProject, testRepository);
            }
            it2 = mvnProject.getRuntimeArtifacts().iterator();
            while (it2.hasNext()) {
                artifact = (Artifact)it2.next();
                id = ArtifactUtils.versionlessKey((Artifact)artifact);
                if (!dependencies.contains(id)) continue;
                File artifactFile = artifact.getFile();
                this.installArtifact(artifactFile, artifact, testRepository);
                Artifact pomArtifact = this.artifactFactory.createArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), null, "pom");
                File pomFile = new File(this.localRepository.getBasedir(), this.localRepository.pathOf(pomArtifact));
                if (!pomFile.exists()) continue;
                this.installArtifact(pomFile, pomArtifact, testRepository);
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to install project dependencies: " + mvnProject, e);
        }
    }
}

