/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.help;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.help.AbstractEffectiveMojo;
import org.apache.maven.settings.Profile;
import org.apache.maven.settings.Proxy;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.apache.maven.settings.SettingsUtils;
import org.apache.maven.settings.io.xpp3.SettingsXpp3Writer;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.PrettyPrintXMLWriter;
import org.codehaus.plexus.util.xml.XMLWriter;

@Mojo(name="effective-settings", requiresProject=false)
public class EffectiveSettingsMojo
extends AbstractEffectiveMojo {
    @Parameter(defaultValue="${settings}", readonly=true, required=true)
    private Settings settings;
    @Parameter(property="showPasswords", defaultValue="false")
    private boolean showPasswords;

    public void execute() throws MojoExecutionException {
        Settings copySettings;
        if (this.showPasswords) {
            copySettings = this.settings;
        } else {
            copySettings = EffectiveSettingsMojo.copySettings(this.settings);
            if (copySettings != null) {
                EffectiveSettingsMojo.hidePasswords(copySettings);
            }
        }
        StringWriter w = new StringWriter();
        String encoding = this.output != null && copySettings != null ? copySettings.getModelEncoding() : System.getProperty("file.encoding");
        PrettyPrintXMLWriter writer = new PrettyPrintXMLWriter((Writer)w, StringUtils.repeat((String)" ", (int)2), encoding, null);
        EffectiveSettingsMojo.writeHeader((XMLWriter)writer);
        EffectiveSettingsMojo.writeEffectiveSettings(copySettings, (XMLWriter)writer);
        String effectiveSettings = EffectiveSettingsMojo.prettyFormat(w.toString(), encoding, false);
        if (this.output != null) {
            try {
                EffectiveSettingsMojo.writeXmlFile(this.output, effectiveSettings);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Cannot write effective-settings to output: " + this.output, (Exception)e);
            }
            this.getLog().info((CharSequence)("Effective-settings written to: " + this.output));
        } else {
            this.getLog().info((CharSequence)(LS + "Effective user-specific configuration settings:" + LS + LS + effectiveSettings + LS));
        }
    }

    private static void hidePasswords(Settings aSettings) {
        List proxies = aSettings.getProxies();
        for (Proxy proxy : proxies) {
            if (!StringUtils.isNotEmpty((String)proxy.getPassword())) continue;
            proxy.setPassword("***");
        }
        List servers = aSettings.getServers();
        for (Server server : servers) {
            if (StringUtils.isNotEmpty((String)server.getPassword())) {
                server.setPassword("***");
            }
            if (!StringUtils.isNotEmpty((String)server.getPassphrase())) continue;
            server.setPassphrase("***");
        }
    }

    private static Settings copySettings(Settings settings) {
        if (settings == null) {
            return null;
        }
        Settings clone = SettingsUtils.copySettings((Settings)settings);
        ArrayList<Server> clonedServers = new ArrayList<Server>(settings.getServers().size());
        for (Server server : settings.getServers()) {
            Server clonedServer = new Server();
            clonedServer.setConfiguration(server.getConfiguration());
            clonedServer.setDirectoryPermissions(server.getDirectoryPermissions());
            clonedServer.setFilePermissions(server.getFilePermissions());
            clonedServer.setId(server.getId());
            clonedServer.setPassphrase(server.getPassphrase());
            clonedServer.setPassword(server.getPassword());
            clonedServer.setPrivateKey(server.getPrivateKey());
            clonedServer.setSourceLevel(server.getSourceLevel());
            clonedServer.setUsername(server.getUsername());
            clonedServers.add(clonedServer);
        }
        clone.setServers(clonedServers);
        ArrayList<Proxy> clonedProxies = new ArrayList<Proxy>(settings.getProxies().size());
        for (Proxy proxy : settings.getProxies()) {
            Proxy clonedProxy = new Proxy();
            clonedProxy.setActive(proxy.isActive());
            clonedProxy.setHost(proxy.getHost());
            clonedProxy.setId(proxy.getId());
            clonedProxy.setNonProxyHosts(proxy.getNonProxyHosts());
            clonedProxy.setPassword(proxy.getPassword());
            clonedProxy.setPort(proxy.getPort());
            clonedProxy.setProtocol(proxy.getProtocol());
            clonedProxy.setSourceLevel(proxy.getSourceLevel());
            clonedProxy.setUsername(proxy.getUsername());
            clonedProxies.add(clonedProxy);
        }
        clone.setProxies(clonedProxies);
        return clone;
    }

    private static void writeEffectiveSettings(Settings settings, XMLWriter writer) throws MojoExecutionException {
        EffectiveSettingsMojo.cleanSettings(settings);
        StringWriter sWriter = new StringWriter();
        SettingsXpp3Writer settingsWriter = new SettingsXpp3Writer();
        try {
            settingsWriter.write((Writer)sWriter, settings);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Cannot serialize Settings to XML.", (Exception)e);
        }
        String effectiveSettings = EffectiveSettingsMojo.prettyFormat(sWriter.toString(), null, true);
        EffectiveSettingsMojo.writeComment(writer, "Effective Settings for '" + EffectiveSettingsMojo.getUserName() + "' on '" + EffectiveSettingsMojo.getHostName() + "'");
        writer.writeMarkup(effectiveSettings);
    }

    private static void cleanSettings(Settings settings) {
        List profiles = settings.getProfiles();
        for (Profile profile : profiles) {
            AbstractEffectiveMojo.SortedProperties properties = new AbstractEffectiveMojo.SortedProperties();
            properties.putAll((Map<?, ?>)profile.getProperties());
            profile.setProperties((Properties)properties);
        }
    }

    private static String getHostName() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            return "unknown";
        }
    }

    private static String getUserName() {
        String userName = System.getProperty("user.name");
        if (StringUtils.isEmpty((String)userName)) {
            return "unknown";
        }
        return userName;
    }
}

