/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.gpg;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.deployer.ArtifactDeployer;
import org.apache.maven.artifact.deployer.ArtifactDeploymentException;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadata;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.ArtifactRepositoryFactory;
import org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.model.io.xpp3.MavenXpp3Writer;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.gpg.AbstractGpgMojo;
import org.apache.maven.plugin.gpg.AscArtifactMetadata;
import org.apache.maven.plugin.gpg.AttachedSignedArtifact;
import org.apache.maven.plugin.gpg.GpgSigner;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.apache.maven.project.artifact.ProjectArtifactMetadata;
import org.apache.maven.project.validation.ModelValidationResult;
import org.apache.maven.project.validation.ModelValidator;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.WriterFactory;
import org.codehaus.plexus.util.xml.XmlStreamReader;
import org.codehaus.plexus.util.xml.XmlStreamWriter;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class SignAndDeployFileMojo
extends AbstractGpgMojo {
    private File ascDirectory;
    private boolean offline;
    private String groupId;
    private String artifactId;
    private String version;
    private String packaging;
    private String classifier;
    private String description;
    private File file;
    private File pomFile;
    private boolean generatePom;
    private boolean uniqueVersion;
    private String url;
    private String repositoryId;
    private String repositoryLayout;
    private ArtifactDeployer deployer;
    private ArtifactRepository localRepository;
    private Map repositoryLayouts;
    private ArtifactFactory artifactFactory;
    private ArtifactRepositoryFactory repositoryFactory;
    private ModelValidator modelValidator;
    private MavenProject project;
    private MavenProjectHelper projectHelper;
    private File javadoc;
    private File sources;
    private int retryFailedDeploymentCount;
    protected boolean updateReleaseInfo;
    private String types;
    private String classifiers;
    private String files;

    private void initProperties() throws MojoExecutionException {
        if (this.pomFile != null) {
            this.generatePom = false;
            Model model = this.readModel(this.pomFile);
            this.processModel(model);
        }
        if (this.packaging == null && this.file != null) {
            this.packaging = FileUtils.getExtension((String)this.file.getName());
        }
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        GpgSigner signer = this.newSigner(null);
        signer.setOutputDirectory(this.ascDirectory);
        signer.setBaseDirectory(new File("").getAbsoluteFile());
        if (this.offline) {
            throw new MojoFailureException("Cannot deploy artifacts when Maven is in offline mode");
        }
        this.initProperties();
        this.validateArtifactInformation();
        if (!this.file.exists()) {
            throw new MojoFailureException(this.file.getPath() + " not found.");
        }
        ArtifactRepositoryLayout layout = (ArtifactRepositoryLayout)this.repositoryLayouts.get(this.repositoryLayout);
        if (layout == null) {
            throw new MojoFailureException("Invalid repository layout: " + this.repositoryLayout);
        }
        ArtifactRepository deploymentRepository = this.repositoryFactory.createDeploymentArtifactRepository(this.repositoryId, this.url, layout, this.uniqueVersion);
        if (StringUtils.isEmpty((String)deploymentRepository.getProtocol())) {
            throw new MojoFailureException("No transfer protocol found.");
        }
        Artifact artifact = this.artifactFactory.createArtifactWithClassifier(this.groupId, this.artifactId, this.version, this.packaging, this.classifier);
        if (this.file.equals(this.getLocalRepoFile(artifact))) {
            throw new MojoFailureException("Cannot deploy artifact from the local repository: " + this.file);
        }
        File fileSig = signer.generateSignatureForArtifact(this.file);
        AscArtifactMetadata metadata = new AscArtifactMetadata(artifact, fileSig, false);
        artifact.addMetadata((ArtifactMetadata)metadata);
        if (!"pom".equals(this.packaging)) {
            if (this.pomFile == null && this.generatePom) {
                this.pomFile = this.generatePomFile();
            }
            if (this.pomFile != null) {
                metadata = new ProjectArtifactMetadata(artifact, this.pomFile);
                artifact.addMetadata((ArtifactMetadata)metadata);
                fileSig = signer.generateSignatureForArtifact(this.pomFile);
                metadata = new AscArtifactMetadata(artifact, fileSig, true);
                artifact.addMetadata((ArtifactMetadata)metadata);
            }
        }
        if (this.updateReleaseInfo) {
            artifact.setRelease(true);
        }
        this.project.setArtifact(artifact);
        try {
            this.deploy(this.file, artifact, deploymentRepository, this.localRepository);
        }
        catch (ArtifactDeploymentException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
        if (this.sources != null) {
            this.projectHelper.attachArtifact(this.project, "jar", "sources", this.sources);
        }
        if (this.javadoc != null) {
            this.projectHelper.attachArtifact(this.project, "jar", "javadoc", this.javadoc);
        }
        if (this.files != null) {
            if (this.types == null) {
                throw new MojoExecutionException("You must specify 'types' if you specify 'files'");
            }
            if (this.classifiers == null) {
                throw new MojoExecutionException("You must specify 'classifiers' if you specify 'files'");
            }
            int filesLength = StringUtils.countMatches((String)this.files, (String)",");
            int typesLength = StringUtils.countMatches((String)this.types, (String)",");
            int classifiersLength = StringUtils.countMatches((String)this.classifiers, (String)",");
            if (typesLength != filesLength) {
                throw new MojoExecutionException("You must specify the same number of entries in 'files' and 'types' (respectively " + filesLength + " and " + typesLength + " entries )");
            }
            if (classifiersLength != filesLength) {
                throw new MojoExecutionException("You must specify the same number of entries in 'files' and 'classifiers' (respectively " + filesLength + " and " + classifiersLength + " entries )");
            }
            int fi = 0;
            int ti = 0;
            int ci = 0;
            for (int i = 0; i <= filesLength; ++i) {
                File file;
                int nci;
                int nti;
                int nfi = this.files.indexOf(44, fi);
                if (nfi == -1) {
                    nfi = this.files.length();
                }
                if ((nti = this.types.indexOf(44, ti)) == -1) {
                    nti = this.types.length();
                }
                if ((nci = this.classifiers.indexOf(44, ci)) == -1) {
                    nci = this.classifiers.length();
                }
                if (!(file = new File(this.files.substring(fi, nfi))).isFile()) {
                    file = new File(this.project.getBasedir(), this.files.substring(fi, nfi));
                }
                if (file.isFile()) {
                    if (StringUtils.isWhitespace((String)this.classifiers.substring(ci, nci))) {
                        this.projectHelper.attachArtifact(this.project, this.types.substring(ti, nti).trim(), file);
                    } else {
                        this.projectHelper.attachArtifact(this.project, this.types.substring(ti, nti).trim(), this.classifiers.substring(ci, nci).trim(), file);
                    }
                } else {
                    throw new MojoExecutionException("Specified side artifact " + file + " does not exist");
                }
                fi = nfi + 1;
                ti = nti + 1;
                ci = nci + 1;
            }
        } else {
            if (this.types != null) {
                throw new MojoExecutionException("You must specify 'files' if you specify 'types'");
            }
            if (this.classifiers != null) {
                throw new MojoExecutionException("You must specify 'files' if you specify 'classifiers'");
            }
        }
        List attachedArtifacts = this.project.getAttachedArtifacts();
        for (Artifact attached : attachedArtifacts) {
            fileSig = signer.generateSignatureForArtifact(attached.getFile());
            attached = new AttachedSignedArtifact(attached, new AscArtifactMetadata(attached, fileSig, false));
            try {
                this.deploy(attached.getFile(), attached, deploymentRepository, this.localRepository);
            }
            catch (ArtifactDeploymentException e) {
                throw new MojoExecutionException("Error deploying attached artifact " + attached.getFile() + ": " + e.getMessage(), (Exception)((Object)e));
            }
        }
    }

    private File getLocalRepoFile(Artifact artifact) {
        String path = this.localRepository.pathOf(artifact);
        return new File(this.localRepository.getBasedir(), path);
    }

    private void processModel(Model model) {
        Parent parent = model.getParent();
        if (this.groupId == null) {
            this.groupId = model.getGroupId();
            if (this.groupId == null && parent != null) {
                this.groupId = parent.getGroupId();
            }
        }
        if (this.artifactId == null) {
            this.artifactId = model.getArtifactId();
        }
        if (this.version == null) {
            this.version = model.getVersion();
            if (this.version == null && parent != null) {
                this.version = parent.getVersion();
            }
        }
        if (this.packaging == null) {
            this.packaging = model.getPackaging();
        }
    }

    private Model readModel(File pomFile) throws MojoExecutionException {
        XmlStreamReader reader = null;
        try {
            reader = ReaderFactory.newXmlReader((File)pomFile);
            Model model = new MavenXpp3Reader().read((Reader)reader);
            return model;
        }
        catch (FileNotFoundException e) {
            throw new MojoExecutionException("POM not found " + pomFile, (Exception)e);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error reading POM " + pomFile, (Exception)e);
        }
        catch (XmlPullParserException e) {
            throw new MojoExecutionException("Error parsing POM " + pomFile, (Exception)((Object)e));
        }
        finally {
            IOUtil.close((Reader)reader);
        }
    }

    private File generatePomFile() throws MojoExecutionException {
        File file;
        Model model = this.generateModel();
        XmlStreamWriter fw = null;
        try {
            File tempFile = File.createTempFile("mvndeploy", ".pom");
            tempFile.deleteOnExit();
            fw = WriterFactory.newXmlWriter((File)tempFile);
            new MavenXpp3Writer().write((Writer)fw, model);
            file = tempFile;
        }
        catch (IOException e) {
            try {
                throw new MojoExecutionException("Error writing temporary pom file: " + e.getMessage(), (Exception)e);
            }
            catch (Throwable throwable) {
                IOUtil.close(fw);
                throw throwable;
            }
        }
        IOUtil.close((Writer)fw);
        return file;
    }

    private void validateArtifactInformation() throws MojoFailureException {
        Model model = this.generateModel();
        ModelValidationResult result = this.modelValidator.validate(model);
        if (result.getMessageCount() > 0) {
            throw new MojoFailureException("The artifact information is incomplete or not valid:\n" + result.render("  "));
        }
    }

    private Model generateModel() {
        Model model = new Model();
        model.setModelVersion("4.0.0");
        model.setGroupId(this.groupId);
        model.setArtifactId(this.artifactId);
        model.setVersion(this.version);
        model.setPackaging(this.packaging);
        model.setDescription(this.description);
        return model;
    }

    protected void deploy(File source, Artifact artifact, ArtifactRepository deploymentRepository, ArtifactRepository localRepository) throws ArtifactDeploymentException {
        int retryFailedDeploymentCount = Math.max(1, Math.min(10, this.retryFailedDeploymentCount));
        ArtifactDeploymentException exception = null;
        for (int count = 0; count < retryFailedDeploymentCount; ++count) {
            try {
                if (count > 0) {
                    this.getLog().info((CharSequence)("Retrying deployment attempt " + (count + 1) + " of " + retryFailedDeploymentCount));
                }
                this.deployer.deploy(source, artifact, deploymentRepository, localRepository);
                for (ArtifactMetadata metadata : artifact.getMetadataList()) {
                    this.getLog().info((CharSequence)("Metadata[" + metadata.getKey() + "].filename = " + metadata.getRemoteFilename()));
                }
                exception = null;
                break;
            }
            catch (ArtifactDeploymentException e) {
                if (count + 1 < retryFailedDeploymentCount) {
                    this.getLog().warn((CharSequence)("Encountered issue during deployment: " + e.getLocalizedMessage()));
                    this.getLog().debug((Throwable)e);
                }
                if (exception != null) continue;
                exception = e;
                continue;
            }
        }
        if (exception != null) {
            throw exception;
        }
    }
}

