/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.eclipse.writers;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.eclipse.BuildCommand;
import org.apache.maven.plugin.eclipse.LinkedResource;
import org.apache.maven.plugin.eclipse.Messages;
import org.apache.maven.plugin.eclipse.writers.AbstractEclipseWriter;
import org.apache.maven.plugin.ide.IdeDependency;
import org.apache.maven.plugin.ide.IdeUtils;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.xml.PrettyPrintXMLWriter;
import org.codehaus.plexus.util.xml.XMLWriter;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.Xpp3DomBuilder;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class EclipseProjectWriter
extends AbstractEclipseWriter {
    private static final String ELT_NAME = "name";
    private static final String ELT_COMMENT = "comment";
    private static final String ELT_BUILD_COMMAND = "buildCommand";
    private static final String ELT_LINK = "link";
    private static final String ELT_BUILD_SPEC = "buildSpec";
    private static final String ELT_LINKED_RESOURCES = "linkedResources";
    private static final String ELT_NATURE = "nature";
    private static final String ELT_NATURES = "natures";
    private static final String FILE_DOT_PROJECT = ".project";
    private static final int LINK_TYPE_FILE = 1;
    private static final int LINK_TYPE_DIRECTORY = 2;
    ArrayList linkNames = new ArrayList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void write() throws MojoExecutionException {
        boolean addLinks;
        OutputStreamWriter w;
        LinkedHashSet<String> projectnatures = new LinkedHashSet<String>();
        LinkedHashSet<BuildCommand> buildCommands = new LinkedHashSet<BuildCommand>();
        LinkedHashSet<LinkedResource> linkedResources = new LinkedHashSet<LinkedResource>();
        File dotProject = new File(this.config.getEclipseProjectDirectory(), FILE_DOT_PROJECT);
        if (dotProject.exists()) {
            InputStreamReader reader;
            block27: {
                this.log.info((CharSequence)Messages.getString("EclipsePlugin.keepexisting", dotProject.getAbsolutePath()));
                reader = null;
                try {
                    Xpp3Dom linkedResourcesElement;
                    Xpp3Dom buildSpec;
                    reader = new InputStreamReader((InputStream)new FileInputStream(dotProject), "UTF-8");
                    Xpp3Dom dom = Xpp3DomBuilder.build((Reader)reader);
                    Xpp3Dom naturesElement = dom.getChild(ELT_NATURES);
                    if (naturesElement != null) {
                        Xpp3Dom[] existingNatures = naturesElement.getChildren(ELT_NATURE);
                        for (int j = 0; j < existingNatures.length; ++j) {
                            projectnatures.add(existingNatures[j].getValue());
                        }
                    }
                    if ((buildSpec = dom.getChild(ELT_BUILD_SPEC)) != null) {
                        Xpp3Dom[] existingBuildCommands = buildSpec.getChildren(ELT_BUILD_COMMAND);
                        for (int j = 0; j < existingBuildCommands.length; ++j) {
                            Xpp3Dom buildCommandName = existingBuildCommands[j].getChild(ELT_NAME);
                            if (buildCommandName == null) continue;
                            buildCommands.add(new BuildCommand(existingBuildCommands[j]));
                        }
                    }
                    if ((linkedResourcesElement = dom.getChild(ELT_LINKED_RESOURCES)) == null) break block27;
                    Xpp3Dom[] existingLinks = linkedResourcesElement.getChildren(ELT_LINK);
                    for (int j = 0; j < existingLinks.length; ++j) {
                        Xpp3Dom linkName = existingLinks[j].getChild(ELT_NAME);
                        if (linkName == null) continue;
                        this.linkNames.add(existingLinks[j].getChild(ELT_NAME).getValue());
                        linkedResources.add(new LinkedResource(existingLinks[j]));
                    }
                }
                catch (XmlPullParserException e) {
                    this.log.warn((CharSequence)Messages.getString("EclipsePlugin.cantparseexisting", dotProject.getAbsolutePath()));
                    IOUtil.close((Reader)reader);
                }
                catch (IOException e2) {
                    this.log.warn((CharSequence)Messages.getString("EclipsePlugin.cantparseexisting", dotProject.getAbsolutePath()));
                    {
                        catch (Throwable throwable) {
                            IOUtil.close(reader);
                            throw throwable;
                        }
                    }
                    IOUtil.close((Reader)reader);
                }
            }
            IOUtil.close((Reader)reader);
        }
        Iterator iter = this.config.getProjectnatures().iterator();
        while (iter.hasNext()) {
            projectnatures.add((String)iter.next());
        }
        iter = this.config.getBuildCommands().iterator();
        while (iter.hasNext()) {
            buildCommands.add((BuildCommand)iter.next());
        }
        iter = this.config.getLinkedResources().iterator();
        while (iter.hasNext()) {
            linkedResources.add((LinkedResource)iter.next());
        }
        try {
            w = new OutputStreamWriter((OutputStream)new FileOutputStream(dotProject), "UTF-8");
        }
        catch (IOException ex) {
            throw new MojoExecutionException(Messages.getString("EclipsePlugin.erroropeningfile"), (Exception)ex);
        }
        PrettyPrintXMLWriter writer = new PrettyPrintXMLWriter((Writer)w, "UTF-8", null);
        writer.startElement("projectDescription");
        writer.startElement(ELT_NAME);
        writer.writeText(this.config.getEclipseProjectName());
        writer.endElement();
        this.addComment((XMLWriter)writer, this.config.getProject().getDescription());
        writer.startElement("projects");
        IdeDependency[] dependencies = this.config.getDeps();
        if (!this.config.isPde()) {
            ArrayList<String> duplicates = new ArrayList<String>();
            for (int j = 0; j < dependencies.length; ++j) {
                IdeDependency dep = dependencies[j];
                if (!dep.isReferencedProject() || duplicates.contains(dep.getEclipseProjectName())) continue;
                writer.startElement("project");
                writer.writeText(dep.getEclipseProjectName());
                writer.endElement();
                duplicates.add(dep.getEclipseProjectName());
            }
        }
        writer.endElement();
        writer.startElement(ELT_BUILD_SPEC);
        Iterator it = buildCommands.iterator();
        while (it.hasNext()) {
            ((BuildCommand)it.next()).print((XMLWriter)writer);
        }
        writer.endElement();
        writer.startElement(ELT_NATURES);
        it = projectnatures.iterator();
        while (it.hasNext()) {
            writer.startElement(ELT_NATURE);
            writer.writeText((String)it.next());
            writer.endElement();
        }
        writer.endElement();
        boolean bl = addLinks = !this.config.getProjectBaseDir().equals(this.config.getEclipseProjectDirectory());
        if (addLinks || this.config.isPde() && dependencies.length > 0 || linkedResources.size() > 0) {
            writer.startElement(ELT_LINKED_RESOURCES);
            if (linkedResources.size() > 0) {
                Iterator it2 = linkedResources.iterator();
                while (it2.hasNext()) {
                    ((LinkedResource)it2.next()).print((XMLWriter)writer);
                }
            }
            if (addLinks) {
                this.addFileLink((XMLWriter)writer, this.config.getProjectBaseDir(), this.config.getEclipseProjectDirectory(), this.config.getProject().getFile());
                this.addSourceLinks((XMLWriter)writer, this.config.getProjectBaseDir(), this.config.getEclipseProjectDirectory(), this.config.getProject().getCompileSourceRoots());
                this.addResourceLinks((XMLWriter)writer, this.config.getProjectBaseDir(), this.config.getEclipseProjectDirectory(), this.config.getProject().getBuild().getResources());
                this.addSourceLinks((XMLWriter)writer, this.config.getProjectBaseDir(), this.config.getEclipseProjectDirectory(), this.config.getProject().getTestCompileSourceRoots());
                this.addResourceLinks((XMLWriter)writer, this.config.getProjectBaseDir(), this.config.getEclipseProjectDirectory(), this.config.getProject().getBuild().getTestResources());
            }
            if (this.config.isPde()) {
                for (int j = 0; j < dependencies.length; ++j) {
                    IdeDependency dep = dependencies[j];
                    if (!dep.isAddedToClasspath() || dep.isProvided() || dep.isReferencedProject() || dep.isTestDependency() || dep.isOsgiBundle()) continue;
                    String name = dep.getFile().getName();
                    this.addLink((XMLWriter)writer, name, IdeUtils.fixSeparator(IdeUtils.getCanonicalPath(dep.getFile())), 1);
                }
            }
            writer.endElement();
        }
        writer.endElement();
        IOUtil.close((Writer)w);
    }

    private void addFileLink(XMLWriter writer, File projectBaseDir, File basedir, File file) throws MojoExecutionException {
        if (file.isFile()) {
            String name = IdeUtils.toRelativeAndFixSeparator(projectBaseDir, file, true);
            String location = IdeUtils.fixSeparator(IdeUtils.getCanonicalPath(file));
            this.addLink(writer, name, location, 1);
        } else {
            this.log.warn((CharSequence)Messages.getString("EclipseProjectWriter.notafile", file));
        }
    }

    private void addSourceLinks(XMLWriter writer, File projectBaseDir, File basedir, List sourceRoots) throws MojoExecutionException {
        for (String sourceRootString : sourceRoots) {
            File sourceRoot = new File(sourceRootString);
            if (!sourceRoot.isDirectory()) continue;
            String name = IdeUtils.toRelativeAndFixSeparator(projectBaseDir, sourceRoot, true);
            String location = IdeUtils.fixSeparator(IdeUtils.getCanonicalPath(sourceRoot));
            this.addLink(writer, name, location, 2);
        }
    }

    private void addResourceLinks(XMLWriter writer, File projectBaseDir, File basedir, List sourceRoots) throws MojoExecutionException {
        Iterator it = sourceRoots.iterator();
        while (it.hasNext()) {
            String resourceDirString = ((Resource)it.next()).getDirectory();
            File resourceDir = new File(resourceDirString);
            if (!resourceDir.isDirectory()) continue;
            String name = IdeUtils.toRelativeAndFixSeparator(projectBaseDir, resourceDir, true);
            String location = IdeUtils.fixSeparator(IdeUtils.getCanonicalPath(resourceDir));
            this.addLink(writer, name, location, 2);
        }
    }

    private void addLink(XMLWriter writer, String name, String location, int type) {
        if (!this.linkNames.contains(name)) {
            writer.startElement(ELT_LINK);
            writer.startElement(ELT_NAME);
            writer.writeText(name);
            writer.endElement();
            writer.startElement("type");
            writer.writeText(Integer.toString(type));
            writer.endElement();
            writer.startElement("location");
            writer.writeText(location);
            writer.endElement();
            writer.endElement();
        }
    }

    private void addComment(XMLWriter writer, String projectDescription) {
        String comment = "";
        if (projectDescription != null && (comment = projectDescription.trim()).length() > 0) {
            if (!comment.endsWith(".")) {
                comment = comment + ".";
            }
            comment = comment + " ";
        }
        comment = comment + "NO_M2ECLIPSE_SUPPORT: Project files created with the maven-eclipse-plugin are not supported in M2Eclipse.";
        writer.startElement(ELT_COMMENT);
        writer.writeText(comment);
        writer.endElement();
    }
}

