/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.ear;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

public class HelpMojo
extends AbstractMojo {
    private boolean detail;
    private String goal;
    private int lineLength;
    private int indentSize;

    public void execute() throws MojoExecutionException {
        if (this.lineLength <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'lineLength' should be positive, using '80' as default.");
            this.lineLength = 80;
        }
        if (this.indentSize <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'indentSize' should be positive, using '2' as default.");
            this.indentSize = 2;
        }
        StringBuffer sb = new StringBuffer();
        this.append(sb, "org.apache.maven.plugins:maven-ear-plugin:2.4.2", 0);
        this.append(sb, "", 0);
        this.append(sb, "Maven EAR Plugin", 0);
        this.append(sb, "Generates a J2EE Enterprise Archive (EAR) file.", 1);
        this.append(sb, "", 0);
        if (this.goal == null || this.goal.length() <= 0) {
            this.append(sb, "This plugin has 3 goals:", 0);
            this.append(sb, "", 0);
        }
        if (this.goal == null || this.goal.length() <= 0 || "ear".equals(this.goal)) {
            this.append(sb, "ear:ear", 0);
            this.append(sb, "Builds J2EE Enteprise Archive (EAR) files.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "applicationXml", 2);
                this.append(sb, "The location of a custom application.xml file to be used within the ear file.", 3);
                this.append(sb, "", 0);
                this.append(sb, "archive", 2);
                this.append(sb, "The archive configuration to use. See Maven Archiver Reference.", 3);
                this.append(sb, "", 0);
                this.append(sb, "artifactTypeMappings", 2);
                this.append(sb, "The artifact type mappings.", 3);
                this.append(sb, "", 0);
                this.append(sb, "classifier", 2);
                this.append(sb, "Classifier to add to the artifact generated. If given, the artifact will be an attachment instead.", 3);
                this.append(sb, "", 0);
                this.append(sb, "defaultLibBundleDir", 2);
                this.append(sb, "The default bundle dir for libraries.", 3);
                this.append(sb, "", 0);
                this.append(sb, "earSourceDirectory", 2);
                this.append(sb, "Single directory for extra files to include in the EAR.", 3);
                this.append(sb, "", 0);
                this.append(sb, "earSourceExcludes", 2);
                this.append(sb, "The comma separated list of tokens to exclude from the EAR.", 3);
                this.append(sb, "", 0);
                this.append(sb, "earSourceIncludes (Default: **)", 2);
                this.append(sb, "The comma separated list of tokens to include in the EAR.", 3);
                this.append(sb, "", 0);
                this.append(sb, "encoding (Default: UTF-8)", 2);
                this.append(sb, "Character encoding for the auto-generated deployment file(s).", 3);
                this.append(sb, "", 0);
                this.append(sb, "escapedBackslashesInFilePath (Default: false)", 2);
                this.append(sb, "To escape interpolated value with windows path c:\\foo\\bar will be replaced with c:\\\\foo\\\\bar", 3);
                this.append(sb, "", 0);
                this.append(sb, "escapeString", 2);
                this.append(sb, "Expression preceded with the String won't be interpolated \\${foo} will be replaced with ${foo}", 3);
                this.append(sb, "", 0);
                this.append(sb, "fileNameMapping", 2);
                this.append(sb, "The file name mapping to use for all dependencies included in the EAR file.", 3);
                this.append(sb, "", 0);
                this.append(sb, "filtering (Default: false)", 2);
                this.append(sb, "Specify that the ear sources should be filtered.", 3);
                this.append(sb, "", 0);
                this.append(sb, "filters", 2);
                this.append(sb, "Filters (property files) to include during the interpolation of the pom.xml.", 3);
                this.append(sb, "", 0);
                this.append(sb, "finalName", 2);
                this.append(sb, "The name of the EAR file to generate.", 3);
                this.append(sb, "", 0);
                this.append(sb, "generatedDescriptorLocation", 2);
                this.append(sb, "Directory where the deployment descriptor file(s) will be auto-generated.", 3);
                this.append(sb, "", 0);
                this.append(sb, "includeLibInApplicationXml (Default: false)", 2);
                this.append(sb, "Should libraries be added in application.xml", 3);
                this.append(sb, "", 0);
                this.append(sb, "jboss", 2);
                this.append(sb, "The JBoss specific configuration.", 3);
                this.append(sb, "", 0);
                this.append(sb, "mainArtifactId", 2);
                this.append(sb, "The id to use to define the main artifact (e.g. the artifact without a classifier) when there is multiple candidates.", 3);
                this.append(sb, "", 0);
                this.append(sb, "manifestFile", 2);
                this.append(sb, "The location of the manifest file to be used within the ear file. If not value if specified, the default location in the workDirectory is taken. If the file does not exist, a manifest will be generated automatically.", 3);
                this.append(sb, "", 0);
                this.append(sb, "modules", 2);
                this.append(sb, "The ear modules configuration.", 3);
                this.append(sb, "", 0);
                this.append(sb, "nonFilteredFileExtensions", 2);
                this.append(sb, "A list of file extensions that should not be filtered if filtering is actived.", 3);
                this.append(sb, "", 0);
                this.append(sb, "outputDirectory", 2);
                this.append(sb, "The directory for the generated EAR.", 3);
                this.append(sb, "", 0);
                this.append(sb, "resourcesDir", 2);
                this.append(sb, "Deprecated. please use earSourcesDirectory instead", 3);
                this.append(sb, "", 0);
                this.append(sb, "The directory to get the resources from.", 3);
                this.append(sb, "", 0);
                this.append(sb, "unpackTypes", 2);
                this.append(sb, "The comma separated list of artifact's type(s) to unpack by default.", 3);
                this.append(sb, "", 0);
                this.append(sb, "version (Default: 1.3)", 2);
                this.append(sb, "The version of the application.xml to generate. Valid values are 1.3, 1.4, 5 and 6.", 3);
                this.append(sb, "", 0);
                this.append(sb, "workDirectory", 2);
                this.append(sb, "Directory that resources are copied to during the build.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "generate-application-xml".equals(this.goal)) {
            this.append(sb, "ear:generate-application-xml", 0);
            this.append(sb, "A Mojo that generates the EAR deployment descriptor file(s).", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "artifactTypeMappings", 2);
                this.append(sb, "The artifact type mappings.", 3);
                this.append(sb, "", 0);
                this.append(sb, "defaultLibBundleDir", 2);
                this.append(sb, "The default bundle dir for libraries.", 3);
                this.append(sb, "", 0);
                this.append(sb, "description", 2);
                this.append(sb, "Description of the application to be used when application.xml file is autogenerated.", 3);
                this.append(sb, "", 0);
                this.append(sb, "displayName", 2);
                this.append(sb, "Display name of the application to be used when application.xml file is autogenerated.", 3);
                this.append(sb, "", 0);
                this.append(sb, "encoding (Default: UTF-8)", 2);
                this.append(sb, "Character encoding for the auto-generated deployment file(s).", 3);
                this.append(sb, "", 0);
                this.append(sb, "fileNameMapping", 2);
                this.append(sb, "The file name mapping to use for all dependencies included in the EAR file.", 3);
                this.append(sb, "", 0);
                this.append(sb, "generateApplicationXml", 2);
                this.append(sb, "Whether the application.xml should be generated or not.", 3);
                this.append(sb, "", 0);
                this.append(sb, "generatedDescriptorLocation", 2);
                this.append(sb, "Directory where the deployment descriptor file(s) will be auto-generated.", 3);
                this.append(sb, "", 0);
                this.append(sb, "includeLibInApplicationXml (Default: false)", 2);
                this.append(sb, "Should libraries be added in application.xml", 3);
                this.append(sb, "", 0);
                this.append(sb, "jboss", 2);
                this.append(sb, "The JBoss specific configuration.", 3);
                this.append(sb, "", 0);
                this.append(sb, "mainArtifactId", 2);
                this.append(sb, "The id to use to define the main artifact (e.g. the artifact without a classifier) when there is multiple candidates.", 3);
                this.append(sb, "", 0);
                this.append(sb, "modules", 2);
                this.append(sb, "The ear modules configuration.", 3);
                this.append(sb, "", 0);
                this.append(sb, "security", 2);
                this.append(sb, "The security-roles to be added to the auto-generated application.xml file.", 3);
                this.append(sb, "", 0);
                this.append(sb, "version (Default: 1.3)", 2);
                this.append(sb, "The version of the application.xml to generate. Valid values are 1.3, 1.4, 5 and 6.", 3);
                this.append(sb, "", 0);
                this.append(sb, "workDirectory", 2);
                this.append(sb, "Directory that resources are copied to during the build.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "help".equals(this.goal)) {
            this.append(sb, "ear:help", 0);
            this.append(sb, "Display help information on maven-ear-plugin.\nCall\n\u00a0\u00a0mvn\u00a0ear:help\u00a0-Ddetail=true\u00a0-Dgoal=<goal-name>\nto display parameter details.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "detail (Default: false)", 2);
                this.append(sb, "If true, display all settable properties for each goal.", 3);
                this.append(sb, "", 0);
                this.append(sb, "goal", 2);
                this.append(sb, "The name of the goal for which to show help. If unspecified, all goals will be displayed.", 3);
                this.append(sb, "", 0);
                this.append(sb, "indentSize (Default: 2)", 2);
                this.append(sb, "The number of spaces per indentation level, should be positive.", 3);
                this.append(sb, "", 0);
                this.append(sb, "lineLength (Default: 80)", 2);
                this.append(sb, "The maximum length of a display line, should be positive.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((CharSequence)sb.toString());
        }
    }

    private static String repeat(String str, int repeat) {
        StringBuffer buffer = new StringBuffer(repeat * str.length());
        for (int i = 0; i < repeat; ++i) {
            buffer.append(str);
        }
        return buffer.toString();
    }

    private void append(StringBuffer sb, String description, int indent) {
        Iterator it = HelpMojo.toLines(description, indent, this.indentSize, this.lineLength).iterator();
        while (it.hasNext()) {
            sb.append(it.next().toString()).append('\n');
        }
    }

    private static List toLines(String text, int indent, int indentSize, int lineLength) {
        ArrayList lines = new ArrayList();
        String ind = HelpMojo.repeat("\t", indent);
        String[] plainLines = text.split("(\r\n)|(\r)|(\n)");
        for (int i = 0; i < plainLines.length; ++i) {
            HelpMojo.toLines(lines, ind + plainLines[i], indentSize, lineLength);
        }
        return lines;
    }

    private static void toLines(List lines, String line, int indentSize, int lineLength) {
        int lineIndent = HelpMojo.getIndentLevel(line);
        StringBuffer buf = new StringBuffer(256);
        String[] tokens = line.split(" +");
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i];
            if (i > 0) {
                if (buf.length() + token.length() >= lineLength) {
                    lines.add(buf.toString());
                    buf.setLength(0);
                    buf.append(HelpMojo.repeat(" ", lineIndent * indentSize));
                } else {
                    buf.append(' ');
                }
            }
            for (int j = 0; j < token.length(); ++j) {
                char c = token.charAt(j);
                if (c == '\t') {
                    buf.append(HelpMojo.repeat(" ", indentSize - buf.length() % indentSize));
                    continue;
                }
                if (c == '\u00a0') {
                    buf.append(' ');
                    continue;
                }
                buf.append(c);
            }
        }
        lines.add(buf.toString());
    }

    private static int getIndentLevel(String line) {
        int i;
        int level = 0;
        for (i = 0; i < line.length() && line.charAt(i) == '\t'; ++i) {
            ++level;
        }
        for (i = level + 1; i <= level + 4 && i < line.length(); ++i) {
            if (line.charAt(i) != '\t') continue;
            ++level;
            break;
        }
        return level;
    }
}

