/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.checkstyle;

import java.util.List;
import org.apache.maven.plugin.checkstyle.AbstractCheckstyleReport;
import org.apache.maven.plugin.checkstyle.exec.CheckstyleExecutorRequest;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.reporting.MavenReportException;

@Mojo(name="checkstyle-aggregate", aggregator=true, requiresDependencyResolution=ResolutionScope.COMPILE, threadSafe=true)
public class CheckstyleAggregateReport
extends AbstractCheckstyleReport {
    @Parameter(property="reactorProjects", readonly=true)
    private List<MavenProject> reactorProjects;

    protected MavenProject getProject() {
        return this.project;
    }

    protected CheckstyleExecutorRequest createRequest() throws MavenReportException {
        CheckstyleExecutorRequest request = new CheckstyleExecutorRequest();
        request.setAggregate(true).setReactorProjects(this.reactorProjects).setConsoleListener(this.getConsoleListener()).setConsoleOutput(this.consoleOutput).setExcludes(this.excludes).setFailsOnError(this.failsOnError).setIncludes(this.includes).setIncludeResources(this.includeResources).setIncludeTestResources(this.includeTestResources).setResourceIncludes(this.resourceIncludes).setResourceExcludes(this.resourceExcludes).setIncludeTestSourceDirectory(this.includeTestSourceDirectory).setListener(this.getListener()).setLog(this.getLog()).setProject(this.project).setSourceDirectories(this.getSourceDirectories()).setResources(this.resources).setTestResources(this.testResources).setStringOutputStream(this.stringOutputStream).setSuppressionsLocation(this.suppressionsLocation).setTestSourceDirectories(this.getTestSourceDirectories()).setConfigLocation(this.configLocation).setPropertyExpansion(this.propertyExpansion).setHeaderLocation(this.headerLocation).setCacheFile(this.cacheFile).setSuppressionsFileExpression(this.suppressionsFileExpression).setEncoding(this.encoding).setPropertiesLocation(this.propertiesLocation);
        return request;
    }

    public String getOutputName() {
        return "checkstyle-aggregate";
    }

    public boolean canGenerateReport() {
        return !this.skip && this.project.isExecutionRoot() && this.reactorProjects.size() > 1;
    }
}

