/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.changes.schema;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.apache.commons.io.input.XmlStreamReader;
import org.apache.maven.plugin.changes.schema.ChangesSchemaValidator;
import org.apache.maven.plugin.changes.schema.SchemaValidatorException;
import org.apache.maven.plugin.changes.schema.XmlValidationHandler;
import org.codehaus.plexus.util.IOUtil;
import org.xml.sax.SAXException;

public class DefaultChangesSchemaValidator
implements ChangesSchemaValidator {
    public static final String W3C_XML_SCHEMA = "http://www.w3.org/2001/XMLSchema";
    public static final String CHANGES_SCHEMA_PATH = "META-INF/changes/xsd/";
    private Map<String, Schema> compiledSchemas = new HashMap<String, Schema>();

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public XmlValidationHandler validateXmlWithSchema(File file, String schemaVersion, boolean failOnValidationError) throws SchemaValidatorException {
        XmlValidationHandler xmlValidationHandler;
        XmlStreamReader reader = null;
        try {
            String schemaPath = "META-INF/changes/xsd/changes-" + schemaVersion + ".xsd";
            Schema schema = this.getSchema(schemaPath);
            Validator validator = schema.newValidator();
            XmlValidationHandler baseHandler = new XmlValidationHandler(failOnValidationError);
            validator.setErrorHandler(baseHandler);
            reader = new XmlStreamReader(file);
            validator.validate(new StreamSource((Reader)reader));
            reader.close();
            reader = null;
            xmlValidationHandler = baseHandler;
        }
        catch (IOException e) {
            try {
                throw new SchemaValidatorException("IOException : " + e.getMessage(), e);
                catch (SAXException e2) {
                    throw new SchemaValidatorException("SAXException : " + e2.getMessage(), e2);
                }
                catch (Exception e3) {
                    throw new SchemaValidatorException("Exception : " + e3.getMessage(), e3);
                }
            }
            catch (Throwable throwable) {
                IOUtil.close(reader);
                throw throwable;
            }
        }
        IOUtil.close((Reader)reader);
        return xmlValidationHandler;
    }

    public Schema getSchema(String schemaPath) throws SAXException, IOException {
        if (this.compiledSchemas.containsKey(schemaPath)) {
            return this.compiledSchemas.get(schemaPath);
        }
        Schema schema = this.compileJAXPSchema(schemaPath);
        this.compiledSchemas.put(schemaPath, schema);
        return schema;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Schema compileJAXPSchema(String uriSchema) throws IOException, SAXException, NullPointerException {
        Schema schema;
        InputStream in = null;
        try {
            in = Thread.currentThread().getContextClassLoader().getResourceAsStream(uriSchema);
            if (in == null) {
                throw new NullPointerException(" impossible to load schema with path " + uriSchema);
            }
            Schema schema2 = SchemaFactory.newInstance(W3C_XML_SCHEMA).newSchema(new StreamSource(in));
            in.close();
            in = null;
            schema = schema2;
        }
        catch (Throwable throwable) {
            IOUtil.close(in);
            throw throwable;
        }
        IOUtil.close((InputStream)in);
        return schema;
    }

    public void loadSchema(String uriSchema) throws SchemaValidatorException {
        try {
            this.getSchema(uriSchema);
        }
        catch (SAXException e) {
            throw new SchemaValidatorException("SAXException : " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new SchemaValidatorException("IOException : " + e.getMessage(), e);
        }
    }
}

