/*
 * $Id$
 */

package org.apache.maven.model;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.util.*;
import java.util.List;

/**
 * Class Plugin.
 * 
 * @version $Revision$ $Date$
 */
public class Plugin extends ConfigurationContainer 
implements java.io.Serializable
{


      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * Field groupId
     */
    private String groupId = "org.apache.maven.plugins";

    /**
     * Field artifactId
     */
    private String artifactId;

    /**
     * Field version
     */
    private String version;

    /**
     * Field extensions
     */
    private boolean extensions = false;

    /**
     * Field executions
     */
    private java.util.List executions;

    /**
     * Field dependencies
     */
    private java.util.List dependencies;

    /**
     * Field goals
     */
    private Object goals;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method addDependency
     * 
     * @param dependency
     */
    public void addDependency(Dependency dependency)
    {
        getDependencies().add( dependency );
    } //-- void addDependency(Dependency) 

    /**
     * Method addExecution
     * 
     * @param pluginExecution
     */
    public void addExecution(PluginExecution pluginExecution)
    {
        getExecutions().add( pluginExecution );
    } //-- void addExecution(PluginExecution) 

    /**
     * Method getArtifactId
     */
    public String getArtifactId()
    {
        return this.artifactId;
    } //-- String getArtifactId() 

    /**
     * Method getDependencies
     */
    public java.util.List getDependencies()
    {
        if ( this.dependencies == null )
        {
            this.dependencies = new java.util.ArrayList();
        }
        
        return this.dependencies;
    } //-- java.util.List getDependencies() 

    /**
     * Method getExecutions
     */
    public java.util.List getExecutions()
    {
        if ( this.executions == null )
        {
            this.executions = new java.util.ArrayList();
        }
        
        return this.executions;
    } //-- java.util.List getExecutions() 

    /**
     * Method getGoals
     */
    public Object getGoals()
    {
        return this.goals;
    } //-- Object getGoals() 

    /**
     * Method getGroupId
     */
    public String getGroupId()
    {
        return this.groupId;
    } //-- String getGroupId() 

    /**
     * Method getVersion
     */
    public String getVersion()
    {
        return this.version;
    } //-- String getVersion() 

    /**
     * Method isExtensions
     */
    public boolean isExtensions()
    {
        return this.extensions;
    } //-- boolean isExtensions() 

    /**
     * Method removeDependency
     * 
     * @param dependency
     */
    public void removeDependency(Dependency dependency)
    {
        getDependencies().remove( dependency );
    } //-- void removeDependency(Dependency) 

    /**
     * Method removeExecution
     * 
     * @param pluginExecution
     */
    public void removeExecution(PluginExecution pluginExecution)
    {
        getExecutions().remove( pluginExecution );
    } //-- void removeExecution(PluginExecution) 

    /**
     * Method setArtifactId
     * 
     * @param artifactId
     */
    public void setArtifactId(String artifactId)
    {
        this.artifactId = artifactId;
    } //-- void setArtifactId(String) 

    /**
     * Method setDependencies
     * 
     * @param dependencies
     */
    public void setDependencies(java.util.List dependencies)
    {
        this.dependencies = dependencies;
    } //-- void setDependencies(java.util.List) 

    /**
     * Method setExecutions
     * 
     * @param executions
     */
    public void setExecutions(java.util.List executions)
    {
        this.executions = executions;
    } //-- void setExecutions(java.util.List) 

    /**
     * Method setExtensions
     * 
     * @param extensions
     */
    public void setExtensions(boolean extensions)
    {
        this.extensions = extensions;
    } //-- void setExtensions(boolean) 

    /**
     * Method setGoals
     * 
     * @param goals
     */
    public void setGoals(Object goals)
    {
        this.goals = goals;
    } //-- void setGoals(Object) 

    /**
     * Method setGroupId
     * 
     * @param groupId
     */
    public void setGroupId(String groupId)
    {
        this.groupId = groupId;
    } //-- void setGroupId(String) 

    /**
     * Method setVersion
     * 
     * @param version
     */
    public void setVersion(String version)
    {
        this.version = version;
    } //-- void setVersion(String) 


    private java.util.Map executionMap = null;
    
    public void flushExecutionMap()
    {
        this.executionMap = null;
    }

    public java.util.Map getExecutionsAsMap()
    {
        if ( executionMap == null )
        {
            executionMap = new java.util.HashMap();
            if ( getExecutions() != null )
            {
                for ( java.util.Iterator i = getExecutions().iterator(); i.hasNext(); )
                {
                    PluginExecution exec = (PluginExecution) i.next();
                    
                    if ( executionMap.containsKey( exec.getId() ) )
                    {
                        throw new IllegalStateException( "You cannot have two plugin executions with the same (or missing) <id/> elements.\nOffending execution\n\nId: \'" + exec.getId() + "\'\nPlugin:\'" + getKey() + "\'\n\n" );
                    }
                    
                    executionMap.put( exec.getId(), exec );
                }
            }
        }
        
        return executionMap;
    }
    
    public String getKey()
    {
        return constructKey( groupId, artifactId );
    }

    public static String constructKey( String groupId, String artifactId )
    {
        return groupId + ":" + artifactId;
    }
          }
