/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.model.validation;

import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.maven.model.Build;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.DistributionManagement;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.model.PluginManagement;
import org.apache.maven.model.Profile;
import org.apache.maven.model.ReportPlugin;
import org.apache.maven.model.Reporting;
import org.apache.maven.model.Repository;
import org.apache.maven.model.Resource;
import org.apache.maven.model.building.ModelBuildingRequest;
import org.apache.maven.model.building.ModelProblem;
import org.apache.maven.model.building.ModelProblemCollector;
import org.apache.maven.model.validation.ModelValidator;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(role=ModelValidator.class)
public class DefaultModelValidator
implements ModelValidator {
    private static final String ID_REGEX = "[A-Za-z0-9_\\-.]+";

    @Override
    public void validateRawModel(Model model, ModelBuildingRequest request, ModelProblemCollector problems) {
        Parent parent = model.getParent();
        if (parent != null) {
            this.validateStringNotEmpty("parent.groupId", problems, ModelProblem.Severity.FATAL, parent.getGroupId());
            this.validateStringNotEmpty("parent.artifactId", problems, ModelProblem.Severity.FATAL, parent.getArtifactId());
            this.validateStringNotEmpty("parent.version", problems, ModelProblem.Severity.FATAL, parent.getVersion());
            if (DefaultModelValidator.equals(parent.getGroupId(), model.getGroupId()) && DefaultModelValidator.equals(parent.getArtifactId(), model.getArtifactId())) {
                DefaultModelValidator.addViolation(problems, ModelProblem.Severity.FATAL, "parent.artifactId", null, "must be changed, the parent element cannot have the same groupId:artifactId as the project.");
            }
        }
        if (request.getValidationLevel() >= 20) {
            ModelProblem.Severity errOn30 = DefaultModelValidator.getSeverity(request, 30);
            this.validateEnum("modelVersion", problems, ModelProblem.Severity.ERROR, model.getModelVersion(), null, "4.0.0");
            this.validateStringNoExpression("groupId", problems, ModelProblem.Severity.WARNING, model.getGroupId());
            this.validateStringNoExpression("artifactId", problems, ModelProblem.Severity.WARNING, model.getArtifactId());
            this.validateStringNoExpression("version", problems, ModelProblem.Severity.WARNING, model.getVersion());
            this.validateRawDependencies(problems, model.getDependencies(), "dependencies.dependency", request);
            if (model.getDependencyManagement() != null) {
                this.validateRawDependencies(problems, model.getDependencyManagement().getDependencies(), "dependencyManagement.dependencies.dependency", request);
            }
            this.validateRepositories(problems, model.getRepositories(), "repositories.repository", request);
            this.validateRepositories(problems, model.getPluginRepositories(), "pluginRepositories.pluginRepository", request);
            Build build = model.getBuild();
            if (build != null) {
                this.validateRawPlugins(problems, build.getPlugins(), false, request);
                PluginManagement mngt = build.getPluginManagement();
                if (mngt != null) {
                    this.validateRawPlugins(problems, mngt.getPlugins(), true, request);
                }
            }
            HashSet<String> profileIds = new HashSet<String>();
            for (Profile profile : model.getProfiles()) {
                if (!profileIds.add(profile.getId())) {
                    DefaultModelValidator.addViolation(problems, errOn30, "profiles.profile.id", null, "must be unique but found duplicate profile with id " + profile.getId());
                }
                this.validateRawDependencies(problems, profile.getDependencies(), "profiles.profile[" + profile.getId() + "].dependencies.dependency", request);
                if (profile.getDependencyManagement() != null) {
                    this.validateRawDependencies(problems, profile.getDependencyManagement().getDependencies(), "profiles.profile[" + profile.getId() + "].dependencyManagement.dependencies.dependency", request);
                }
                this.validateRepositories(problems, profile.getRepositories(), "profiles.profile[" + profile.getId() + "].repositories.repository", request);
                this.validateRepositories(problems, profile.getPluginRepositories(), "profiles.profile[" + profile.getId() + "].pluginRepositories.pluginRepository", request);
            }
        }
    }

    private void validateRawPlugins(ModelProblemCollector problems, List<Plugin> plugins, boolean managed, ModelBuildingRequest request) {
        ModelProblem.Severity errOn31 = DefaultModelValidator.getSeverity(request, 31);
        String prefix = (managed ? "build.pluginManagement." : "build.") + "plugins.plugin.";
        HashMap<String, Plugin> index = new HashMap<String, Plugin>();
        for (Plugin plugin : plugins) {
            String key = plugin.getKey();
            Plugin existing = (Plugin)index.get(key);
            if (existing != null) {
                DefaultModelValidator.addViolation(problems, errOn31, prefix + "(groupId:artifactId)", null, "must be unique but found duplicate declaration of plugin " + key);
            } else {
                index.put(key, plugin);
            }
            HashSet<String> executionIds = new HashSet<String>();
            for (PluginExecution exec : plugin.getExecutions()) {
                if (executionIds.add(exec.getId())) continue;
                DefaultModelValidator.addViolation(problems, ModelProblem.Severity.ERROR, "build.plugins.plugin[" + plugin.getKey() + "].executions.execution.id", null, "must be unique but found duplicate execution with id " + exec.getId());
            }
        }
    }

    @Override
    public void validateEffectiveModel(Model model, ModelBuildingRequest request, ModelProblemCollector problems) {
        this.validateStringNotEmpty("modelVersion", problems, ModelProblem.Severity.ERROR, model.getModelVersion());
        this.validateId("groupId", problems, model.getGroupId());
        this.validateId("artifactId", problems, model.getArtifactId());
        this.validateStringNotEmpty("packaging", problems, ModelProblem.Severity.ERROR, model.getPackaging());
        if (!model.getModules().isEmpty()) {
            if (!"pom".equals(model.getPackaging())) {
                DefaultModelValidator.addViolation(problems, ModelProblem.Severity.ERROR, "packaging", null, "with value '" + model.getPackaging() + "' is invalid. Aggregator projects " + "require 'pom' as packaging.");
            }
            int n = model.getModules().size();
            for (int i = 0; i < n; ++i) {
                String module = (String)model.getModules().get(i);
                if (!StringUtils.isBlank((String)module)) continue;
                DefaultModelValidator.addViolation(problems, ModelProblem.Severity.WARNING, "modules.module[" + i + "]", null, "has been specified without a path to the project directory.");
            }
        }
        this.validateStringNotEmpty("version", problems, ModelProblem.Severity.ERROR, model.getVersion());
        ModelProblem.Severity errOn30 = DefaultModelValidator.getSeverity(request, 30);
        this.validateEffectiveDependencies(problems, model.getDependencies(), false, request);
        DependencyManagement mgmt = model.getDependencyManagement();
        if (mgmt != null) {
            this.validateEffectiveDependencies(problems, mgmt.getDependencies(), true, request);
        }
        if (request.getValidationLevel() >= 20) {
            Reporting reporting;
            HashSet<String> modules = new HashSet<String>();
            int n = model.getModules().size();
            for (int i = 0; i < n; ++i) {
                String module = (String)model.getModules().get(i);
                if (modules.add(module)) continue;
                DefaultModelValidator.addViolation(problems, ModelProblem.Severity.ERROR, "modules.module[" + i + "]", null, "specifies duplicate child module " + module);
            }
            ModelProblem.Severity errOn31 = DefaultModelValidator.getSeverity(request, 31);
            Build build = model.getBuild();
            if (build != null) {
                for (Plugin p : build.getPlugins()) {
                    this.validateStringNotEmpty("build.plugins.plugin.artifactId", problems, ModelProblem.Severity.ERROR, p.getArtifactId());
                    this.validateStringNotEmpty("build.plugins.plugin.groupId", problems, ModelProblem.Severity.ERROR, p.getGroupId());
                    this.validatePluginVersion("build.plugins.plugin.version", problems, p.getVersion(), p.getKey(), request);
                    this.validateBoolean("build.plugins.plugin.inherited", problems, errOn30, p.getInherited(), p.getKey());
                    this.validateBoolean("build.plugins.plugin.extensions", problems, errOn30, p.getExtensions(), p.getKey());
                    for (Dependency d : p.getDependencies()) {
                        this.validateEnum("build.plugins.plugin[" + p.getKey() + "].dependencies.dependency.scope", problems, errOn30, d.getScope(), d.getManagementKey(), "compile", "runtime", "system");
                    }
                }
                this.validateResources(problems, build.getResources(), "build.resources.resource", request);
                this.validateResources(problems, build.getTestResources(), "build.testResources.testResource", request);
            }
            if ((reporting = model.getReporting()) != null) {
                for (ReportPlugin p : reporting.getPlugins()) {
                    this.validateStringNotEmpty("reporting.plugins.plugin.artifactId", problems, ModelProblem.Severity.ERROR, p.getArtifactId());
                    this.validateStringNotEmpty("reporting.plugins.plugin.groupId", problems, ModelProblem.Severity.ERROR, p.getGroupId());
                    this.validateStringNotEmpty("reporting.plugins.plugin.version", problems, errOn31, p.getVersion(), p.getKey());
                }
            }
            for (Repository repository : model.getRepositories()) {
                this.validateRepository(problems, repository, "repositories.repository", request);
            }
            for (Repository repository : model.getPluginRepositories()) {
                this.validateRepository(problems, repository, "pluginRepositories.pluginRepository", request);
            }
            DistributionManagement distMgmt = model.getDistributionManagement();
            if (distMgmt != null) {
                if (distMgmt.getStatus() != null) {
                    DefaultModelValidator.addViolation(problems, ModelProblem.Severity.ERROR, "distributionManagement.status", null, "must not be specified.");
                }
                this.validateRepository(problems, (Repository)distMgmt.getRepository(), "distributionManagement.repository", request);
                this.validateRepository(problems, (Repository)distMgmt.getSnapshotRepository(), "distributionManagement.snapshotRepository", request);
            }
        }
    }

    private void validateRawDependencies(ModelProblemCollector problems, List<Dependency> dependencies, String prefix, ModelBuildingRequest request) {
        ModelProblem.Severity errOn30 = DefaultModelValidator.getSeverity(request, 30);
        ModelProblem.Severity errOn31 = DefaultModelValidator.getSeverity(request, 31);
        HashMap<String, Dependency> index = new HashMap<String, Dependency>();
        for (Dependency dependency : dependencies) {
            String sysPath;
            String key = dependency.getManagementKey();
            if ("pom".equals(dependency.getType()) && "import".equals(dependency.getScope()) && StringUtils.isNotEmpty((String)dependency.getClassifier())) {
                DefaultModelValidator.addViolation(problems, errOn30, prefix + ".classifier", key, "must be empty, imported POM cannot have a classifier.");
            } else if ("system".equals(dependency.getScope()) && StringUtils.isNotEmpty((String)(sysPath = dependency.getSystemPath())) && !this.hasExpression(sysPath)) {
                DefaultModelValidator.addViolation(problems, ModelProblem.Severity.WARNING, prefix + ".systemPath", key, "should use a variable instead of a hard-coded path " + sysPath);
            }
            Dependency existing = (Dependency)index.get(key);
            if (existing != null) {
                String msg = DefaultModelValidator.equals(existing.getVersion(), dependency.getVersion()) ? "duplicate declaration of version " + StringUtils.defaultString((Object)dependency.getVersion(), (String)"(?)") : "version " + StringUtils.defaultString((Object)existing.getVersion(), (String)"(?)") + " vs " + StringUtils.defaultString((Object)dependency.getVersion(), (String)"(?)");
                DefaultModelValidator.addViolation(problems, errOn31, prefix + ".(groupId:artifactId:type:classifier)", null, "must be unique: " + key + " -> " + msg);
                continue;
            }
            index.put(key, dependency);
        }
    }

    private void validateEffectiveDependencies(ModelProblemCollector problems, List<Dependency> dependencies, boolean managed, ModelBuildingRequest request) {
        ModelProblem.Severity errOn30 = DefaultModelValidator.getSeverity(request, 30);
        String prefix = managed ? "dependencyManagement.dependencies.dependency." : "dependencies.dependency.";
        for (Dependency d : dependencies) {
            this.validateId(prefix + "artifactId", problems, d.getArtifactId(), d.getManagementKey());
            this.validateId(prefix + "groupId", problems, d.getGroupId(), d.getManagementKey());
            if (!managed) {
                this.validateStringNotEmpty(prefix + "type", problems, ModelProblem.Severity.ERROR, d.getType(), d.getManagementKey());
                this.validateStringNotEmpty(prefix + "version", problems, ModelProblem.Severity.ERROR, d.getVersion(), d.getManagementKey());
            }
            if ("system".equals(d.getScope())) {
                String systemPath = d.getSystemPath();
                if (StringUtils.isEmpty((String)systemPath)) {
                    DefaultModelValidator.addViolation(problems, ModelProblem.Severity.ERROR, prefix + "systemPath", d.getManagementKey(), "is missing.");
                } else {
                    File sysFile = new File(systemPath);
                    if (!sysFile.isAbsolute()) {
                        DefaultModelValidator.addViolation(problems, ModelProblem.Severity.ERROR, prefix + "systemPath", d.getManagementKey(), "must specify an absolute path but is " + systemPath);
                    } else if (!sysFile.isFile()) {
                        String jdkHome;
                        String msg = "refers to a non-existing file " + sysFile.getAbsolutePath();
                        if ((systemPath = systemPath.replace('/', File.separatorChar).replace('\\', File.separatorChar)).startsWith(jdkHome = request.getSystemProperties().getProperty("java.home", "") + File.separator + "..")) {
                            msg = msg + ". Please verify that you run Maven using a JDK and not just a JRE.";
                        }
                        DefaultModelValidator.addViolation(problems, ModelProblem.Severity.WARNING, prefix + "systemPath", d.getManagementKey(), msg);
                    }
                }
            } else if (StringUtils.isNotEmpty((String)d.getSystemPath())) {
                DefaultModelValidator.addViolation(problems, ModelProblem.Severity.ERROR, prefix + "systemPath", d.getManagementKey(), "must be omitted. This field may only be specified for a dependency with system scope.");
            }
            if (request.getValidationLevel() < 20) continue;
            this.validateBoolean(prefix + "optional", problems, errOn30, d.getOptional(), d.getManagementKey());
            if (managed) continue;
            this.validateVersion(prefix + "version", problems, errOn30, d.getVersion(), d.getManagementKey());
            this.validateEnum(prefix + "scope", problems, ModelProblem.Severity.WARNING, d.getScope(), d.getManagementKey(), "provided", "compile", "runtime", "test", "system");
        }
    }

    private void validateRepositories(ModelProblemCollector problems, List<Repository> repositories, String prefix, ModelBuildingRequest request) {
        HashMap<String, Repository> index = new HashMap<String, Repository>();
        for (Repository repository : repositories) {
            this.validateStringNotEmpty(prefix + ".id", problems, ModelProblem.Severity.ERROR, repository.getId());
            this.validateStringNotEmpty(prefix + "[" + repository.getId() + "].url", problems, ModelProblem.Severity.ERROR, repository.getUrl());
            String key = repository.getId();
            Repository existing = (Repository)index.get(key);
            if (existing != null) {
                ModelProblem.Severity errOn30 = DefaultModelValidator.getSeverity(request, 30);
                DefaultModelValidator.addViolation(problems, errOn30, prefix + ".id", null, "must be unique: " + repository.getId() + " -> " + existing.getUrl() + " vs " + repository.getUrl());
                continue;
            }
            index.put(key, repository);
        }
    }

    private void validateRepository(ModelProblemCollector problems, Repository repository, String prefix, ModelBuildingRequest request) {
        if (repository != null) {
            if ("local".equals(repository.getId())) {
                DefaultModelValidator.addViolation(problems, ModelProblem.Severity.ERROR, prefix + ".id", null, "must not be 'local', this identifier is reserved.");
            }
            if ("legacy".equals(repository.getLayout())) {
                DefaultModelValidator.addViolation(problems, ModelProblem.Severity.WARNING, prefix + ".layout", repository.getId(), "uses the deprecated value 'legacy'.");
            }
        }
    }

    private void validateResources(ModelProblemCollector problems, List<Resource> resources, String prefix, ModelBuildingRequest request) {
        ModelProblem.Severity errOn30 = DefaultModelValidator.getSeverity(request, 30);
        for (Resource resource : resources) {
            this.validateStringNotEmpty(prefix + ".directory", problems, ModelProblem.Severity.ERROR, resource.getDirectory());
            this.validateBoolean(prefix + ".filtering", problems, errOn30, resource.getFiltering(), resource.getDirectory());
        }
    }

    private boolean validateId(String fieldName, ModelProblemCollector problems, String id) {
        return this.validateId(fieldName, problems, id, null);
    }

    private boolean validateId(String fieldName, ModelProblemCollector problems, String id, String sourceHint) {
        if (!this.validateStringNotEmpty(fieldName, problems, ModelProblem.Severity.ERROR, id, sourceHint)) {
            return false;
        }
        boolean match = id.matches(ID_REGEX);
        if (!match) {
            DefaultModelValidator.addViolation(problems, ModelProblem.Severity.ERROR, fieldName, sourceHint, "with value '" + id + "' does not match a valid id pattern.");
        }
        return match;
    }

    private boolean validateStringNoExpression(String fieldName, ModelProblemCollector problems, ModelProblem.Severity severity, String string) {
        if (!this.hasExpression(string)) {
            return true;
        }
        DefaultModelValidator.addViolation(problems, severity, fieldName, null, "contains an expression but should be a constant.");
        return false;
    }

    private boolean hasExpression(String value) {
        return value != null && value.indexOf("${") >= 0;
    }

    private boolean validateStringNotEmpty(String fieldName, ModelProblemCollector problems, ModelProblem.Severity severity, String string) {
        return this.validateStringNotEmpty(fieldName, problems, severity, string, null);
    }

    private boolean validateStringNotEmpty(String fieldName, ModelProblemCollector problems, ModelProblem.Severity severity, String string, String sourceHint) {
        if (!this.validateNotNull(fieldName, problems, severity, string, sourceHint)) {
            return false;
        }
        if (string.length() > 0) {
            return true;
        }
        DefaultModelValidator.addViolation(problems, severity, fieldName, sourceHint, "is missing.");
        return false;
    }

    private boolean validateNotNull(String fieldName, ModelProblemCollector problems, ModelProblem.Severity severity, Object object, String sourceHint) {
        if (object != null) {
            return true;
        }
        DefaultModelValidator.addViolation(problems, severity, fieldName, sourceHint, "is missing.");
        return false;
    }

    private boolean validateBoolean(String fieldName, ModelProblemCollector problems, ModelProblem.Severity severity, String string, String sourceHint) {
        if (string == null || string.length() <= 0) {
            return true;
        }
        if ("true".equalsIgnoreCase(string) || "false".equalsIgnoreCase(string)) {
            return true;
        }
        DefaultModelValidator.addViolation(problems, severity, fieldName, sourceHint, "must be 'true' or 'false' but is '" + string + "'.");
        return false;
    }

    private boolean validateEnum(String fieldName, ModelProblemCollector problems, ModelProblem.Severity severity, String string, String sourceHint, String ... validValues) {
        if (string == null || string.length() <= 0) {
            return true;
        }
        List<String> values = Arrays.asList(validValues);
        if (values.contains(string)) {
            return true;
        }
        DefaultModelValidator.addViolation(problems, severity, fieldName, sourceHint, "must be one of " + values + " but is '" + string + "'.");
        return false;
    }

    private boolean validateVersion(String fieldName, ModelProblemCollector problems, ModelProblem.Severity severity, String string, String sourceHint) {
        if (string == null || string.length() <= 0) {
            return true;
        }
        if (!this.hasExpression(string)) {
            return true;
        }
        DefaultModelValidator.addViolation(problems, severity, fieldName, sourceHint, "must be a valid version but is '" + string + "'.");
        return false;
    }

    private boolean validatePluginVersion(String fieldName, ModelProblemCollector problems, String string, String sourceHint, ModelBuildingRequest request) {
        ModelProblem.Severity errOn30 = DefaultModelValidator.getSeverity(request, 30);
        if (string == null) {
            return true;
        }
        if (!(string.length() <= 0 || this.hasExpression(string) || "RELEASE".equals(string) || "LATEST".equals(string))) {
            return true;
        }
        DefaultModelValidator.addViolation(problems, errOn30, fieldName, sourceHint, "must be a valid version but is '" + string + "'.");
        return false;
    }

    private static void addViolation(ModelProblemCollector problems, ModelProblem.Severity severity, String fieldName, String sourceHint, String message) {
        StringBuilder buffer = new StringBuilder(256);
        buffer.append('\'').append(fieldName).append('\'');
        if (sourceHint != null) {
            buffer.append(" for ").append(sourceHint);
        }
        buffer.append(' ').append(message);
        DefaultModelValidator.addViolation(problems, severity, buffer.toString());
    }

    private static void addViolation(ModelProblemCollector problems, ModelProblem.Severity severity, String message) {
        problems.add(severity, message, null);
    }

    private static boolean equals(String s1, String s2) {
        return StringUtils.clean((String)s1).equals(StringUtils.clean((String)s2));
    }

    private static ModelProblem.Severity getSeverity(ModelBuildingRequest request, int errorThreshold) {
        return DefaultModelValidator.getSeverity(request.getValidationLevel(), errorThreshold);
    }

    private static ModelProblem.Severity getSeverity(int validationLevel, int errorThreshold) {
        if (validationLevel < errorThreshold) {
            return ModelProblem.Severity.WARNING;
        }
        return ModelProblem.Severity.ERROR;
    }
}

