/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.docrenderer.pdf.itext;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.maven.doxia.docrenderer.DocumentRendererException;
import org.apache.maven.doxia.docrenderer.pdf.AbstractPdfRenderer;
import org.apache.maven.doxia.document.DocumentModel;
import org.apache.maven.doxia.module.itext.ITextSink;
import org.apache.maven.doxia.module.itext.ITextSinkFactory;
import org.apache.maven.doxia.module.itext.ITextUtil;
import org.apache.maven.doxia.module.site.SiteModule;
import org.apache.maven.doxia.sink.Sink;
import org.apache.xml.utils.DefaultErrorHandler;
import org.codehaus.plexus.util.WriterFactory;
import org.codehaus.plexus.util.xml.XmlStreamWriter;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class ITextPdfRenderer
extends AbstractPdfRenderer {
    private static final String XSLT_RESOURCE = "org/apache/maven/doxia/docrenderer/itext/xslt/TOC.xslt";
    private static final TransformerFactory TRANSFORMER_FACTORY = TransformerFactory.newInstance();
    private static final DocumentBuilderFactory DOCUMENT_BUILDER_FACTORY = DocumentBuilderFactory.newInstance();

    public void generatePdf(File iTextFile, File pdfFile) throws DocumentRendererException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Generating : " + pdfFile);
        }
        try {
            ITextUtil.writePdf((InputStream)new FileInputStream(iTextFile), (OutputStream)new FileOutputStream(pdfFile));
        }
        catch (IOException e) {
            throw new DocumentRendererException("Cannot create PDF from " + iTextFile + ": " + e.getMessage(), e);
        }
        catch (RuntimeException e) {
            throw new DocumentRendererException("Error creating PDF from " + iTextFile + ": " + e.getMessage(), e);
        }
    }

    public void render(Map filesToProcess, File outputDirectory, DocumentModel documentModel) throws DocumentRendererException, IOException {
        String outputName = documentModel.getOutputName();
        if (outputName == null) {
            if (this.getLogger().isInfoEnabled()) {
                this.getLogger().info("No outputName is defined in the document descriptor. Using 'target.pdf'");
            }
            documentModel.setOutputName("target");
        } else if (outputName.lastIndexOf(".") != -1) {
            documentModel.setOutputName(outputName.substring(0, outputName.lastIndexOf(".")));
        }
        Iterator j = filesToProcess.keySet().iterator();
        while (j.hasNext()) {
            String pdfFileName;
            File pdfFile;
            String key = (String)j.next();
            SiteModule module = (SiteModule)filesToProcess.get(key);
            String fullDocPath = this.getBaseDir() + File.separator + module.getSourceDirectory() + File.separator + key;
            String iTextFileName = key.substring(0, key.indexOf(".") + 1) + "xml";
            File iTextFile = new File(outputDirectory, iTextFileName);
            if (!iTextFile.getParentFile().exists()) {
                iTextFile.getParentFile().mkdirs();
            }
            if (!(pdfFile = new File(outputDirectory, pdfFileName = key.substring(0, key.indexOf(".") + 1) + this.getOutputExtension())).getParentFile().exists()) {
                pdfFile.getParentFile().mkdirs();
            }
            this.parse(fullDocPath, module, iTextFile);
            this.generatePdf(iTextFile, pdfFile);
        }
    }

    private void parse(String fullDocPath, SiteModule module, File iTextFile) throws DocumentRendererException, IOException {
        XmlStreamWriter writer = WriterFactory.newXmlWriter((File)iTextFile);
        ITextSink sink = (ITextSink)new ITextSinkFactory().createSink((Writer)writer);
        sink.setClassLoader((ClassLoader)new URLClassLoader(new URL[]{iTextFile.getParentFile().toURI().toURL()}));
        this.parse(fullDocPath, module.getParserId(), (Sink)sink);
        sink.close();
    }

    private Document generateDocument(List iTextFiles) throws DocumentRendererException, IOException {
        Document document;
        try {
            document = DOCUMENT_BUILDER_FACTORY.newDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException e) {
            throw new DocumentRendererException("Error building document :" + e.getMessage());
        }
        document.appendChild(document.createElement("itext"));
        for (int i = 0; i < iTextFiles.size(); ++i) {
            Document iTextDocument;
            File iTextFile = (File)iTextFiles.get(i);
            try {
                iTextDocument = DOCUMENT_BUILDER_FACTORY.newDocumentBuilder().parse(iTextFile);
            }
            catch (SAXException e) {
                throw new DocumentRendererException("SAX Error : " + e.getMessage());
            }
            catch (ParserConfigurationException e) {
                throw new DocumentRendererException("Error parsing configuration : " + e.getMessage());
            }
            Node chapter = iTextDocument.getElementsByTagName("chapter").item(0);
            try {
                document.getDocumentElement().appendChild(document.importNode(chapter, true));
                continue;
            }
            catch (DOMException e) {
                throw new DocumentRendererException("Error appending chapter for " + iTextFile + " : " + e.getMessage());
            }
        }
        return document;
    }

    private Transformer initTransformer() throws DocumentRendererException {
        try {
            Transformer transformer = TRANSFORMER_FACTORY.newTransformer(new StreamSource(AbstractPdfRenderer.class.getResourceAsStream("/org/apache/maven/doxia/docrenderer/itext/xslt/TOC.xslt")));
            transformer.setErrorListener(TRANSFORMER_FACTORY.getErrorListener());
            transformer.setOutputProperty("omit-xml-declaration", "false");
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("encoding", "UTF-8");
            return transformer;
        }
        catch (TransformerConfigurationException e) {
            throw new DocumentRendererException("Error configuring Transformer for org/apache/maven/doxia/docrenderer/itext/xslt/TOC.xslt: " + e.getMessage());
        }
        catch (IllegalArgumentException e) {
            throw new DocumentRendererException("Error configuring Transformer for org/apache/maven/doxia/docrenderer/itext/xslt/TOC.xslt: " + e.getMessage());
        }
    }

    private void addTransformerParameters(Transformer transformer, DocumentModel documentModel) {
        if (documentModel.getMeta().getTitle() != null) {
            transformer.setParameter("title", documentModel.getMeta().getTitle());
        }
        if (documentModel.getMeta().getAuthor() != null) {
            transformer.setParameter("author", documentModel.getMeta().getAuthor());
        }
        transformer.setParameter("creationdate", new Date().toString());
        if (documentModel.getMeta().getSubject() != null) {
            transformer.setParameter("subject", documentModel.getMeta().getSubject());
        }
        if (documentModel.getMeta().getKeywords() != null) {
            transformer.setParameter("keywords", documentModel.getMeta().getKeywords());
        }
        transformer.setParameter("producer", "Generated with Doxia by " + System.getProperty("user.name"));
        if (ITextUtil.isPageSizeSupported((String)documentModel.getMeta().getTitle())) {
            transformer.setParameter("pagesize", documentModel.getMeta().getPageSize());
        } else {
            transformer.setParameter("pagesize", "A4");
        }
        transformer.setParameter("frontPageHeader", "");
        if (documentModel.getMeta().getTitle() != null) {
            transformer.setParameter("frontPageTitle", documentModel.getMeta().getTitle());
        }
        transformer.setParameter("frontPageFooter", "Generated date " + new Date().toString());
    }

    private void transform(DocumentModel documentModel, Document document, File iTextFile) throws DocumentRendererException {
        Transformer transformer = this.initTransformer();
        this.addTransformerParameters(transformer, documentModel);
        try {
            transformer.transform(new DOMSource(document), new StreamResult(iTextFile));
        }
        catch (TransformerException e) {
            throw new DocumentRendererException("Error transforming Document " + document + ": " + e.getMessage());
        }
    }

    static {
        TRANSFORMER_FACTORY.setErrorListener((ErrorListener)new DefaultErrorHandler());
    }
}

