/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.docrenderer;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.maven.doxia.Doxia;
import org.apache.maven.doxia.docrenderer.DocumentRenderer;
import org.apache.maven.doxia.docrenderer.DocumentRendererException;
import org.apache.maven.doxia.document.DocumentModel;
import org.apache.maven.doxia.document.io.xpp3.DocumentXpp3Reader;
import org.apache.maven.doxia.logging.Log;
import org.apache.maven.doxia.logging.PlexusLoggerWrapper;
import org.apache.maven.doxia.module.site.SiteModule;
import org.apache.maven.doxia.module.site.manager.SiteModuleManager;
import org.apache.maven.doxia.parser.ParseException;
import org.apache.maven.doxia.parser.manager.ParserNotFoundException;
import org.apache.maven.doxia.sink.Sink;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.xml.XmlStreamReader;
import org.codehaus.plexus.util.xml.XmlUtil;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public abstract class AbstractDocumentRenderer
extends AbstractLogEnabled
implements DocumentRenderer {
    protected SiteModuleManager siteModuleManager;
    protected Doxia doxia;
    private String baseDir;

    public abstract void render(Map var1, File var2, DocumentModel var3) throws DocumentRendererException, IOException;

    public void render(Collection files, File outputDirectory, DocumentModel documentModel) throws DocumentRendererException, IOException {
        this.render(this.getFilesToProcess(files), outputDirectory, documentModel);
    }

    public void render(File baseDirectory, File outputDirectory, DocumentModel documentModel) throws DocumentRendererException, IOException {
        this.render(this.getFilesToProcess(baseDirectory), outputDirectory, documentModel);
    }

    public void render(File baseDirectory, File outputDirectory) throws DocumentRendererException, IOException {
        this.render(baseDirectory, outputDirectory, new DocumentModel());
    }

    public void render(File baseDirectory, File outputDirectory, File documentDescriptor) throws DocumentRendererException, IOException {
        if (documentDescriptor == null || !documentDescriptor.exists()) {
            if (this.getLogger().isWarnEnabled()) {
                this.getLogger().warn("No documentDescriptor found: using default settings!");
            }
            this.render(baseDirectory, outputDirectory);
        } else {
            this.render(this.getFilesToProcess(baseDirectory), outputDirectory, this.readDocumentModel(documentDescriptor));
        }
    }

    public Map getFilesToProcess(File baseDirectory) throws IOException {
        if (!baseDirectory.isDirectory()) {
            if (this.getLogger().isWarnEnabled()) {
                this.getLogger().warn("No files found to process!");
            }
            return new HashMap();
        }
        this.setBaseDir(baseDirectory.getAbsolutePath());
        HashMap<String, SiteModule> filesToProcess = new HashMap<String, SiteModule>();
        Iterator i = this.siteModuleManager.getSiteModules().iterator();
        while (i.hasNext()) {
            SiteModule module = (SiteModule)i.next();
            File moduleBasedir = new File(baseDirectory, module.getSourceDirectory());
            if (!moduleBasedir.exists()) continue;
            List docs = FileUtils.getFiles((File)moduleBasedir, (String)("**/*." + module.getExtension()), null, (boolean)false);
            Iterator j = docs.iterator();
            while (j.hasNext()) {
                String filePath = ((File)j.next()).getPath();
                filesToProcess.put(filePath, module);
            }
        }
        return filesToProcess;
    }

    public Map getFilesToProcess(Collection files) {
        HashMap<String, SiteModule> filesToProcess = new HashMap<String, SiteModule>();
        Iterator it = this.siteModuleManager.getSiteModules().iterator();
        while (it.hasNext()) {
            SiteModule siteModule = (SiteModule)it.next();
            String extension = "." + siteModule.getExtension();
            String sourceDirectory = File.separator + siteModule.getSourceDirectory() + File.separator;
            Iterator j = files.iterator();
            while (j.hasNext()) {
                String file = (String)j.next();
                if (file.indexOf(sourceDirectory) != -1) {
                    filesToProcess.put(file, siteModule);
                    continue;
                }
                if (!file.endsWith(extension) || filesToProcess.containsKey(file)) continue;
                filesToProcess.put(file, siteModule);
            }
        }
        return filesToProcess;
    }

    public DocumentModel readDocumentModel(File documentDescriptor) throws DocumentRendererException, IOException {
        DocumentModel documentModel;
        XmlStreamReader reader = null;
        try {
            reader = ReaderFactory.newXmlReader((File)documentDescriptor);
            documentModel = new DocumentXpp3Reader().read((Reader)reader);
        }
        catch (XmlPullParserException e) {
            throw new DocumentRendererException("Error parsing document descriptor", e);
        }
        finally {
            IOUtil.close((Reader)reader);
        }
        return documentModel;
    }

    public void setBaseDir(String newDir) {
        this.baseDir = newDir;
    }

    public String getBaseDir() {
        return this.baseDir;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void parse(String fullDocPath, String parserId, Sink sink) throws DocumentRendererException, IOException {
        Object reader = null;
        try {
            File f = new File(fullDocPath);
            reader = XmlUtil.isXml((File)f) ? ReaderFactory.newXmlReader((File)f) : ReaderFactory.newPlatformReader((File)f);
            sink.enableLogging((Log)new PlexusLoggerWrapper(this.getLogger()));
            this.doxia.parse((Reader)reader, parserId, sink);
        }
        catch (ParserNotFoundException e) {
            try {
                throw new DocumentRendererException("No parser '" + parserId + "' found for " + fullDocPath + ": " + e.getMessage());
                catch (ParseException e2) {
                    throw new DocumentRendererException("Error parsing " + fullDocPath + ": " + e2.getMessage(), e2);
                }
            }
            catch (Throwable throwable) {
                IOUtil.close(reader);
                sink.flush();
                throw throwable;
            }
        }
        IOUtil.close((Reader)reader);
        sink.flush();
    }

    protected void copyResources(File outputDirectory) throws IOException {
        File resourcesDirectory = new File(this.getBaseDir(), "resources");
        if (resourcesDirectory.isDirectory() && outputDirectory.isDirectory()) {
            this.copyDirectory(resourcesDirectory, outputDirectory);
        }
    }

    protected void copyDirectory(File source, File destination) throws IOException {
        if (source.isDirectory() && destination.isDirectory()) {
            DirectoryScanner scanner = new DirectoryScanner();
            String[] includedResources = new String[]{"**/**"};
            scanner.setIncludes(includedResources);
            scanner.addDefaultExcludes();
            scanner.setBasedir(source);
            scanner.scan();
            List<String> includedFiles = Arrays.asList(scanner.getIncludedFiles());
            Iterator<String> j = includedFiles.iterator();
            while (j.hasNext()) {
                String name = j.next();
                File sourceFile = new File(source, name);
                File destinationFile = new File(destination, name);
                FileUtils.copyFile((File)sourceFile, (File)destinationFile);
            }
        }
    }
}

