/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.jet.random;

import org.apache.mahout.math.jet.random.AbstractContinousDistribution;
import org.apache.mahout.math.jet.random.Fun;
import org.apache.mahout.math.jet.random.engine.RandomEngine;
import org.apache.mahout.math.jet.stat.Probability;

@Deprecated
public class Beta
extends AbstractContinousDistribution {
    private double alpha;
    private double beta;
    private double PDF_CONST;
    private double a_last = 0.0;
    private double b_last = 0.0;
    private double a_;
    private double b_;
    private double t;
    private double fa;
    private double fb;
    private double p1;
    private double p2;
    private double ml;
    private double mu;
    private double p_last = 0.0;
    private double q_last = 0.0;
    private double a;
    private double b;
    private double m;
    private double D;
    private double Dl;
    private double x1;
    private double x2;
    private double x4;
    private double x5;
    private double f1;
    private double f2;
    private double f4;
    private double f5;
    private double ll;
    private double lr;
    private double z2;
    private double z4;
    private double p3;
    private double p4;
    private static final Beta shared = new Beta(10.0, 10.0, Beta.makeDefaultGenerator());

    public Beta(double alpha, double beta, RandomEngine randomGenerator) {
        this.setRandomGenerator(randomGenerator);
        this.setState(alpha, beta);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected double b00(double a, double b, RandomEngine randomGenerator) {
        if (a != this.a_last || b != this.b_last) {
            this.a_last = a;
            this.b_last = b;
            this.a_ = a - 1.0;
            this.b_ = b - 1.0;
            double c = b * this.b_ / (a * this.a_);
            this.t = c == 1.0 ? 0.5 : (1.0 - Math.sqrt(c)) / (1.0 - c);
            this.fa = Math.exp(this.a_ * Math.log(this.t));
            this.fb = Math.exp(this.b_ * Math.log(1.0 - this.t));
            this.p1 = this.t / a;
            this.p2 = (1.0 - this.t) / b + this.p1;
        }
        while (true) {
            double d;
            double V;
            double X;
            double Z;
            double d2;
            double U = randomGenerator.raw() * this.p2;
            if (d2 <= this.p1) {
                double d3;
                Z = Math.exp(Math.log(U / this.p1) / a);
                X = this.t * Z;
                V = randomGenerator.raw() * this.fb;
                if (!(d3 <= 1.0 - this.b_ * X) && (!(V <= 1.0 + (this.fb - 1.0) * Z) || !(Math.log(V) <= this.b_ * Math.log(1.0 - X)))) continue;
                return X;
            }
            Z = Math.exp(Math.log((U - this.p1) / (this.p2 - this.p1)) / b);
            X = 1.0 - (1.0 - this.t) * Z;
            V = randomGenerator.raw() * this.fa;
            if (d <= 1.0 - this.a_ * (1.0 - X) || V <= 1.0 + (this.fa - 1.0) * Z && Math.log(V) <= this.a_ * Math.log(X)) return X;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected double b01(double a, double b, RandomEngine randomGenerator) {
        if (a != this.a_last || b != this.b_last) {
            this.a_last = a;
            this.b_last = b;
            this.a_ = a - 1.0;
            this.b_ = b - 1.0;
            this.t = this.a_ / (a - b);
            this.fb = Math.exp((this.b_ - 1.0) * Math.log(1.0 - this.t));
            this.fa = a - (a + this.b_) * this.t;
            this.t -= (this.t - (1.0 - this.fa) * (1.0 - this.t) * this.fb / b) / (1.0 - this.fa * this.fb);
            this.fa = Math.exp(this.a_ * Math.log(this.t));
            this.fb = Math.exp(this.b_ * Math.log(1.0 - this.t));
            if (this.b_ <= 1.0) {
                this.ml = (1.0 - this.fb) / this.t;
                this.mu = this.b_ * this.t;
            } else {
                this.ml = this.b_;
                this.mu = 1.0 - this.fb;
            }
            this.p1 = this.t / a;
            this.p2 = this.fb * (1.0 - this.t) / b + this.p1;
        }
        while (true) {
            double d;
            double V;
            double X;
            double Z;
            double d2;
            double U = randomGenerator.raw() * this.p2;
            if (d2 <= this.p1) {
                double d3;
                Z = Math.exp(Math.log(U / this.p1) / a);
                X = this.t * Z;
                V = randomGenerator.raw();
                if (!(d3 <= 1.0 - this.ml * X) && (!(V <= 1.0 - this.mu * Z) || !(Math.log(V) <= this.b_ * Math.log(1.0 - X)))) continue;
                return X;
            }
            Z = Math.exp(Math.log((U - this.p1) / (this.p2 - this.p1)) / b);
            X = 1.0 - (1.0 - this.t) * Z;
            V = randomGenerator.raw() * this.fa;
            if (d <= 1.0 - this.a_ * (1.0 - X) || V <= 1.0 + (this.fa - 1.0) * Z && Math.log(V) <= this.a_ * Math.log(X)) return X;
        }
    }

    protected double b1prs(double p, double q, RandomEngine randomGenerator) {
        double X;
        if (p != this.p_last || q != this.q_last) {
            this.p_last = p;
            this.q_last = q;
            this.a = p - 1.0;
            this.b = q - 1.0;
            double s = this.a + this.b;
            this.m = this.a / s;
            if (this.a > 1.0 || this.b > 1.0) {
                this.D = Math.sqrt(this.m * (1.0 - this.m) / (s - 1.0));
            }
            if (this.a <= 1.0) {
                this.x2 = this.Dl = this.m * 0.5;
                this.z2 = 0.0;
                this.x1 = 0.0;
                this.ll = 0.0;
                this.f1 = 0.0;
            } else {
                this.x2 = this.m - this.D;
                this.x1 = this.x2 - this.D;
                this.z2 = this.x2 * (1.0 - (1.0 - this.x2) / (s * this.D));
                if (this.x1 <= 0.0 || (s - 6.0) * this.x2 - this.a + 3.0 > 0.0) {
                    this.x1 = this.z2;
                    this.x2 = (this.x1 + this.m) * 0.5;
                    this.Dl = this.m - this.x2;
                } else {
                    this.Dl = this.D;
                }
                this.f1 = Beta.f(this.x1, this.a, this.b, this.m);
                this.ll = this.x1 * (1.0 - this.x1) / (s * (this.m - this.x1));
            }
            this.f2 = Beta.f(this.x2, this.a, this.b, this.m);
            if (this.b <= 1.0) {
                this.D = (1.0 - this.m) * 0.5;
                this.x4 = 1.0 - this.D;
                this.z4 = 1.0;
                this.x5 = 1.0;
                this.lr = 0.0;
                this.f5 = 0.0;
            } else {
                this.x4 = this.m + this.D;
                this.x5 = this.x4 + this.D;
                this.z4 = this.x4 * (1.0 + (1.0 - this.x4) / (s * this.D));
                if (this.x5 >= 1.0 || (s - 6.0) * this.x4 - this.a + 3.0 < 0.0) {
                    this.x5 = this.z4;
                    this.x4 = (this.m + this.x5) * 0.5;
                    this.D = this.x4 - this.m;
                }
                this.f5 = Beta.f(this.x5, this.a, this.b, this.m);
                this.lr = this.x5 * (1.0 - this.x5) / (s * (this.x5 - this.m));
            }
            this.f4 = Beta.f(this.x4, this.a, this.b, this.m);
            this.p1 = this.f2 * (this.Dl + this.Dl);
            this.p2 = this.f4 * (this.D + this.D) + this.p1;
            this.p3 = this.f1 * this.ll + this.p2;
            this.p4 = this.f5 * this.lr + this.p3;
        }
        while (true) {
            double Y;
            double V;
            double W;
            double d;
            double U = randomGenerator.raw() * this.p4;
            if (d <= this.p1) {
                double d2;
                double d3;
                W = U / this.Dl - this.f2;
                if (d3 <= 0.0) {
                    return this.m - U / this.f2;
                }
                if (W <= this.f1) {
                    return this.x2 - W / this.f1 * this.Dl;
                }
                U = randomGenerator.raw();
                V = this.Dl * U;
                X = this.x2 - V;
                Y = this.x2 + V;
                if (W * (this.x2 - this.z2) <= this.f2 * (X - this.z2)) {
                    return X;
                }
                V = this.f2 + this.f2 - W;
                if (d2 < 1.0) {
                    if (V <= this.f2 + (1.0 - this.f2) * U) {
                        return Y;
                    }
                    if (V <= Beta.f(Y, this.a, this.b, this.m)) {
                        return Y;
                    }
                }
            } else if (U <= this.p2) {
                double d4;
                double d5;
                W = (U -= this.p1) / this.D - this.f4;
                if (d5 <= 0.0) {
                    return this.m + U / this.f4;
                }
                if (W <= this.f5) {
                    return this.x4 + W / this.f5 * this.D;
                }
                U = randomGenerator.raw();
                V = this.D * U;
                X = this.x4 + V;
                Y = this.x4 - V;
                if (W * (this.z4 - this.x4) <= this.f4 * (this.z4 - X)) {
                    return X;
                }
                V = this.f4 + this.f4 - W;
                if (d4 < 1.0) {
                    if (V <= this.f4 + (1.0 - this.f4) * U) {
                        return Y;
                    }
                    if (V <= Beta.f(Y, this.a, this.b, this.m)) {
                        return Y;
                    }
                }
            } else if (U <= this.p3) {
                double d6;
                U = (U - this.p2) / (this.p3 - this.p2);
                Y = Math.log(U);
                X = this.x1 + this.ll * Y;
                if (d6 <= 0.0) continue;
                W = randomGenerator.raw() * U;
                if (W <= 1.0 + Y) {
                    return X;
                }
                W *= this.f1;
            } else {
                double d7;
                U = (U - this.p3) / (this.p4 - this.p3);
                Y = Math.log(U);
                X = this.x5 - this.lr * Y;
                if (d7 >= 1.0) continue;
                W = randomGenerator.raw() * U;
                if (W <= 1.0 + Y) {
                    return X;
                }
                W *= this.f5;
            }
            if (Math.log(W) <= this.a * Math.log(X / this.m) + this.b * Math.log((1.0 - X) / (1.0 - this.m))) break;
        }
        return X;
    }

    public double cdf(double x) {
        return Probability.beta(this.alpha, this.beta, x);
    }

    private static double f(double x, double a, double b, double m) {
        return Math.exp(a * Math.log(x / m) + b * Math.log((1.0 - x) / (1.0 - m)));
    }

    public double nextDouble() {
        return this.nextDouble(this.alpha, this.beta);
    }

    public double nextDouble(double alpha, double beta) {
        if (alpha > 1.0) {
            if (beta > 1.0) {
                return this.b1prs(alpha, beta, this.randomGenerator);
            }
            if (beta < 1.0) {
                return 1.0 - this.b01(beta, alpha, this.randomGenerator);
            }
            return Math.exp(Math.log(this.randomGenerator.raw()) / alpha);
        }
        if (alpha < 1.0) {
            if (beta > 1.0) {
                return this.b01(alpha, beta, this.randomGenerator);
            }
            if (beta < 1.0) {
                return this.b00(alpha, beta, this.randomGenerator);
            }
            return Math.exp(Math.log(this.randomGenerator.raw()) / alpha);
        }
        if (beta != 1.0) {
            return 1.0 - Math.exp(Math.log(this.randomGenerator.raw()) / beta);
        }
        return this.randomGenerator.raw();
    }

    public double pdf(double x) {
        if (x < 0.0 || x > 1.0) {
            return 0.0;
        }
        return Math.exp(this.PDF_CONST) * Math.pow(x, this.alpha - 1.0) * Math.pow(1.0 - x, this.beta - 1.0);
    }

    public void setState(double alpha, double beta) {
        this.alpha = alpha;
        this.beta = beta;
        this.PDF_CONST = Fun.logGamma(alpha + beta) - Fun.logGamma(alpha) - Fun.logGamma(beta);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static double staticNextDouble(double alpha, double beta) {
        Beta beta2 = shared;
        synchronized (beta2) {
            return shared.nextDouble(alpha, beta);
        }
    }

    public String toString() {
        return this.getClass().getName() + '(' + this.alpha + ',' + this.beta + ')';
    }
}

