/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queries.payloads;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.apache.lucene.index.IndexReaderContext;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermContext;
import org.apache.lucene.queries.payloads.PayloadFunction;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.similarities.Similarity;
import org.apache.lucene.search.spans.SpanCollector;
import org.apache.lucene.search.spans.SpanQuery;
import org.apache.lucene.search.spans.SpanTermQuery;
import org.apache.lucene.search.spans.SpanWeight;
import org.apache.lucene.search.spans.Spans;
import org.apache.lucene.util.BytesRef;

@Deprecated
public class PayloadTermQuery
extends SpanTermQuery {
    protected PayloadFunction function;
    private boolean includeSpanScore;

    public PayloadTermQuery(Term term, PayloadFunction function) {
        this(term, function, true);
    }

    public PayloadTermQuery(Term term, PayloadFunction function, boolean includeSpanScore) {
        super(term);
        this.function = Objects.requireNonNull(function);
        this.includeSpanScore = includeSpanScore;
    }

    public SpanWeight createWeight(IndexSearcher searcher, boolean needsScores) throws IOException {
        TermContext context = TermContext.build((IndexReaderContext)searcher.getTopReaderContext(), (Term)this.term);
        return new PayloadTermWeight(context, searcher, needsScores ? Collections.singletonMap(this.term, context) : null);
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.function.hashCode();
        result = 31 * result + (this.includeSpanScore ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        PayloadTermQuery other = (PayloadTermQuery)((Object)obj);
        return this.includeSpanScore == other.includeSpanScore && this.function.equals(other.function);
    }

    private class PayloadTermWeight
    extends SpanTermQuery.SpanTermWeight {
        public PayloadTermWeight(TermContext context, IndexSearcher searcher, Map<Term, TermContext> terms) throws IOException {
            super((SpanTermQuery)PayloadTermQuery.this, context, searcher, terms);
        }

        public PayloadTermSpanScorer scorer(LeafReaderContext context) throws IOException {
            Spans spans = super.getSpans(context, SpanWeight.Postings.PAYLOADS);
            Similarity.SimScorer simScorer = this.simWeight == null ? null : this.similarity.simScorer(this.simWeight, context);
            return spans == null ? null : new PayloadTermSpanScorer(spans, (SpanWeight)this, simScorer);
        }

        public Explanation explain(LeafReaderContext context, int doc) throws IOException {
            int newDoc;
            PayloadTermSpanScorer scorer = this.scorer(context);
            if (scorer != null && (newDoc = scorer.advance(doc)) == doc) {
                float freq = scorer.sloppyFreq();
                Explanation freqExplanation = Explanation.match((float)freq, (String)("phraseFreq=" + freq), (Explanation[])new Explanation[0]);
                Similarity.SimScorer docScorer = this.similarity.simScorer(this.simWeight, context);
                Explanation scoreExplanation = docScorer.explain(doc, freqExplanation);
                Explanation expl = Explanation.match((float)scoreExplanation.getValue(), (String)("weight(" + this.getQuery() + " in " + doc + ") [" + this.similarity.getClass().getSimpleName() + "], result of:"), (Explanation[])new Explanation[]{scoreExplanation});
                String field = ((SpanQuery)this.getQuery()).getField();
                Explanation payloadExpl = PayloadTermQuery.this.function.explain(doc, field, scorer.payloadsSeen, scorer.payloadScore);
                if (PayloadTermQuery.this.includeSpanScore) {
                    return Explanation.match((float)(expl.getValue() * payloadExpl.getValue()), (String)"btq, product of:", (Explanation[])new Explanation[]{expl, payloadExpl});
                }
                return Explanation.match((float)payloadExpl.getValue(), (String)"btq(includeSpanScore=false), result of:", (Explanation[])new Explanation[]{payloadExpl});
            }
            return Explanation.noMatch((String)"no matching term", (Explanation[])new Explanation[0]);
        }

        protected class PayloadTermSpanScorer
        extends Spans {
            protected BytesRef payload;
            protected float payloadScore;
            protected int payloadsSeen;
            private final Spans spans;
            private final PayloadTermCollector payloadCollector;

            public PayloadTermSpanScorer(Spans spans, SpanWeight weight, Similarity.SimScorer docScorer) throws IOException {
                super(weight, docScorer);
                this.payloadCollector = new PayloadTermCollector();
                this.spans = spans;
            }

            public int nextStartPosition() throws IOException {
                return this.spans.nextStartPosition();
            }

            public int startPosition() {
                return this.spans.startPosition();
            }

            public int endPosition() {
                return this.spans.endPosition();
            }

            public int width() {
                return this.spans.width();
            }

            public void collect(SpanCollector collector) throws IOException {
                this.spans.collect(collector);
            }

            protected void doStartCurrentDoc() throws IOException {
                this.payloadScore = 0.0f;
                this.payloadsSeen = 0;
            }

            protected void doCurrentSpans() throws IOException {
                this.payloadCollector.reset();
                this.spans.collect((SpanCollector)this.payloadCollector);
                this.processPayload();
            }

            protected void processPayload() throws IOException {
                float payloadFactor = this.payloadCollector.payload == null ? 1.0f : this.docScorer.computePayloadFactor(this.docID(), this.spans.startPosition(), this.spans.endPosition(), this.payloadCollector.payload);
                this.payloadScore = PayloadTermQuery.this.function.currentScore(this.docID(), PayloadTermQuery.this.term.field(), this.spans.startPosition(), this.spans.endPosition(), this.payloadsSeen, this.payloadScore, payloadFactor);
                ++this.payloadsSeen;
            }

            public float scoreCurrentDoc() throws IOException {
                return PayloadTermQuery.this.includeSpanScore ? this.getSpanScore() * this.getPayloadScore() : this.getPayloadScore();
            }

            protected float getSpanScore() throws IOException {
                return super.scoreCurrentDoc();
            }

            protected float getPayloadScore() {
                return PayloadTermQuery.this.function.docScore(this.docID(), PayloadTermQuery.this.term.field(), this.payloadsSeen, this.payloadScore);
            }

            public int docID() {
                return this.spans.docID();
            }

            public int nextDoc() throws IOException {
                return this.spans.nextDoc();
            }

            public int advance(int target) throws IOException {
                return this.spans.advance(target);
            }

            public long cost() {
                return this.spans.cost();
            }

            public float positionsCost() {
                return this.spans.positionsCost();
            }
        }
    }

    private static class PayloadTermCollector
    implements SpanCollector {
        BytesRef payload;

        private PayloadTermCollector() {
        }

        public void collectLeaf(PostingsEnum postings, int position, Term term) throws IOException {
            this.payload = postings.getPayload();
        }

        public void reset() {
            this.payload = null;
        }
    }
}

