/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.nl;

import java.io.IOException;
import java.io.Reader;
import java.nio.charset.Charset;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.core.LowerCaseFilter;
import org.apache.lucene.analysis.core.StopFilter;
import org.apache.lucene.analysis.miscellaneous.KeywordMarkerFilter;
import org.apache.lucene.analysis.miscellaneous.StemmerOverrideFilter;
import org.apache.lucene.analysis.nl.DutchStemFilter;
import org.apache.lucene.analysis.snowball.SnowballFilter;
import org.apache.lucene.analysis.standard.StandardFilter;
import org.apache.lucene.analysis.standard.StandardTokenizer;
import org.apache.lucene.analysis.util.CharArrayMap;
import org.apache.lucene.analysis.util.CharArraySet;
import org.apache.lucene.analysis.util.WordlistLoader;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.Version;
import org.tartarus.snowball.ext.DutchStemmer;

public final class DutchAnalyzer
extends Analyzer {
    public static final String DEFAULT_STOPWORD_FILE = "dutch_stop.txt";
    private final CharArraySet stoptable;
    private CharArraySet excltable = CharArraySet.EMPTY_SET;
    private final CharArrayMap<String> stemdict;
    private final Version matchVersion;

    public static CharArraySet getDefaultStopSet() {
        return DefaultSetHolder.DEFAULT_STOP_SET;
    }

    public DutchAnalyzer(Version matchVersion) {
        this(matchVersion, DefaultSetHolder.DEFAULT_STOP_SET, CharArraySet.EMPTY_SET, DefaultSetHolder.DEFAULT_STEM_DICT);
    }

    public DutchAnalyzer(Version matchVersion, CharArraySet stopwords) {
        this(matchVersion, stopwords, CharArraySet.EMPTY_SET, matchVersion.onOrAfter(Version.LUCENE_36) ? DefaultSetHolder.DEFAULT_STEM_DICT : CharArrayMap.emptyMap());
    }

    public DutchAnalyzer(Version matchVersion, CharArraySet stopwords, CharArraySet stemExclusionTable) {
        this(matchVersion, stopwords, stemExclusionTable, matchVersion.onOrAfter(Version.LUCENE_36) ? DefaultSetHolder.DEFAULT_STEM_DICT : CharArrayMap.emptyMap());
    }

    public DutchAnalyzer(Version matchVersion, CharArraySet stopwords, CharArraySet stemExclusionTable, CharArrayMap<String> stemOverrideDict) {
        this.matchVersion = matchVersion;
        this.stoptable = CharArraySet.unmodifiableSet(CharArraySet.copy(matchVersion, stopwords));
        this.excltable = CharArraySet.unmodifiableSet(CharArraySet.copy(matchVersion, stemExclusionTable));
        this.stemdict = CharArrayMap.unmodifiableMap(CharArrayMap.copy(matchVersion, stemOverrideDict));
    }

    protected Analyzer.TokenStreamComponents createComponents(String fieldName, Reader aReader) {
        if (this.matchVersion.onOrAfter(Version.LUCENE_31)) {
            StandardTokenizer source = new StandardTokenizer(this.matchVersion, aReader);
            TokenFilter result = new StandardFilter(this.matchVersion, (TokenStream)source);
            result = new LowerCaseFilter(this.matchVersion, (TokenStream)result);
            result = new StopFilter(this.matchVersion, (TokenStream)result, this.stoptable);
            if (!this.excltable.isEmpty()) {
                result = new KeywordMarkerFilter((TokenStream)result, this.excltable);
            }
            if (!this.stemdict.isEmpty()) {
                result = new StemmerOverrideFilter((TokenStream)result, this.stemdict);
            }
            result = new SnowballFilter((TokenStream)result, new DutchStemmer());
            return new Analyzer.TokenStreamComponents((Tokenizer)source, (TokenStream)result);
        }
        StandardTokenizer source = new StandardTokenizer(this.matchVersion, aReader);
        TokenFilter result = new StandardFilter(this.matchVersion, (TokenStream)source);
        result = new StopFilter(this.matchVersion, (TokenStream)result, this.stoptable);
        if (!this.excltable.isEmpty()) {
            result = new KeywordMarkerFilter((TokenStream)result, this.excltable);
        }
        result = new DutchStemFilter((TokenStream)result, this.stemdict);
        return new Analyzer.TokenStreamComponents((Tokenizer)source, (TokenStream)result);
    }

    private static class DefaultSetHolder {
        static final CharArraySet DEFAULT_STOP_SET;
        static final CharArrayMap<String> DEFAULT_STEM_DICT;

        private DefaultSetHolder() {
        }

        static {
            try {
                DEFAULT_STOP_SET = WordlistLoader.getSnowballWordSet(IOUtils.getDecodingReader(SnowballFilter.class, (String)DutchAnalyzer.DEFAULT_STOPWORD_FILE, (Charset)IOUtils.CHARSET_UTF_8), Version.LUCENE_CURRENT);
            }
            catch (IOException ex) {
                throw new RuntimeException("Unable to load default stopword set");
            }
            DEFAULT_STEM_DICT = new CharArrayMap(Version.LUCENE_CURRENT, 4, false);
            DEFAULT_STEM_DICT.put("fiets", "fiets");
            DEFAULT_STEM_DICT.put("bromfiets", "bromfiets");
            DEFAULT_STEM_DICT.put("ei", "eier");
            DEFAULT_STEM_DICT.put("kind", "kinder");
        }
    }
}

