/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.miscellaneous;

import java.io.IOException;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.KeywordAttribute;
import org.apache.lucene.analysis.util.CharArrayMap;

public final class StemmerOverrideFilter
extends TokenFilter {
    private final CharArrayMap<String> dictionary;
    private final CharTermAttribute termAtt = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);
    private final KeywordAttribute keywordAtt = (KeywordAttribute)this.addAttribute(KeywordAttribute.class);

    public StemmerOverrideFilter(TokenStream input, CharArrayMap<String> dictionary) {
        super(input);
        this.dictionary = dictionary;
    }

    public boolean incrementToken() throws IOException {
        if (this.input.incrementToken()) {
            String stem;
            if (!this.keywordAtt.isKeyword() && (stem = this.dictionary.get(this.termAtt.buffer(), 0, this.termAtt.length())) != null) {
                this.termAtt.setEmpty().append(stem);
                this.keywordAtt.setKeyword(true);
            }
            return true;
        }
        return false;
    }
}

