/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.security.oauthbearer.internals.secured;

import java.util.Arrays;
import java.util.Set;
import java.util.TreeSet;
import org.apache.kafka.common.security.oauthbearer.internals.secured.ClaimValidationUtils;
import org.apache.kafka.common.security.oauthbearer.internals.secured.OAuthBearerTest;
import org.apache.kafka.common.security.oauthbearer.internals.secured.ValidateException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ClaimValidationUtilsTest
extends OAuthBearerTest {
    @Test
    public void testValidateScopes() {
        Set scopes = ClaimValidationUtils.validateScopes((String)"scope", Arrays.asList("  a  ", "    b    "));
        Assertions.assertEquals((int)2, (int)scopes.size());
        Assertions.assertTrue((boolean)scopes.contains("a"));
        Assertions.assertTrue((boolean)scopes.contains("b"));
    }

    @Test
    public void testValidateScopesDisallowsDuplicates() {
        Assertions.assertThrows(ValidateException.class, () -> ClaimValidationUtils.validateScopes((String)"scope", Arrays.asList("a", "b", "a")));
        Assertions.assertThrows(ValidateException.class, () -> ClaimValidationUtils.validateScopes((String)"scope", Arrays.asList("a", "b", "  a  ")));
    }

    @Test
    public void testValidateScopesDisallowsEmptyNullAndWhitespace() {
        Assertions.assertThrows(ValidateException.class, () -> ClaimValidationUtils.validateScopes((String)"scope", Arrays.asList("a", "")));
        Assertions.assertThrows(ValidateException.class, () -> ClaimValidationUtils.validateScopes((String)"scope", Arrays.asList("a", null)));
        Assertions.assertThrows(ValidateException.class, () -> ClaimValidationUtils.validateScopes((String)"scope", Arrays.asList("a", "  ")));
    }

    @Test
    public void testValidateScopesResultIsImmutable() {
        TreeSet<String> callerSet = new TreeSet<String>(Arrays.asList("a", "b", "c"));
        Set scopes = ClaimValidationUtils.validateScopes((String)"scope", callerSet);
        Assertions.assertEquals((int)3, (int)scopes.size());
        callerSet.add("d");
        Assertions.assertEquals((int)4, (int)callerSet.size());
        Assertions.assertTrue((boolean)callerSet.contains("d"));
        Assertions.assertEquals((int)3, (int)scopes.size());
        Assertions.assertFalse((boolean)scopes.contains("d"));
        callerSet.remove("c");
        Assertions.assertEquals((int)3, (int)callerSet.size());
        Assertions.assertFalse((boolean)callerSet.contains("c"));
        Assertions.assertEquals((int)3, (int)scopes.size());
        Assertions.assertTrue((boolean)scopes.contains("c"));
        callerSet.clear();
        Assertions.assertEquals((int)0, (int)callerSet.size());
        Assertions.assertEquals((int)3, (int)scopes.size());
    }

    @Test
    public void testValidateScopesResultThrowsExceptionOnMutation() {
        TreeSet<String> callerSet = new TreeSet<String>(Arrays.asList("a", "b", "c"));
        Set scopes = ClaimValidationUtils.validateScopes((String)"scope", callerSet);
        Assertions.assertThrows(UnsupportedOperationException.class, scopes::clear);
    }

    @Test
    public void testValidateExpiration() {
        Long expected = 1L;
        Long actual = ClaimValidationUtils.validateExpiration((String)"exp", (Long)expected);
        Assertions.assertEquals((Long)expected, (Long)actual);
    }

    @Test
    public void testValidateExpirationAllowsZero() {
        Long expected = 0L;
        Long actual = ClaimValidationUtils.validateExpiration((String)"exp", (Long)expected);
        Assertions.assertEquals((Long)expected, (Long)actual);
    }

    @Test
    public void testValidateExpirationDisallowsNull() {
        Assertions.assertThrows(ValidateException.class, () -> ClaimValidationUtils.validateExpiration((String)"exp", null));
    }

    @Test
    public void testValidateExpirationDisallowsNegatives() {
        Assertions.assertThrows(ValidateException.class, () -> ClaimValidationUtils.validateExpiration((String)"exp", (Long)-1L));
    }

    @Test
    public void testValidateSubject() {
        String expected = "jdoe";
        String actual = ClaimValidationUtils.validateSubject((String)"sub", (String)expected);
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testValidateSubjectDisallowsEmptyNullAndWhitespace() {
        Assertions.assertThrows(ValidateException.class, () -> ClaimValidationUtils.validateSubject((String)"sub", (String)""));
        Assertions.assertThrows(ValidateException.class, () -> ClaimValidationUtils.validateSubject((String)"sub", null));
        Assertions.assertThrows(ValidateException.class, () -> ClaimValidationUtils.validateSubject((String)"sub", (String)"  "));
    }

    @Test
    public void testValidateClaimNameOverride() {
        String expected = "email";
        String actual = ClaimValidationUtils.validateClaimNameOverride((String)"sub", (String)String.format("  %s  ", expected));
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testValidateClaimNameOverrideDisallowsEmptyNullAndWhitespace() {
        Assertions.assertThrows(ValidateException.class, () -> ClaimValidationUtils.validateSubject((String)"sub", (String)""));
        Assertions.assertThrows(ValidateException.class, () -> ClaimValidationUtils.validateSubject((String)"sub", null));
        Assertions.assertThrows(ValidateException.class, () -> ClaimValidationUtils.validateSubject((String)"sub", (String)"  "));
    }

    @Test
    public void testValidateIssuedAt() {
        Long expected = 1L;
        Long actual = ClaimValidationUtils.validateIssuedAt((String)"iat", (Long)expected);
        Assertions.assertEquals((Long)expected, (Long)actual);
    }

    @Test
    public void testValidateIssuedAtAllowsZero() {
        Long expected = 0L;
        Long actual = ClaimValidationUtils.validateIssuedAt((String)"iat", (Long)expected);
        Assertions.assertEquals((Long)expected, (Long)actual);
    }

    @Test
    public void testValidateIssuedAtAllowsNull() {
        Long expected = null;
        Long actual = ClaimValidationUtils.validateIssuedAt((String)"iat", expected);
        Assertions.assertEquals(expected, (Long)actual);
    }

    @Test
    public void testValidateIssuedAtDisallowsNegatives() {
        Assertions.assertThrows(ValidateException.class, () -> ClaimValidationUtils.validateIssuedAt((String)"iat", (Long)-1L));
    }
}

